#
/*
 *
 *
 * The  information  in  this  document  is  subject  to  change
 * without  notice  and  should not be construed as a commitment
 * by Digital Equipment Corporation or by DECUS.
 * 
 * Neither Digital Equipment Corporation, DECUS, nor the authors
 * assume any responsibility for the use or reliability of  this
 * document or the described software.
 * 
 * 	Copyright (C) 1980, DECUS
 * 
 * 
 * General permission to copy or modify, but not for profit,  is
 * hereby  granted,  provided that the above copyright notice is
 * included and reference made to  the  fact  that  reproduction
 * privileges were granted by DECUS.
 *
 */

/*
 * RSX-11M V3.2 Executive C Extensions Library -- PLAS Demo.
 *
 * Task 'A'  --  Sender
 *
 * Bob Denny
 * 14-Jun-80
 *
 */

#include <stdio.h>
#include <cx.h>			/* Must precede the next 2 */
#include <rdbdf.h>
#include <wdbdf.h>

/*
 * Static Declarations
 */

struct rdb region;		/* Region Definition Block */
struct wdb window;		/* Window Definition Block */

/*
 * Directive error procedure.
 */

direrr(msg)
char *msg;
  {
  printf("<A> %s $DSW = %d\n", msg, $dsw);
  exitt();
  };

/*
 * Main program.
 */

main()
  {
  struct rad50 rcvtsk;			/* Receiver task name */

					/* Create 1KW region "DYNCOM" */
  region.r_gsiz = 040;
  ascr50(6, "DYNCOM", &region.r_gnam);
  ascr50(6, "GEN   ", &region.r_gpar);
  region.r_gsts = RS_MDL|RS_ATT|RS_DEL|RS_RED|RS_WRT;
  region.r_gpro = 0167000;			/* RWED, RWED, R, R */
  if( crrg(&region) < 0 )
    direrr("CRRG error.");
					/* Create 1KW window with APR7 */
  window.w_napr = 7;
  window.w_nsiz = 040;
  window.w_nrid = region.r_gid;
  window.w_noff = 0;
  window.w_nlen = 0;
  window.w_nsts = WS_WRT;
  if( craw(&window) < 0 )
    direrr("CRAW error.");
					/* Map the window */
  if( map(&window) < 0 )
    direrr("MAP error.");
					/* Put message out there */
  cpystr(window.w_nbas, "Hello out there in PLAS land!!");

					/* Attempt to send ref. */
  ascr50(6, "DEMO1B", &rcvtsk);		/* Make RAD50 rcvr task name */
  window.w_nsrb = 0;			/* (no 8 word buffer ) */
  if( sref(&rcvtsk, &window, 1) < 0 )
    direrr("SREF failure.");
  else 
    if( rqst(&rcvtsk) < 0 )		/* Try to start task B */
      direrr("Task B Failure.");
    else
      {
      wtse(1);
      puts("<A> Reference received by task B");
      }
					/* Unmap and detach */
  umap(&window);
  dtrg(&region);
  }
