/*
 *			s t r n c a . c
 */

/*)LIBRARY
*/

#ifdef	DOCUMENTATION


title	strncat	Concatenate a String Onto Another, with Count
index		Concatenate a string onto another, with count

synopsis
	.s.nf
	char *
	strncat(out, in, count);
	char		*out;
	char		*in;
	unsigned int	count;
	.s.f
Description

	Append "in" to "out".  Return out.
	At most, "count" bytes are moved from in.
	Note that "count" does not include the trailing null.

Bugs

#endif

#define	EOS	0

char *
strncat(out, in, count)
char			*out;
register char		*in;
register unsigned int	count;
/*
 * Append out to in, moving at most count bytes from in.
 */
{
	register char	*op;

	if (count > 0) {
	    for (op = out; (*op++ != EOS);)
		;
	    op--;			/* op -> EOS trailer in out	*/
	    while ((*op++ = *in++) != EOS) {
		if (--count <= 0) {
		    *op = EOS;
		    break;
		}
	    }
	}
	return (out);
}
