/*
 *			r 5 0 t o a . c
 */

/*)LIBRARY
*/

#ifdef	DOCUMENTATION

title	r50toa	Convert Radix-50 to Ascii
Index		Convert radix-50 to Ascii

synopsis
	.s.nf
	r50toa(buff, r5vec, r5cnt);
	char		*buff;	/* Output text buffer	*/
	int		*r5vec;	/* Input rad50 buffer	*/
	int		r5cnt;	/* How many rad50 words	*/
	.s.f
description:

	Convert r5cnt words of radix 50 data to Ascii.  All letters
	will be in lower-case.  The output buffer will not be
	null-trailed, nor will blank fields be supressed.

bugs

#endif


#ifdef	pdp11
#define	SHORT	unsigned
#else
#define	SHORT	unsigned short
#endif

#ifdef	OLD

static int divtab[] = {
	0,	1,	50,	3100
	int			*divptr;
	int			ccount;
	SHORT int		r5word;
	char			c;

	while (--r5cnt >= 0) {
	    /*
	     * Do each rad50 word.  The code is translated word
	     * for word from macro-11, hence the spaghetti style.
	     * See c5ta.mac for the details.
	     */
	    r5word = *r5vec++;
	    for (divptr = &divtab[4]; *--divptr != 0;) {
		c = -1;
		if (r5word >= 0174777) goto fourty;
		c = r5word % *divptr;
		r5word /= *divptr;
		if (c == 000) goto fifty;		/* Blank	*/
		if (c >  033) goto sixty;
		if (c == 033) goto seventy;
		if (c == 035) c = -1;			/* Illegal	*/
fourty:		c += 040;				/* Alpha or ?	*/
fifty:		c += 016;				/* Digit	*/
sixty:		c += 011;				/* . or $	*/
seventy:	c += 011;				/* $ or .	*/
		*buffer++ = c;
	    }
	}
}

#else

/*
 * Dave Conroy's algorithm
 */


/*
 * Convert `nr50' words worth of
 * RADIX 50 data, pointed to by the argument
 * r5vec, into `3*nr50' bytes of Ascii and
 * store the characters into the buffer
 * pointed to by the `cp' argument. The output
 * string is in lower case. The illegal code
 * in RADIX 50 is converted to a `?'.
 */

static char     ctable[] = {
	" abcdefghijklmnopqrstuvwxyz$.?0123456789"
};

r50toa(buffer, r5vec, r5cnt)
register char		*buffer;	/* Output buffer		*/
SHORT int		*r5vec;		/* Input rad50 vector		*/
int			r5cnt;		/* Number of 16-bit words to do	*/
/*
 * Convert r5cnt words of radix 50 data to Ascii.  All letters will be
 * in lower-case.  The output buffer will not be null-trailed, nor will
 * blank fields be supreessed.
 */
{
        register unsigned	r50;
        register char		*cp;

	while (--r5cnt >= 0) {
	    r50 = *r5vec++;
	    for (cp = ctable; r50 >= 03100; cp++) {
		r50 -= 03100;
	    }
	    *buffer++ = *cp;
	    for (cp = ctable; r50 >= 00050; cp++) {
		r50 -= 050;
	    }
	    *buffer++ = *cp;
	    *buffer++ = ctable[r50];
	}
}

#endif
