The following changes were made to the program DOB by Tom Getzinger to make
the program output listings more readable and to handle several changes made to
the object file format since the original writing of DOB.

The changes were made by:
	Harry Herman
	Corpane Industries
	Bluegrass Industrial Park
	250 Production Court
	Louisville, Ky 40299

The changes will be listed as they are refered to in the source listings

				hah
    Fix the processing of the .END statement to save the transfer
address if specified.  A line of code was apparently missing in GSD2.MAC.

				hah001
    Print instructions of the form:

	EMT	global
	    or
	TRAP	global

in the proper format.  Previously, DOB would split the entry into two
bytes and display them as:

	.BYTE	210
	.BYTE	global	(for EMT)
	    or
	.BYTE	211
	.BYTE	global	(for TRAP)

This involved adding a routine in DASM3 to check each instruction that
was broken into two bytes to see if the high byte was a 210(8) or 211(8)
with a second byte that was flagged as relocated.  If the above conditions
were met and the insrtuctions were at consecutive addresses, they are
printed as EMTs or TRAPs, else they are printed as .BYTEs.

				hah002
    Handle the new RLD entry called 'Additive Relocation'.  This entry
simply adds a specified constant to the base of the LIBR if this is a
LIBR.STB file that is being processed, or adds the constant to the base of
the program if it isnt a LIBR.STB.  I simply substitute a symbol called
		'LIB.BASE'
for the entry and add in, or subtract the specified constant.  Note that
LIB.BASE is a pseudosymbol and will not yeild the correct results if the file
is reassembled with MACRO-11.  It is informational only.  MACRO-11 is not
capable of producing the correct object module entry and LIB.BASE is not defined
anywhere, so it would come out as an unresolved global.
    Changes were made in DASM3, DISOP3, RLD2, RLD3, RODATA and EQUATE to handle
this.

				hah003
    Convert all numbers greater than 170000(8) to negative numbers.  I picked
170000 arbitrarily as a number that would seldom interfere with most bitmasks
and most (but not all) addressing.  Most programs do not directly address
locations in APR 7 (addresses 160000-177777) since that is generally reserved
for the I/O page, and only RSX privileged programs can directly access the
I/O page (or RSTS programs with PEEK and POKE syscalls).  Basically any time
a constant is to be printed, I check to see if the value is > 170000.  If so,
I replace the existing plus sign with a minus sign, and then negate the value
and reprint it as a positive magnitude.  For example,  the value 177777 octal
will now be printed as -1 instead of 177777.  This makes looking up error
values for RSX error messages much easier and also negative indexes show up
as negative intead of as large 'positive' indexes.  The only drawback is in
taking apart LIBR .STB files that were built for the upper APRs, as all
globals defined in the LIBR at addresses greater than 170000 will now print
as negative numbers.
    The modules CLENUP, DISOP3 and RLD3 were modified to accomplish this.

				hah004
    Handle the new .PSECT declaration attributes of SAVe and LIBrary.  Note
that MACRO-11 cannot process the LIB attribute as that is only created by
TKB when creating STB files for LIBRs and COMMONs.  A note is printed with
each PSECT declaration that uses the LIBrary attribute to say that the module
cannot be reassembled with MACRO-11 since MACRO-11 will give a syntax error
if the LIB arguement is used with the .PSECT declaration.  The disassembly does
continue though, so that you can see the rest of the information (autoload
vectors, symbol definitions, segment descriptors, internal symbol declarations,
etc.) that are contained in the .STB file.
    The only change was to GSD2.

				hah005
    Mofify PASS2 to ignore the ISD entries for now.  A future incomplete
modification will actually take apart the ISD entries as documented with the
TKB manual that came with RSTS v8.0.  However, for now the ISDs are simply
ignored instead of aborting DOB as it used to.

				hah006
    Handle the library base symbol in the complex expression evaluation.  See
hah002 for an explination of how it was handled.  The modules modified were
DCOM and EQUATE.

				hah007
    Add the PSECT '. ABS.' if it was not defined after the END OF GSD record
is reached.  This was necessary because overlaid LIBR .STB files reference
the PSECT without declaring the PSECT.
    The module modified was PASS1.

				hah008
    For each global symbol entry in the GSD, check to see if it is a definition
or a reference.  If it is only a reference, print a comment to that effect.
This allows quicker identification of unresolved globals as opposed to the
globals declared in the module.
    The module modified was GSD2.

				hah009
    Added support for ISD entries created by TKB for .STB files.  Rest
of ISD entries will be added as time permits.  Created new module called
ISD3, and modified PASS3 to call ISD3 instead of ignoring the record.

				hah010
     Modified SELECT.MAC to look for a pointer to its jump table to be in R0
instead of having the jump table being in the instruction space immediately
after the call statement.  This was done in order to allow DOB to be built as
an I&D space task.  TKB command files modified also to use I&D space.  Note that
this program will still run on machines that do not support I&D space by just
removing the /ID switch from the TKB command line and then rebuilding the
program.  No code changes are required.

				hah011
     Added support for finding modules in RT-11 object libraries like SYSLIB.OBJ
or RSTS.OBJ.  Also added obtion to allow user to specify a global symbol if the
module name is unknown.  Note that the module table is still scanned first if
the option is selected, and then the entry point table is searched.  A future
version will skip the module search if the global symbol switch is specified.
The switches are input file switches and are:
	For RT11 libraries the following combinations all work the same:
		/LB:name/RT
		/LB/RT:name
		/RT:name/LB
		/RT:name
	For global symbols, specify the global symbol after the /LB or /RT
switches and also specify /EP.  For example, to find the module in SYSLIB
that defines the symbol $DSW, use:
		LB:SYSLIB/LB:$DSW/EP

				hah012
     Most of the error messages printed by DOB have been extended to give
more detail as to what the problem is.  The original DOB only had a very few
error messages such as 'Illegal object format' which meant that something
was wrong with something in the object file, but did not indicate what; or
'Command syntax error', which either meant there was a syntax error, or that
one of the files specified could not be opened, or that the object module
requested from the object library could not be found, but it did not give an
indication of which problem it actually was.
     New error messages have been added to be more explicit about what the
problem was.  Also, certain errors in the command line processing are no longer
considered fatal and will cause a re-prompt if the program was not run as a
CCL (RSTS) or with an MCR command line (RSX).

				hah013
     Added a switch as both an input file switch and an output file switch
to print the version of DOB being used.  For example:
	DOB/ID				(command line)
	DOB>/ID				(from in DOB)
	DOB>TI:=xxxxxx/LB:yyyyyy/ID	(Print version number then find
					module yyyyyy in library xxxxxx)
				hah014
     Added support for the new .WEAK assembler directive.  If a global symbol
has the 'WEAK' attribute set, DOB will print:
	.WEAK	xxxxxx		intead of:
	.GLOBL	xxxxxx

				hah015
      Originally DOB had to be task built with a fixed extended size to allow
room for the number of .PSECTs and .GLOBLs that might be anticipated in a
module disassembly.  If more .PSECTs and/or .GLOBLs were found, then the
program would abort because there was no room to store the remaining symbols.
Then DOB would have to be rebuilt to allow more space and the disassembly
tried again.
     To avoid that, DOB was modified to extend its size whenever new space
is needed for .PSECTs, .GLOBLs, or internal working storage.  This works in
both the I&D space version and the non-I&D version.  Although the non-I&D
space version will run out of space before the I&D space version does, I
doubt that there are any object modules around that define or reference
enough .PSECTs and .GLOBLs to cause even the non-I&D version run out of work
space.

				hah016
     The length of the terminal line buffer has been extended to 132 characters
to allow room for eventually allowing an octal dump option to be added.  However
the current internal orginization of DOB during the code output phase is making
adding that feature non-trivial so it will have to wait for a future release.
                                                                                                                                                                          