
/*	EDSSUB.C	Overlay for SET command			*/
/*								*/
/*	15-AUG-1985 14:22  Brian Nelson				*/
/*	Removed from EDSET.C so I can overlay it in the PDP-11	*/
/*	versin of C TED.					*/


/*								*/
/*	Copyright Notice					*/
/*								*/
/*								*/
/*	C version Copyright (C) 1984 Change Software, Inc.	*/
/*	Copyright (C) 1978 1979 1980 1981 1982 1983 1984 1985	*/
/*		      Change Software, Inc.			*/
/*								*/
/*								*/
/*	This software is furnished under a license and may	*/
/*	be  used  and  copied  only in accordance with the	*/
/*	terms of such license and with  the  inclusion  of	*/
/*	the  above copyright notice.  This software or any	*/
/*	other copies thereof may not be provided or other-	*/
/*	wise made available to any other person.  No title	*/
/*	to and ownership of the software is hereby  trans-	*/
/*	ferred.							*/
/*								*/



#include	"sysdef.h"
#include	"edswdf.h"

#define	then
#define	QUOTE	047
#define	COMMA	054
#define	SPACE	040
#define	TAB	011

struct	map	{
		char *name ;
		char idx ;
		char minlen ;
		} ;



#define	SEREXACT	1
#define	SERGENERAL	2
#define	SERBOUNDED	3
#define	SERUNBOUNDED	4

#define	SETVT100	1
#define	SETVT220	2
#define	SETANSI		3


static struct map sermap[] = {"EXACT"	,SEREXACT	,3	,
			      "GENERAL"	,SERGENERAL	,3	,
			      "BOUNDED"	,SERBOUNDED	,3	,
			      "UNBOUNDED",SERUNBOUNDED	,3	,
			      ""	,0		,0	} ;

static struct map termap[] = {"VT100"	,SETVT100	,3	,
			      "VT220"	,SETVT220	,3	,
			      "ANSI"	,SETANSI	,2	,
			      ""	,0		,0	} ;



#define	CASEMIXED	1
#define	CASEUPPER	2
#define	CASELOWER	3
#define	TABEXPANDED	1
#define	TABKEEP		2

static struct map casemap[]= {"MIXED"	,CASEMIXED	,1	,
			      "UPPER"	,CASEUPPER	,1	,
			      "LOWER"	,CASELOWER	,1	,
			      ""	,0		,0	} ;

static struct map tabmap[] = {"EXPANDED",TABEXPANDED	,1	,
			      "OFF"	,TABEXPANDED	,2	,
			      "ON"	,TABKEEP	,2	,
			      "KEEP"	,TABKEEP	,2	,
			      ""	,0		,0	} ;

#define	COL132	1
#define	COL80	2

static struct map screenmap[] = {"132"	,COL132		,2	,
			      	 "80" 	,COL80 		,2	,
				 ""   	,0     		,0	} ;

#define	ASTALL	1
#define	ASTPAGE	2

static struct map astmap[] = {"ALL"	,ASTALL	,2	,
			      "ANY"	,ASTALL	,2	,
			      "PAGE"	,ASTPAGE,2	,
			      ""   	,0	,0	} ;

#define	DELPREV	1
#define	DELCUR	2

static struct map delmap[] = {"PREVIOUS",DELPREV,2	,
			      "CURRENT" ,DELCUR ,2	,
			      ""	,0	,0	} ;

#define	HEAD_HELP	1
#define	HEAD_UPDATE	2
#define	LINE_NEXT	1
#define	LINE_EOLN	2

static struct map headmap[] =	{"HELP"	,HEAD_HELP	,2	,
				 "FAST"	,HEAD_HELP	,2	,
				 "UPDATE",HEAD_UPDATE	,2	,
				 ""	,0		,0	} ;

static struct map linemap[] =	{"NEXT"	,LINE_NEXT	,2	,
				 "EOLN"	,LINE_EOLN	,2	,
				 ""	,0		,0	} ;


			
setser(s)
char *s;
{
	extern struct map *findmap() ;
	extern int matchflag,ffstop ;
	register struct map *mp ;

	if ( mp=findmap(s,&sermap,"SEARCH") )
	  then	{
		switch( mp->idx ) {
		  case	SEREXACT:
			  matchflag = 0 ;
			  break ;
		  case	SERGENERAL:
			  matchflag = 1 ;
			  break ;
		  case	SERBOUNDED:
			  ffstop = 1 ;
			  break ;
		  case	SERUNBOUNDED:
			  ffstop = 0 ;
			  break ;
			}
		}
}


setdev(s)
char *s ;
{
	extern struct map *findmap() ;
	extern int ansi,vt100,vt220,termtype ;
	register struct map *mp ;

	if ( mp=findmap(s,&termap,"TERMINAL") )
	  then	{
		switch( mp->idx ) {
		  case	SETVT100:
			  termtype = vt100 ;
			  break ;
		  case	SETVT220:
			  termtype = vt220 ;
			  break ;
		  case	SETANSI:
			  termtype = ansi ;
			  break ;
			}
		}
}





settab(s)
char *s ;
{
	extern struct fswitch inswitch ;
	extern struct map *findmap() ;
	register struct map *mp ;

	if ( mp=findmap(s,&tabmap,"SET TAB") )
	  then	{
		switch( mp->idx ) {
		  case	TABKEEP:
			  inswitch.tabxl = 0 ;
			  break ;
		  case	TABEXPANDED:
			  inswitch.tabxl = 1 ;
			  break ;
			}
		}
}


setcase(s)
char *s ;
{
	extern struct fswitch inswitch ;
	extern struct map *findmap() ;
	register struct map *mp ;

	if ( mp=findmap(s,&casemap,"SET CASE") )
	  then	{
		switch( mp->idx ) {
		  case	CASEMIXED:
			  inswitch.casexl = 0 ;
			  break ;
		  case	CASEUPPER:
			  inswitch.casexl = 1 ;
			  break ;
			}
		}
}




setword(cp)
register char *cp ;
{
	extern char worddelim[] ;
	register char ch,*wp ;
	int i, notdone ;

	notdone = 1 ;
	wp = worddelim ;
	*wp = 0 ;
	while ( notdone && ( ch = *cp++ ) != 0 ) {

	   switch( ch ) {
		case QUOTE:
			if ( (*wp++ = *cp++) == 0 || *cp++ != QUOTE )
			  then {
				tederror("Invalid syntax in SET WORD") ;
				notdone = 0 ;
				}
			break ;
		case COMMA:
			break ;
		case SPACE:
		case TAB:
			break ;
		default:
			tederror("Invalid syntax in SET WORD") ;
			xprintf(" <%d>\n",ch) ;
			break ;
			}
		}
}
			  



setverbose(cp)
char *cp ;
{
	extern int verbose ;
	verbose = 1 ;
}

setquiet(cp)
char *cp ;
{
	extern int verbose ;
	verbose = 0 ;
}





setsize(s)
char *s ;
{
	extern struct map *findmap() ;
	register struct map *mp ;

	if ( mp=findmap(s,&screenmap,"SCREEN") )
	  then	{
		switch( mp->idx ) {
		  case	COL132:
			  set132col() ;
			  break ;
		  case	COL80:
			  set80col() ;
			  break ;
			}
		}
}



setast(s)
char *s ;
{
	extern struct map *findmap() ;
	register struct map *mp ;
	extern int astaction ;

	if ( mp=findmap(s,&astmap,"SET AST") )
	  then	{
		switch( mp->idx ) {
		  case	ASTALL:
			  astaction = 1 ;
			  break ;
		  case	ASTPAGE:
			  astaction = 0 ;
			  break ;
			}
		}
}


setdelete(s)
char *s ;
{
	extern struct map *findmap() ;
	register struct map *mp ;
	extern int prevdelete ;

	if ( mp=findmap(s,&delmap,"SET DELETE") )
	  then	{
		switch( mp->idx ) {
		  case	DELPREV:
			  prevdelete = 1 ;
			  break ;
		  case	DELCUR:
			  prevdelete = 0 ;
			  break ;
			}
		}
}


setwrap(s)
char *s ;
{
	extern int maxlen,rightmargin ;
	register int temp ;
	
	temp = getval(s) ;
	if ( temp > 0 && temp < maxlen ) then rightmargin = temp ;
}







setheader(s)
char *s ;
{
	register struct map *mp ;
	extern struct map *findmap() ;
	extern int updheader ;

	if ( mp=findmap(s,&headmap,"HEADER") )
	  then	{
		switch( mp->idx ) {
		  case	HEAD_UPDATE:
			  updheader = 1 ;
			  break ;
		  case	HEAD_HELP:
			  updheader = 0 ;
			  break ;
			} ;
		}
}


setline(s)
char *s ;
{
	register struct map *mp ;
	extern struct map *findmap() ;
	extern int linenext ;

	if ( mp=findmap(s,&linemap,"LINE") )
	  then	{
		switch( mp->idx ) {
		  case	LINE_NEXT:
			linenext = 1 ;
			break ;
		  case	LINE_EOLN:
			linenext = 0 ;
			break ;
			} 
		}
}



static getval(s)
char *s ;
{
	register int res ;
	register char ch ;

	res = 0 ;
	while (*s != 0 && isdigit(*s) == 0 ) s++ ;
	while (*s != 0 && isdigit( (ch = *s++) ) ) res = 10*res + (ch - '0') ;
	return(res) ;
}

