.ENABLE SUBSTITUTION
; This command file will compile the subroutines for producing
; autoscaled labeled x-y graphs for a variety of plotting
; devices for RSX-11M and M/Plus.  You must specify the
; FORTRAN compiler to use.
;
; First, we shall see if the compiled version of FTE (the Fortran
; preprocessor) works on your machine.
;
RUN FTE
.IF <EXSTAT> = 1 .GOTO FTEOK
;
; It doesnt seem to work so we will build a new FTE using FTEBUILD.CMD.
;
@FTEBUILD

.FTEOK:
.SETS UIC <UIC>
.ASKS FORT Enter FORTRAN compiler to use in upper case (FOR,F4P,F77)
.SETS DEFOTS "LB:[1,1]F4POTS"
.IF FORT = "FOR" .SETS DEFOTS "LB:[1,1]FOROTS"
; If your Fortran OTS run-time library is in SYSLIB, enter S below.
.ASKS [::DEFOTS] FOROTS Enter name of your 'FORT' OTS library
.ASK  FCSRES Do you have an FCSRES to link tasks to
;
; You have a choice of which software character set to use when building
; the PLOTxx tasks which plot device-independent plot files.
; You can choose the full Hershey character set which includes simplex
; and complex characters plus Greek and special symbols.  Or you may
; choose the smaller software character set which only has one set.
; Note that the Hershey set is better, but takes up more disk space
; (about 250 blocks per PLOTxx task).
;
.ASK HERSHY Do you want the full Hershey set

.;ASKS FTNLIB Enter [UIC]filename for library to contain GRAF routines
.;ASKS DEVLIB Enter uic for device-dependent libraries
.;ASKS PLOTAS Enter uic for plot-displaying tasks
.SETS FTNLIB "GRAFLIB"
.SETS DEVLIB ""
.SETS PLOTAS ""
.SETS FORSUF "/CO:50"				!SUFFIX FOR F77 COMPILER
.IF FORT = "FOR" .SETS FORSUF "/EX/-SN"	!SUFFIX FOR FOR COMPILER ONLY
.;
.; MAKE SURE TASKS ARE INSTALLED
.;
.IFNINS ...PIP INS $PIP
.IFNINS ...LBR INS $LBR
.IFNINS ...TKB INS $TKB
.IF FORT <> "FOR" .IFNINS ...'FORT' INS $'FORT'
.IF FORT <> "FOR" .GOTO NOFOR
;
; The software character set in SWCHAR.FTN has some rather
; lengthy DATA statements which seem to overwhelm the
; FOR compiler unless it has been installed with sufficient
; /INC.  If this happens, an error message about insufficient
; dynamic storage is displayed.  To avoid this, we shall try
; to install FOR with /INC=40000 which works for our FOR, but
; may not work for yours.  It should be as large as will install.
;
;
.IFINS ...FOR REM ...FOR
INS $FOR/INC=40000
.ASK GO Did FOR install successfully
.IFF GO ; You will have to try to install FOR with as large an INC
.IFF GO ; as possible, then change the line in this command file
.IFF GO ; which says ".INS $FOR/INC=40000" to whatever is the
.IFF GO ; INC which works.
.IFF GO .EXIT

.NOFOR:

;
; Compile the GRAF subroutines
;
RUN FTE/CMD="FTE GRAF/CR"
'FORT' GRAF=GRAF.TMP'FORSUF'
RUN FTE/CMD="FTE GRAFADV/CR"
'FORT' GRAFADV=GRAFADV.TMP'FORSUF'
'FORT' CONVERTNO=CONVERTNO.FTN'FORSUF'
RUN FTE/CMD="FTE PARSCL"
'FORT' PARSCL=PARSCL.TMP'FORSUF'
'FORT' STRING=STRING.FTN'FORSUF'
'FORT' TRIG=TRIG.FTN'FORSUF'
LBR 'FTNLIB'/CR:20.:64.:64.
LBR 'FTNLIB'/RP=GRAF,GRAFADV,STRING,PARSCL,CONVERTNO,TRIG
PIP *.OBJ;*/DE,*.TMP;*
;
; Compile the device-specific plotting libraries
;
RUN FTE/CMD="FTE SYMBOS"
'FORT' SYMBOS=SYMBOS.TMP'FORSUF'
RUN FTE/CMD="FTE LPPLOT"
'FORT' LPPLOT=LPPLOT.TMP'FORSUF'
LBR 'DEVLIB'LPLIB/CR:20.=LPPLOT,SYMBOS
'FORT' HPPLOT=HPPLOT.FTN'FORSUF'
'FORT' HPSUBS=HPSUBS.FTN'FORSUF'
LBR 'DEVLIB'HPLIB/CR:20.=HPPLOT,HPSUBS,SYMBOS
'FORT' TKPLOT=TKPLOT.FTN'FORSUF'
'FORT' TKSUBS=TKSUBS.FTN'FORSUF'
LBR 'DEVLIB'TKLIB/CR:20.=TKPLOT,TKSUBS,SYMBOS
'FORT' PFSUBS=PFSUBS.FTN'FORSUF'
LBR 'DEVLIB'PFLIB/CR:20.=PFSUBS
PIP *.OBJ;*/DE,*.TMP;*
;
; Compile the small software character set object files
;
'FORT' SWCHAR=SWCHAR.FTN'FORSUF'
RUN FTE/CMD="FTE SYMBOSFUL"
'FORT' SYMBOSFUL=SYMBOSFUL.TMP'FORSUF'
PIP 'DEVLIB'SWCHAR.OBS=SWCHAR.OBJ,SYMBOSFUL.OBJ
PIP *.OBJ;*/DE
;
; Build the large (Hershey) software character set library
;
.IFF HERSHY .GOTO SKIPHE

RUN FTE/CMD="FTE SYMBOSFUL"
'FORT' SYMBOSFUL=SYMBOSFUL.TMP'FORSUF'
'FORT' HCSGEN=HCSGEN'FORSUF'
'FORT' NEWLVL=NEWLVL'FORSUF'
'FORT' HORLIN=HORLIN'FORSUF'
'FORT' BULLET=BULLET'FORSUF'
'FORT' STAR=STAR'FORSUF'
MAC HCSMAC=HCSMAC,PLTR
MAC ITWAS=ITWAS
MAC HCST03=HCST03,HCDB
MAC HCST04=HCST04,HCDB
MAC HCST05=HCST05,HCDB
MAC HCST06=HCST06,HCDB
MAC HCST07=HCST07,HCDB
MAC HCST08=HCST08,HCDB
MAC HCST09=HCST09,HCDB
MAC HCST10=HCST10,HCDB
MAC HCST11=HCST11,HCDB
MAC HCST12=HCST12,HCDB
MAC HCST13=HCST13,HCDB
MAC HCST14=HCST14,HCDB
MAC HCST15=HCST15,HCDB
MAC HCST16=HCST16,HCDB
MAC HCST17=HCST17,HCDB
MAC HCST18=HCST18,HCDB
MAC HCST20=HCST20,HCDB
PIP HERSHEY.OBS = *.OBJ
LBR HERSHEY/CR=HERSHEY.OBS
PIP HERSHEY.OBS;*/DE,*.OBJ;*

.SKIPHE:
;
; Taskbuild the PLOTxx tasks for each device
;
RUN FTE/CMD="FTE PLOT/CR"
'FORT' PLOT=PLOT.TMP'FORSUF'
.SETS LIB "TK"
.GOSUB BUILD
.SETS LIB "LP"
.GOSUB BUILD
.SETS LIB "HP"
.GOSUB BUILD
PIP *.OBJ;*/DE,*.TMP;*
;
; Build the DRAW task for generating publication graphs.
;
RUN FTE/CMD="FTE DRAW/LI"
'FORT' DRAW=DRAW.TMP'FORSUF'
.OPEN DRAWBLD.TKB
		.DATA 'PLOTAS'DRAW/CP/FP=DRAW
		.DATA 'FTNLIB'/LB
		.DATA 'DEVLIB'PFLIB/LB
.IF FOROTS <> "S" .DATA 'FOROTS'/LB
		.DATA /
.IFT FCSRES 	.DATA LIBR=FCSRES:RO
		.DATA TASK=...DRA
		.DATA //
.CLOSE
TKB @DRAWBLD.TKB
PIP DRAWBLD.TKB;*/DE,*.OBJ;*,*.TMP;*
;
; Compile DRAWALL.FTE, since it requires the FTE preprocessor.
;
RUN FTE/CMD="FTE DRAWALL/CR"
'FORT' DRAWALL=DRAWALL.TMP'FORSUF'
;
; If you support CCL (Concise Command Language), then you should
; include in your SYSCCL.CCL file the segment PLOTCCL.CCL which is
; in this uic.  This supports commands such as PLOTxx for plotting
; from device independent plot files.
;
; Most of the files in this uic are not needed, and you may copy
; them to another medium if desired.  You will need to keep:
;  PLOT%%.TSK
;  %%LIB.OLB
;  GRAFLIB.OLB
;  SWCHAR.OBS (rarely used)
;  HERSHEY.OLB (even more rarely used)
;
; You may also want to build DRAWALL.FTE which we have compiled
; above (it uses the FTE preprocessor too).  It should be build
; with reference to GRAFLIB and PFLIB as well as your usual
; Fortran OTS library.  Then plot the output plot file using
; one of the PLOTxx tasks, e.g. RUN PLOTTK/CMD="PLT PLOT.PLT"
; if you don't support CCL, PLOTTK if you do support CCL.
; This program generates a four page table of all the character
; sets available in the Hershey character set.  Of course if you
; didn't ask for the Hershey character set this won't work.
;
; Another test of the system is to run one of the sample DRAWGRAPH
; input files.  Without CCL you must RUN DRAW/CMD="DRA DRAWSAMPL.FIG".
; There are also some sample Fortran programs in SAMPLEn.FTN.
;
; That should be everything, I hope.
; In case of problems, contact David Villeneuve, 613-993-9975.
;
.EXIT


.BUILD:
.;
.; Build a PLOTxx task, where xx is the name of the device
.; specific plotting library to use, one per device type.
.; LIB = two letter code xx of plotting library and task name.
.; HERSHY is false if PLOT21 software character set to be used,
.;	  is true  if Hershey character set to be used (must be overlaid).
.;
.OPEN 'LIB'BLD.TKB
.IFT HERSHY		.DATA 'PLOTAS'PLOT'LIB'/CP/FP='LIB'BLD/MP
.IFF HERSHY		.DATA 'PLOTAS'PLOT'LIB'/CP/FP=PLOT
.IFF HERSHY		.DATA 'DEVLIB'SWCHAR.OBS
.IFF HERSHY		.DATA 'DEVLIB''LIB'LIB/LB
.IFF HERSHY		.DATA 'FTNLIB'/LB
.IFF HERSHY .AND .IF FOROTS <> "S"	.DATA 'FOROTS'/LB
.IFF HERSHY		.DATA /
.IFT FCSRES		.DATA LIBR=FCSRES:RO
			.DATA ACTFIL=3
			.DATA //
.CLOSE
.IFF HERSHY .GOTO NOHER

.OPEN 'LIB'BLD.ODL
.DATA		.ROOT	PLOT-A-B-C-D-LIB-E
.DATA	A:	.FCTR	HERSHEY/LB:HCSGEN:HCSMAC:ITWAS
.DATA	B:	.FCTR	HERSHEY/LB:SYMBOL:SYMBOC:SYMBOS
.DATA	C:	.FCTR	HERSHEY/LB:HORLIN:NEWLVL
.DATA	D:	.FCTR	HERSHEY/LB:BULLET:STAR
.DATA	E:	.FCTR	*(PLAIN,FANCY,MISC)
.DATA	PLAIN:	.FCTR	*(H3,H4,H5,H6,H7,H8)
.DATA	FANCY:	.FCTR	*(H9,H10,H11,H12,H13,H14,H15,H16,H17,H18)
.DATA	MISC:	.FCTR	*(H20)
.DATA	H3:	.FCTR	HERSHEY/LB:HCST03
.DATA	H4:	.FCTR	HERSHEY/LB:HCST04
.DATA	H5:	.FCTR	HERSHEY/LB:HCST05
.DATA	H6:	.FCTR	HERSHEY/LB:HCST06
.DATA	H7:	.FCTR	HERSHEY/LB:HCST07
.DATA	H8:	.FCTR	HERSHEY/LB:HCST08
.DATA	H9:	.FCTR	HERSHEY/LB:HCST09
.DATA	H10:	.FCTR	HERSHEY/LB:HCST10
.DATA	H11:	.FCTR	HERSHEY/LB:HCST11
.DATA	H12:	.FCTR	HERSHEY/LB:HCST12
.DATA	H13:	.FCTR	HERSHEY/LB:HCST13
.DATA	H14:	.FCTR	HERSHEY/LB:HCST14
.DATA	H15:	.FCTR	HERSHEY/LB:HCST15
.DATA	H16:	.FCTR	HERSHEY/LB:HCST16
.DATA	H17:	.FCTR	HERSHEY/LB:HCST17
.DATA	H18:	.FCTR	HERSHEY/LB:HCST18
.DATA	H20:	.FCTR	HERSHEY/LB:HCST20
.IF FOROTS = "S"	.DATA LIB:	.FCTR	'FTNLIB'/LB-'DEVLIB''LIB'LIB/LB
.IF FOROTS <> "S"	.DATA LIB:	.FCTR	'FTNLIB'/LB-'DEVLIB''LIB'LIB/LB-'FOROTS'/LB
		.DATA	.END
.CLOSE

.NOHER:

TKB @'LIB'BLD.TKB
.RETURN
