; This command file will compile and build the Fortran program
; which performs the BUILD command.  As in the accompanying
; document, you will probably want to modify the source to
; suit your particular installation.  We shall assume that
; you have done this.
;
; David Villeneuve, National Research Council of Canada.
; Version May 1985.
;
.ENABLE SUBSTITUTION
;
; First, we shall see if the compiled version of FTE (the Fortran
; preprocessor) works on your machine.
;
RUN FTE
.IF <EXSTAT> = 1 .GOTO FTEOK
;
; It doesnt seem to work so we will build a new FTE using FTEBUILD.CMD.
;
@FTEBUILD

.FTEOK:
.SETS UIC <UIC>
; You must specify the FORTRAN compiler to use,
.ASKS FORT Enter FORTRAN compiler to use in upper case (FOR,F4P,F77)
.SETS DEFOTS "LB:[1,1]F4POTS"
.IF FORT = "FOR" .SETS DEFOTS "LB:[1,1]FOROTS"
; If your Fortran OTS run-time library is in SYSLIB, enter S below.
.ASKS [::DEFOTS] FOROTS Enter name of your 'FORT' OTS library
.ASK  FCSRES Do you have an FCSRES to link tasks to
.SETS FORSUF "/-TR"				!SUFFIX FOR F77 COMPILER
.IF FORT = "FOR" .SETS FORSUF "/EX/-SN/CD:EIS"	!SUFFIX FOR FOR COMPILER ONLY
.;
.; MAKE SURE TASKS ARE INSTALLED
.;
.IFNINS ...PIP INS $PIP
.IFNINS ...LBR INS $LBR
.IFNINS ...TKB INS $TKB
.IFNINS ...'FORT' INS $'FORT'
.SETS CR "/CR"
;
; Create the task builder command files.
;
.OPEN BUI.BLD
		.DATA BUI/CP/FP,BUI=BUI/MP
.IFT FCSRES	.DATA LIBR=FCSRES:RO
		.DATA TASK=...BUI
		.DATA PRI=60
		.DATA ACTFIL=2
		.DATA UNITS=2
		.DATA ASG=TI:2
		.DATA //
.CLOSE

PIP BUI.ODL/NV=BUIODL0.ODL
.OPENA BUI.ODL
.IF FOROTS =  "S" .DATA LIB:	.FCTR	STRINGLIB/LB
.IF FOROTS <> "S" .DATA LIB:	.FCTR	STRINGLIB/LB-'FOROTS'/LB
		  .DATA 	.END
.CLOSE
;
; Create a library of the string manipulation functions.
;
'FORT' STRING=STRING'forsuf'
LBR STRINGLIB/CR=STRING
;
; Run the FTE preprocessor to translate the structured code into Fortran.
;
RUN FTE/CMD="FTE BUI'CR'"
;
; Now compile the Fortran
;
'FORT' BUI=BUI.TMP'forsuf'
PIP *.TMP;*/DE
;
; Put the modules into a library, and taskbuild.
;
LBR BUI/CR=BUI
TKB @BUI.BLD
PIP *.OBJ;*/DE
;
; BUI.TSK is the BUILD task.  It should be copied somewhere and installed.
; BUI.LST is the source listing file.
; BUI.MAP is the task builder map file.
; The libraries may be deleted.
;
