; Update 2 Feb 86

Program_name MACRO
	DB 'VTKermit'
	ENDM

VerDef	MACRO
	DB ' '
	Program_name
	DB ' 1.0'
	ENDM

RB_Flag = 1			; Turn on or off Rainbow support
				;  1 = ON, 0 = OFF

Help_window_left=12		; Leftmost column of help window
Help_window_top=5		; Topmost row of help window

; ASCII chars we use ...

SOH     EQU     1		; SOH -- Start of header (Control A)
EOT	EQU	4		; EOT -- End of transmission (Control-D)
ACK	EQU	6		; ACK -- Positive acknowledge (Control F)
Bell    EQU     7		; BEL -- Beep tone (Control G)
Bs	EQU	8		; BS -- Backspace (Control H)
Tab     EQU     11q		; HT -- Horizontal tab (Control I)
Lf      EQU     12q		; LF -- Line feed (Control J)
Vt	EQU	13q		; VT -- Vertical tab (Control K)
Ff      EQU     14q		; FF -- Form feed (Control L)
Cr      EQU     15q		; CR -- Carriage return (Control M)
ShO	EQU	16q		; SI -- Shift out (Control N)
ShI	EQU	17q		; SO -- Shift in (Control O)
Xon     EQU     21q		; DC1 -- Transmit on (Control Q)
Xoff    EQU     23q		; DC3 -- Transmit off (Control S)
ASCII_NAK EQU	25q		; NAK -- Negative acknowledge (Control U)
CtlZ	EQU	32q		; Control Z
Esc     EQU     33q		; Escape
Space	EQU	40q		; A blank
Del     EQU     177q		; Delete

DOS     EQU     21H

CONIN   EQU     01H
CONOUT  EQU     02H
RDRIN   EQU     03H
PUNOUT  EQU     04H
LSTOUT  EQU     05H
DCONIO  EQU     06H
CONINQ	EQU	07H		; quiet console input
PRSTR   EQU     09H
CONSTAT EQU     0BH
SELDSK	EQU	0EH		; Select disk.  [21a]
OPENF   EQU     0FH
CLOSF   EQU     10H
SFIRST  EQU	11H
SNEXT	EQU	12H
DELF    EQU     13H
READF   EQU     14H             ; Read from the file.
WRITEF  EQU     15H
MAKEF   EQU     16H
GCURDSK	EQU	19H		; Current disk.  [21a]
SETDMA	EQU	1AH
PRSFCB	EQU	29H		; parse an fcb.
DOSVER	EQU	30H		; dos version #
CHDIR	EQU	3BH		; 2.0 change directory
CREATE2	EQU	3CH		; 2.0 create
OPEN2	EQU	3DH		; 2.0 open
CLOSE2	EQU	3EH		; 2.0 close
READF2	EQU	3FH		; 2.0 read.
WRITEF2	EQU	40H		; 2.0 write
LSEEK	EQU	42H		; 2.0 lseek
IOCTL	EQU	44H
GCD	EQU	47H		; 2.0 get current directory.

PAREVN	EQU	00H		; Even parity.			[10 start]
PARMRK	EQU	01H		; Mark parity.
PARNON	EQU	02H		; No parity.	
PARODD	EQU	03H		; Odd parity.
PARSPC	EQU	04H		; Space parity.

CMKEY   EQU     01H             ; Parse a keyword.
CMIFI   EQU     02H             ; Parse an input file spec (can be wild).
CMOFI   EQU     03H             ; Parse an output file spec.
CMCFM   EQU     04H             ; Parse a confirm.
CMTXT	EQU	05H		; Parse arbitrary text up to CR.   [8]

FLOXON	EQU	1113H		; Use XON/XOFF for flow control.
FLONON	EQU	0		; Don't do flow control.
DEFHAND	EQU	XON		; Use XON as default handshake.

Cmdlen	EQU	80H		; Size of command buffer
DMASIZ	EQU	80H		; Size of DMA.
FCBSIZ	EQU	25H

MAXTAK	EQU	10		; Max number of TAKE's allowed. [25t]
MAXTRY  EQU	10		; Default number of retries on a packet.
IMXTRY  EQU	20		; Default number of retries send initiate.

DEFESC  EQU     ']'-100q        ; The default escape character.
DRPSIZ  EQU     5EH             ; Default receive packet size.
DSPSIZ  EQU     50H             ; Default send packet size.
DSTIME  EQU     10              ; Default send time out interval.
DRTIME  EQU     10              ; Default receive time out interval.
DSRVTM	EQU	20		; Default server timeout.
DSPAD   EQU     00H             ; Default send padding.
DRPAD   EQU     00H             ; Default receive padding.
DSPADC  EQU     00H             ; Default send padding char.
DRPADC  EQU     00H             ; Default receive padding char.
DSEOL   EQU     CR              ; Default send EOL char.
DREOL   EQU     CR              ; Default receive EOL char.
DSSOH	EQU	SOH		; Default send start-of-packet char.
DRSOH	EQU	SOH		; Default receive start-of-packet char.
DSQUOT  EQU     '#'             ; Default send quote char.
DRQUOT  EQU     '#'             ; Default receive quote char.
DQBIN	EQU	'&'		; Default 8-bit prefix. [21b]
DRPT	EQU	'~'		; Default repeat prefix.
DCHKLEN	EQU	1		; Default checksum length.
DEFPAR	EQU	PARNON		; Default parity (none.) 
IBMPAR  EQU	PARMRK		; IBM's parity (mark.)		[10 end]


bufsiz	EQU	2048		; size of serial input buffer

; baud rate definitions
B00455	EQU	0		; 45.5 baud
B0050	EQU	1		; 50 baud
B0075	EQU	2		; 75 baud
B0110	EQU	3		; 110 baud
B01345	EQU	4		; 134.5 baud
B0150	EQU	5		; 150 baud
B0300	EQU	6		; 300 baud
B0600	EQU	7		; 600 baud
B1200	EQU	8		; 1200 baud
B1800	EQU	9		; 1800 baud
B2000	EQU	10		; 2000 baud
B2400	EQU	11		; 2400 baud
B4800	EQU	12		; 4800 baud
B9600	EQU	13		; 9600 baud
B19200	EQU	14		; 19200 baud
B38400	EQU	15		; 38400 baud 
B23040	EQU	16		; 23040 baud 

BAUDSIZ	EQU	17		; Number of options for baud rate.

; Structure definitions.

; Modem information.
mdminfo	struc
mddat	dw	0		; Default to port 1. [19b start]
mdstat	dw	0		; Ditto. 
mdcom	dw	0		; Here too. 
mden	db	0
mddis	db	0
mdmeoi	db	0
mdintv	dw	0		; [19b end]
mdminfo	ends

; Command information.
cmdinfo	struc	
cmstat  db      0               ; What is presently being parsed.
cmaflg  db      0               ; Non-zero when an action char has been found.
cmccnt  db      0               ; Non-zero if a significant char is found.
cmsflg  db      0               ; Non-zero when the last char was a space.
cmostp  dw      0               ; Old stack pointer for reparse.
cmrprs  dw      0               ; Address to go to on reparse.
cmprmp  dw      0               ; Address of prompt.
cmptab  dw      0               ; Address of present keyword table.
cmhlp   dw      0               ; Address of present help.
cmdbuf  db      Cmdlen DUP(0)   ; Buffer for command parsing.
cmfcb   dw      0               ; Pointer to FCB.
cmfcb2  dw      0               ; Pointer to position in FCB.
cmcptr  dw      0               ; Pointer for next char input.
cmdptr  dw      0               ; Pointer into the command buffer.
cmsiz	dw	0		; Size info of user input.
cmkptr  dw      0               ; Pointer to keyword.
cmsptr  dw      0               ; Place to save a pointer.
cmchr	db	0		; Save char when checking ambiguity.
cmrflg	db	0		; Assume parsing filename for send. [21a]
cmcr	db	0		; Say whether bare CR is allowed.
cmdinfo	ends

; Flags information.
flginfo	struc
belflg	db	1		; Use bell  [17a -- DT]
comflg	db	1		; Use COM1 by default. [19b]
abfflg	db	1		; Discard incoming file if abort. [20d]
debug	db	0		; Debugging mode (default off).
flwflg  db      1               ; File warning flag (default on). [19c]
ibmflg  db      0               ; IBM flag (default off).
extflg  db      0               ; Exit flag (default off).
vtflg	db	1		; H-19 emulation.
droflg	db	0		; Override default disk drive. [21a]
nmoflg	db	0		; Override name from the F packet. [21a]
wldflg	db	0		; Assume no "*" in fn.         [7]
cxzflg	db	0		; ^X/^Z to interrupt file x-fer. [20b] 
xflg	db	0		; Seen "X" packet. [21c]
filflg  db      0               ; Non-zero when nothing in DMA buffer.
eoflag  db      0               ; EOF flag; non-zero on EOF.
getflg	db	0		; Assume normal RECEIVE (not GET). [21a]
capflg	db	0		; On if capturing data. [25]
takflg	db	0		; On if echo commands of TAKE file.
timflg	db	1		; Say if are timing out or not.
destflg	db	1		; Incoming files destination: disk or printer.
eofcz	db	0		; ^Z signals eof if non-zero.
remflg	db	0		; non-zero if in remote mode for this XFER
Real_remflg db	0		; non-zero if REALLY in remote mode.
flginfo	ends

; Transmission parameters
trinfo	struc
maxdat	db	80		; Max packet size for send.
chklen	db	1		; Number of characters in checksum.
seol	db	dseol		; Send EOL char.
reol	db	dreol		; Receive EOL char.
ssoh	db	dssoh		; Send start-of-packet character.
rsoh	db	drsoh		; Receive start-of-packet character.
squote  db	dsquot		; Send quote character.
rquote	db	drquot		; Receive quote character.
spsiz	db	dspsiz		; Send packet size.
rpsiz	db	drpsiz		; Receive packet size.
stime	db	dstime		; Send timeout. (Don't timeout).
rtime	db	drtime		; Receive timeout.
spad	db	dspad		; Send padding.
rpad	db	drpad		; Receive padding.
spadch	db	dspadc		; Send padding char.
rpadch	db	drpadc		; Receive padding char.
ebquot	db	'Y'		; Send 8-bit quote character.
escchr	db	defesc		; Escape character.
scaps	db	0		; Send Kermit capabilities
rcaps	db	10q		; Receive Kermit capabilities
trinfo	ends

pktinfo	struc
pktnum  dw      0               ; Packet number.
numpkt  dw      0               ; Total number of packets sent.
numrtr  dw      0               ; Total number of retries.
argblk  dw      0               ; For subroutine arguments.
argbk1  dw      0
argbk2  dw      0
argbk3  dw      0
numtry  db      0               ; Number of tries on this packet.
oldtry  db      0               ; Number of tries on previous packet.
state   db      0               ; Present state of the automaton.
pktinfo	ends

takinfo	struc
takfcb	db	fcbsiz dup(0)
takbuf	db	dmasiz dup(0)
takptr	dw	0
takchl	db	0
takcnt	dw	0,0
takinfo ends

; Port Information.
prtinfo	struc
baud	dw	0		; Default baud rate.
flowc	dw	0		; Do flow control with XON/XOFF.
ecoflg  db      0               ; Local echo flag (default off).
parflg  db	0		; Parity flag (default none.)  [10]
floflg	db	0		; If need flow control during file x-fer.
hndflg	db	0		; If need handshake during file x-fer.
hands	db	0		; Default handshake.
prtinfo	ends

mkeyw	macro	key,val
	local	junk,oldval
oldval	EQU	$
	db	junk,key,'$'
junk	EQU	$-oldval-2
	dw	val
	endm


; definitions for terminal handler:

termarg	struc
flgs	db	?		; flags
prt	db	?		; port to use (0,1)
cols	db	?		; # columns on screen
rows	db	?		; # rows on screen
captr	dw	?		; routine to call with captured data
belld	dw	?		; bell divisor
klen	dw	?		; length of key redefinition table
ktab	dw	?		; address of key redefinition table
krpl	dw	?		; address of key replacement table
escc	db	?		; escape character
baudb	db	?		; baud rate bits.
parity	db	?		; parity
termarg	ends

; bits for flag byte
scrsam	EQU	80h			; on if shouldn't redraw screen
capt	EQU	40h			; capture output
emheath	EQU	20h			; emulate heath
havtt	EQU	10h			; have translate table
trnctl	EQU	08h			; translate control chars
modoff	EQU	04h			; mode line off
lclecho	EQU	01h			; local echo
