#
/*
 *
 *
 * The  information  in  this  document  is  subject  to  change
 * without  notice  and  should not be construed as a commitment
 * by Digital Equipment Corporation or by DECUS.
 *
 * Neither Digital Equipment Corporation, DECUS, nor the authors
 * assume any responsibility for the use or reliability of  this
 * document or the described software.
 *
 * 	Copyright (C) 1980, DECUS
 *
 *
 * General permission to copy or modify, but not for profit,  is
 * hereby  granted,  provided that the above copyright notice is
 * included and reference made to  the  fact  that  reproduction
 * privileges were granted by DECUS.
 *
 */

/*
 * Home block.
 */
struct	home
{
	int	h_ibsz;		/* Index bit map size */
	long	h_iblb;		/* Indec bit map loc. */
	int	h_fmax;		/* Max. files */
	int	h_sbcl;		/* Storage map cluster factor */
	int	h_dvty;		/* Device type */
	int	h_vlev;		/* Structure level */
	char	h_vnam[12];	/* Volume id */
	char	h_res0[4];	/* Reserved */
	int	h_vown;		/* Owener's UIC */
	int	h_vpro;		/* Volume protection code */
	int	h_vcha;		/* Volume characteristics */
	int	h_dfpr;		/* Default protection */
	char	h_res1[6];	/* Reserved */
	char	h_wisz;		/* Default pointers per window */
	char	h_fiex;		/* Default extension */
	char	h_lruc;		/* Entries in dir. lru */
	char	h_res2[11];	/* Reserved */
	int	h_chk1;		/* First checksum */
	char	h_vdat[14];	/* Creation date and time */
	char	h_vhlb[100];	/* Volume header label */
	char	h_ssin[82];	/* System specific information */
	char	h_rvtb[254];	/* Rel. vol. table */
	int	h_chk2;		/* Second checksum */
};

/*
 * User attributes.
 */
struct	ufat
{
	char	f_rtyp;		/* Record type */
	char	f_ratt;		/* Record attributes */
	int	f_rsiz;		/* Record size */
	long	f_hibk;		/* Highest block in file */
	long	f_efbk;		/* End of file block */
	int	f_ffby;		/* First free byte */
	char	f_crap[18];	/* Pad to 32 bytes */
};

#define	R_FIX	1		/* Fixed length */
#define	R_VAR	2		/* Variable length */
#define	R_SEQ	3		/* Sequenced */

#define	FD_FTN	01		/* Fortran slew */
#define	FD_CR	02		/* Need slew */
#define FD_PRN  04		/* Print control */
#define	FD_BLK	010		/* No block span */

/*
 * Header block.
 */
struct	header
{
	char	h_idof;		/* Ident. area offset (words) */
	char	h_mpof;		/* Map area offset (words) */
	int	h_fnum;		/* File number */
	int	h_fseq;		/* File sequence */
	int	h_flev;		/* Structure level and system number */
	char	h_prog;		/* Programmer number */
	char	h_proj;		/* Project number */
	int	h_fpro;		/* Protection */
	char	h_ucha;		/* User char. */
	char	h_scha;		/* System char. */
	struct	ufat h_ufat;	/* User file attributes */

	int	i_fnam[3];	/* File name */
	int	i_ftyp[1];	/* File type */
	int	i_fver;		/* File version */
	int	i_rvno;		/* Rev. number */
	char	i_rvdt[7];	/* Rev. date */
	char	i_rvti[6];	/* Rev. time */
	char	i_crdt[7];	/* Creation date */
	char	i_crti[6];	/* Creation time */
	char	i_exdt[7];	/* Expiration date */
	char	i_res0;		/* Reserved */

	char	m_esqn;		/* Ext. seg. number */
	char	m_ervn;		/* Ext. rel. vol. number */
	int	m_efnu;		/* Ext. file number */
	int	m_efsq;		/* Ext. file sequence */
	char	m_ctsz;		/* Size of block count field */
	char	m_lbsz;		/* Size of lbn field */
	char	m_use;		/* No. of pointers in use */
	char	m_max;		/* No. of pointers avail. */
	int	m_map[204];	/* Map words */

	int	h_cksm;		/* Checksum */
};

#define	UC_CON	0200		/* Logically contig. */
#define	UC_DLK	0100		/* Locked */
#define UC_CNB	0040		/* Contig best effort */
#define UC_WCK	0020		/* Write check */
#define UC_RCK	0010		/* Read check */
#define UC_WBC	0004		/* Write back cache */
#define UC_NID	0002		/* No incremental dump */
#define	SC_MDL	0200		/* Marked for delete */
#define	SC_BAD	0100		/* Bad blocks in file */
#define SC_DIR	0040		/* Directory file */
#define	SC_SPL	0020		/* Spool intermediate file */

/*
 * Directory.
 */
struct	dir
{
	int	d_fid[3];	/* File id */
	int	d_fnam[3];	/* File name */
	int	d_ftyp[1];	/* File type */
	int	d_fver;		/* File version */
};

/*
 * Magic.
 */
#define	BOOTB	1		/* Boot block */
#define	HOMEB	2		/* Home block */
#define	IMAPB	3		/* Base of index bitmap */
