/*
 *				e t e x t . c
 *
 * Format a vms error message.  Return a pointer to the text buffer.
 *
 * Usage:
 *	extern char	*
 *	vms_etext(errorcode)
 *	int		errorcode;
 *	...
 *	    fprintf(stderr, "error: %s\n", vms_etext(errorcode));
 *
 */

#include	<stdio.h>
#include	<ctype.h>
#define	EOS	0

#include	<descrip.h>

static char		errname[257];	/* Error text stored here	*/
static $DESCRIPTOR(err, errname);	/* descriptor for error text	*/


char *
vms_etext(errorcode)
int		errorcode;
{
	char		*bp;
	short		errlen;		/* Actual text length		*/

	lib$sys_getmsg(&errorcode, &errlen, &err, &15);
	/*
	 * Trim trailing junk.
	 */
	for (bp = &errname[errlen]; --bp >= errname;) {
	    if (isgraph(*bp) && *bp != ' ')
		break;
	}
	bp[1] = EOS;
	return(errname);
}

