/*
 *				b l k e q . c
 */

/*)LIBRARY
*/

#ifdef	DOCUMENTATION

title	blkeq	Test Two Blocks of Memory For Equality
index		Test two blocks of memory for equality

synopsis

	 blkeq(a,b,nbytes)
	 char *a;
	 char *b;
	 unsigned nbytes;

description

	blkeq returns TRUE if a and b point to nbytes bytes of identical
	memory.

	Zero bytes have no special meaning to blkeq() and are compared
	along with everything else.

bugs

author

	Jerry Leichter
#endif

/*
)EDITLEVEL=06
 * Edit history
 * 0.0 18-Jun-81 JSL	Invention
 * 0.1 23-Jun-81 JSL	nbytes should be unsigned
 */

#define FALSE 0
#define TRUE 1

blkeq(a,b,nbytes)
register char *a;
register char *b;
register unsigned nbytes;
{	
	while (nbytes-- != 0)
		if (*a++ != *b++)
			return(FALSE);
	return(TRUE);
}
