-h- cleare.c	Fri Oct 21 10:03:06 1983	CLEARE.C;2
#define	rsts	1
#include <stdio.h>
#include <rsts.h>

clearerr(fp)
FILE *fp;
{
    fp->io_flag &= ~(IO_EOF | IO_ERR);
    return;
}
-h- clrfqb.c	Fri Oct 21 10:03:06 1983	CLRFQB.C;4
#include <rsts.h>

clrfqb()
/*
 * Clear the firqb
 */
{
	zero(&firqb, fqbsiz);
}
-h- clrfqx.c	Fri Oct 21 10:03:06 1983	CLRFQX.C;4
#include <rsts.h>

clrfqx()
/*
 * Clear the firqb and the xrb
 */
{
	zero(&firqb, fqbsiz + xrbsiz);
}
-h- clrxrb.c	Fri Oct 21 10:03:06 1983	CLRXRB.C;4
#include <rsts.h>

clrxrb()
/*
 * Clear the xrb
 */
{
	zero(&xrb, xrbsiz);
}

-h- dmpfqb.c	Fri Oct 21 10:03:06 1983	DMPFQB.C;5
#include <stdio.h>
#include <rsts.h>

static char *fqname[] = {
	"IOSTS ",
	"FQJOB ",
	"FQERNO",
	"FQPPN ",
	"FQNAM1",
	"      ",
	"FQEXT ",
	"FQSIZ ",
	"FQBUFL",
	"FQMODE",
	"FQFLAG",
	"FQPFLG",
	"FQDEV ",
	"FQDEVN",
	"FQCLUS",
	"FQNENT"
};	

dumpfqb()
/*
 * Dump the firqb, restore it after dumping.
 */
{
	register int		*xp;
	register int		temp;
	register int		offset;
	struct rsts_xrb		myxrb;
	struct rsts_firqb	myfqb;
	char			r50buf[4];

	getxrb(&myxrb);
	getfqb(&myfqb);
	offset = 0;
	for (xp = &(myfqb.firqb_errorcode); xp <= &(myfqb.fqnent);) {
		r50toa(r50buf, xp, 1);
		r50buf[3] = 0;
		temp = *xp++;
		printf("firqb+%02o = %06o %03o %03o\t%3s\t%s\n",
			offset * 2, temp, (temp >> 8) & 0377, temp & 0377,
			r50buf, fqname[offset]);
		offset++;
	}
	putfqb(&myfqb);
	putxrb(&myxrb);
}
-h- doprnt.c	Fri Oct 21 10:03:06 1983	DOPRNT.C;40
/*
 *			d o p r n t . c
 *
 */

/*)LIBRARY
*/

#ifdef	DOCUMENTATION

title		Output Formatter
index		Output formatter

internal

synopsis
	.s.nf
	c_doprnt(format, argvec, iov)
	char		*format;
	int		*argvec[];
	FILE		*iov;
	.s.f
Description

	c_doprnt() performs all formatting operations for printf(),
	sprintf(), and fprintf().  The formatting options are described
	in the documentation of printf().

Bugs

	c_doprnt() is functionally identical to the _doprnt() module
	in Unix and Vax-11 C libraries.  Unfortunately, the initial '_'
	conflicts with RSX FCS library conventions.

#endif

#include		<stdio.h>
#define	EOS		('\0')
#define	FALSE		0
#define	TRUE		1
#ifdef	PDP10
#define	BITS_PER_CHAR	36
#else
#define	BITS_PER_CHAR	8
#endif

/*
 * WORKSIZE is the dimension of work[] which must hold enough characters
 * to store a long integer (expanded using the %b format) + '-' and EOS
 */
#define	WORKSIZE	(((sizeof (long)) * BITS_PER_CHAR) + 2)

struct	fmtbuf {
	char	f_type;		/* Format type ('d', etc.)		*/
	char	f_width;	/* Argument width (INT or LONG)		*/
	char	f_radix;	/* Argument radix (8, 10, etc.)		*/
};

#define	INT	0
#define	LONG	1
/*
 * formatinfo[] stores information about the "value" formats
 */
static struct fmtbuf formatinfo[] = {
	{ 'b',	INT,	 2 },
	{ 'd',	INT,	10 },
	{ 'o',	INT,	 8 },
	{ 'u',	INT,	10 },
	{ 'x',	INT,	16 },
	{ 'B',	LONG,	 2 },
	{ 'D',	LONG,	10 },
	{ 'O',	LONG,	 8 },
	{ 'U',	LONG,	10 },
	{ 'X',	LONG,	16 },
	{ EOS,	0,	 0 },
};

c_doprnt(format, arg, fildes)
char		*format;		/* Format string		*/
register union {
	char		**s;
	int		*i;
	unsigned int	*u;
	long		*l;
	char		*c;
} arg;
FILE		*fildes;		/* File descriptor		*/
{
	register int	c;
	register union {
		struct fmtbuf	*fmt;
		char		*result;
	} p;		
	char		ljust;		/* TRUE for left-justification	*/
	char		work[WORKSIZE];	/* Number buffer		*/
	char		fill;		/* '0' or ' ' for fill		*/
	int		prec;		/* Precision			*/
	int		slen;		/* Field length			*/
	int		width;		/* Argument width		*/
	long		value;		/* Current argument value	*/
	int		temp;		/* Set if '-' needed.		*/
	int		radix;		/* Conversion radix		*/

	while ((c = *format++) != EOS) {
	    /*
	     * Check for conversion specifications.
	     */
	    if (c == '%') {
		/*
		 * Check for various options.
		 */
		c = *format++;
		ljust = 0;			/* No left adjustment	*/
		prec = 0;			/* Print all the arg.	*/
		fill = ' ';			/* Fill with spaces	*/
		if (c == '-') {			/* %-	left justify	*/
		    ljust++;
		    c = *format++;
		}
		if (c == '0') {			/* %0d	zero fill arg.	*/
		    fill = c;
		    c = *format++;
		}
		if (c == '?' || c == '*') {	/* %*	width from arg	*/
		    width = *arg.i++;
		    c = *format++;
		}
		else {				/* %n	field width	*/
		    width = 0;
		    while (isdigit(c)) {
			width *= 10;
			width += (c - '0');
			c = *format++;
		    }
		}
		prec = 32767;
		if (c == '.') {			/* %n.n	precision	*/
		    c = *format++;		/* %n.* (from arg)	*/
		    if (c == '?' || c == '*') {
			prec = *arg.i++;
			c = *format++;
		    }
		    else {
			while (isdigit(c)) {
			    prec *= 10;
			    prec += (c - '0');
			    c = *format++;
			}
		    }
		}
		/*
		 * Process conversion chars, understanding longs.
		 */
		if (c == 'l' || c == 'L') {
		    switch (c = *format++) {
		    case 'b':
		    case 'd':
		    case 'o':
		    case 'u':
		    case 'x':
			c = toupper(c);	/* Make %lb %B		*/
		    case 'B':
		    case 'D':
		    case 'O':
		    case 'U':
		    case 'X':
			break;
		    default:		/* Here on %Lfoo == %Ufoo	*/
			c = 'U';
			format--;
			break;
		    }
		}
		/*
		 * Search the numeric format structure for this conversion.
		 */
		for (p.fmt = formatinfo;
			(p.fmt->f_type != c && p.fmt->f_type != EOS);
			p.fmt++)
		    ;
		if (p.fmt->f_type != EOS) {
		    /*
		     * A numeric conversion was found.
		     * Get the value and expand it into the work area.
		     */
		    if (p.fmt->f_width == INT) {
			if (c == 'd')
			    value = *arg.i++;
			else
			    value = *arg.u++;
		    }
		    else {
			value = *arg.l++;
		    }
		    radix = p.fmt->f_radix;
		    p.result = &work[WORKSIZE];
		    *--p.result = EOS;		/* Terminate result	*/
		    if (value == 0)
			*--p.result = '0';
		    else {
			/*
			 * Convert a signed non-zero number.
			 * temp will signal whether a '-' is needed.
			 */
			if ((temp = (value < 0 && c == 'd' || c == 'D')))
			    value = (-value);
			/*
			 * The sign (if needed) is stored in temp.
			 */
			while (value > 0) {
			    c = value % radix;
			    *--p.result = c + ((c < 10) ? '0' : ('a' - 10));
			    value /= radix;
			}
			if (temp)
			    *--p.result = '-';
		    }
		}
		else { 
		    /*
		     * String or something
		     */		
		    switch (c) {
		    case 'q':			/* Funny int value	*/
			/*
			 * Convert a word as a pair of octal bytes.
			 */
			c = 16384;
			p.result = work;
			temp = *arg.i++;
			while (c > 0) {
			    *p.result++ = (temp / c) + '0';
			    temp %= c;
			    if (c == 256) {
				c = 64;
				*p.result++ = '.';
			    }
			    else
				c >>= 3;
			}
			*p.result = EOS;
			p.result = work;
			break;

		    case 'r':			/* Remote format	*/
			format = *arg.s++;
			continue;		/* No print here	*/

		    case 's':			/* String		*/
			if ((p.result = *arg.s++) == NULL)
			    p.result = "{NULL}";	/* Bug hack	*/
			break;

		    case 'c':			/* Character		*/
			c = *arg.c++;
			/*
			 * Fall through
			 */
		    default:			/* %% or whatever	*/
		    	p.result = work;
			*p.result = c;
			work[1] = EOS;
			break;
		    }
		}
		/*
		 * p.result -> first byte of string to output.
		 * Reuse c as a register temp.
		 */
		c = strlen(p.result);		/* True result length	*/
		slen = (c > prec) ? prec : c;	/* Field length		*/
		if (!ljust) {			/* Right justify?	*/
		    while (width-- > slen) {
			putc(fill, fildes);
		    }
		}
		/*
		 * Output the string (up to "prec" bytes)
		 */
		for (c = prec; *p.result != EOS && --c >= 0;) {
		    putc(*p.result++, fildes);
		}
		if (ljust) {			/* Left justify?	*/
		    while (width-- > slen) {
			putc(' ', fildes);
		    }
		}
	    }
	    else {
		/*
		 * Not in a % thing, just output the byte.
		 */
		putc(c, fildes);
	    }
	}
	return;
}


-h- error.c	Fri Oct 21 10:03:06 1983	ERROR.C;2
#define	rsts	1
#include <stdio.h>
#include <rsts.h>

int	(*$$errx)() = NULL;

error(string)
char *string;
{
    fprintf(stderr, string);
    putc('\n', stderr);
    if ($$errx != NULL)
        (*$$errx)();
    exit();
}
-h- exit.c	Fri Oct 21 10:03:06 1983	EXIT.C;2
#define	rsts	1
#include <stdio.h>
#include <rsts.h>

extern	$$opsy;
typedef	int	(*fncp) ();
#define	__exit	(* ((fncp) 0))

$$exit()
{
    exit();
}

int	$$exst = 0;
exit()
{
    if ($$opsy == 7) {	/* If we're in the RT11 emulator		*/
        __exit();	/* Exit by jumping to the CLR R0/.EXIT at 0,2	*/
    }
    clrfqx();
    rstsys(_RTS);
    rstsys(_EXIT);
}

$$fail()
{
    if ($$opsy == 7) {	/* If we're in the RT11 emulator		*/
        __exit();	/* Exit by jumping to the CLR R0/.EXIT at 0,2	*/
    }
    clrfqx();
    rstsys(_RTS);
    rstsys(_EXIT);
}
-h- fclose.c	Fri Oct 21 10:03:06 1983	FCLOSE.C;2
#define	rsts	1
#include <stdio.h>
#include <rsts.h>

fclose(fp)
FILE *fp;
{
    if (fp == stderr) {
	return(-1);
    }
    if ($$luns[fp->io_lun - 1] == fp) {
        mfree(fp->io_bbuf);
	$$ferr = 0;
	if (fp->io_flag & IO_OPN) {
	    fflush(fp);
	    $dclos(fp);
	}
	$$fero($$ferr, fp);
	if ($$ferr) {
	    return(-1);
	}
	else {
	    return(0);
	}
    }
    return(-1);
}

$dclos(fp)
FILE *fp;
{
    clrfqx();
    firqb.fqfun	= CLSFQ;
    firqb.fqfil	= fp->io_lun * 2;
    $$ferr = rstsys(CALFIP);
}
-h- feof.c	Fri Oct 21 10:03:06 1983	FEOF.C;2
#define	rsts	1
#include <stdio.h>
#include <rsts.h>

feof(fp)
FILE *fp;
{
    return((fp->io_flag & IO_EOF) != 0);
}
-h- fflush.c	Fri Oct 21 10:03:06 1983	FFLUSH.C;2
#define	rsts	1
#include <stdio.h>
#include <rsts.h>

fflush(fp)
FILE *fp;
{
    register int flags;

    flags = fp->io_flag;

    fp->io_flag &= ~(IO_ERR | IO_EOF);
    if (flags & IO_MOD && flags & IO_BZY) {
	clrxrb();
	xrb.xrlen	= fp->io_bsiz;		/* Buffer length	*/
        if (flags & IO_REC) {
	    xrb.xrbc	= fp->io_bcnt;
        }
        else {
	    zero(fp->io_bptr, fp->io_bsiz - fp->io_bcnt);
	    xrb.xrbc 	= fp->io_bsiz;
        }
	xrb.xrloc	= fp->io_bbuf;		/* Buffer start		*/
	xrb.xrci	= fp->io_lun * 2;	/* Channel number	*/
	if (flags & IO_FIL) {
	    xrb.xrblk = fp->io_bnbr++;
	}
	rstsys(_WRITE);
	fp->io_flag &= ~IO_BZY;
	fp->io_bptr = fp->io_bbuf;
	fp->io_bcnt = 0;
    }
}
-h- fgets.c	Fri Oct 21 10:03:06 1983	FGETS.C;2
#define	rsts	1
#include <stdio.h>
#include <rsts.h>

extern char *gets();
extern char *fgets();

char *
gets(buffer)
char *buffer;
{
    int c;
    char *ps;

    ps = buffer;
    do {
	if ((c = getchar()) == EOF) {
	    return(NULL);
	}
	*ps++ = c;
    } while (c != '\n');
    *--ps = 0;
    return(buffer);
}

char *
fgets(buffer, maxbyt, fp)
char *buffer;
int maxbyt;
FILE *fp;
{
    int i;
    char *ps;
    int c;

    ps = buffer;
    for (i = 0; i < maxbyt; i++) {
	if ((c = getc(fp)) == EOF) {
	    return(NULL);
	}
	*ps++ = c;
	if (c == '\n') {
	    *ps = 0;
	    break;
	}
    }
    return(buffer);
}
-h- fopen.c	Fri Oct 21 10:03:06 1983	FOPEN.C;2
#define	rsts	1
#include <stdio.h>
#include <rsts.h>

extern FILE *$$flun();
extern FILE *$$open();
 
FILE *
fopen(name, mode)
char *name, *mode;
{
    FILE *fp;

    if (!(fp = $$flun())) {
	return(NULL);
    }
    return($$open(name, mode, fp));
}


FILE *
$$flun()
{
    register int i;
    FILE *fp;

    for (i = 0; i < MAXLUN; i++) {
	if (!($$luns[i])) {
	    if (!(fp = malloc(sizeof(FILE)))) {
		$$ferr = NOBUFS;
		return(NULL);
	    }
	    else {
		zero(fp, sizeof(FILE));
		fp->io_lun = i+1;
		fp->io_bptr = fp->io_bbuf;
		return($$luns[i] = fp);
	    }
	}
    }
    $$ferr = NOROOM;
    return(NULL);
}

extern FILE *$dopen();

FILE *
$$open(name, mode, fp)
char *name, *mode;
FILE *fp;
{
    register char c, omode;
    int cmode;

    cmode = 0;
    while (c = *mode++) {
	switch (c) {
	case 'w':
	    omode = 'w';
	    fp->io_flag |= 1;
	    cmode++;
	    break;
	case 'r':
	    omode = 'r';
	    fp->io_bnbr = 1;
	    cmode++;
	    break;
	case 'a':
	    omode = 'a';
	    fp->io_flag |= 2;
	    cmode++;
	    break;
	case 'n':
	    fp->io_flag |= IO_NOS;
	case 'u':
	    break;
	default:
	    $$fero(BADFUO, fp);
	    return(NULL);
	}
    }
    if (cmode != 1) {
	$$fero(BADFUO, fp);
	return(NULL);
    }
    if (!(fp->io_name = malloc(strlen(name)+1))) {
	$$fero(NOBUFS, fp);
	return(NULL);
    }
    strcpy(fp->io_name, name);
    return($dopen(name, omode, fp));
}

FILE *
$dopen(name, omode, fp)
char *name;
char omode;
FILE *fp;
{

retry:
    clrfqx();
    xrb.xrlen	= strlen(name);	/* Length of the file name	*/
    xrb.xrbc	= xrb.xrlen;	/* Another copy of the length	*/
    xrb.xrloc	= name;		/* Name starting address	*/
    if (rstsys(_FSS)) {
	$$fero($$ferr, fp);
	return(NULL);
    }
    firqb.fqfil	= (fp->io_lun) * 2;
    if (omode == 'w') {
	firqb.fqfun = CREFQ;
    }
    else {
	firqb.fqfun = OPNFQ;
	if (((xrb.xrmod & 0377) == DSKHND) && !firqb.fqmode) {
	    firqb.fqmode = 0100002;
	}
    }
    $$ferr = rstsys(CALFIP);
    if (omode == 'a' && $$ferr == NOSUCH) {
	omode = 'w';
	goto retry;
    }
    if ($$ferr) {
	$$fero($$ferr, fp);
	return(NULL);
    }
    else {
	if (firqb.fqflag & FLGFRC) {
	    fp->io_flag |= IO_REC;
	}
	if ((firqb.fqflag & 0377) == TTYHND) {
	    fp->io_flag |= IO_TTY;
	}
	if (firqb.fqflag & FLGRND) {
	    fp->io_bnbr = 1;
	    fp->io_flag |= IO_FIL;
	    if (omode == 'a') {
		fp->io_bnbr = firqb.fqsiz + 1;
	    }
	}
        if (fp->io_bbuf)
            free(fp->io_bbuf);
        if ((fp->io_bbuf = malloc(fp->io_bsiz = firqb.fqbufl)) == NULL) {
            clrfqb();
            firqb.fqfun = RSTFQ;
            firqb.fqfil = (fp->io_lun) * 2;
            rstsys(CALFIP);
            $$fero(NOBUFS, fp);
            fp->io_flag = 0;
            return(NULL);
        }
	fp->io_flag |= IO_OPN;
	return(fp);
    }
}

$$fero(error, fp)
int error;
FILE *fp;
{
    char *stp;

    $$ferr = error;
    if (fp) {
        if (stp = fp->io_name)
            free(stp);
        if (fp->io_bbuf)
            free(fp->io_bbuf);
        $$luns[fp->io_lun - 1] = 0;
        free(fp);
    }
}
-h- forcen.c	Fri Oct 21 10:03:06 1983	FORCEN.C;3
#include <stdio.h>
#include <rsts.h>
#include <rserr.h>

forcenl()
/*
 * Force echo on and a new line
 */
{
	rstsys(_TTRST);
	rstsys(_TTECH);
	clrxrb();
	rstsys(_POSTN);
	if ((xrb.xrbc & 0377) != 0)
		print("\r\n");
}
-h- getc.c	Fri Oct 21 10:03:06 1983	GETC.C;2
#define	rsts	1
#include <stdio.h>
#include <rsts.h>

getchar()
{
    return(getc(stdin));
}

getc(fp)
FILE *fp;
{
    char c;

    if (fp->io_flag & IO_NOS) {
	return($getc(fp));
    }
    else {
	while ((c = $getc(fp)) != EOF) {
	    switch (c) {
		case '\0':
		    break;
		case '\r':
		    if ((c = $getc(fp)) == '\n') {
			return('\n');
		    }
		    else {
			ungetc(c, fp);
			return('\r');
		    }
		case '\032':
		    if (fp->io_flag & IO_TTY) {
			fp->io_flag |= IO_EOF;
			return(EOF);
		    }
		    return('\032');
		default:
		    return(c);
	    }
	}
	return(EOF);
    }
}

$getc(fp)
FILE *fp;
{
    return(--fp->io_bcnt >= 0 ? *fp->io_bptr++ & 0377 : $$get(fp));
}	

ungetc(c, fp)
char c;
FILE *fp;
{
    fp->io_bcnt++;
    *--fp->io_bptr = c;
}

$$get(fp)
FILE *fp;
{
    if (fp->io_flag2 & IO_ODT2) {
        clrxrb();
        xrb.xrlen  = 4;
        xrb.xrci   = fp->io_lun * 2;
        xrb.xrblkm = TTYHND;
        rstsys(_SPEC);
    }
    clrxrb();
    xrb.xrlen = fp->io_bsiz;
    xrb.xrloc = fp->io_bbuf;
    if (fp->io_flag & IO_FIL) {
	xrb.xrblk = fp->io_bnbr++;
    }
    else {
	xrb.xrmod = fp->io_recm;
    }
    if (fp->io_flag & IO_TTY) {
        xrb.xrtime = fp->io_wait;
    }
    xrb.xrci = fp->io_lun * 2;
    $$ferr = rstsys(_READ);
    fp->io_bptr = fp->io_bbuf;
    fp->io_bcnt = xrb.xrbc;
    if ($$ferr) {
	fp->io_flag |= IO_EOF;
	if ($$ferr != EOFERR) {
	    fp->io_flag |= IO_ERR;
	}
	else {
	    if (fp->io_flag & IO_TTY) {
		fp->io_flag &= ~IO_EOF;
		fp->io_bcnt--;
		return(*fp->io_bptr++ & 0377);
	    }
	}
	return(EOF);
    }
    fp->io_bcnt--;
    return(*fp->io_bptr++ & 0377);
}	    
-h- getcw.c	Fri Oct 21 10:03:06 1983	GETCW.C;3
#include <stdio.h>
#include <rsts.h>
#include <rserr.h>

getcw()
/*
 * Get the next character typed at the keyboard.  Wait only one second.
 * return:
 *	<  0	-value is a (fatal) error
 *	== 0	Nothing was typed
 *	>  0	The returned character
 */
{
	char		buf[2];
	register int	errcode;

	rstsys(_TTDDT);			/* Enter single character mode	*/
	clrxrb();
	xrb.xrlen = 1;			/* One character only		*/
	xrb.xrloc = &buf[0];		/* Into this buffer		*/
	xrb.xrtime = 1;			/* One second wait time		*/
	errcode = rstsys(_READ);	/* Do the read			*/
	if (errcode == 0)
		return(buf[0] & 0377);
	else if (errcode == HNGTTY)
		return(0);
	else return (-errcode);
}
-h- getfqb.c	Fri Oct 21 10:03:06 1983	GETFQB.C;4
#include <rsts.h>

getfqb(myfqb)
struct	rsts_firqb	*myfqb;
/*
 * Store the system firqb in myfqb
 */
{
	copy(myfqb, &firqb, fqbsiz);
}
-h- getkb.c	Fri Oct 21 10:03:06 1983	GETKB.C;3
#include <stdio.h>
#include <rsts.h>
#include <rserr.h>
 
getkb()
/*
 * Get the job's console keyboard number
 */ 
{
	clrfqb();
	firqb.fqfun = UU_SYS;
	firqb.fqsizm = 1;
	RSTSYS(_UUO);
	return(firqb.fqsizm);
}
-h- getrst.c	Fri Oct 21 10:03:06 1983	GETRST.C;3
#include <stdio.h>
#include <rsts.h>
#include <rserr.h>
 

getrsts(channel, line, wait_time, modifier)
int	channel;		/* I/o channel to read from		*/
char	line[82];		/* Where to read to			*/
int	wait_time;		/* How long to wait, 0 == forever	*/
int	modifier;		/* Device modifier			*/
/*
 * Get a line using raw rsts/e call, (return in line[]);
 * This is a simple call used for general input from the command terminal.
 * See the RSTS Programming manual and the RSTS/E System Directives manual
 * for a description of time and modifier.
 * Return:
 *	0	Data present in the line
 *     ERR	Error code
 */
{
	register char	*lp;		/* Will -> our line		*/
	register int	errcode;	/* Error code			*/

	errcode = rs_read(channel, line, 80, 0, 0, wait_time, modifier);
	if (errcode < 0)
		return(-errcode);
	for (lp = line + errcode - 1; lp >= line
		 && *lp == '\r' && *lp == '\n' && *lp == '\0'; lp--);
	*++lp = 0;			/* Null terminator		*/
	return(0);
}
-h- getw.c	Fri Oct 21 10:03:06 1983	GETW.C;2
#include <stdio.h>
getw(fp)
FILE	*fp;
{
    return( (getc(fp) & 0377)
	  | (getc(fp) << 8)
	  );
}
-h- getxrb.c	Fri Oct 21 10:03:06 1983	GETXRB.C;4
#include <rsts.h>

getxrb(myxrb)
struct	rsts_xrb	*myxrb;
/*
 * Store the system xrb in myxrb
 */
{
	copy(myxrb, &xrb, xrbsiz);
}
-h- init.c	Fri Oct 21 10:03:06 1983	INIT.C;2
#define	rsts	1
#include <stdio.h>
#include <rsts.h>

extern int	$$rsts;
extern int	$$opsy;
extern int	$$vms;
extern unsigned	$$mend;
extern int	$$tick;

#define	KWORDS	2048

#ifdef rt11
#define	OPSYS	7

#define	HIMEM	(*((int *) 050 ))
#define	RMON	(*((int *) 054 ))
#define	CONFIG	(*((int *) (RMON + 0300) ))
#define	CLOCK50	040

#else
#define	OPSYS	4
#endif
#define	BUFSIZ	128

static	char	err_buf[BUFSIZ];

$$init()
{
    $$opsy = OPSYS;	/* If = 4, RSTS EMTs are legal	*/

    $$rsts = 1;		/* We're RSTS	*/
    $$vms = 0;		/* And not VMS	*/

    stderr->io_flag = (IO_OPN | IO_REC | IO_TTY | 1);
    stderr->io_name = "_TT:";
    stderr->io_bptr =
    stderr->io_bbuf = err_buf;
    stderr->io_bsiz = BUFSIZ;

#ifdef rt11

    if  (CONFIG & CLOCK50)
        $$tick = 50;
    $$mend = HIMEM + 2;

#else

    clrfqb();
    firqb.fqfun = 26;
    firqb.fqsizm = 1;
    rstsys(_UUO);
    $$mend = firqb.fqsiz * KWORDS;

#endif

    $$args();

/*
 *    $$uic =
 *    $$task =
 */
}

extern int	$$argc;
extern char	**$$argv;

static
$$args()
{
    char	*cmd;
    char	*cmn;
    char	*limit;
    char	c;
    int		state;

    $$argc = corcmn[0];
    cmd = alloc($$argc + 1);
    $$argv = calloc($$argc + 1, sizeof (char *));
    cmn = corcmn + 1;
    limit = corcmn + $$argc;
    $$argc = 0;
    state = 0;
    while (cmn <= limit) {
        c = (*cmn++ & 0177);
        switch (state) {
            case 0:
                if (c <= ' ')
                    break;
                else {
                    $$argv[$$argc++] = cmd;
                    state = 1;
                }
            case 1:
                if (c > ' ') {
                    *cmd++ = tolower(c);
                }
                else {
                    *cmd++ = EOS;
                    state = 0;
                }
                break;
        }
    }
    *cmd++ = EOS;
}
-h- input.c	Fri Oct 21 10:03:06 1983	INPUT.C;3
#include <stdio.h>
#include <rsts.h>
#include <rserr.h>
 
input(line)
char	line[81];		/* The string to fill with the line	*/
/*
 * Read a line from the console, erase cr or lf terminator.
 */
{
	char	*lp;
 
	clrxrb();
	xrb.xrlen = 80;
	xrb.xrloc = line;
	rstsys(_READ);
	for (lp = line + xrb.xrbc - 1; lp >= line &&
			(*lp == '\r' || *lp == '\n' || *lp == 0); lp--);
	*++lp = 0;
	return;
}
-h- iov.c	Fri Oct 21 10:03:06 1983	IOV.C;2
#define	rsts	1
#include <stdio.h>

int	$$ferr;
FILE	$$eiov;
FILE	*stderr = &$$eiov;
FILE	*stdin = &$$eiov;
FILE	*stdout = &$$eiov;
FILE	*$$luns[MAXLUN];
-h- isprin.c	Fri Oct 21 10:03:06 1983	ISPRIN.C;7
/*
 *			i s p r i n . c
 */

/*)LIBRARY
*/

#ifdef	DOCUMENTATION

title	isprint	Test for Printable Character
index		Test for printable character

synopsis
	.s.nf
	int
	isprint(c)
	int		c;
	.s.f
Description

	Return non-zero if c is a printable character.  The printable
	characters include all graphics, including space.  (See
	isgraph(), also.)

Bugs

	The value is defined only if isascii(c) is TRUE.

#endif

#include	<ctype.h>
#ifdef	isprint
#undef	isprint
#endif

int
isprint(c)
int		c;
{
	return (_ctype_[c & 0177] & (_PULD | _B));
}
-h- peek.c	Fri Oct 21 10:03:06 1983	PEEK.C;3
#include <rsts.h>

peek(loc)
char	*loc;
/*
 * Rsts peek command
 */
{
	xrb.xrlen = loc;
	rstsys(_PEEK);
	return(xrb.xrlen);
}

-h- print.c	Fri Oct 21 10:03:06 1983	PRINT.C;3
#include <stdio.h>
#include <rsts.h>
#include <rserr.h>

print(str)
char	*str;			/* The string to print			*/
/*
 * print a string on the console
 */ 
{
	clrxrb();
	xrb.xrlen = xrb.xrbc = strlen(str);
	xrb.xrloc = str;
	rstsys(_WRITE);
}
-h- printf.c	Fri Oct 21 10:03:06 1983	PRINTF.C;22
/*
 *			p r i n t f . c
 *
 * Formatted output to the "standard" device.
 */

/*)LIBRARY
*/

#ifdef	DOCUMENTATION

title	printf	Formatted Output Conversion
index		Formatted output conversion

synopsis
	.s.nf
	printf(format, arg1, ...)	
	char		*format;

	fprintf(stream, format, arg1, ...)
	FILE		*stream;
	char		*format;

	char *
	sprintf(buffer, format, arg1, ...);
	char		*buffer;
	char		*format;

	c_doprnt(format, argvec, iov)
	char		*format;
	int		*argvec[];
	FILE		*stream;
	.s.f
 Description

	printf() converts, formats, and prints its arguments, under control
	of the first argument, writing output to stdout. fprintf()
	writes its output to the indicated file.  sprintf() writes its
	output to the indicated string buffer.  c_doprnt() is the internal
	print formatter which is called by printf, etc.  

	sprintf() returns a pointer to the EOS at the end of the output
	buffer.  This is not necessarily transportable.

	The format argument is a character string which contains two
	types of objects: plain characters, which are simply copied
	to the output stream, and conversion specifications, each of
	which causes conversion and printing of the next successive
	argument to printf.

	Each conversion specification is introduced by the character %.
	Following the %, there may be
	.lm +4
	.s.i -4;-###an  optional  minus  sign  "-"  which  specifies left
	adjustment of the converted argument in the indicated
	field.
	.s.i -4;-###an optional digit string specifying field  width.  If
	the  converted argument has fewer characters than the
	field width, it will be blank-padded on the left  (or
	right, if  the  left-adjustment  indicator  has  been
	given) to make up the  field  width.   If  the  field
	width  is  specified as '*' or '?', the next argument
	is used.  (Note: '?' is  obsolete.)  If the  width is
	specified  with a leading  zero,  zeros are  used for
	padding instead of blanks.  This zero  does NOT imply
	an octal field width.  For example, assume the  value
	123 is to be printed:
	
		%d	"123"
		%5d	"  123"
		%-5d	"123  "
		%05d	"00123"
	.s.i -4;-###an  optional  period "." which serves to separate the
	field width from the precision argument.
	.s.i -4;-###an optional digit string (precision) which  specifies
	the number of digits  to be printed from a string.   If the
	precision is  specified  as  '*'  or  '?',  the  next
	argument is used.  If the precision is zero, no bytes in the
	string will be printed.
	.s.i -4;-###a character which indicates the  type  of  conversion
	   to be applied.
	.lm -4
	The conversion characters and their meanings are
	.lm +4.s
	.i -4;b###Binary (bits)
	.i -4;d###Signed-decimal
	.i -4;u###Unsigned-decimal
	.i -4;o###Octal
	.i -4;x###Hexadecimal, 10-15 are represented by a-f
	.lm -4.s
	The  integer  argument  is converted to decimal,
	octal, or hexadecimal   notation   respectively.
	Any   of   the   conversion  characters  may  be
	capitalized or preceeded  by  'l'  to  signal  "long"   integer
	argument.
	.lm +4
	.s.i -4;c###The argument character is printed.  If the argument
	is zero (EOS), it will be ignored.
	.s.i -4;q###The (16-bit) integer is printed as a pair of
	octal bytes in the format "123.456"  The bytes follow
	the PDP-11 order (high order byte first).  This format
	is not transportable to other systems.
	.s.i -4;r###Remote format.  The next  printf()  argument  is
	the format.  Note that this is not a subroutine.
	The current format is not processed further. For
	example:

	    bug(args)
	    {
		error("Error at %r", &args);
	    }

	This routine might be called as follows:

	    bug("Error %d at %s\n", val, name);

	%r is not transportable to  all  implementations
	of  the  standard  library.  It does not word on
	Vax-11 C, for example.  c_doprnt() may  be  used
	as shown below for similar functionality.
	.s.i -4;s###The  argument is taken to be a string (character
	pointer) and  characters  from  the  string  are
	printed  until  a  null  character  or until the
	number of characters indicated by the  precision
	specification  is   reached;   however   if  the
	precision   specification  is  0  or missing all
	characters up to null are printed.
	.s.lm -4
	If no recognizable character appears after the %, that character
	is printed; thus % may be printed by the use of the string %%.
	In no case does a non-existant or small field width cause truncation
	of a field; padding takes place only if the specified field
	width exceeds the actual width.  Characters generated by printf()
	are printed by calling putchar().

	c_doprnt() is the internal print formatter called by all
	"top-level" print functions.  It is functionally identical
	to the Unix and Vax-11 C _doprnt() library routine.  Unfortunately,
	the leading '_' conflicts with RSX-11M file services library
	routine conventions, requiring the use of an unique prefix.
	If your programs wish to call c_doprnt,
	a potentially transportable procedure would be:

	    #ifdef decus
		c_doprnt(format, args, iov);
	    #else
		_doprnt(format, args, iov);
	    #endif

	You should assume, however, that _doprnt() is not necessarily
	present on all implementations of the "standard library."

Bugs

#endif

#include	<stdio.h>
#ifdef	rsts
#include	<rsts.h>
#endif

#ifdef	rsts
#ifndef	MAXBUF
#define	MAXBUF	512
#endif

static char	tempbuffer[MAXBUF];
#endif
  
printf(format, args)
char	*format;
{
#ifdef	rsts
	FILE		dummyiov;

	if ((stdout->_flag & IO_REC) != 0) {
	    dummyiov._flag = _IOSTRG | _IOWRT;
	    dummyiov._base = NULL;
	    dummyiov._ptr = tempbuffer;
	    dummyiov._cnt = 32767;
	    c_doprnt(format, &args, &dummyiov);
	    rs_write(stdout->io_lun, tempbuffer, strlen(tempbuffer),
		0, 0, fd->io_recm);
	}
	else {	    
	    c_doprnt(fmt, &args, stdout);
	}
#else
	c_doprnt(fmt, &args, stdout);
#endif
}

fprintf(fd, format, args)
register FILE	*fd;
char		*format;
{
#ifdef	rsts
	FILE		dummyiov;

	if ((fd->_flag & IO_REC) != 0) {
	    dummyiov._flag = _IOSTRG | _IOWRT;
	    dummyiov._base = NULL;
	    dummyiov._ptr = tempbuffer;
	    dummyiov._cnt = 32767;
	    c_doprnt(format, &args, &dummyiov);
	    rs_write(fd->io_lun, tempbuffer, strlen(tempbuffer),
		0, 0, fd->io_recm);
	}
	else {	    
	    c_doprnt(fmt, &args, fd);
	}
#else
	c_doprnt(fmt, &args, fd);
#endif
}

#ifdef	TESTING
/*)BUILD
	$(FILES)	= { printf doprnt }
*/

char	buffer[80];
char	format[80];

main()
{
	printf("just text\n");
	printf("one number (one-two-three) %d\n", 123);
	printf("string \"%s\"\n", "Hello there");
	printf("char '%c'\n", 'x');
	for (;;) {
	    clearerror(stdin);
	    fputs("format: ", stdout);
	    fflush(stdout);
	    if (gets(format) == NULL)
		break;
	    for (;;) {
		printf("Arg for \"%s\", <CR> to exit: ", format);
		fflush(stdout);
		if (gets(buffer) == NULL || buffer[0] == EOS)
		    break;
		printf("buffer = \"%s\" (%d): ", buffer, atoi(buffer));
		printf(format, atoi(buffer));
		printf("\n[");
		printf(format, atoi(buffer));
		printf("]\n");
	    }
	}
}

#endif
-h- printf.old	Fri Oct 21 10:03:06 1983	PRINTF.OLD;1
#define	rsts	1
#include <stdio.h>
#include <rsts.h>

#define	BUFSIZ	512
static	FILE	fakfp$;
static	char	fak_buf[BUFSIZ];
printf(control, args)
char *control;
{

    if (stdout->io_flag & IO_REC) {
	zero(&fakfp$, sizeof(FILE));
	fakfp$.io_bptr =
        fakfp$.io_bbuf = fak_buf;
	fakfp$.io_bsiz = BUFSIZ;
	$doprn(control, &args, &fakfp$);
	putc('\0', &fakfp$);
	$write(stdout, fakfp$.io_bbuf, strlen(fakfp$.io_bbuf),stdout->io_recm);
    }
    else {
	$doprn(control, &args, stdout);
    }
}

fprintf(fp, control, args)
FILE *fp;
char *control;
{
    if (fp->io_flag & IO_REC) {
	zero(&fakfp$, sizeof(FILE));
	fakfp$.io_bptr =
        fakfp$.io_bbuf = fak_buf;
	fakfp$.io_bsiz = BUFSIZ;
	$doprn(control, &args, &fakfp$);
	putc('\0', &fakfp$);
	$write(fp, fakfp$.io_bbuf, strlen(fakfp$.io_bbuf),fp->io_recm);
    }
    else {
	$doprn(control, &args, fp);
    }
}

sprintf(buffer, control, args)
char *buffer;
char *control;
{
    zero(&fakfp$, sizeof(FILE));
    fakfp$.io_bptr =
    fakfp$.io_bbuf = buffer;
    fakfp$.io_bsiz = 32767;
    $doprn(control, &args, &fakfp$);
    putc('\0', &fakfp$);
    return(buffer);
}

$doprn(control, pargs, $fp)
char *control;
int *pargs;
FILE *$fp;
{
    char c, *ps, rjust, s[17], zrofil;
    int k, prec, slen, width;
    char *nbase(), *nspoct();

    while( c = *control++ ){

	/* Check for conversion specifications. */
	if( c == '%' ){

	    /* Check for various options. */
	    if( (c = *control) == '-' ){
		rjust = 0;
		c = *control++;
	    }
	    else {
		rjust = 1;
	    }
	    zrofil =  (c == '0');

	    if( *control == '?' ){
		width = *pargs++;
		c = *(++control);
		++control;
	    }
	    else {
		width = 0;
		while( isdigit( c = tolower(*control++)) ){
		    width = 10*width + c - '0';
		}
	    }
	    if( c == '.' ){
		if( *control == '?' ){
		    prec = *pargs++;
		    c = *(++control);
		    ++control;
		}
		else {
		    prec = 0;
		    while( isdigit( c = tolower(*control++)) ){
			prec = 10*prec + c - '0';
		    }
		}
	    }
	    else 	prec = 32767;

	    /* Process conversion chars. */
	    switch(c){

	    case ('b'):
		ps = nbase(*pargs++, 2, s);
		break;

	    case ('o'):
		ps = nbase(*pargs++, 8, s);
		break;

	    case ('d'):
		if( *pargs < 0 ){
		    ps = nbase(-*pargs++, 10, s);
		    *--ps = '-';
		}
		else	ps = nbase(*pargs++, 10, s);
		break;

	    case ('u'):
		ps = nbase(*pargs++, 10, s);
		break;

	    case ('x'):
		ps = nbase(*pargs++, 16, s);
		break;

	    case ('q'):
		ps = nspoct(*pargs++, s);
		break;

	    case ('s'):
		ps = *pargs++;
		break;

	    case ('c'):
		c = *pargs++;
		/* fall thru */
	    default:
		*(ps = s) = c;
		s[1] = EOS;
	    }

	    k = strlen(ps);
	    slen = (k > prec) ? prec : k;

	    if( rjust ){
		while( width -- > slen ){
		    putc(zrofil? '0' : ' ', $fp);
		}
	    }

	    for( k = 1;  *ps && k <= prec;  ++k ){
		putc(*ps++, $fp);
	    }

	    if( !rjust ){
		while( width -- > slen ){
		    putc(' ', $fp);
		}
	    }
	}
	else	putc(c, $fp);
    }
    return;
}

char *nbase(n, base, s)
unsigned n, base;
char *s;
{
    int d;

    *(s += 16) = EOS;
    if( n == 0 )  *--s = '0';
    else {
	while( n > 0 ){
	    d = n % base;
	    *--s = d + (d < 10 ? '0' : 55);
	    n /= base;
	}
    }
    return (s);
}

char *nspoct(n, s)
unsigned n;
char s[];
{
    int d;	char *ps;
    d = 16384; ps = s;

    while( d > 0 ){
	*ps++ = n/d + '0';
	n %= d;
	if( d == 256 ){
	    d = 64;
	    *ps++ = '.';
	}
	else	d /= 8;
    }
    *ps = EOS;
    return (s);
}

$write(fp, buffer, buflen, modifier)
FILE *fp;
char *buffer;
int buflen;
int modifier;
{
    clrxrb();
    xrb.xrlen	= buflen;	/* Buffer length		*/
    xrb.xrbc	= buflen;	/* Number of bytes to write	*/
    xrb.xrloc	= buffer;	/* Buffer start			*/
    xrb.xrci	= fp->io_lun * 2; /* Channel number		*/
    xrb.xrmod	= modifier;	/* Device (record) modifier	*/
    $$ferr = rstsys(_WRITE);
}
-h- putc.c	Fri Oct 21 10:03:06 1983	PUTC.C;2
#define	rsts	1
#include <stdio.h>
#include <rsts.h>

putchar(c)
char c;
{
    putc(c, stdout);
}

putc(c, fp)
char c;
FILE *fp;
{
    if (c == 033)
        c = 0233;
    if (!(fp->io_flag & IO_NOS)) {
	switch (c) {
	case '\n':
	    $ptbyt('\r', fp);
	default:
	    $ptbyt(c, fp);
	}
    }
    else {
	$ptbyt(c, fp);
    }
    if (fp->io_flag & IO_REC) {
	fflush(fp);
    }
}

$ptbyt(c, fp)
char c;
FILE *fp;
{
    if (fp->io_bcnt == 0)
        fp->io_bptr = fp->io_bbuf;
    *fp->io_bptr++ = c;
    fp->io_flag |= IO_BZY;
    if (++fp->io_bcnt >= fp->io_bsiz) {
        fflush(fp);
    }
}
-h- putfqb.c	Fri Oct 21 10:03:06 1983	PUTFQB.C;4
#include <rsts.h>

putfqb(myfqb)
struct	rsts_firqb	*myfqb;
/*
 * Store the user firqb in low-core
 */
{
	copy(&firqb, myfqb, fqbsiz);
}
-h- puts.c	Fri Oct 21 10:03:06 1983	PUTS.C;2
#define	rsts	1
#include <stdio.h>
#include <rsts.h>

puts(s)
char *s;
{
    fputss(s, stdout);
}

fputss(s, fp)
char *s;
FILE *fp;
{
    char	c;
    int		is_rec;

    if (is_rec = (fp->io_flag & IO_REC))
        fp->io_flag &= ~IO_REC;

    while (c = *s++)
        putc(c, fp);
    putc('\n', fp);

    if (is_rec) {
        fp->io_flag |= IO_REC;
        fflush(fp);
    }
}

fputs(s, fp)
char *s;
FILE *fp;
{
    char	c;
    int		is_rec;

    if (is_rec = (fp->io_flag & IO_REC))
        fp->io_flag &= ~IO_REC;

    while (c = *s++)
        putc(c, fp);

    if (is_rec) {
        fp->io_flag |= IO_REC;
        fflush(fp);
    }
}
-h- putw.c	Fri Oct 21 10:03:06 1983	PUTW.C;2
#include <stdio.h>
putw(word, fp)
int	word;
FILE	*fp;
{
    putc(word & 0377, fp);
    putc((word >> 8) & 0377, fp);
}
-h- putxrb.c	Fri Oct 21 10:03:06 1983	PUTXRB.C;4
#include <rsts.h>

putxrb(myxrb)
struct	rsts_xrb	*myxrb;
/*
 * Store the user xrb in low-core
 */
{
	copy(&xrb, myxrb, xrbsiz);
}
-h- readme.506	Fri Oct 21 10:03:06 1983	README.506;2
[..., 6]		RSTS/E interface routines
---------		------ --------- --------


This account contains files for a direct interface to RSTS/E system
calls.  Most routines are documented.  Otherwise, you're on your own.
-h- rsclos.c	Fri Oct 21 10:03:06 1983	RSCLOS.C;3
#include <stdio.h>
#include <rsts.h>
#include <rserr.h>

rs_close(channel)
int		channel;		/* Channel to close		*/
/*
 * Close a channel for rsts/e.  Note:
 *	channel >  0	Close this channel
 *	channel == 0	Reset all channels
 *	channel <  0	Reset this channel
 */
{
	clrxrb();
	clrfqb();
	if (channel > 0) {
		firqb.fqfun	= CLSFQ;
		firqb.fqfil	= channel * 2;
	}
	else {
		firqb.fqfun	= RSTFQ;
		firqb.fqfil	= (-channel) * 2;
	}
	return(rstsys(CALFIP));
}
-h- rserro.c	Fri Oct 21 10:03:06 1983	RSERRO.C;3
#include <stdio.h>
#include <rsts.h>
#include <rserr.h>
 
 
rserror(errno)
/*
 * Fatal error exit.
 *
 * Print the RSTS error message on the keyboard, remove the current job
 * from the receiver table (just in case), close all channels, and exit. 
 */
{
	rs_err("?Fatal error: ", errno, "\r\n");
	rsexit();
}


rs_err(leadin, errno, trailer)
char	*leadin;		/* Leading message			*/
char	errno;			/* the RSTS error number		*/
char	*trailer;		/* Trailing message			*/
/*
 * Print error message "leadin <error text for errno> trailer"
 */
{
	char	outbuffer[30];

	clrfqx();
	firqb.fqfun = UU_ERR;
	firqb.fqfil = errno;
	rstsys(_UUO);
	strcpy(outbuffer, &firqb.fqfil);
	forcenl();
	print(leadin);
	print(outbuffer);
	print(trailer);
}
 
-h- rsexit.c	Fri Oct 21 10:03:06 1983	RSEXIT.C;3
#include <stdio.h>
#include <rsts.h>
#include <rserr.h>
 
rsexit()
/*
 * Remove the current job from the receiver table, close open files and
 * exit to the default run-time system. 
 */
{
	forcenl();
	clrfqx();
	rstsys(_MESAG);
	clrfqx();
	firqb.fqfun = CLSFQ;
	rstsys(CALFIP);
	exit();
}
-h- rsname.c	Fri Oct 21 10:03:06 1983	RSNAME.C;3
#include <stdio.h>
#include <rsts.h>
#include <rserr.h>
		
rsname(text)
char		*text;		/* What to stuff			*/
/*
 * Name the program as "text"
 */
{
	register int	txtlen;

	txtlen = strlen(text);
	clrfqx();
/*
ascr50((txtlen > 6) ? 6 : txtlen, text, &firqb.fqnam1[0]);
dumpfqb();
*/
	xrb.xrlen = txtlen;
	xrb.xrbc = txtlen;
	xrb.xrloc = text;
	rstsys(_FSS);
	rstsys(_NAME);
}
-h- rsopen.c	Fri Oct 21 10:03:06 1983	RSOPEN.C;3
#include <stdio.h>
#include <rsts.h>
#include <rserr.h>
 

#ifdef rt11
#define	RT_RMON		054	/* Work area starting address		*/
#define	RT_LOGTBL	014	/* Logical name table			*/
#define RT_MODE		004	/* Mode word for opens			*/

struct	{
	char	*pointer;	/* For addressing into the work area	*/
};

struct	{
	int	integer;
};
#endif

rs_open(channel, name, omode)
int		channel;	/* Channel number for open		*/
char		*name;		/* File name string			*/
char		*omode;		/* Mode "r", "a", or "w" only		*/
/*
 * Open a file, return error code -- zero for success.
 * Sorry, you must supply the channel.
 */
{
	register	char	*p;
	register	int	errcode;

retry:	clrfqx();
	xrb.xrlen	= strlen(name);	/* Length of the file name	*/
	xrb.xrbc	= xrb.xrlen;	/* Another copy of the length	*/
	xrb.xrloc	= name;		/* Name starting address	*/
	xrb.xrblk	= 44;		/* 44 byte logical name table	*/
#ifdef rt11
	p = RT_RMON->pointer + RT_LOGTBL;
	xrb.xrtime	= p;		/* Save start of logical table	*/
#endif
	if ((errcode = rstsys(_FSS)) != 0)
		return(-1);
	firqb.fqfil	= channel * 2;
	firqb.fqfun	= (*omode == 'w') ? CREFQ : OPNFQ;
/*
 * Force clustersize to zero (bug somewhere in RSTS)
 */
	firqb.fqclus	= 0;		/* ?? Bug ??			*/
	errcode = rstsys(CALFIP);
	if (*omode == 'a' && errcode == 5) {
		omode = "w";
		goto retry;
	}
	return(errcode);
}
-h- rsread.c	Fri Oct 21 10:03:06 1983	RSREAD.C;3
#include <stdio.h>
#include <rsts.h>
#include <rserr.h>
 
rs_read(channel, buffer, buflen, block, blockmsb, wait, modifier)
int		channel;		/* Channel to read from		*/
char		*buffer;		/* I/O buffer			*/
int		buflen;			/* Buffer size			*/
int		block;			/* Block number for disk	*/
int		blockmsb;		/* High-byte for disk block	*/
int		wait;			/* Wait time for terminal	*/
int		modifier;		/* Device modifier		*/
/*
 * read from this channel. Return
 *	>= 0	Number of bytes read
 *	<  0	-(error code)
 */
{
	register int	errcode;

	clrxrb();
	xrb.xrlen	= buflen;	/* Buffer length		*/
	xrb.xrbc	= 0;		/* Must be zero			*/
	xrb.xrloc	= buffer;	/* Buffer start			*/
	xrb.xrci	= channel * 2;	/* Channel number		*/
	xrb.xrblkm	= blockmsb;	/* High-byte for disk i/o	*/
	xrb.xrblk	= block;	/* Block number			*/
	xrb.xrtime	= wait;		/* Wait time for i/o		*/
	xrb.xrmod	= modifier;	/* Device (record) modifier	*/
	errcode = rstsys(_READ);
	return((errcode == 0) ? xrb.xrbc : -errcode);
}
-h- rsrec.c	Fri Oct 21 10:03:06 1983	RSREC.C;2
#define	rsts	1
#include <stdio.h>
#include <rsts.h>

rsrec(fp, mod)
FILE *fp;
int mod;
{
    fp->io_recm = mod;
}
-h- rsts.h	Fri Oct 21 10:03:06 1983	RSTS.H;6
/*
 *			R S T S . H
 *
 * Header file for calling RSTS/E I/O services from C.
 *
 * The following are defined:
 *
 *	struct rsts_xrb { .. } xrb;
 *
 *		Load/access values by xrb.xrlen, etc.
 *
 *	struct rsts_firqb { .. } firqb;
 *
 *		Load/access values by firqb.fqjob
 *
 *	RSTS/E EMT codes (CALFIP, _READ, etc.)  The '.' in the
 *	true definition is represented by '_'.
 *
 *	FIRQB function codes, PLAS (firqb.fqerno) function codes,
 *	_UUO or UUOFQ subfunction codes, handler indexes, open file
 *	flag bits, low-core layouts, and keyword status bits.
 *
 *	Also, the "get monitor tables" values are defined as offsets
 *	into the firqb.  Note that firqb/xrb values are volatile.
 *
 * The RSTS/E i/o library contains the following (macro) functions:
 *
 *	rstsys(emt)		Execute a RSTS/E emt, return error code.
 *	clrxrb()		Clear the XRB (before loading it with stuff)
 *	clrfqb()		Clear the FIRQB
 *	getxrb(myxrb)		Copy the system xrb   to   your area
 *	getfqb(myfirqb)		Copy the system firqb to   your area
 *	putxrb(myxrb)		Load the system xrb   from your area
 *	putfqb(myfqb)		Load the system firqb from your area
 *
 * For example, to check for a logical device name, you should:
 *	clrxrb();
 *	clrfqb();
 *	xrb.xrlen		= (first  word of radix-50);
 *	xrb.xrbc		= (second word of radix-50);
 *	firqb.fqdev		= (two bytes of ascii for device name check);
 *	firqb.fqdevn[0]		= (unit number);
 *	firqb.fqdevn[1]		= (non-zero if a real unit number);
 *	rstsys(_LOGS);
 */

/*
 * Define XRB structure
 */

struct rsts_xrb {
	int	xrlen;		/*   0 Length of i/o buffer in bytes	*/
	int	xrbc;		/*   2 Byte count for transfer		*/
	char *	xrloc;		/*   4 Buffer start address		*/
	char	xrci;		/*   6 Channel number * 2 for transfer	*/
	char	xrblkm;		/*   7 Random-access block number, MSB	*/
	int	xrblk;		/* 010 Random-access block number, LSB	*/
	int	xrtime;		/* 012 Wait time for terminal input	*/
	int	xrmod;		/* 014 Transfer modifier		*/
};
#define	xrbsiz	14		/* Length of xrb			*/

/*
 * Define FIRQB structure (twice to get all the bits)
 */

struct rsts_firqb {
	char	firqb_errcode;	/*   0 Reserved for returned error code	*/
	char	firqb_reserved;	/*   1 Reserved byte			*/
	char	fqjob;		/*   2 Holds your job number * 2	*/
	char	fqfun;		/*   3 Function requested		*/
	char	fqerno[1];	/*   4 Error message code and text	*/
	char	fqsizm;		/*   5 File size in blocks, MSB		*/
	int	fqppn;		/*   6 Project-programmer number	*/
	int	fqnam1[2];	/* 010 2-word filename in radix-50	*/
	int	fqext;		/* 014 .ext in radix-50			*/
	int	fqsiz;		/* 016 File size in blocks, low-order	*/
	int	fqnam2[3];	/* 020 3-word new radix-50 filename.ext */
	char	fqpflg;		/* 026 "Protection code real" indicator	*/
	char	fqprot;		/* 027 New protection code		*/
	int	fqdev;		/* 030 2-byte Ascii device name		*/
	char	fqdevn[2];	/* 032 1-byte unit, 1-byte real flag	*/
	int	fqclus;		/* 034 File cluster size for creates	*/
	int	fqnent;		/* 036 Number of entries on dir. lookup	*/
};

#define fqfil	fqerno[0]
#define fqbufl	fqnam2[0]
#define fqmode	fqnam2[1]
#define fqflag	fqnam2[2]

#define	fqbsiz	32		/* Firqb size in bytes			*/

/*
 * Define emt codes
 */

#define	EMT	0104000		/* EMT instruction			*/
#define	CALFIP	EMT+0		/* Call FIP, with firqb loaded		*/
#define	_READ	EMT+2		/* Read					*/
#define	_WRITE	EMT+4		/* Write				*/
#define	_CORE	EMT+6		/* Change user memory size (see below)	*/
#define	_SLEEP	EMT+8		/* Sleep job for N seconds		*/
#define	_PEEK	EMT+10		/* Peek at memory			*/
#define	_SPEC	EMT+12		/* Special i/o function			*/
#define	_TTAPE	EMT+14		/* Enter tape mode			*/
#define	_TTECH	EMT+16		/* Enable echo				*/
#define	_TTNCH	EMT+18		/* Disable echo				*/
#define	_TTDDT	EMT+20		/* DDT submode				*/
#define	_TTRST	EMT+22		/* Cancel CTRL/O effect			*/
#define	_TIME	EMT+24		/* Get timing information		*/
#define	_POSTN	EMT+26		/* Get device horizontal position	*/
#define	_DATE	EMT+28		/* Get current date and time		*/
#define	_SET	EMT+30		/* Set keyword bit(s)			*/
#define	_STAT	EMT+32		/* Get my statistics			*/
#define	_RUN	EMT+34		/* Run a new program			*/
#define	_NAME	EMT+36		/* Install a new program name		*/
#define	_EXIT	EMT+38		/* Exit to default run-time system	*/
#define	_RTS	EMT+40		/* Change to a new run-time system	*/
#define	_ERLOG	EMT+42		/* Log an error from the run-time sys.	*/
#define	_LOGS	EMT+44		/* Check for logical device name	*/
#define	_CLEAR	EMT+46		/* Clear keyword bits			*/
#define	_MESAG	EMT+48		/* Message send/receive			*/
#define	_CCL	EMT+50		/* CCL checker				*/
#define	_FSS	EMT+52		/* File string scan			*/
#define	_UUO	EMT+54		/* UUO hook				*/
#define	_CHAIN	EMT+56		/* Chain to a new program		*/
#define	_PLAS	EMT+58		/* Resident library control		*/
#define	_RSX	EMT+60		/* Enter RSX emulation			*/
#define	_ULOG	EMT+62		/* Assign/reassign/deassign device	*/

/*
 * Note: do not use the _CORE directive when running under RT11 emulation
 */

/*
 * File processor function codes (loaded into firqb->fqfun)
 */

#define	CLSFQ	0		/* Close an open channel		*/
#define	OPNFQ	2		/* Open a channel			*/
#define	CREFQ	4		/* Create/extend/open a channel		*/
#define	DLNFQ	6		/* Delete a named file			*/
#define	RENFQ	8		/* Rename a file			*/
#define	DIRFQ	10		/* Directory information		*/
#define	UUOFQ	12		/* Process UUO				*/
#define	ERRFQ	14		/* Get error message text		*/
#define	RSTFQ	16		/* Reset (close) [all] channels		*/
#define	LOKFQ	18		/* Lookup a file			*/
#define	ASSFQ	20		/* Assign a device			*/
#define	DEAFQ	22		/* Deassign a device			*/
#define	DALFQ	24		/* Deassign all devices			*/
#define	CRTFQ	26		/* Create/extend/open .tmp file on disk	*/
#define	CRBFQ	28		/* Create/extend/open compiled file	*/


/*
 * _PLAS function codes (loaded into firqb->fqerno)
 */

#define	ATRFQ	0		/* Attach region (resident library)	*/
#define	DTRFQ	2		/* Detach region (resident library)	*/
#define	CRAFQ	4		/* Create address window		*/
#define	ELAFQ	6		/* Eliminate address window		*/
#define	MAPFQ	8		/* Map address window			*/
#define	UMPFQ	10		/* Unmap address window			*/

/*
 * _UUO/UUOFQ subfunction codes (UU_??? for Basic-Plus runtime requests)
 */

#define	UU_SPL	-28		/* One-shot spooling request		*/
#define	UU_DMP	-27		/* On-line monitor snapshot		*/
#define	UU_FIL	-26		/* File utility				*/
#define	UU_ATR	-25		/* Read/write file attributes		*/
#define	UU_CCL	-24		/* CCL command add/delete		*/
#define	UU_???	-23		/* Reserved (Basic-Plus)		*/
#define	UU_???	-22		/* Reserved (Basic-Plus)		*/
#define	UU_???	-21		/* Reserved (Basic-Plus)		*/
#define	UU_???	-20		/* Reserved (Basic-Plus)		*/
#define	UU_LOG	-19		/* Set number of allowed logins		*/
#define	UU_RTS	-18		/* Run-time system & res. lib. control	*/
#define	UU_NAM	-17		/* Set file's run-time system name	*/
#define	UU_DIE	-16		/* Special shutup logout		*/
#define	UU_ACT	-15		/* Accounting information dump		*/
#define	UU_DAT	-14		/* Date/time changer			*/
#define	UU_PRI	-13		/* Priority, runburst changer		*/
#define	UU_TB2	-12		/* 2nd part of monitor tables		*/
#define	UU_BCK	-11		/* Backup accounting changer		*/
#define	UU_???	-10		/* Reserved (Basic-Plus)		*/
#define	UU_HNG	-9		/* Hangup/enable a dataset		*/
#define	UU_FCB	-8		/* Get fcb/ddb information		*/
#define	UU_???	-7		/* Reserved (Basic-Plus)		*/
#define	UU_POK	-6		/* Poke monitor memory			*/
#define	UU_???	-5		/* Reserved (Basic-Plus)		*/
#define	UU_???	-4		/* Reserved (Basic-Plus)		*/
#define	UU_TB1	-3		/* 1st part of monitor tables		*/
#define	UU_NLG	-2		/* Set no logins			*/
#define	UU_YLG	-1		/* Set number of logins to maximum	*/
#define	UU_PAS	0		/* Create an account			*/
#define	UU_DLU	1		/* Delete an account			*/
#define	UU_CLN	2		/* Clean a disk pack			*/
#define	UU_MNT	3		/* Disk pack mount/dismount		*/
#define	UU_LIN	4		/* Login				*/
#define	UU_BYE	5		/* Logout				*/
#define	UU_ATT	6		/* Attach				*/
#define	UU_DET	7		/* Detach				*/
#define	UU_CHU	8		/* Change password/quota		*/
#define	UU_ERR	9		/* Get error message text		*/
#define	UU_ASS	10		/* Assign				*/
#define	UU_DEA	11		/* Deassign				*/
#define	UU_DAL	12		/* Deassign all devices			*/
#define	UU_ZER	13		/* Zero device/directory		*/
#define	UU_RAD	14		/* Read accounting information		*/
#define	UU_DIR	15		/* Get directory information		*/
#define	UU_TRM	16		/* Set terminal characteristics		*/
#define	UU_LOK	17		/* Wildcard directory lookup		*/
#define	UU_???	18		/* Reserved (Basic-Plus)		*/
#define	UU_CHE	19		/* Cache enable/disable			*/
#define	UU_CNV	20		/* Convert date/time to ascii		*/
#define	UU_SLN	21		/* Set/clear system-wide logical names	*/
#define	UU_???	22		/* Reserved (Basic-Plus)		*/
#define	UU_SWP	23		/* Add/remove swap/err/ovr files	*/
#define	UU_JOB	24		/* Job creation (spawn)			*/
#define	UU_PPN	25		/* Wildcard P,PN lookup			*/
#define	UU_SYS	26		/* Return job status information	*/
#define	UU_KMC	27		/* Connect KMC-11 to another device	*/

/*
 * Device handler indexes
 */

#define	DSKHND	0		/* Disk(s)				*/
#define	TTYHND	2		/* Terminal(s)				*/
#define	DTAHND	4		/* DECtape				*/
#define	LPTHND	6		/* Line printer(s)			*/
#define	PTRHND	8		/* Paper tape reader			*/
#define	PTPHND	10		/* Paper tape punch			*/
#define	CDRHND	12		/* Card reader				*/
#define	MTAHND	14		/* Magtape(s)				*/
#define	PKBHND	16		/* Pseudo-keyboards			*/
#define	RXDHND	18		/* Floppy disk				*/
#define	RJEHND	20		/* 2780 Remote Job Entry		*/
#define	NULHND	22		/* Null device				*/
#define	DMCHND	24		/* DMC-11 device			*/
#define	AUDHND	26		/* Autodial device (DN-11)		*/
#define	PLTHND	28		/* X-Y plotter				*/
#define	DT2HND	30		/* DECtape II (TU-58)			*/
#define	KMCHND	32		/* KMC-11 Microprocessor		*/
#define	IBMHND	34		/* IBM interconnect			*/
#define	MBXHND	36		/* Mailbox (reserved for VAX-11)	*/

/*
 * Flag bits for an open file
 */

#define	DDNFS	256		/* File(device) is non-file structured	*/
#define	DDRLO	512		/* File(device) is read-locked		*/
#define	DDWLO	1024		/* File(device) is write-locked		*/
#define	FLGPOS	2048		/* File(device) keeps it's own position	*/
#define	FLGMOD	4096		/* File(device) accepts modifiers	*/
#define	FLGFRC	8192		/* File(device) is byte-oriented	*/
#define	FLGKB	16384		/* File(device) is interactive		*/
#define	FLGRND	0100000		/* File(device) is random-access	*/


/*
 * Define job-unique low memory layout.
 */

#define	KEY			0400	/* Loc. of Job status keyword	*/
#define	FIRQB			0402	/* Loc. of firqb		*/
#define	XRB			0442	/* Loc. of xrb			*/
#define	CORCMN			0460	/* Loc. of core common		*/
#define key	(*((int *) KEY))
#define firqb	(*((struct rsts_firqb *) FIRQB))
#define xrb	(*((struct rsts_xrb *) XRB))
#define corcmn	((char *) CORCMN)

#define	usrppn	(*((int *) 0734))	/* User-assignable p,pn number	*/
#define	usrprt	(*((int *) 0736))	/* User-assignable prot. code	*/
#define	usrlog	(*((int *) 0740))	/* User logical dev. name table	*/
/*
 * Define keyword status bits
 */

#define	JFSPRI	000400		/* Job is at special run priority	*/
#define	JFFPP	001000		/* Job uses floating-point processor	*/
#define	JFPRIV	002000		/* Job has permanent privileges		*/
#define	JFSYS	004000		/* Job has temporary privileges active	*/
#define	JFNOPR	010000		/* Job is not yet logged in		*/
#define	JFBIG	020000		/* Job can exceed its private mem. max.	*/
#define	JFLOCK	040000		/* Job is not to be swapped		*/

/*
 * Define the error codes (used to by in RSERR.H)
 */

#define	BADDIR	1
#define	BADNAM	2
#define	INUSE 	3
#define	NOROOM	4
#define	NOSUCH	5
#define	NODEVC	6
#define	NOTCLS	7
#define	NOTAVL	8
#define	NOTOPN	9
#define	PRVIOL	10
#define	EOFERR 	11
#define	ABORT 	12
#define	DATERR	13
#define	HNGDEV	14
#define	HNGTTY	15
#define	FIEXST	16
#define	DTOOOF	17
#define	BADFUO	18
#define	INTLCK	19
#define	WRGPAK	20
#define	NOTMNT	21
#define	PAKLCK	22
#define	BADCLU	23
#define	PRIVAT	24
#define	INTPAK	25
#define	BADPAK	26
#define	DETKEY	27
#define	CTRLCE	28
#define	SATTBD	29
#define	DEVNFS	30
#define	BADCNT	31
#define	NOBUFS	32
#define	B.4   	33
#define	B.10  	34
#define	B.250 	35
#define	B.STAK	36
#define	B.SWAP	37
#define	B.PRTY	38
#define	MAGSEL	39
#define	MAGRLE	40
#define	NRRTS 	41
#define	VCSERR	42
#define	VCAERR	43
#define	SIZERR	44
#define	VCOERR	45
#define	BSERR 	46
#define	LINERR	47
#define	FLTERR	48
#define	EXPERR	49
#define	FMTERR	50
#define	FIXERR	51
#define	BDNERR	52
#define	LOGERR	53
#define	SQRERR	54
#define	SUBERR	55
#define	MINVER	56
#define	ODD   	57
#define	ONBAD 	58
#define	NEDERR	59
#define	IOLERR	60
#define	DIVBY0	61
#define	NORTS 	62
#define	FIELDE	63
#define	NORACS	64
#define	NOTMTA	65
#define	ERRERR	66
#define	BADSWT	67
#define	STMERR	71
#define	EXITTM	72
#define	EXITNR	73
#define	UNDFNI	74
#define	COSERR	75
#define	TLOPNV	76
#define	TLNZSP	77
#define	TLNOIT	78
#define	TLIFFE	79
#define	TLCONI	80
#define	TLNOTF	81
#define	TLQDUM	82
#define	TLMFND	83
#define	TLRNNM	84
#define	MODERR	85
#define	OUTOAS	87
#define	FUNERR	88
#define	TLTMAF	89
#define	TLINCD	90
#define	CPNSDF	91
#define	CPUPFR	92
#define	CPUFNX	93
#define	CPUPDF	94
#define	CPUPED	95
#define	TLJNKY	96
#define	TLNOFN	97
#define	SASYNE	98
#define	SAFNOS	99
#define	SASNOI	100
#define	TLURTP	101
#define	TLXDIM	102
#define	FUCORE	103
#define	RESERR	104
#define	DIMED2	105
#define	TLIDIM	106
#define	NOGOTO	107
#define	EOSERR	108
#define	TLCNTD	109
#define	TLPRNM	110
#define	EDBMCE	111
#define	EDEXON	112
#define	NRNERR	113
#define	EDCONE	114
#define	EDARSV	115
#define	PRERRS	116
#define	UDMERR	117
#define	PRNER1	118
#define	NONOIM	119
#define	PRNER2	120
#define	BADERR	121
#define	DISERR	122
#define	STPERR	123
#define	DIMERR	124
#define	NOMATH	125
#define	XCDCOR	126
#define	SCAERR	127
-h- rstslb.cmd	Fri Oct 21 10:03:06 1983	RSTSLB.CMD;2
cc [c.rstslb]ERROR
AS ERROR/d
cc [c.rstslb]EXIT
AS EXIT/d
cc [c.rstslb]FCLOSE
AS FCLOSE/d
cc [c.rstslb]FFLUSH
AS FFLUSH/d
cc [c.rstslb]FGETS
AS FGETS/d
cc [c.rstslb]FOPEN
AS FOPEN/d
cc [c.rstslb]GETC
AS GETC/d
cc [c.rstslb]INIT
AS INIT/d
cc [c.rstslb]IOV
AS IOV/d
cc [c.rstslb]PRINTF
AS PRINTF/d
cc [c.rstslb]PUTC
AS PUTC/d
cc [c.rstslb]PUTS
AS PUTS/d
cc [c.rstslb]RSREC
AS RSREC/d
cc [c.rstslb]SLEEP
AS SLEEP/d
cc [c.rstslb]PUTFQB
as PUTFQB/d
cc [c.rstslb]GETFQB
as GETFQB/d
cc [c.rstslb]DMPFQB
as DMPFQB/d
cc [c.rstslb]CLRFQX
as CLRFQX/d
cc [c.rstslb]CLRFQB
as CLRFQB/d
cc [c.rstslb]PUTXRB
as PUTXRB/d
cc [c.rstslb]GETXRB
as GETXRB/d
cc [c.rstslb]CLRXRB
as CLRXRB/d
cc [c.rstslb]GETW
AS GETW/d
cc [c.rstslb]putw
AS putw/d
cc [c.rstslb]FEOF
as FEOF/d
cc [c.rstslb]CLEARE
as CLEARE/d
cc [c.rstslb]signal
as signal/d
macro sigast=[c.rstslb]sigast
macro rstsys=[c.rstslb]rt11,[c.rstslb]rstsys
macro rtemt=[c.rstslb]rt11,[c.rstslb]rtemt

run $libr
sy:[1,216]rstslb=c:clib/d
IOV
UNGETC
SLEEP
SETCC
REWIND
QSET
PUTW
PUTS
PUTC
PRINTF
ISATTY
$$QIOW
$$PUTC
$$PUT
$$GETC
$$GET
$$FOPT
$$FOPA
$$FLUN
$$FLSH
$$FALO
$$FCSI
$$CLFU
$$CL16
$$INIT
GETW
GETTTY
GETS
$$GCMD
GETCHA
FWRITE
FWILD
FTTY
FTELL
FSPOOL
FSEEK
FREC
FREAD
FPUT
FOPEN
FMKDL
FLUN
FGETS
FGETNA
FGET
FFLUSH
FERROR
FERR
FEOF
FCLOSE
FCLEAR
EXIT
ERROR
DELETE
CLEARE
SCANF

^Z
LIBR
rstslb=rstslb/c
PUTFQB,GETFQB,DMPFQB,CLRFQX/c
CLRFQB,PUTXRB,GETXRB,CLRXRB/c
ERROR,EXIT,FCLOSE,FFLUSH,FGETS/c
FOPEN,GETC,INIT,IOV,PRINTF/c
PUTC,PUTS,RSREC,SLEEP/c
GETW,putw,FEOF,CLEARE/c
signal,sigast,rtemt,rstsys
^Z
pip c:<40>=rstslb.obj/w
pip PUTFQB.obj,GETFQB.obj,DMPFQB.obj,CLRFQX.obj/de/w
pip CLRFQB.obj,PUTXRB.obj,GETXRB.obj,CLRXRB.obj/de/w
pip ERROR.obj,EXIT.obj,FCLOSE.obj,FFLUSH.obj,FGETS.obj/de/w
pip FOPEN.obj,GETC.obj,INIT.obj,IOV.obj,PRINTF.obj/de/w
pip PUTC.obj,PUTS.obj,RSREC.obj,SLEEP.obj/de/w
pip GETW.obj,putw.obj,FEOF.obj,CLEARE.obj/de/w
pip signal.obj,sigast.obj,rtemt.obj,rstsys.obj/de/w
-h- rstsys.mac	Fri Oct 21 10:03:06 1983	RSTSYS.MAC;3
	.title	rstsys	Execute a RSTS EMT
	.ident	/000001/
;
;+
;
; Index		Execute a RSTS EMT
;
; Usage
;
;	int
;	rstsys(emt)
;
; Description
;
;	Execute a rsts emt, returning the error code.
;
; Bugs
;
;-
;
; Edit history
; 000001 21-Apr-82 JLB	Initial edit
; 000002  7-May-82 JLB	Fix $$OPSYS bug
;

firqb = 0402
	.globl	$$opsy

	.psect	.prog.
rstsys::
	mov	(pc)+,	-(sp)		; Build cleanup command on stack
	  jsr	sp, @(sp)+		; Returns from command exec.
	mov	2+2(sp),-(sp)		; Get user emt code (hope it's an EMT)
	cmp	$$opsy,	#7		; Under RT11?
	bne	no.rt			; If so we must
	mov	(pc)+,	-(sp)		;  Stuff the prefix emt on the stack
	  emt	377			;  Emt prefix code
no.rt:
	jsr	pc,	(sp)		; Execute the stuff
	clr	r0			; Error code is a pos. byte
	bisb	@#firqb,r0		; Get error code from firqb
	rts	pc			; And exit
	.end

-h- rstsys.rsx	Fri Oct 21 10:03:06 1983	RSTSYS.RSX;2
firqb = 0402
	.psect	.prog.							/03
rstsys:
	mov	(pc)+,-(sp)		/ Build cleanup command on stack
	  jsr	sp,*(sp)+		/ Returns from command exec.
	mov	2+2(sp),-(sp)		/ Get user emt code
	jsr	pc,(sp)			/ Execute the stuff
	clr	r0			/ Error code is a pos. byte
	bisb	*$firqb,r0		/ Get error code from firqb
	rts	pc			/ And exit

	.globl	rstsys
-h- rstsys.rt	Fri Oct 21 10:03:06 1983	RSTSYS.RT;2
firqb = 0402
	.psect	.prog.							/03
rstsys:
	mov	(pc)+,-(sp)		/ Build cleanup command on stack
	  jsr	sp,*(sp)+		/ Returns from command exec.
	mov	2+2(sp),-(sp)		/ Get user emt code
	mov	(pc)+,-(sp)		/ RT11	Stuff the emt opcode
	  emt	377			/ RT11	Emt prefix code
	jsr	pc,(sp)			/ Execute the stuff
	clr	r0			/ Error code is a pos. byte
	bisb	*$firqb,r0		/ Get error code from firqb
	rts	pc			/ And exit

	.globl	rstsys
-h- rswrit.c	Fri Oct 21 10:03:06 1983	RSWRIT.C;3
#include <stdio.h>
#include <rsts.h>
#include <rserr.h>

rs_write(channel, buffer, buflen, block, blockmsb, modifier)
int		channel;		/* Channel to read from		*/
char		*buffer;		/* I/O buffer			*/
int		buflen;			/* Buffer size			*/
int		block;			/* Block number for disk	*/
int		blockmsb;		/* High-byte for disk block	*/
int		modifier;		/* Device modifier		*/
/*
 * Write to this channel. Return zero on success, else error code
 */
{
	register int	errcode;

	clrxrb();
	xrb.xrlen	= buflen;	/* Buffer length		*/
	xrb.xrbc	= buflen;	/* Number of bytes to write	*/
	xrb.xrloc	= buffer;	/* Buffer start			*/
	xrb.xrci	= channel * 2;	/* Channel number		*/
	xrb.xrblkm	= blockmsb;	/* High-byte for disk i/o	*/
	xrb.xrblk	= block;	/* Block number			*/
	xrb.xrmod	= modifier;	/* Device (record) modifier	*/
	return(rstsys(_WRITE));
}
-h- rsx.mac	Fri Oct 21 10:03:06 1983	RSX.MAC;2

	.title	rsx	rsx header file
;
; Version of 10-Feb-82
;
RSX	=	1		;Assemble for RSX
C$$SXT	=	1		;Assume SXT instruction
				;Note: set C$$SXT = 0 for 11/04, 11/05,
				; 11/20 and 11/40 without EIS.
C$$EIS	=	C$$SXT		;Assume inline EIS if C$$SXT.  This
				; may be overridden at compile time.
C$$FLT	=	0		;Assume double precision
N$$FIL	=	8.		;For the RSX run-time library,
				;Default to 8 simultaneously open files.
				;Note: change this to allocate block buffers.
C$PMTR	=	4		;Locally define C$PMTR and C$AUTO
C$AUTO	=	-6		;To minimize global symbol references

.IIF	NDF	L$$IST	.NLIST
.IIF	NDF	L$$IST	.DSABL	CRF
.IIF	NDF	C$$SXT	C$$SXT	=	0	; No SXT
.IIF	NDF	C$$EIS	C$$EIS	=	0	; No EIS
.MACRO	CALL	ARG1,ARG2
.IF B	ARG2
	  JSR	PC,ARG1
.IFF
	  JSR	ARG1,ARG2
.ENDC
.ENDM	CALL

.MACRO	CALLR	ARG1
	  JMP	ARG1
.ENDM

.MACRO	RETURN	ARG1
.IF B	ARG1
	  RTS	PC
.IFF
	  RTS	ARG1
.ENDC
.ENDM	RETURN

;
; This macro defines the crash instruction
;
.MACRO	CRASH
.LIST
	BPT
.NLIST
.ENDM	CRASH

	.ENABL	LC, GBL
	.NLIST	CND, BEX
.IIF	NDF	L$$IST	.ENABL	CRF
.IIF	NDF	L$$IST	.LIST

-h- rsxlib.cmd	Fri Oct 21 10:03:06 1983	RSXLIB.CMD;2
XCC [5,6]ERROR
XAS ERROR -D
XCC [5,6]EXIT
XAS EXIT -D
XCC [5,6]FCLOSE
XAS FCLOSE -D
XCC [5,6]FFLUSH
XAS FFLUSH -D
XCC [5,6]FGETS
XAS FGETS -D
XCC [5,6]FOPEN
XAS FOPEN -D
XCC [5,6]GETC
XAS GETC -D
XCC [5,6]INIT
XAS INIT -D
XCC [5,6]IOV
XAS IOV -D
XCC [5,6]PRINTF
XAS PRINTF -D
XCC [5,6]PUTC
XAS PUTC -D
XCC [5,6]PUTS
XAS PUTS -D
XCC [5,6]RSREC
XAS RSREC -D
XCC [5,6]SLEEP
XAS SLEEP -D
XCC [5,6]PUTFQB
XAS PUTFQB -D
XCC [5,6]GETFQB
XAS GETFQB -D
XCC [5,6]DMPFQB
XAS DMPFQB -D
XCC [5,6]CLRFQX
XAS CLRFQX -D
XCC [5,6]CLRFQB
XAS CLRFQB -D
XCC [5,6]PUTXRB
XAS PUTXRB -D
XCC [5,6]GETXRB
XAS GETXRB -D
XCC [5,6]CLRXRB
XAS CLRXRB -D
XCC [5,6]GETW
XAS GETW -D
XCC [5,6]putw
XAS putw -D
XCC [5,6]FEOF
XAS FEOF -D
XCC [5,6]CLEARE
XAS CLEARE -D
XCC [5,6]signal
XAS signal -D
mac sigast=[5,6]sigast
mac rstsys=[5,6]rsx,[5,6]rstsys

PIP sy:rstslb=c:c.olb
LBR
sy:rstslb/de:IOV:UNGETC:SLEEP:SETCC:REWIND:QSET:PUTW:PUTS:PUTC:PRINTF
sy:rstslb/de:ISATTY:$$QIOW:$$PUTC:$$PUT:$$GETC:$$GET:$$FOPT:$$FOPA:$$FLUN
sy:rstslb/de:$$FLSH:$$FALO:$$FCSI:$$CLFU:$$CL16:$$INIT:GETW:GETTTY:GETS
sy:rstslb/de:$$GCMD:GETCHA:FWRITE:FWILD:FTTY:FTELL:FSPOOL:FSEEK:FREC
sy:rstslb/de:FREAD:FPUT:FOPEN:FMKDL:FLUN:FGETS:FGETNA:FGET:FFLUSH:FERROR
sy:rstslb/de:FERR:FEOF:FCLOSE:FCLEAR:EXIT:ERROR:DELETE:CLEARE:SCANF
sy:rstslb/co
sy:rstslb=PUTFQB,GETFQB,DMPFQB,CLRFQX
sy:rstslb=CLRFQB,PUTXRB,GETXRB,CLRXRB
sy:rstslb=ERROR,EXIT,FCLOSE,FFLUSH,FGETS
sy:rstslb=FOPEN,GETC,INIT,IOV,PRINTF
sy:rstslb=PUTC,PUTS,RSREC,SLEEP
sy:rstslb=GETW,putw,FEOF,CLEARE
sy:rstslb=signal,sigast,rstsys
^Z
pip c:<40>=sy:rstslb.olb/w
pip PUTFQB.obj,GETFQB.obj,DMPFQB.obj,CLRFQX.obj/DE/W
pip CLRFQB.obj,PUTXRB.obj,GETXRB.obj,CLRXRB.obj/DE/W
pip ERROR.obj,EXIT.obj,FCLOSE.obj,FFLUSH.obj,FGETS.obj/DE/W
pip FOPEN.obj,GETC.obj,INIT.obj,IOV.obj,PRINTF.obj/DE/W
pip PUTC.obj,PUTS.obj,RSREC.obj,SLEEP.obj/DE/W
pip GETW.obj,putw.obj,FEOF.obj,CLEARE.obj/DE/W
pip signal.obj,sigast.obj,rstsys.obj/DE/W
-h- rt11.mac	Fri Oct 21 10:03:06 1983	RT11.MAC;2

	.title	rt11	rt11 header file
;
; Version of 10-Feb-82
;
RSX	=	0		;Assemble for RT11
C$$SXT	=	1		;Assume SXT instruction
				;Note: set C$$SXT = 0 for 11/04, 11/05,
				; 11/20 and 11/40 without EIS.
C$$EIS	=	0		;Disable inline EIS
				; may be overridden at compile time.
C$$FLT	=	0		;Assume double precision
C$PMTR	=	4		;Locally define C$PMTR and C$AUTO
C$AUTO	=	-6		;To minimize global symbol references

.IIF	NDF	L$$IST	.NLIST
.IIF	NDF	L$$IST	.DSABL	CRF
.IIF	NDF	C$$SXT	C$$SXT	=	0	; No SXT
.IIF	NDF	C$$EIS	C$$EIS	=	0	; No EIS
.MACRO	CALL	ARG1,ARG2
.IF B	ARG2
	  JSR	PC,ARG1
.IFF
	  JSR	ARG1,ARG2
.ENDC
.ENDM	CALL

.MACRO	CALLR	ARG1
	  JMP	ARG1
.ENDM

.MACRO	RETURN	ARG1
.IF B	ARG1
	  RTS	PC
.IFF
	  RTS	ARG1
.ENDC
.ENDM	RETURN

;
; This macro defines the crash instruction
;
.MACRO	CRASH
.LIST
	BPT
.NLIST
.ENDM	CRASH

	.ENABL	LC, GBL
	.NLIST	CND, BEX
.IIF	NDF	L$$IST	.ENABL	CRF
.IIF	NDF	L$$IST	.LIST

-h- rtemt.mac	Fri Oct 21 10:03:06 1983	RTEMT.MAC;2
	.title	rtemt	Execute a RT11 EMT
	.ident	/000001/
;
;+
;
; Index		Execute a RT11 EMT after loading r0
;
; Usage
;
;	int
;	rtemt(emt, r0value)
;
; Description
;
;	Execute a rt11 emt after loading r0.
;
; Bugs
;
;-
;
; Edit history
; 000001 21-Apr-82 JLB	Initial edit
;


;
; Do an RT11 EMT after loading R0
;
; Usage:
;	rtemt(emt, r0)
;
	.globl	csv$
	.globl	cret$

	.psect	.prog.
rtemt::
	jsr	r5,	csv$	; Save the regs and setup R5
	mov	C$PMTR+2(r5),r0	; Load R0 from the second arg
	mov	(pc)+,	-(sp)	; Push a "return from stack" on the stack
	  jsr	sp, @(sp)+	;  "Return" to be pushed
	mov	C$PMTR+0(r5),-(sp) ; Push the EMT (No error checking!!!)
	jsr	pc,	(sp)	; Call the routine created on the stack
	jmp	cret$		; And return to our caller
	.end

-h- sigast.mac	Fri Oct 21 10:03:06 1983	SIGAST.MAC;2
;
; sigast.mac defines the routine(s) that catch signals.
;
; These routines are put in as AST servers and determine what AST called
; them. They then call the appropriate routine, telling it which signal.
;
; Assuming the signal number is in which, the C code would look like:
;
;	if (~(which & 1))
;	    (*$$sigs[which])(which);
;
; The int and quit signals are both assumed to by CTRL/C, and undo the
; implied CTRL/O.
;
;****************************************************************
;*								*
;*			W A R N I N G ! ! !			*
;*								*
;* The way we tell which interupt we're catching, is with a	*
;* bunch of entry points pointed into a series of INC WHICHs.	*
;* Ghu help you if you should be interupted during the INCs,	*
;* or before which is saved into R1! In general, don't get	*
;* interupted during an interupt handler. You were warned.	*
;*								*
;****************************************************************
.RCTRLO = 104355	; RT11 Cancel CTRL-O
.TTRST	= 104026	; RSTS Cancel CTRL-O

	.psect	.data.
which:	.word	0
	.psect	.prog.

	inc	which	; 16
	inc	which	; SIG_TERM
	inc	which	; SIG_ALRM
	inc	which	; SIG_PIPE
	inc	which	; SIG_SYS
	inc	which	; SIG_SEGV
	inc	which	; SIG_BUS
	inc	which	; SIG_KILL
	inc	which	; SIG_FPE
	inc	which	; SIG_EMT
	inc	which	; SIG_IOT
	inc	which	; SIG_TRAP
	inc	which	; SIG_ILL
	inc	which	; SIG_QUIT
	inc	which	; SIG_INT
	inc	which	; SIG_HUP
$$sig0:
	mov	r0, -(sp)	; Save R0
	mov	r1, -(sp)	;  and R1
	mov	which, r1	; Get the signal number
	clr	which		;  and make sure the next one works
				;
				; Breath a sigh of relief here - we've
				; closed the interupt window.
				;

	cmp	#2, r1		; If signal is quit or interupt
	bgt	get.sig		;  we want to undo any CTRL/Os
	cmp	#3, r1
	blt	get.sig
	jsr	pc, no.ctrlo
get.sig:
	mov	r1, -(sp)	; Signal number is the argument
	asl	r1		; Use it as a word index
	mov	$$sigs(r1), r1	;  into the signal table
	bit	#1, r1		; If the entry is odd, then ignore the signal
	bne	nocall		; Otherwise it is the routine to call
	jsr	pc, (r1)	; So call it.
nocall:
	tst	(sp)+		; Get the arg (the signal no) off the stack
	mov	(sp)+, r1	; Restore R1
	mov	(sp)+, r0	;  and R0
	rti	

no.ctrlo:			; We need to re-enadle ouput.
	tst	$$rsts		; On RSTS?
	beq	no.rsts
	cmp	$$opsy, #7	;  and RT11.RTS?
	bne	no.rt11		;   do rtemt(.RCTRLO, 0)
	clr	-(sp)		; Push the zero
	mov	#.RCTRLO, -(sp)	;  and the EMT
	jsr	pc, rtemt	;   and call the routine
	cmp	(sp)+,(sp)+	; Get the args off the stack
	br	done		;  and call it a day.
no.rt11:
	mov	#.TTRST,-(sp)	; Then we can do RSTS EMTs
	jsr	pc, rstsys	;  via rstsys(.TTRST)
	tst	(sp)+		; Get the arg off the stack.
no.rsts:
done:	rts	pc

	.globl	$$rsts
	.globl	$$opsy
	.globl	rtemt
	.globl	rstsys

	.globl	$$sigs

	.globl	$$sig0
	.end
-h- signal.c	Fri Oct 21 10:03:06 1983	SIGNAL.C;2
/*
 *	signal - catch or ignore signals
 */
#include <rsts.h>
#include <signal.h>

extern	$$rsts;
extern	$$opsy;

extern	$$sig0();

int	(*$$sigs[NSIG])() = {
    SIG_DFL,	/*		Undefined */
    SIG_DFL,	/* SIGHUP	hangup */
    SIG_DFL,	/* SIGINT	interrupt */
    SIG_DFL,	/* SIGQUIT	quit */
    SIG_DFL,	/* SIGILL	illegal instruction (not reset when caught) */
    SIG_DFL,	/* SIGTRAP	trace trap (not reset when caught) */
    SIG_DFL,	/* SIGIOT	IOT instruction */
    SIG_DFL,	/* SIGEMT	EMT instruction */
    SIG_DFL,	/* SIGFPE	floating point exception */
    SIG_DFL,	/* SIGKILL	kill (cannot be caught or ignored) */
    SIG_DFL,	/* SIGBUS	bus error */
    SIG_DFL,	/* SIGSEGV	segmentation violation */
    SIG_DFL,	/* SIGSYS	bad argument to system call */
    SIG_DFL,	/* SIGPIPE	write to a pipe with no one to read it */
    SIG_DFL,	/* SIGALRM	alarm clock */
    SIG_DFL,	/* SIGTERM	software termination signal from kill */
    SIG_DFL	/* 16		Unassigned */
};

#define EMT	0104000
#define	_SETCC	EMT+0362		/* RT11/RSTS .setcc call	*/
#define	_RCTRLO	EMT+0355		/* RT11 clear CTRL/O call	*/
#define	r_cast	(*((int *) 024))	/* RSX/RSTS CTRL/C AST vector	*/

signal(sig, func)
int	sig;
int	func;
{
    int	catcher;
    int	old;

    if (sig <= 0 || sig >= NSIG)
        return(-1);

    if (func == SIG_DFL)
        catcher = 0;
    else
        catcher = ((int) $$sig0) - (sig * 4);

    if (func & 1)
        func = SIG_IGN;

    switch(sig) {
	case SIGINT:	/* interrupt */
	case SIGQUIT:	/* quit */
            if ($$rsts) {
                if ($$opsy == 7) {
                    rtemt(_SETCC, catcher);
                }
                else {
                    r_cast = catcher;
                }
            }
            break;
	case SIGHUP:	/* hangup */
	case SIGILL:	/* illegal instruction (not reset when caught) */
	case SIGTRAP:	/* trace trap (not reset when caught) */
	case SIGIOT:	/* IOT instruction */
	case SIGEMT:	/* EMT instruction */
	case SIGFPE:	/* floating point exception */
	case SIGKILL:	/* kill (cannot be caught or ignored) */
	case SIGBUS:	/* bus error */
	case SIGSEGV:	/* segmentation violation */
	case SIGSYS:	/* bad argument to system call */
	case SIGPIPE:	/* write to a pipe with no one to read it */
	case SIGALRM:	/* alarm clock */
	case SIGTERM:	/* software termination signal from kill */
            break;
        default:
            return(-1);
        break;
    }
    old = $$sigs[sig];
    $$sigs[sig] = func;
    return(old);    
}

ssignal(sig, func)
int	sig;
int	func;
{
    int	err;

    err = signal(sig, func);
    if (err == -1)
        return(0);
    else
        return(err);
}
-h- signal.h	Fri Oct 21 10:03:06 1983	SIGNAL.H;2

/*
 *	signal - signal value definitions include file
 */
#define NSIG	17	/* number of signals */

#define	SIGHUP	1	/* hangup */
#define	SIGINT	2	/* interrupt */
#define	SIGQUIT	3	/* quit */
#define	SIGILL	4	/* illegal instruction (not reset when caught) */
#define	SIGTRAP	5	/* trace trap (not reset when caught) */
#define	SIGIOT	6	/* IOT instruction */
#define	SIGEMT	7	/* EMT instruction */
#define	SIGFPE	8	/* floating point exception */
#define	SIGKILL	9	/* kill (cannot be caught or ignored) */
#define	SIGBUS	10	/* bus error */
#define	SIGSEGV	11	/* segmentation violation */
#define SIGSYS	12	/* bad argument to system call */
#define SIGPIPE	13	/* write to a pipe with no one to read it */
#define SIGALRM	14	/* alarm clock */
#define SIGTERM	15	/* software termination signal from kill */
 
extern	int	(*signal())();
extern	int	(*ssignal())();
 
#define	SIG_DFL	0	/* default */
#define SIG_IGN	1	/* ignore */
-h- sleep.c	Fri Oct 21 10:03:06 1983	SLEEP.C;2
#define	rsts	1
#include <stdio.h>
#include <rsts.h>

sleep(sec)
int sec;
{
    clrxrb();
    xrb.xrlen = sec;
    rstsys(_SLEEP);
}
-h- sprint.c	Fri Oct 21 10:03:06 1983	SPRINT.C;7
/*
 *			s p r i n t . c
 *
 * Formatted numeric conversion
 */

/*)LIBRARY
*/

#ifdef	DOCUMENTATION

title	sprintf	Formatted Numeric Conversion
index		Formatted Conversion

synopsis
	.s.nf
	char *
	sprintf(buffer, format, arg1, ...);
	char		*buffer;
	char		*format;
	.s.f
Description

	sprintf() converts and formats its arguments, writing the
	result to the indicated string buffer.

	For information on formatting, please refer to the description
	of printf.

	sprintf() returns a pointer to the EOS byte at the end
	of the output buffer.  Note, however, that this feature
	is not transportable to other C implementations.

Bugs

#endif

#include	<stdio.h>

char *
sprint(buffer, format, args)
char		*buffer;
char		*format;
/*
 * Formatted conversion
 */
{
	FILE		dummyiov;
	register FILE	*fd;

	fd = &dummyiov;
	fd->_flag = _IOSTRG | _IOWRT;
	fd->_base = NULL;
	fd->_ptr = buffer;
	fd->_cnt = 32767;
	c_doprnt(format, &args, fd);
	return (fd->_ptr);
}
-h- stdio.h	Fri Oct 21 10:03:06 1983	STDIO.H;3
/*
 * Stdio header file.	Version of 14-Apr-82
 *
 * Edit history
 * 01 13-Aug-79 MM	Defined IOV to match the RSX package
 * 02 18-Mar-80	MM	Redefined everything for the new library
 * 03 14-May-80 MM	Do not define things twice
 * 04 13-Jun-80 MM	Define fwild stuff
 * 05 01-Aug-80 MM	Flag changes (IOV Version 08)
 * 06 15-Sep-80 RBD	Add cell for UIC under RSX.
 * 07 22-Sep-80 MM	Added VF$WLD
 * 08 25-Sep-80 MM	Removed VF$BAD
 * 09 17-Feb-81 MM	Added VMS runoff hack flag
 * 10 08-Oct-81 MM	Nothing special
 * 11 10-Mar-82 MM	Added documentation header
 * 12 14-Apr-82 JLB	Add RSTS stuff
 */

#ifdef	DOCUMENTATION

title	stdio	Definitions for standard i/o library
index		Definitions for standard i/o library

Synopsis

	#include <stdio.h>

Description

	<stdio.h> should be included in the assembly of all C programs
	that use the standard i/o library (fopen(), getc(), printf(), etc.)
	.s
	It defines the following:
	.s
	  FILE	The  i/o  routines  use  and  return pointers to
		objects of this type.
	.s
	  NULL	I/O routines signal "rejection" by  returning  a
		pointer to a null object.
	.s
	  EOF	The get character routine returns this value  to
		signal end of file.
	.s								
	stdin	The "standard" input file.  Normally the  user's
		terminal; it may be redirected.
	.s
	stdout	The "standard" output file.  Normally the user's
		terminal; it may be redirected.
	.s
	stderr	The "error" output file.  It will  always  write
		to the user's terminal.
Bugs

	This version of stdio.h also defines TRUE, FALSE, and EOS
	(end of string) which are not transportable to other
	C systems.
	.s
	If you compile with -r or #define rsts, you will get a
	native rsts standard i/o header which is not yet fully
	supported.
#endif

#ifndef	IO_OPN
#ifdef	rsts
/*
 * New format
 */
typedef struct IOV {
	int	io_flag;	/* Control flags	*/
	int	io_flag2;	/* RSTS specific flags	*/
	int	io_recm;	/* Record Modifier	*/
	int	io_wait;	/* Wait time		*/
	int	io_bnbr;	/* Disk block number	*/
	char	*io_name;	/* File name pointer	*/
	char	*io_wild;	/* Wild card buffer	*/
	int	io_lun;		/* RT11 channel number	*/
	int	io_bcnt;	/* Buffer free count	*/
	char	*io_bptr;	/* Buffer free pointer	*/
	int	io_bsiz;	/* Buffer size		*/
	char	*io_bbuf;	/* Data buffer		*/
} FILE;

#define	MAXLUN	15

extern	FILE	*$$luns[];	/* Lun table		*/

#else
/*
 * Old format
 */
#ifdef	rsx
typedef struct IOV {
	int	io_flag;	/* Control flags	*/
	int	io_uget;	/* Unget char storage	*/
	int	io_bcnt;	/* Buffer free count	*/
	char	*io_bptr;	/* Buffer free pointer	*/
	char	*io_rbuf;	/* Record buffer start	*/
	int	io_rbsz;	/* Record buffer size	*/
	char	*io_bbuf;	/* Block buffer start	*/
	char	*io_wild;	/* Wildcard lookup buf	*/
	int	io_uic;		/* File's UIC in binary	*/
	int	io_iosb[2];	/* I/O status block	*/
	int	io_fdb[0];	/* File data block	*/
} FILE;

#endif
#ifdef rt11
typedef struct IOV {
	int	io_flag;	/* Control flags	*/
	int	io_uget;	/* Unget char storage	*/
	char	*io_name;	/* File name pointer	*/
	char	*io_wild;	/* Wild card buffer	*/
	int	io_lun;		/* RT11 channel number	*/
	int	io_bcnt;	/* Buffer free count	*/
	char	*io_bptr;	/* Buffer free pointer	*/
	int	io_bnbr;	/* Disk block number	*/
	char	io_bbuf[512];	/* Data buffer		*/
} FILE;
#endif
#endif

/*
 * Bits in iov.io_flag.
 *
 * These could be redone as
 *
 *	extern	VF$OPN;
 *	#define	IO_OPN	((int)(&VF$OPN))
 *
 * etc.
 */

#define	IO_OPN	0100000		/* Open file		*/
#define	IO_REC	0040000		/* Record device	*/
#define	IO_TTY	0020000		/* Console terminal	*/
#define	IO_EOF	0010000		/* EOF seen		*/
#define	IO_ERR	0004000		/* Error seen		*/
#define	IO_FIL	0002000		/* Disk file		*/
#define	IO_NOH	0001000		/* No newlines by fopen	*/
#define	IO_NOS	0000400		/* No newlines needed	*/
#define	IO_UBF	0000200		/* User does buffering	*/
#define	IO_BZY	0000100		/* Buffer busy (RT11)	*/
#define IO_WF1	0000040		/* fwild first flag	*/
#define IO_VER	0000020		/* fwild: ;0 or ;-1	*/
#define IO_VM1	0000010		/* fwild: version ;-1	*/
#define IO_WLD	0000004		/* fwild: wildcard file	*/
#define	IO_MOD	0000003		/* File open mode 	*/
				/* 0    means read	*/
				/* 1    means write	*/
				/* 2    means append	*/
				/* != 0 means output	*/
/*
 * Bits in flag2: (RSTS only, at present)
 */
#define	IO_ODT2	0100000		/* ODT mode (RSTS only)	*/

#define EOF	(-1)		/* End of file by getc	*/
#define NULL	0		/* Impossible pointer	*/
#define TRUE	1		/* if (TRUE)		*/
#define FALSE	0		/* if (!TRUE)		*/
#define EOS	0		/* End of string	*/
 
extern	FILE	*stdin;		/* Standard input file	*/
extern	FILE	*stdout;	/* Standard output file	*/
extern 	FILE	*stderr;	/* Standard error file	*/
extern	int	$$ferr;		/* Error codes set here	*/

#endif
-h- sys3.mac	Fri Oct 21 10:03:06 1983	SYS3.MAC;2
	.title	sys3
	.enabl	lc
	.ident	/000003/
;+
; Execute rsts sys function calls -3 and -12 to get system table
; locations.  These are globalized, for your convenience.
;
; Calling sequence:
;
;	sys3()
;
; Return: tables are setup
;
; Assemble with COMMON.MAC
;-
;
; Edit history
; 000001 ??-???-?? MM	Initial edit
; 000002 15-May-80 MM	Conversion for the new C compiler
; 000003 12-Aug-80 MM	Fixed data .psect
;
	.globl	clrfqb, rstsys

	.psect	.prog.
sys3::
	call	clrfqb			; Clean out the firqb
	movb	#uu.tb1,@#firqb+fqfun	; -3 function
	mov	#.uuo,-(sp)		; and do the
	call	rstsys			; uuo call
	mov	#firqb,r0		; Now move out
	mov	#table1,r1		; the data
10$:	mov	(r0)+,(r1)+
	cmp	r0,#firqb+fqsiz
	blo	10$

	call	clrfqb			; Now, do the same
	movb	#uu.tb2,@#firqb+fqfun	; for the other table
;	mov	#.uuo,(sp)		; Still on the stack
	call	rstsys			; (.uuo is on the stack)
	mov	#firqb,r0		; Now, move out
	mov	#table2,r1		; the other
20$:	mov	(r0)+,(r1)+
	cmp	r0,#firqb+fqsiz
	blo	20$
	tst	(sp)+			; pop off .uuo value
	return				; That's all

	.psect	.data.							;03

table1:		.word
fqbjob::	.word
cnt.kb::	.byte
maxcnt::	.byte
devcnt::	.word
devptr::	.word
memlst::	.word
jobtbl::	.word
jbstat::	.word
jbwait::	.word
untclu::	.word
untcnt::	.word
stactl::	.word
jsbtbl::	.word
satctm::	.word
curdat::	.word
untown::	.word

table2:		.word
		.word
frees::		.word
devnam::	.word
csrtbl::	.word
dev0kb::	.word
ttyhct::	.word
jobcnt::	.word
rtslst::	.word
erlctl::	.word
sndlst::	.word
lognam::	.word
devsyn::	.word
memsiz::	.word
ccllst::	.word
fcblst::	.word

	.end
