/*
 * P$OLDFIL - Select a file menu
 */

#ifdef   DOCUMENTATION

title    p$oldfil    File Selection Menu
index                File Selection Menu

synopsis

	 #define NCHOICES xxx /* nchoice */
	 char *wspec;         /* Wild file spec */
	 int *nchoice;        /* Max allowed to select */
	 char *fspecs;        /* Array of 50-byte spec bufs */
	 char *text1;         /* Text at top of frame */
	 char *msg1;          /* Message on line 23 */
	 char *msg2;          /* Message on line 24 */
	 int *stat;           /* 2-word status block */

	 p$oldfil(wspec, nchoice, fspecs, text1, msg1, msg2,
		 stat)

description

	The p$oldfil directive solicits the names of one or more existing
	files by displaying the File Selection Menu.
	.s
	The default wild-card specification can be used by supplying a
	zero-length string, in order to display the latest versions of
	all files in the user's current directory.  The Additional Options
	"show all versions" and "show only the latest versions" work only
	when you use the default wild-card specifications Otherwise, the
	same file selection menu will redisplay.
	.s
	The p$oldfil routine requires a static buffer, a multi-buffer, and a
	file selection buffer.

author

	Bob Denny

#endif

extern oldfil();

p$oldfil(wspec, nchoice, fspecs, text1, msg1, msg2, stat)
char *wspec;            /* Wild file spec for selections */
int *nchoice;           /* In: Max number to select  Out: Number chosen */
char *fspecs;           /* Array of contiguous 50-byte filespec bufs */
char *text1;            /* Text at top of frame */
char *msg1;             /* Message on line 23 */
char *msg2;             /* Message on line 24 */
int *stat;              /* 2-word status block */
   {
   int i, wlen, t1len, m1len, m2len;
   int *sizes;

   if((sizes = malloc(*nchoice * sizeof(int))) == 0)
      {
      stat[1] = 0;
      return(stat[0] = -10);            /* No buffer space */
      }
   wlen = strlen(wspec);
   t1len = strlen(text1);
   m1len = strlen(msg1);
   m2len = strlen(msg2);
   call(oldfil, 12, stat, nchoice, fspecs, sizes, wspec, &wlen,
         text1, &t1len, msg1, &m1len, msg2, &m2len);
   if(stat[0] != 1)			/* If EXIT or MAIN SCREEN pressed */
      *nchoice = 0;			/* Indicate nothing chosen */
   else
      {
      for(i=0; i<*nchoice; i++)
         fspecs[(50 * i) + sizes[i]] = '\0';
      }
   free(sizes);
   return(stat[0]);
   }
