/*
 * P$DMENU - Display dynamic menu
 */

#ifdef DOCUMENTATION

title    p$dmenu     Display Dynamic Menu
index                Display Dynamic Menu

synopsis

	 char *action;   /* --> buffer to receive action str */
  	 int maxlen;     /* Size of action string buffer */
 	 int addopt;     /* TRUE = enable additional opt's */
 	 char *msg1;     /* Message for line 23 or NULL */
	 char *msg2;     /* Message for line 24 or NULL */
	 int *stat;      /* --> 2 word status block */

	p$dmenu(action, maxlen, addopt, msg1, msg2, stat)

description

	p$dmenu displays the single-choice menu in the dynamic buffer.
	It serves as the gateway to the dmenu directive in a standard C
	library.

	For more information refer to the Professional Developer's
	Toolkit Reference Manual.

author

	Bob Denny

#endif

extern dmenu();

p$dmenu(action, maxlen, addopt, msg1, msg2, stat)
char *action;                           /* --> buffer to receive action str */
int maxlen;                             /* Size of action string buffer */
int addopt;                             /* TRUE = enable additional opt's */
char *msg1;                             /* Message for line 23 or NULL */
char *msg2;                             /* Message for line 24 or NULL */
int *stat;                              /* --> 2 word status block */
   {
   int actlen, m1len, m2len;

   m1len = strlen(msg1);
   m2len = strlen(msg2);
   call(dmenu, 10, stat, action, &maxlen, &actlen, 0, &addopt,
         msg1, &m1len, msg2, &m2len);
   action[actlen] = '\0';
   return(stat[0]);
   }
