
/*
 *	fps.h - Bit definitions for the Floating Point Status (FPS) word
 */

#ifdef	DOCUMENTATION

title	fps	Bit definitions for the floating point status word
index		Bit definitions for the floating point status word

Synopsis

	#include <fps.h>

Description

	This module defines common definitions for the FP-11 floating
	point status word.  The following are defined:
	.s.nf
	FER	0100000	Floating error	(sense/reset)
	FID	0040000	Disable all interrupts
	FIUV	0004000	Interrupt on undefined variable
	FIU	0002000	Interrupt on underflow
	FIV	0001000	Interrupt on overflow
	FIC	0000400	Interrupt on int. conv. error
	FD	0000200	Double precision mode
	FL	0000100	Long integer mode
	FT	0000040 Chop mode
	FN	0000010	Floating negative (sense)
	FZ	0000004	Floating zero     (sense)
	FV	0000002	Floating overflow (sense)
	FC	0000001	Floating carry    (sense)
	.s.f
	
#endif

/*
 * )EDITLEVEL=01
 * Edit history
 * 0.0 13-Aug-82 MM	Retyped from Unimation original
 */

#define	FER	0100000	/* Floating error (sense/reset)			*/
#define	FID	0040000	/* Disable all interrupts			*/
#define	FIUV	0004000	/* Interrupt on undefined variable		*/
#define	FIU	0002000	/* Interrupt on underflow			*/
#define	FIV	0001000	/* Interrupt on overflow			*/
#define	FIC	0000400	/* Interrupt on int. conv. error		*/
#define	FD	0000200	/* Double precision mode			*/
#define	FL	0000100	/* Long integer mode				*/
#define	FT	0000040 /* Chop mode					*/
#define	FN	0000010	/* Floating negative (sense)			*/
#define	FZ	0000004	/* Floating zero     (sense)			*/
#define	FV	0000002	/* Floating overflow (sense)			*/
#define	FC	0000001	/* Floating carry    (sense)			*/

