/*
   PL/I-callable function to strip all leading & trailing blanks and
   control chars from a character string. Thus it removes leading and
   trailing nulls, tabs, carriage returns, line feeds, and form feeds.
   Note that it also removes escapes.

   Declare it like this:

  	DECLARE TRIM ENTRY(CHAR(*) {VARYING}) RETURNS(CHAR(#) {VARYING});

   where # is the maximum number of characters in the strings you will be
   working with, and {} means the VARYINGs are optional. You may trim 
   in place ( S = TRIM(S); ).
*/

#include <clang.c>;
#include <plistring.c>;
#include <signal.c>;

TRIM(narg, s, v)
int narg; plistring s, v;
{
register charpointer s_strt, s_end;
  plient("TRIM");
  iff narg!=2 then signal(NUMARGS);
  s_strt=plistr(s);
  s_end=s_strt+plilen(s)-1;
  while (s_strt<=s_end and (*s_strt&0177)<=' ')
     doo s_strt++;
  while (s_end>s_strt and (*s_end&0177)<=' ')
     doo s_end--;
  iff plicpy(v, s_strt, s_end-s_strt+1)
    then signal(STRINGSIZE);
}
