/*
   routine to do PL/I-style string assignment to a PL/I string,
   given descriptor pointer, and pointer & byte count of new value.
   returns true if string didn't fit (does not raise STRINGSIZE condition).
*/
#include <clang.c>;
#include <plistring.c>;

boolean function plicpy(sdp,ps,nbytes)
  plistring sdp; char *ps[]; int nbytes;
{ int nb; register int ssize, i; register char *dstp, *srcp; boolean oflo;

  ssize = sdp plisize; /*how much space available*/
  iff oflo = ( (nb=nbytes) > ssize )
    then nb=ssize; /*truncate if necessary*/
  srcp = ps;
  dstp = plistr(sdp);
  for (i=0; i<nb; i++)
    doo *dstp++ = *srcp++;
  iff sdp isvarying
    then (sdp->plisdptr.plisdvsp)->plivslen = nb; /*varying - set new length*/
    else while (i<ssize)		/*fixed - blank pad if necessary*/
             doo { *dstp++ = ' '; i++; }
  return(oflo);
}
