/*
BEGIN DOCUMENTATION

Name: Daniel T. Soldahl				Created: 12/21/83
					    Last Update: 12/21/83
Title: CONECT.C: Connect to external task for ast on abort.

Index: Connect to task

Abstract: Enables ast on external task abort to set a global flag.

Usage: dsw = conect(&task)

Parameters: struct rad50 task	  - INPUT: External task name
	    int conect()	  - OUTPUT: Returns dsw of cnct directive
	    extern boolean tskabo - OUTPUT: Set to true when task aborts

Environment: RSX11M V4.0, DECUS C Compiler

See Also: VSENDRECV.C (Uses tskabo)

Description: In order to prevent routines like vrecv from hanging when
	     an external task is aborted it is neccessary to connect to
	     the external task and be activated via an ast when the task
	     is aborted.  This routine contains the abort ast routine and
	     a global flag.  Calling conect enables this routine and
	     sets this flag to "false".


Example(s):

Uses:

Internal: 

Update History:

END DOCUMENTATION
*/



#include <clang.c>
#include <cx.h>
#include <tparbf.h>


/* External Routines */

extern cnct();
extern gtsk();

/* Forward References */

extern tskabt();

/* Global Variables */

    boolean tskabo = false;	/* Flag to mark if external task aborted */
    struct tparbf tskpar;	/* Task header information */


/* CONECT: Connect to external task, return dsw of directive
	   globals out: tskabo,tskpar;
*/

int
conect(tskptr)
    struct rad50 *tskptr;
{
    int static esb[8];

	gtsk(&tskpar);	/* get our task header */
	return(cnct(tskptr,0,&tskabt,esb));
} /* end conect */



/* TSKABT: Ast for task abort
	  globals in:tskpar;
	  globals out:tskabo;

Program Logic:

	unstop self (in case we were stopped)
	task abort := true
*/

tskabt()
{
	astset();			/* save registers */
	ustp(&tskpar.g_tstn);		/* unstop self if stopped */
	tskabo = true;
	astx(1);		/* remove addr of exit status block */
} /* end tskabt */
