.m1 4
.m2 2
.m3 2
.m4 4
.rm 72
.rh
.he 1 /DEUNA Driver/Corporate SPR/SPR Form No. 600789/
.he 2 /XEDRV Problem/No. __________/Page # of 7/
.he 3 /Carl T. Mickelson, Goodyear Aerospace Corp.///
.he 4 /Akron, Ohio 44315 (216) 796-2388///
.fi
.ad
.ti +5
The DEUNA device driver distributed as part of RSX11M V4.1 Update D has a
serious logic error when issued a QIO to do a DEUNA diagnostic function without
a related transmit or receive data transfer.
The logic error can cause the DEUNA to be left in an indeterminate state; we
experienced the inability to transmit any packets after using this type of
diagnostic function QIO (i.e. with no data transfer).

.ti +5
Two scenarios are presented below that explain how such a QIO is erroneously
handled.
After these scenarios are discussed, patches are presented that correct the
errors, and return a success status for such a diagnostic function.
It is shown that the changes fix only the errors and do not affect how a QIO
combining both data transfer and diagnostic functions is performed.

.ti +5
This problem has been reported to the Telephone Support Center as call
# M850422151.

.ti +5
Attachments:
.br
Copies of sections of XEDRV that pertain to the error analysis.
.bp
.ce 2
Scenario 1 - Setting the Auxiliary
Characteristics Buffer Length to ZERO

.ti +5
The DEUNA driver documentation included in the RSX11M V4.1 Update D Release
Notes states in section 11.6.6 on page 85, that to do DEUNA diagnostic
functions without doing a data transfer at the same time, one should code
the length of the characteristics buffer (Transmit or Receive QIO parameter P4)
to zero (0).
Doing this will cause IE.SPC to be returned as the QIO status, but the
documentation indicates that any diagnostics buffer (P5 and P6) present will
be processed.
THESE STATEMENTS ARE INCORRECT.
What actually happens follows: IE.SPC is returned, as stated, but the driver
does NOT
re-map the diagnostic buffer, thereby making the user's buffer inaccessible
to the Executive when the QIO is executed.
However, the driver ATTEMPTS TO USE the un-mapped buffer, and can leave the
DEUNA in an indeterminate state as experienced at this site.

.ti +5
Referring to the attached listings, observe the following, using IO.XMT
(transmit a packet) as an example:

1.
UC.QUE is set in the device UCB so that the I/O request calls the driver
to do parameter checking and buffer mapping using the issuing task's
memory mapping context.

2.
XEINI is where the driver is entered, and after some initial I/O packet
processing and error checking, a dispatch table is used to transfer control
to XEXMT (XERCV for a receive (IO.RCV) QIO).

3.
XEXMT calls BFCHK to validate and remap the user's auxiliary characteristics
and diagnostic function buffers into Executive address space.

4.
Examining BFCHK shows that if the characteristics buffer LENGTH (now in
I.PRM+10) in the I/O packet contains a zero, BFCHK branches to 20$, setting
the IE.SPC QIO status, and returns to XEXMT with the C bit set.
Note here that no examination has been made to test for the presence of or to
re-map a diagnostic function buffer (P5 and P6, now in I.PRM+12 and I.PRM+14).

5.
Continuing in XEXMT, the set C bit causes a branch to 70$, and hence to XMTDN.

6.
At XMTDN (transmit data transfer done), the driver queues the un-mapped
diagnostic function buffer to the pending function queue in the driver
(if I.PRM+12 (P5) is non-zero).
This is a major error, since the driver does not have the information
available to properly access to user's data buffer.
The result can place the DEUNA in an indeterminate state, or can cause the
driver to hang, preventing completion of the diagnostic function QIO.
Both of these cases have been seen at this site.

.ti +5
The examination of BFCHK made to analyse scenario 1 above indicated a second
possible scenario for performing no-data diagnostic functions.


.ce 2
Scenario 2 - Setting the Auxiliary
Characteristics Buffer Address to ZERO

.ti +5
Setting the auxiliary buffer address parameter (P3) to zero changes the
execution path thru BFCHK.
Now the test of auxiliary buffer address (I.PRM+6) equal to 0 upon entry to
BFCHK causes a branch to 40$ where the length field is cleared and
BFCHK continues at 10$ to validate any diagnostic function buffer found to be
present.
Successful completion of these operations causes a return to XEXMT with C
clear, and an error status in R0 equal to zero (propagated out of CKCHR,
where R0 is used to check the proper formatting of the characteristics
buffer).

.ti +5
Back in XEXMT upon return from BFCHK, the BCS falls through (C is clear) to
the test of the auxiliary buffer address (I.PRM+6).
Since this parameter is zero, the branch to 50$ takes place, where an error
status of IE.BAD is returned, and the QIO is terminated.
This is certainly not the desired result, but it is an improvement over
scenario 1, since all of these type of diagnostic function QIO's are
now at least guaranteed to finish, leaving the DEUNA alone.

.ti +5
It should be noted that a similar problem exists in the receive function
code as well.

.ti +5
Clearly, the documentation in the Update D release notes (section 11.6.6),
while well intentioned, is erroneous.
Further, the driver itself has a logic error that prevents non-data transfer
diagnostic functions from completing whichever way is used to code the
absence of the auxiliary characteristics buffer.
A sort of "XE_Catch 22".

.ti +5
Attention now turns to correcting the driver logic errors so that these types
of diagnostic functions can complete successfully.
.bp
.ce 2
Driver and Documentation Changes
Needed to Fix Errors

.ti +5
Following are the changes (*) necessary to correct the driver code, and to fix
the driver documentation to properly perform diagnostic functions without an
associated data transfer.

.ce 1
Change Number 1

.ti +5
In XEXMT:, change to read:

.nf
.na
        CALL    BFCHK                   ; Validate optional characteristics
                                        ; .. buffers
*       BCS     60$                     ; If CS, invalid
        TST     I.PRM+6(R3)             ; Do we have an AUX buffer?
*       BEQ     70$                     ; If EQ, none present
        .
        .  < code through 70$ remains as is>
        .
.fi
.ad
.ti +5
At 70$:, change to read:

.nf
.na
70$:    CLR     R1                      ; Clear status word 2
*       MOV     #IE.SPC&377,R0          ; Assume no DIAG buffer
*       TST     I.PRM+12(R3)            ; Do we have a DIAG buffer?
*       BEQ     60$                     ; If EQ, neither AUX nor DIAG, error
*       MOV     #IS.SUC,R0              ; Else, indicate success
        BR      XMTDN                   ; Do xmit done, user wants diag info

.fi
.ad
.ti +5
Changing the BCS target will reject improper buffers, while changing the BEQ
target will permit a properly re-mapped diagnostic function buffer to be
queued to the driver and subsequently executed.
Insertion of the code following 70$ tests to see if a diagnostic function buffer
is provided when the auxiliary characteristics function buffer is known to
be missing (only path to 70$ is from TST I.PRM+6(R3)).
Should both buffers be missing, IE.SPC is returned to status, otherwise IS.SUC
is returned, indicating that the diagnostic buffer was processed.
The status of each individual diagnostic function is returned in the
diagnostic buffer function status words (C.STAT).

.ce 1
Change Number 2

.ti +5
In XERCV:, change to read:

.nf
.na
        CALL    BFCHK                   ; Validate optional characteristics
                                        ; .. buffers
*       BCS     20$                     ; If CS, invalid
*       TST     I.PRM+6(R3)             ; Do we have an AUX buffer?
*       BEQ     50$                     ; If EQ, none present
.bp
        .
        .  < code through 50$ remains as is>
        .
.fi
.ad
.ti +5
At 50$:, change to read:

.nf
.na
* 50$:  MOV     #IE.SPC&377,R0          ; Assume no DIAG buffer
*       TST     I.PRM+12(R3)            ; Do we have a DIAG buffer?
*       BEQ     20$                     ; If EQ, neither AUX nor DIAG, error
*       MOV     #IS.SUC,I.PRM+12(R3)    ; Else, indicate success
        CLR     I.PRM+4(R3)             ; Save status words

.fi
.ad
.ti +5
As before, changing the BCS target will reject improper buffers, while adding
the I.PRM+6 test and the following BEQ will permit
a properly re-mapped diagnostic function buffer to be
queued to the driver and subsequently executed.
Adding the code at 50$ tests to see if a diagnostic function buffer
is provided when the auxiliary characteristics function buffer is known to
be missing (only path to 50$ is from TST I.PRM+6(R3)).
Should both buffers be missing, IE.SPC is returned to status, otherwise IS.SUC
is returned, indicating that the diagnostic buffer was processed.
The status of each individual diagnostic function is returned in the
diagnostic buffer function status words (C.STAT).

.ce 1
Change Number 3

.ti +5
Change the driver documentation regarding how to do diagnostic functions without
an associated data transfer.
The modified paragraph 11.6.6 from the Update D Release Notes should read as
follows:

"11.6.6 Diagnostic Functions Without Data Transfer - To do diagnostic functions
without data transfer specify all the parameters correctly with the exception of
the ADDRESS of the auxiliary characteristics buffer.
The auxiliary characteristics buffer address must be set to ZERO.
This address value causes the driver to skip processing of the user data buffer
specified in the IO.XMT or IO.RCV QIO.
However, the driver will process the diagnostic buffer, if present.
IS.SUC will be returned as status for the call if a diagnostic buffer is
processed, IE.SPC is returned if neither the auxiliary nor diagnostic buffers
are present."
.bp
.ce 1
Validity of the Changes

.ti +5
The question of whether these changes will affect the execution of QIO's that
perform both data transfer and diagnostic functions in the same parameter set
needs to be addressed on two fronts.

.ti +5
First, since there are no changes made in the buffer validation functions
BFCHK and CKCHR, these routines perform as before.
In fact, the change recommended in using the address of the auxiliary buffer
equal to 
zero simply allows the correct logic of BFCHK to be brought to bear in
validating a diagnostic buffer when no auxiliary characteristics buffer
is provided.
This buffer validation and re-mapping is an absolute necessity for diagnostic
functions to work properly!

.ti +5
Secondly, the changes recommended for XEXMT and XERCV must not modify the
program flow through either of these routines for a dual function QIO
(transmit or receive, plus diagnostic functions).
Examining the revised program flow in XEXMT and XERCV, after calling BFCHK,
reveals that the driver now properly rejects a QIO with a bad diagnostics buffer
when no auxiliary buffer is provided, instead of trying to make use of an
unmapped user buffer as in the original release.
Further, the changes made to test if both buffers are missing from the QIO
properly returns an error code for no buffers specified and a success code
when the diagnostic buffer is processed.
This represents improved performance compared to the documentation in
section 11.6.6 of the release notes.
The user now KNOWS positively if his parameters are good or bad; there is
no reason to guess about diagnostic function success.

.ti +5
When both the auxiliary and diagnostic function buffers are provided, the
revisions presented here do not change the processing of a properly
formulated QIO request.
.bp
.ce 1
Additional DEUNA Comments

.ti +5
There are a few additional comments that need to be made regarding the
DEUNA driver and micro-code implementations and the driver documentation
as presented in section 11 of the Update D Release notes.

1.
The Ethernet standard allows a minimum of 46. and a maximum of 1500.
data bytes in an Ethernet packet.
These limits should be fully supported by the driver and micro-code in
the DEUNA.
The current device driver limits the maximum packet data length to
1498. to insure there is room for the software padding word inserted
by the driver when the requested protocol specifies padding in
the transfer.
For those user specified protocols for which padding is not requested,
the driver should permit a full 1500. bytes of data in the users message.
As the driver currently is implemented, the 1498. byte limit is
enforced on the user's data buffer without regard to protocol padding
status.
Further, this limit is imposed upon the user's auxiliary characteristics
and diagnostic function buffers as well.
The need for this test on these buffers is questionable.

2.
The micro-code in the DEUNA itself does not permit minimum Ethernet
packets to be received.
The minimum size packet recognized by the DEUNA is 64. bytes of data
PLUS 18. bytes for destination and source node addresses, protocol type,
and frame check sequence.
This size restriction should be 64. bytes INCLUDING the 18. bytes for
addresses, protocol, and frame check.
Such a minimum size restriction would then be consistent with the defined
Ethernet standard, and would allow a minimum data field of 46. bytes
within the transmitted packet.
The DEUNA micro-code should be modified to support this minimum size, and
the section of driver documentation (para. 11.6.7) that addresses buffer size
restrictions should be modified to reflect this change.

3.
Finally, the section of the driver documentation (para. 11.5, and Table 2
Valid Function Codes) that pertains to issuing diagnostic functions
should include comments that certain of these
functions, particularly those that modify the operational state of the
DEUNA, will not be performed unless the task issuing the QIO is privileged.
