/*
   READEF.C

   calling sequence:

	dcl readef entry(fixed bin(15)) returns(fixed bin(15));

	. . .

	i = readef(event);  / * 0 if clear, 1 if set * /
   or
	if readef(event)
	  then . . .  / *this code executed if event flag was set * /
	  else . . .  / *this code executed if event flag was clear * /
*/

#include <cxd.h> ;
#include <signal.c> ;

 READEF (narg,evtflg,state)

	int	narg ;
	int	*evtflg ;
	int	*state ;

   {

      unsigned	evtbuf [6] ;
      register	group ;
      register	shift ;

      plient ("READEF") ;

      if (narg != 2)
         signal (NUMARGS) ;

      rdxf (&evtbuf) ;
      group = (*evtflg-1)/16 ;
      if ($dsw < 0) 
	 {
            msgti ("error on readef (RDXF$), dsw=%",$dsw) ;
            signal (ERROR) ;
	 }
      if ( ($dsw == IS_CLR) && (group >= 4) )
	 {
	    msgti ("error on readef: group global event flags do not exist") ;
	    signal (ERROR) ;
	 }
      shift = *evtflg-(group*16+1) ;
      *state = (evtbuf[group]>>shift) & 01 ;
      return ;

   }
