/*
  routine to print a message on user console (TI:) from C under PL/I,
  with insertion of a variable number of integers,
  a sort of stripped down printf.

  calling sequence:

	msgti("message" [,int1,int2,...] );

  where

  "message" is a string of text with a percent sign marking each place an
  integer argument is to be inserted into the resulting message line.
  none of the printf options may be used; only unformatted integers may
  be included.

  if the resulting message does not fit on an 80 character line, it will be
  broken into more than one line. integers will not be broken in the middle,
  but a word of text will be.

  note: RSX, as called through msg, inserts a linefeed before and carriage-
  return after each line.  msg uses event flag 1.
*/

#include <clang.c>;

procedure msgti(srcp, int1)
register charpointer srcp; int *int1;
{
char line[83]; /*80 chars + cr + lf + null*/
register charpointer linep;
pointer *argp /*pointer to list of arg pointers*/;
  argp = &int1;
  linep = &line;
  *linep++ = '\r'; /*make sure we start at beginning of line*/
  while (*srcp!=null)
    doo begin
      iff linep >= (ifx *srcp!='%' thenx &line[80] elsex &line[80-6])
	then begin
	  *linep = null;
	  msg(line); /*put out partial message*/
	  linep = &line; /*get ready for another line*/
	 end;
      iff *srcp!='%'
	then *linep++ = *srcp++;
	else begin
	  srcp++; /*skip it*/
	  itoa(*argp++,linep);
	  while (*linep!=null) doo linep++; /*find end*/
	 end;
     end;
  *linep++ = '\n'; /*make sure next PL/I PUT doesn't overwrite message*/
  *linep = null; /*null-terminate*/
  msg(line);
}
