/*
BEGIN DOCUMENTATION

Name: TCMTDEL.C					Created: 05/22/84  DTS
					    Last Update: 05/24/84

Title: Text collection management text delete function.

Index: TCM text editor

Abstract: Implements "TXTDEL" function of TCM to add text to an
	  existing "window" on the screen.

Usage:	See "TCM.DOC"

Parameters: srbuf.row & srbuf.col has beginning of delete text, srbuf.
	    height & srbuf.width has row & col for end of delete text.

Environment: RSX11M V4.0, DECUS C Compiler

See Also: TCM.C, TCMPDELTX.C, TCMTINS.C, TCM.DOC

Description: Removes text between given cursor locations from named text
	     window.  Calls function to re-display text on screen.

Example(s):  See "TCM.DOC"

Uses:

Internal: Removes text directly from contiguous text buffer.

Update History:

END DOCUMENTATION
*/

/* #define debug 0 */

#include <clang.c>
#include <stdio.h>
#include <cx.h>
#include "tcmdefs.h"
#include "tcmerr.h"
#include "tcmpublic.h"
#include "tcmedopt.h"

/* Forward reference */

/***	(TXTDEL) Text Insertion: Add text to window buffer    ***/

txtdel()
{
    register struct twindcb	*win;
    register charpointer	p;
    register int	cnt,spacecnt,endcol,i;
    charpointer		startptr,endptr;

	iff (win = fndwnd()) == NULL then
	{
	    ret.cd = TE_NSW;
	}
	else
	{
	    ret.cd = TS_SUC;		/* Default to successful */

	    /*** Point to start of delete ***/

	    cnt = ifx (srbuf.row > 0) thenx srbuf.row elsex win->edlinnum;
	    iff cnt > win->botline then cnt = win->botline;
	    iff win->edlinnum != cnt then
	    {
		win->edline = fndlin(win->bufstart,win->bufend,cnt);	/* Point to selected line */
		win->edlinnum = cnt;
	    }
	    ret.bline = win->edlinnum;
	    win->column = ifx (srbuf.col > 0) and (srbuf.col < win->width) thenx 
		srbuf.col elsex win->width - 1;
	    ret.bcol = win->column;
	    cnt = virlen(win->edline) + 1;
	    spacecnt = ifx win->column > cnt thenx
		win->column - cnt elsex 0;		/* Count of pad chars */
	    startptr = virchr(win->edline,win->column - spacecnt);

	    /*** Point to end of delete ***/

	    cnt = ifx (srbuf.height > 0) thenx srbuf.height elsex win->edlinnum;
	    iff cnt > win->botline then cnt = win->botline;
	    iff win->edlinnum != cnt then
		endptr = fndlin(win->bufstart,win->bufend,cnt);	/* Point to selected line */
	    else
		endptr = win->edline;
	    cnt = virlen(endptr) + 1;
	    endcol = ifx (srbuf.width > 0) and (srbuf.width < cnt) thenx 
		srbuf.width elsex cnt;
	    endptr = virchr(endptr,endcol);

	    cnt = endptr - startptr;			/* Characters to delete */
	    for(i = cnt,p = startptr; i-- > 0; )
	    {
		iff *p++ == eos then
		    win->botline--;			/* Subtract deleted lines */
	    }
	    while ((spacecnt > 0) and (cnt > 0))
	    {
		spacecnt--;
		*startptr++ = ' ';			/* Pad line with spaces */
		cnt--;
	    }
	    iff cnt > 0 then	/* If end of delete > start of delete, delete text */
	    {
		p = win->bufstart + win->curmax;	/* Current end of text */
		movedn(startptr + cnt, startptr, p - endptr);	/* Close buffer */
		win->curmax -= cnt;			/* Subtract from buffer */
		endptr = win->edline;
		iff wrapline(&endptr,win->width) != false then	/* Test for line wrap */
    		    win->botline++;
	    }
	}
	iff ret.cd == TS_SUC then		/* add iniout() ?	     */
	{
	    lin[curline].fircol = newlin;
	    setout(win);
	}
	iff ret.cd == TS_SUC then
	{
	    lin[curline].fircol = newlin;	/* Redisplay current line    */
	    refresh();				/* Display window changes    */
	    rstout(win);
	}
} /* end txtdel */
