/*
BEGIN DOCUMENTATION

Name: TCMTBLS.C 				Created: 08/01/83  DTS
					    Last Update: 05/03/84
Title: Global Tables to map editing keys to functions

Index:

Abstract: Used by TCMINPUT to map escape sequences into 8 bit values which
	  are > 127.  All tables are position dependent with fixed length
	  entries.  Used by TCMEDIT to map value >= 127 into editing function.

Usage:

Parameters: 

Environment: RSX 11M V4.0, DECUS C

See Also: TCMEDIT.C, TCMINPUT.C

Description: 

Example(s):

Uses:

Internal: 

Update History:

END DOCUMENTATION
*/

typedef	char	*(*funcpointer)();	/* Pointer to function returning charpointer */
typedef char	*charpointer;
#define eos '\0'			/* Null character for padding strings */
#define esc '\033'			/* Escape leading character for keypad */


    /* Global values used by editing functions */

char wrddel[] = " .,;:'?";	/* Characters to terminate word */
char pardel[] = "\r\r";		/* String to mark end of paragraph */

    /* Global values used by TCMINPUT */

int  esclen = 3;	/* Maximum escape sequence length */

/***	esctab has up to 32 fixed length entries filled with nulls    ***/
/***	The end is marked by entry starting with a null character.    ***/

char esctab[] =	{	/* Escape sequence table [32] max. */

		'O','P',eos,	/* First character is gold key (pf1) */
		'O','q',eos,	/* Keypad 1 */
		'O','r',eos,	/* Keypad 2 */
		'O','s',eos,	/* Keypad 3 */
		'O','t',eos,	/* Keypad 4 */
		'O','u',eos,	/* Keypad 5 */
		'O','v',eos,	/* Keypad 6 */
		'O','w',eos,	/* Keypad 7 */
		'O','x',eos,	/* Keypad 8 */
		'O','y',eos,	/* Keypad 9 */
		'O','Q',eos,	/* PF2 (help)  */
		'O','R',eos,	/* PF3 */
		'O','A',eos,	/* UP (Assumes cursor key mode set */
		'O','B',eos,	/* DOWN */
		'O','C',eos,	/* RIGHT */
		'O','D',eos,	/* LEFT */
		'O','n',eos,	/* Keypad . */
		'O','S',eos,	/* PF4 */
		'O','m',eos,	/* Keypad - */
		'O','l',eos,	/* Keypad , */
		'O','p',eos,	/* Keypad 0 */
		'O','M',eos,	/* Keypad ENTER */
		'[','A',eos,	/* UP (Assumes cursor key mode reset */
		'[','B',eos,	/* DOWN */
		'[','C',eos,	/* RIGHT */
		'[','D',eos,	/* LEFT */
		'O','P','a',	/* gold a */
		'O','P','b',	/* gold b */
		'O','P','c',	/* gold c */
		'O','P','d',	/* gold d */
		'O','P','e',	/* gold e */
		eos,eos,eos };	/* End of table */


/***	gldtab has up to 64 fixed length entries filled with nulls    ***/
/***	The end is marked by entry starting with a null character.    ***/

char gldtab[] =	{		/* Gold key sequence table [64] max. */

		esc,'O','P',	/* PF1 (gold key) */
		esc,'O','q',	/* Keypad 1 */
		esc,'O','r',	/* Keypad 2 */
		esc,'O','s',	/* Keypad 3 */
		esc,'O','t',	/* Keypad 4 */
		esc,'O','u',	/* Keypad 5 */
		esc,'O','v',	/* Keypad 6 */
		esc,'O','w',	/* Keypad 7 */
		esc,'O','x',	/* Keypad 8 */
		esc,'O','y',	/* Keypad 9 */
		esc,'O','Q',	/* PF2 (help)  */
		esc,'O','R',	/* PF3 */
		esc,'O','A',	/* UP (Assumes cursor key mode set */
		esc,'O','B',	/* DOWN */
		esc,'O','C',	/* RIGHT */
		esc,'O','D',	/* LEFT */
		esc,'O','n',	/* Keypad . */
		esc,'O','S',	/* PF4 */
		esc,'O','m',	/* Keypad - */
		esc,'O','l',	/* Keypad , */
		esc,'O','p',	/* Keypad 0 */
		esc,'O','M',	/* Keypad ENTER */
		esc,'[','A',	/* UP (Assumes cursor key mode reset */
		esc,'[','B',	/* DOWN */
		esc,'[','C',	/* RIGHT */
		esc,'[','D',	/* LEFT */
		'0',eos,eos,	/* digit 0 */
		'1',eos,eos,	/* digit 1 */
		'2',eos,eos,	/* digit 2 */
		'3',eos,eos,	/* digit 3 */
		'4',eos,eos,	/* digit 4 */
		'5',eos,eos,	/* digit 5 */
		'6',eos,eos,	/* digit 6 */
		'7',eos,eos,	/* digit 7 */
		'8',eos,eos,	/* digit 8 */
		'9',eos,eos,	/* digit 9 */
		'A',eos,eos,	/* Alphabetic characters */
		'B',eos,eos,
		'C',eos,eos,
		'D',eos,eos,
		'E',eos,eos,
		'F',eos,eos,
		'G',eos,eos,
		'H',eos,eos,
		'I',eos,eos,
		'J',eos,eos,
		'K',eos,eos,
		'L',eos,eos,
		'M',eos,eos,
		'N',eos,eos,
		'O',eos,eos,
		'P',eos,eos,
		'Q',eos,eos,
		'R',eos,eos,
		'S',eos,eos,
		'T',eos,eos,
		'U',eos,eos,
		'V',eos,eos,
		'W',eos,eos,
		'X',eos,eos,
		'Y',eos,eos,
		'Z',eos,eos,
		eos,eos,eos };	/* End of table */


/***	External functions used in EDFUNC table, all return cursor char ptr    ***/

extern	charpointer	nulfun();	/* Ignore keypress - do nothing */
extern	charpointer	invfun();	/* Invalid or user function key */
extern	charpointer	entfun();	/* Enter keypress - do nothing error */
extern	charpointer	inewln();	/* Insert new line at cursor position */
extern	charpointer	xitfwd();	/* Exit forward key pressed - exit editor */
extern	charpointer	xitbkd();	/* Exit back key pressed - exit editor */
extern	charpointer	canfun();	/* Cancel key pressed - exit editor */
extern	charpointer	instgl();	/* Toggle Insert/Replace mode */
extern	charpointer	retfun();	/* Return (cursor to start of next line) */
extern	charpointer	csleft();	/* Move cursor left */
extern	charpointer	csright();	/* Move cursor right */
extern	charpointer	csup();		/* Move cursor up */
extern	charpointer	csdown();	/* Move cursor down */
extern	charpointer	backln();	/* Cursor to start of last line */
extern	charpointer	topscr();	/* Cursor to top of window */
extern	charpointer	botscr();	/* Cursor to bottom of window */
extern	charpointer	beglin();	/* Move cursor to start of line */
extern	charpointer	endlin();	/* Move cursor to end of line */
extern	charpointer	toptxt();	/* Move cursor to start of text */
extern	charpointer	bottom();	/* Move cursor to end of text */
extern	charpointer	tabfun();	/* Move cursor to next tab stop */
extern	charpointer	settab();	/* Set tab stop at cursor column */
extern	charpointer	clrtab();	/* Clear tab stop at cursor column */
extern	charpointer	pgfor();	/* Scroll screen up section */
extern	charpointer	pgbac();	/* Scroll screen down section */
extern	charpointer	deleft();	/* Delete character left */
extern	charpointer	dechrt();	/* Delete character right */
extern	charpointer	dechlf();	/* Delete character left (FMS Style) */
extern	charpointer	wordrt();	/* Move cursor right word */
extern	charpointer	wordlf();	/* Move cursor left word */
extern	charpointer	dewdrt();	/* Delete word right */
extern	charpointer	dewdlf();	/* Delete word left */
extern	charpointer	inline();	/* Insert blank line */
extern	charpointer	deline();	/* Delete current line */
extern	charpointer	undelt();	/* Undelete line or word */
extern	charpointer	reform();	/* Reformat paragraph to margins */
extern	charpointer	repaint();	/* Refresh window on screen */
extern	charpointer	help();		/* Help key pressed */

/***	EDFUNC is a table of 129 editing keypad functions    ***/

funcpointer edfunc[129] = {
		dechlf,		/* Rubout character */
		invfun,		/* Control @ */
		invfun,		/* Control A */
		invfun,		/* Control B */
		canfun,		/* Control C */
		invfun,		/* Control D */
		invfun,		/* Control E */
		invfun,		/* Control F */
		invfun,		/* Control G */
		backln,		/* Control H */
		tabfun,		/* Control I */
		dewdlf,		/* Control J */
		invfun,		/* Control K */
		invfun,		/* Control L */
		retfun,		/* Control M */
		inewln,		/* Control N */
		invfun,		/* Control O */
		invfun,		/* Control P */
		invfun,		/* Control Q */
		repaint,	/* Control R */
		invfun,		/* Control S */
		invfun,		/* Control T */
		canfun,		/* Control U */
		invfun,		/* Control V */
		repaint,	/* Control W */
		invfun,		/* Control X */
		invfun,		/* Control Y */
		xitfwd,		/* Control Z */
		nulfun,		/* Control [ */
		invfun,		/* Control \ */
		invfun,		/* Control ] */
		invfun,		/* Control ~ */
		invfun,		/* Control ? */
		nulfun,		/* Gold key offset PF1 */
		nulfun,		/* Keypad 1 */
		settab,		/* Keypad 2 */
		nulfun,		/* Keypad 3 */
		wordlf,		/* Keypad 4 */
		wordrt,		/* Keypad 5 */
		nulfun,		/* Keypad 6 */
		pgbac,		/* Keypad 7 */
		pgfor,		/* Keypad 8 */
		inline,		/* Keypad 9 */
		help,		/* PF2 (help) */
		xitbkd,		/* PF3 */
		csup,		/* UP */
		csdown,		/* DOWN */
		csright,	/* RIGHT */
		csleft,		/* LEFT */
		canfun,		/* Keypad . */
		xitfwd,		/* PF4 */
		deline,		/* Keypad - */
		dechrt,		/* Keypad , */
		reform,		/* Keypad 0 */
		entfun,		/* Keypad ENTER */
		csup,		/* UP */
		csdown,		/* DOWN */
		csright,	/* RIGHT */
		csleft,		/* LEFT */
		invfun,
		invfun,
		invfun,
		invfun,
		invfun,
		invfun,
		instgl,		/* Gold Gold (PF1) */
		nulfun,		/* Gold Keypad 1 */
		clrtab,		/* Gold Keypad 2 */
		invfun,		/* Gold Keypad 3 */
		nulfun,		/* Gold Keypad 4 */
		nulfun,		/* Gold Keypad 5 */
		nulfun,		/* Gold Keypad 6 */
		toptxt,		/* Gold Keypad 7 */
		bottom,		/* Gold Keypad 8 */
		invfun,		/* Gold Keypad 9 */
		help,		/* Gold PF2 (help) */
		xitbkd,		/* Gold PF3 */
		topscr,		/* Gold UP */
		botscr,		/* Gold DOWN */
		endlin,		/* Gold RIGHT */
		beglin,		/* Gold LEFT */
		canfun,		/* Gold Keypad . */
		xitfwd,		/* Gold PF4 */
		undelt,		/* Gold Keypad - */
		dewdrt,		/* Gold Keypad , */
		reform,		/* Gold Keypad 0 */
		nulfun,		/* Gold Keypad ENTER */
		topscr,		/* Gold UP */
		botscr,		/* Gold DOWN */
		endlin,		/* Gold RIGHT */
		beglin,		/* Gold LEFT */
		invfun,
		invfun,
		invfun,
		invfun,
		invfun,
		invfun,
		invfun,
		invfun,
		invfun,
		invfun,
		invfun,
		invfun,
		invfun,
		invfun,
		invfun,
		invfun,
		invfun,
		invfun,
		invfun,
		invfun,
		invfun,
		invfun,
		invfun,
		invfun,
		invfun,
		invfun,
		invfun,
		invfun,
		invfun,
		invfun,
		invfun,
		invfun,
		invfun,
		invfun,
		invfun,
		invfun,
		invfun,
		invfun	};
