/*
BEGIN DOCUMENTATION

Name: TCMSAVWIN.C:				Created: 7/20/83  DTS
					    Last Update:01/05/84

Title: Text collection management system text save routine.

Index: TCM text editor

Abstract: Implements "TWINSA" function of TCM to save text window
	  to a sequential file.

Usage:	See "TCM.DOC"

Parameters:

Environment: RSX11M V4.0, DECUS C Compiler

See Also: TCM.C

Description: 

Example(s):  See "TCM.DOC"

Uses:

Internal: 

Update History:

END DOCUMENTATION
*/

#include <clang.c>
#include <stdio.h>
#include <cx.h>
#include "tcmdefs.h"
#include "tcmerr.h"
#include "tcmpublic.h"



/***	(TWINSA) Save Window to File    ***/

winsave()
{
    struct twindcb *wptr;

	/* Store text_save file name */
	count = MAXLEN;
	iff vrecv(&mastsk,line,&count) != IS_SUC then /* always receive file name */
	    error("TWINSA - Receive data error");
	line[count] = eos;	/* Mark end of file name */
	ret.cd = TS_SUC;	/* Default to O.K. */
	iff (wptr = fndwnd()) == NULL then
	    ret.cd = TE_NSW;
	else
	    ret.cd = tcmput(line,&(wptr->file),wptr->bufstart,wptr->botline);
	ret.dsw = $dsw;
} /* end file */
