/*
BEGIN DOCUMENTATION

Name: TCMPINSTXT.C 				Created: 05/11/84  DTS
					    Last Update: 05/15/84
Title: TCM TXTINS PL/I User Interface

Index: text editor, editor, TCM, TXTINS

Abstract: Invokes separate TCM editing task to insert textual data 
	  into a tcm text window.

Usage: See "TCM.DOC" for PL/I usage

Parameters: See "TCM.DOC"

Environment: RSX11M V4.0 & RSX11M PLUS V2.1, DECUS C Compiler,
	     AIS PL/I Compiler, MMR PL/I Interface

See Also: TCM.C, TCMPLI.C

Description: This is the user entry for the text collection management (TCM)
	     function TXTINS.  This function inserts text into a given
	     location within a text window.  The text insert function is
	     actually executed by a separate slave task.  All data passes
	     between the caller (this program) and the slave through a common
	     set of task to task communication routines. 

Example(s):

Uses:

Internal:

Update History:

END DOCUMENTATION
*/



#include <clang.c>
#include <stdio.h>
#include <cx.h>
#include <signal.c>
#include <plistring.c>
#include "tcmdefs.h"
#include "tcmerr.h"
#include "tcmedopt.h"

#define TILUN 5			/* PL/I terminal lun for attach */
#define plinull -1		/* Null PL/I pointer */

/* External Routines */

extern charpointer plistr();
extern plient();
extern int tsndcmd();		/* Send srbuf & command to slave task */
extern tcm_status();		/* Return current status of edit task */
extern tcmdet();		/* Detach terminal */
extern tcmatt();		/* Attach terminal */

/* external globals */

extern struct rad50 tcmslv;	/* External task name */
extern struct cmdbuff srbuf;	/* Send buffer for commands */
extern int tcmdsw;		/* DSW of last directive */
extern struct retbuf ret;	/* Parameters returned from slave task */

/* TXTINS: (INPUT: w_name,ins_data,c_pos; OUTPUT: c_pos,rc);

Send command to insert text in TCM window on screen

Program Logic for TXTINS:

	IF tcm_status() != TS_SUC
	    exit with rc = tcm_status;
	ELSE
	    srbuf.name := w_name;
	    srbuf.row := c_pos.line;
	    srbuf.col := c_pos.column;
	    Send (cmd := 'T')
	    Send ins_data (insertion text or file name)
	    Receive status (rc)
	    set c_pos from returned position
	ENDIF
*/

txtins(narg,w_name,ins_data,c_pos,rc)
    int narg;
    plistring w_name,ins_data;
    struct plicursor **c_pos;
    pointer rc;
{
    register struct pliwdef *win_def;

	plient("TXTINS");
	iff narg != 4 then
	    signal(NUMARGS);
	iff (*rc = tcm_status()) == TS_SUC then
	{
	    setname(w_name);			/* Put window name to srbuf */
	    srbuf.row = (*c_pos)->line;		/* Set c_pos to srbuf */
	    srbuf.col = (*c_pos)->column;
	    tcmdet(TILUN);			/* Detach terminal */
	    iff (tcmdsw = tsndcmd('T')) == IS_SUC then
		tcmdsw = vsend(&tcmslv,plistr(ins_data),plilen(ins_data));
	    iff tcmdsw == IS_SUC then
	    {
		recv_status(rc);
		(*c_pos)->line = ret.bline;
		(*c_pos)->column = ret.bcol;
	    }
	    else
		*rc = TE_SRV;
	    tcmatt(TILUN);			/* Attach terminal */
	}
} /* end txtins */
