/* TCMDEFS.H: constants and types used in TCM system 		03/15/84 */

#define RDFLAG 5		/* Event flag for terminal input */
#define ATFLAG 6		/* Event flag for terminal attach */
#define MAXLEN 256		/* Maximum line length + 1 */
#define SCBUFLEN 800
#define CRTLIN 24		/* Number of CRT lines supported */
#define CRTLEN 132		/* Number of columns on screen */
#define UNLPOS 33		/* Column for "U-Line" message */
#define BLDPOS 41		/* Bold message position */
#define INSPOS 57		/* Insert message */
#define MORPOS 73		/* More text message */
#define	STATLEN 80		/* Maximum status line display length */
#define TLUN 1			/* Lun for edit terminal */
#define VT52 65			/* Sctype for accepted terminals */
#define VT100 97
#define LA120 0

#define current 0		/* Line display status for repaint */
#define changed 1		/* Positive integer indicates change */
#define newlin -1
#define nochg -2
#define tempmsg -3

#define INITTABS "-------------------------------------------------------------------------------"
#define TABCOUNT 0		/* Number of tabs set in initial string above */

#define eos '\0'
#define BELL '\07'		/* ASCII Control Characters */
#define SO '\016'
#define SI '\017'
#define ESC '\033'

#define	BOLDON "\033[1m"	/* VT100 screen strings */
#define UNLINON "\033[4m"
#define REVERON "\033[7m"
#define ENHOFF "\033[0m"
#define VT100INIT "\033<\033=\033(B\033)0"	/* VT100, App keys, US & Graphics */

#define BOXTLC 'l'		/* line drawing characters (Top Left Corner) */
#define BOXTOP 'q'
#define BOXTRC 'k'		/* Top Right Corner */
#define BOXSIDE "\016x\017"	/* SO x SI */
#define BOXBLC 'm'		/* Bottom Left Corner */
#define BOXBRC 'j'		/* Bottom Right Corner */

#define IS_TMO 002		/* Full Duplex terminal driver functions */

#define IO_ATT 01400
#define IO_RAL 01010
#define IO_RNE 01020
#define IO_RST 01001
#define IO_WVB 011000
#define IO_WAL 0410
#define IO_KIL 012
#define IO_DET 02000

#define TF_ESQ 020
#define TF_NOT 002
#define TF_RNE 020
#define TF_TMO 0200

#define IE_ABO 0361
#define IE_BCC 0276
#define IE_TMO 0241

#define	SF_GMC 02560		/* Get multiple characteristics */
#define SF_SMC 02440		/* Set "   " */

#define	TC_WID 01		/* Terminal Width */
#define TC_RAT 07		/* Typeahead mode - RSX11M only */
#define TC_ACR 024		/* Wrap */
#define TC_FDX 064		/* Full duplex */
#define TC_TBF 071		/* Typeahead buffer count */

/***	DECUS C library routines    ***/

extern char *cpystr();		/* Copy string, return end of out */
extern char *strcpy();		/* copy string, return start of out */
extern int strlen();		/* Length of string */
extern boolean streq();
extern scerln();
extern scerpg();
extern char *scget();
extern int sclmargin();
extern scout();
extern int scset();
extern int scsettype();
extern int kbin();

/***	RSX directives - DECUS C library extentions    ***/

extern int qio();
extern wtse();
extern int $dsw;

/***	Definition of Text WINDow Control Block    ***/

typedef struct twindcb {	/* one for each window on screen */
		ADDR	twinptr;	/* Link to next window */
		char	name[10];	/* String, 8 char name + null */
	short	int	row;		/* Location of top on screen */
	short	int	col;		/* Left margin */
	short	int	height;		/* Lines on screen */
	short	int	width;		/* Max line length */
		int	max_chars;	/* Maximum chars in memory */
		int	virt_lines;	/* Maximum displayable lines */
		int	curmax;		/* Current # of chars in memory */
		FILE	*file;		/* In/Out file pointer, NULL => none */
	short	int	topline;	/* Current top line on screen */
	short	int	botline;	/* Last initialized line in buffer */
	short	int	column;		/* Cursor column in current edit line */
	short	int	edlinnum;	/* Last line # returned to caller */
	short	int	scroll;		/* Lines to scroll per section */
		char	*bufstart;	/* Buffer starting address */
		char	*bufend;	/* End of buffer for this window */
		char	*edline;	/* Pointer to start of current line */
		char	fillchr;	/* Background character for window */
		boolean	border;		/* Flag for borders */
		};


    /* Command buffer structure for master to slave communication */

typedef struct cmdbuff {
		char		cmd;		/* Command Code */
		char		name[9];	/* String, 8 char name + null */
		short	int	row;		/* Location of top on screen */
		short	int	col;		/* Left margin */
		short	int	height;		/* Lines on screen */
		short	int	width;		/* Max line length */
		short	int	max_chars;	/* Maximum chars in memory */
		short	int	virt_lines;	/* Maximum displayable lines */
		char		opflag;		/* Output file or cursor flg */
		char		fillchr;	/* Fill character for window */
		};


    /* Return code buffer structure for slave to master status */

typedef struct retbuf {
		short	int	cd;		/* Return code for function */
		short	int	dsw;		/* Dsw of last directive */
		short	int	bcol;		/* Buffer column from tcoll */
		short	int	bline;		/* Buffer line from tcoll */
		short	int	term;		/* Value of terminating character */
		      };


    /* Display status & line pointers */

typedef struct dsplin {
		short	int	len;		/* Current line length */
		short	int	fircol;		/* First column changed since display, or status (nochg, current) */
		short	int	firchr;		/* Offset into string for fircol */
		short	int	laschr;		/* offset for last column changed (valid if fircol>0) */
			charpointer start;	/* Beginning of display line */
		      };
