/*
BEGIN DOCUMENTATION

Name: Daniel T. Soldahl				Created: 07/20/83
					    Last Update: 01/06/84
Title: TCMATTACH.C - Attach /Detach Terminal for TCM editing.

Index:

Abstract: Sets terminal parms and attaches terminal for editing.

Usage:

Parameters:


Environment: DECUS C, RSX11M V4.0

See Also: TCMEDIT.C, TCM.DOC, TCMNOTES.DOC

Description: Uses qio functions to set terminal for typeahead, full
	     duplex, and nowrap and to attach the terminal.

Example(s):

Uses:

Internal:

Update History:

END DOCUMENTATION
*/

#include <clang.c>
#include <stdio.h>
#include <cx.h>
#include "tcmdefs.h"



/***	Attach terminal (TI:) for input, set full duplex, typeahead    ***/

attach(lun)

    int	 lun;    
{
    int fnc;	/* parm definitions for qio */
    int eflag;
    int iosb[2];
    union {
	   int i;
	   pointer p;
	  } devpar[6];
    union {
	   int	dev;
	   char name[2];
	  } dnam;

    int	 unit;
    int ttchar[5];
    register int i,c;

    /* assign TI: device to given lun */

	dnam.name[0] = 'T';
	dnam.name[1] = 'I';
	unit = 0;

	alun(lun,dnam.dev,unit);


    /* Attach terminal to capture all characters & allow typeahead */

	fnc = IO_ATT;
	eflag = ATFLAG;
	iosb[0] = 0;
	devpar[0].i = 0;
	devpar[1].i = 0;
	devpar[2].i = 0;


	iff qiow(fnc,lun,eflag,iosb,0,devpar) < 0
	    then error("Attach error dsw = %d\n",$dsw);

    /* Set terminal characteristics for fullduplex & typeahead */

	fnc = SF_SMC;
	ttchar[0] = TC_FDX + 256;	/* Set full duplex */
	ttchar[1] = TC_ACR + 0;		/* Clear wrap */
	ttchar[2] = TC_RAT + 256;	/* Set typeahead */
	devpar[0].p = ttchar;
	devpar[1].i = 6;		/* Number of bytes in ttchar table */

	iff qiow(fnc,lun,eflag,iosb,0,devpar) < 0
	    then error("ATTACH - SMC error dsw = %d\n",$dsw);




} /* end attach */



/***	Detach terminal & kill outstanding I/O    ***/

detach(lun)

    int	lun;
{
    int iosb[2];

	iff qiow(IO_KIL,lun,ATFLAG,iosb,0,0) < 0		/* was qio not qiow */
	    then error("I/O Kill error, lun %d",lun);
	iff qiow(IO_DET,lun,ATFLAG,iosb,0,0) < 0
	    then error("Detach error, lun %d",lun);

} /* end detach */
