.;
.;
.;		B R U . C M D
.;
.;	Conduct a standard BRU run.
.;	This command file can be invoked either interactively by
.;		>@BRU
.;	Or as an MCR command by
.;		>@BRU input output
.;	    or
.;		>@BRU output=input
.;	Input and output devices will be mounted (foreign) as necessary.
.;	An output disk mounted foreign WILL be initialized.
.;
.;	The following switches are legal, and can appear on either input
.;	or output device:
.;		Switch	Default	Meaning
.;		/BA	/-BA	Run bad before copy (foreign disks only).
.;		/EX	/-EX	Exclude the named files from the copy.
.;		/IM	/-IM	Disk is "image mode".
.;		/PR	/PR	Preserve file ID''s.
.;		/RW	/RW	Rewind tape before copy. No effect for disk.
.;		/VE	/-VE	Verify volume after copy.
.;

.;	Author:	T. R. Wyant
.;	Maintainer:
.;		Process Systems System Manager
.;	Date:	24-Feb-83
.;	Modified:
.;		28-Apr-83 - T. R. Wyant
.;			Added size check & init switches for different-
.;				sized disks (M+V2.0 and M V4.0 only).
.;		02-Dec-83 - T. R. Wyant
.;			Added "bad" option.
.;		05-Mar-84 - T. R. Wyant
.;			Added "System Name" option.
.;		03-May-84 - T. R. Wyant
.;			Added /PR switch.
.;		11-Oct-84 - T. R. Wyant
.;			Added elapsed time counter.
.;		07-Nov-84 - T. R. Wyant
.;			Added ability to CON ONLINE
.;		09-Nov-84 - T. R. Wyant
.;			Added image mode support (/IM switch).
.;			Add support for "all defaults".
.;		15-Nov-84 - T. R. Wyant
.;			Added support for "non-standard" driver names.
.;		19-Nov-84 - T. R. Wyant
.;			Added support for the /EXCLUDE function.
.;		17-Dec-84 - T. R. Wyant
.;			Added support for /NOPRESERVE tape to disk.
.;
.;	Remarks:
.;		This command file will work under the following operating
.;		systems:
.;			RSX-11M V3.2
.;			RSX-11M V4.0
.;			RSX-11M V4.1
.;			RSX-11M+ V1.0
.;			RSX-11M+ V2.0
.;			RSX-11M+ V2.1
.;		Note that under the "Old" releases (M 3.2 and M+ 1.0),
.;		volumes must not be mounted foreign before running the
.;		command file; all unmounted volumes will be mounted
.;		foreign.
.;
	.ENABLE SUBSTITUTION
	.ENABLE ESCAPE
	.SETS S$STIM <TIME>	! Start time.
	.SETS D$MM1 ""		! Density for input from MM: drvr
	.SETS D$MM2 "/DEN:1600"	! Density for output to MM: drvr
	.SETS D$MT1 ""		! Density for input from MT: drvr
	.SETS D$MT2 "/DEN:800"	! Density for output to MT: drvr
	.SETS D$MS1 ""		! Density for input from MS: drvr
	.SETS D$MS2 ""		! Density for output to MS: drvr
	.SETS D$MF1 ""		! Density for input from MF: drvr
	.SETS D$MF2 "/DEN:6250"	! Density for output to MF: drvr
	.SETN O$DUCW 140010	! UCW1 value for a disk.
	.SETN O$DDNC 001700	! UCW1 "dont care" mask for a disk.
	.SETN O$TUCW 000140	! UCW1 value for a tape.
	.SETN O$TDNC 140621	! UCW1 "dont care" mask for a tape.
.;
.;		To get the system identification printed at the top
.;		when this command file is run interactively,
.;		just define the node name to be the system ID here.
.;		For example:
.;
	.SETS SYS1 "First system"
	.SETS COMM "Communications system"
	.SETS BLANK "The Unknown System."
.;
.;
	.IFNDF P1	.SETS P1 ""
	.IFNDF P2	.SETS P2 ""
	.PARSE P1 "=" P1 S
	.IF S = ""	.GOTO NOSWAP
	.SETS P2 P1
	.SETS P1 S
.NOSWAP:.SETF PROMPT
	.IF P1 <> ""	.OR .IF P2 <> ""	.GOTO START
	.SETS S$TXT "."
	.IFDF '<NETNOD>' .SETS S$TXT ", the "+'<NETNOD>'+"."
;
;
;		B R U . C M D
;
;	Run BRU on '<NETNOD>'::'S$TXT'
;
;	For help on any query, hit the escape key.
;
	.SETT PROMPT
.START:	.SETS MCR ".;"
	.SETS DCL ".;"
	.SETS CCL ".;"
	.IF <CLI> = "MCR"	.GOTO SYSTM
	.IF <CLI> = "DCL"	.GOTO SYSTM
	.IF <CLI> = "CCL"	.GOTO SYSTM
	; Error -- Command line interpreter "'<CLI>'" not supported.
	.EXIT 2
.SYSTM:	.SETS '<CLI>' ""
	.IF <SYSTEM> = 1	.GOTO DEFIN
	.IF <SYSTEM> = 6	.GOTO DEFIN
	; Error -- Operating system '<SYSTEM>' not supported.
	.EXIT 2
.DEFIN:	.SETS DIR1 "in"
	.SETS DIR2 "out"
	.SETN INDEX 1.
	.SETF ABORT
	.IFNDF <PRIVIL>	.GOTO COMSWI	! If 3.2/1.0 or before.
	.IF <SYSTEM> = 6 .IF <SYSID> < "15" .GOTO COMSWI	! If M+ V2.0
	.IF <SYSTEM> = 1 .IF <SYSID> < "35" .GOTO COMSWI	! If M 4.0
	.SETF SW$IMP		; Image switch not seen.
.COMSWI:.SETF SW$RWP		; Rewind switch not seen.
	.SETT SW$RWV		; Default is rewind.
	.SETF SW$EXP		; Exclude switch not seen.
	.SETF SW$EXV		; Default is to include the named files.
	.SETF SW$VEP		; Verify switch not seen.
	.SETF SW$VEV		; Default is no verification.
	.SETF SW$BAP		; Bad switch not seen.
	.SETF SW$BAV		; Default is not to run bad.
	.SETF SW$PRP		; Preserve switch not seen.
	.SETT SW$PRV		; Default is preserve file ID''s.
	.SETF SW$IMV		; Default is not image.
	.SETF SW$IM1		; Default on input is no image mode.
	.SETF SW$IM2		; Default on output is no image mode.
	.GOSUB DEV		; Check out input device.
	.GOSUB DEV		; Check out output device.
	.IFT TAP1 .IFT TAP2	; Error -- Input and output cannot both be tape.
	.IFT TAP1 .IFT TAP2	.EXIT 2
	.IFT SW$IM1 .IFT TAP2	; Error -- You cannot copy "image mode" disks to tape.
	.IFT SW$IM1 .IFT TAP2	.EXIT 2
	.IFT SW$IM2 .IFT TAP1	; Error -- You cannot copy tape to "image mode" disks.
	.IFT SW$IM2 .IFT TAP1	.EXIT 2
	.IF DEV1 = DEV2		; Error -- Input and output device cannot be same.
	.IF DEV1 = DEV2		.EXIT 2
	.IF FIL2 <> ""		; Error -- Output file spec. not allowed.
	.IF FIL2 <> ""		.EXIT 2
	.IF FIL1 = ""	.SETT SW$EXP	! If there is no input file spec,
	.IF FIL1 = ""	.SETF SW$EXV	!     override the /EX switch.

.DEFQ:	.IFF PROMPT	.GOTO DEFQE
	;
	; The questions applicable to this BRU run are:
	;

	.SETS S "N"
	.IFT SW$VEV .SETS S "Y"
	.IFF SW$VEP ; >* Shall I verify the output volume (Default: "'S'")

	.IFF TAP1 .IFF TAP2	.GOTO BRANCH
	.IFF SW$RWP		.GOTO BRANCH
	.SETS S "N"
	.IFT SW$RWV .SETS S "Y"
	; >* Shall I rewind the tape first (Default: "'S'")
.BRANCH:.;

	.IFNDF SW$IMP	.GOTO BRANCH
	.IFT SW$IMP	.GOTO BRANCH
	.IFT TAP1 .OR .IFT TAP2	.GOTO BRANCH
	.IFT F111 .IFT F112	.GOTO BRANCH
	.SETS S "N"
	.IFT SW$IMV .SETS S "Y"
	.SETS S1 "either"
	.IFT F111	.SETS S1 "the output"
	.IFT F112	.SETS S1 "the input"
	; >* Is 'S1' disk in BRU (NOT FILES-11) format (Default: "'S'")
	.IFT F111 .OR .IFT F112	.GOTO BRANCH
	.IFF SW$IMV	.GOTO BRANCH
	; >* Is the input disk in BRU (NOT FILES-11) format (Default: "N")
.BRANCH:.;

	.IFT TAP2 .OR .IFT F112			.GOTO BRANCH
	.IFT SW$IM2 .OR .IFT SW$PRP		.GOTO BRANCH
	.SETS S "N"
	.IFDF <PRIVIL> .IFT SW$PRV .SETS S "Y"
	; >* Shall I preserve file IDs (Default: "'S'")
.BRANCH:.;

	.IFT TAP2 .OR .IFT SW$IM2 .OR .IFT F112	.GOTO BRANCH
	.IFT SW$BAP				.GOTO BRANCH
	.SETS S "N"
	.IFDF <PRIVIL> .IFT SW$BAV .SETS S "Y"
	; >* Shall I run BAD on 'DEV2' first (Default: "'S'")
.BRANCH:.;

	.IFT SW$EXP	.GOTO BRANCH
	.SETS S "N"
	.IFT SW$EXV .SETS S "Y"
	; >* Shall I copy all files on 'DEV1' EXCEPT 'FIL1' (Default: "'S'")
.BRANCH:.;

	;
	; If these defaults are appropriate, answer the following
	; question "Y".
	;
	.SETS S ".ASK [<FALSE>]"
	.IFNDF <PRIVIL>	.SETS S ".ASK"
	'S' L$Q Do you want to take all the above defaults
	.IFF <ESCAPE>	.GOTO DEFQP
	;
	; If all the defaults for the listed questions are appropriate,
	; answer this question "Y", and you will be asked no more
	; questions. If one or more defaults are not appropriate,
	; answer this question "N", and you will be asked all the
	; listed questions, and possibly others depending on your
	; responses.
	;
	.GOTO DEFQ
.DEFQP:	.IFT L$Q	.SETF PROMPT
.DEFQE:	.;

.VERSW:	.SETS S ".ASK [SW$VEV]"
	.IFNDF <PRIVIL>	.SETS S ".ASK"
	.IFT PROMPT .IFF SW$VEP	'S' SW$VEV Shall I verify the output volume
	.IFF <ESCAPE>	.GOTO VERSWE
	;
	; BRU has the capability of reading the output volume back in and
	; comparing it to the input volume. An error will be reported if the
	; two volumes do not match. There are two drawbacks to this:
	;	* It takes longer (about 2-3X)
	;	* You should not write to the input volume while BRU is
	;		running. If you do, you may produce spurious
	;		verification failures.
	;
	; The default is no verification.
	;
	.GOTO VERSW
.VERSWE:.;

.REWSW:	.IFF TAP1 .IFF TAP2	.GOTO REWSWE
	.SETS S ".ASK [SW$RWV]"
	.IFNDF <PRIVIL>	.SETS S ".ASK"
	.IFT PROMPT .IFF SW$RWP	'S' SW$RWV Shall I rewind the tape first
	.IFF <ESCAPE>	.GOTO REWSWE
	;
	; You have the choice of:
	;	Rewinding the tape before processing;
	;	beginning your processing at the current location.
.IFT TAP2	; If you rewind the tape, all backup sets currently on the tape
.IFT TAP2	; will be lost. If you do not rewind the tape, your new backup
.IFT TAP2	; set will be appended to the tape.
	.SETS S ""
	.IFF SW$RWV	.SETS S "not "
	;
	; The default is 'S'to rewind.
	;
	.GOTO REWSW
.REWSWE:.;

.IMGSW:	.IFT TAP1 .OR .IFT TAP2	.GOTO IMGSWE
	.IFNDF SW$IMP	.GOTO IMGSWE
	.IFT SW$IMP	.GOTO IMGSWE
	.IFT F111 .IFT F112	.GOTO IMGSWE
	.SETS S ".ASK [SW$IMV]"
	.IFNDF <PRIVIL>	.SETS S ".ASK"
	.SETS S1 "either"
	.IFT F111	.SETS S1 "the output"
	.IFT F112	.SETS S1 "the input"
	.IFT PROMPT 'S' SW$IMV Is 'S1' disk in BRU (NOT FILES-11) format
	.IFF <ESCAPE>	.GOTO IMGSWP
	;
	; BRU can copy one large disk to several small disks (and back
	; again) by pretending the small disks are tapes. The small disks
	; are written in BRU format, meaning only BRU can read them.
	; Copying BRU disks to FILES-11 disks seems to be slower than
	; the normal BRU disk-to-disk, but is much faster than tape.
	.SETS S ""
	.IFF SW$IMV	.SETS S "no "
	;
	; The default is 'S'BRU formatted disks.
	;
	.GOTO IMGSW
.IMGSWP:.IFF SW$IMV	.GOTO IMGSWE
	.IFT F111	.SETT SW$IM2
	.IFT F112	.SETT SW$IM1
	.IFT F111 .OR .IFT F112	.GOTO IMGSWE
.IMGSWW:
	.SETS S ".ASK [SW$IM1]"
	.IFNDF <PRIVIL>	.SETS S ".ASK"
	.IFT PROMPT 'S' SW$IM1 Is the input disk in BRU (NOT FILES-11) format
	.IFF <ESCAPE>	.IFF SW$IM1	.SETT SW$IM2
	.IFF <ESCAPE>	.GOTO IMGSWE
	;
	; You have already told me that one of the disks is in BRU format.
	; I need to know which one it is. If you answer this question "Y"
	; I will treat the input disk as being in BRU format. If you ans-
	; wer this question "N", I will treat the output disk as being in
	; BRU format. It is illegal for both disks to be in BRU format.
	;
	.GOTO IMGSWW
.IMGSWE:.;

.PRESW:	.IFT TAP2 .OR .IFT F112 .GOTO PRESWE
	.IFT SW$IM2	.GOTO PRESWE
	.SETS S ".ASK [SW$PRV]"
	.IFNDF <PRIVIL>	.SETS S ".ASK"
	.IFT PROMPT .IFF SW$PRP	'S' SW$PRV Shall I preserve file IDs
	.IFF <ESCAPE>	.GOTO PRESWE
	;
	; The file ID is a short, "internal" means of referring to a file.
	; In particular, it is used by the RSX operating system to find
	; installed tasks. If your input pack is bootable, and you wish
	; your output pack to be bootable too, you must answer this question
	; "yes". Note that it may not be possible to preserve file IDs
	; when BRUing from a larger pack to a smaller one.
	.SETS S ""
	.IFF SW$PRV	.SETS S "not "
	;
	; The default is 'S'to preserve file ID''s.
	;
	; IF YOU ARE COPYING A SYSTEM DISK, ALWAYS ANSWER THIS QUESTION "Y".
	;
	.GOTO PRESW
.PRESWE:.;

.BADSW:	.IFT TAP2 .OR .IFT SW$IM2 .OR .IFT F112	.GOTO BADSWE
	.SETS S ".ASK [SW$BAV]"
	.IFNDF <PRIVIL>	.SETS S ".ASK"
	.IFT PROMPT .IFF SW$BAP	'S' SW$BAV Shall I run BAD on 'DEV2' first
	.IFF <ESCAPE>	.GOTO BADSWE
	;
	; If you answer "Y" to this question, the bad block locator will
	; be run on your output disk before the copy takes place. This
	; normally needs to be done only if:
	;	The disk has just been formatted;
	;	Hardware diagnostics have been run on the disk;
	;	You suspect that the disk contains bad blocks that are
	;		not in the bad block file.
	.SETS S ""
	.IFF SW$BAV	.SETS S "not "
	;
	; The default is 'S'to run BAD.
	;
	.GOTO BADSW
.BADSWE:.;

.EXCSW:	.IFF PROMPT	.GOTO EXCSWE
	.IFT SW$EXP	.GOTO EXCSWE
	.SETS S ".ASK [SW$BAV]"
	.IFNDF <PRIVIL>	.SETS S ".ASK"
	'S' SW$EXV Shall I copy all files on 'DEV1' EXCEPT 'FIL1'
	.IFF <ESCAPE>	.GOTO EXCSWE
	;
	; If you answer "Y" to this question, all files on 'DEV1' will
	; be copied to 'DEV2', EXCEPT for 'FIL1'.
	; If you answer "N", only 'FIL1' will be
	; copied from 'DEV1' to 'DEV2'.
	;
	.IFF SW$EXV	; The default is to copy only 'FIL1'.
	.IFT SW$EXV	; The default is to copy all but 'FIL1'.
	;
	.GOTO EXCSW
.EXCSWE:.;
.;

	.SETN INDEX 1.
	.SETS S$STIM <TIME>
;                               Started: 'S$STIM%R8'
	.GOSUB MOU		; Mount the input device.
	.GOSUB MOU		; Mount the output device.
	.SETS CMDSTR ""
	.SETS UFDSWI ""
	.IFDF <PRIVIL>		.SETS UFDSWI "/UFD"
	.IFF TAP1 .IFT F111	.SETS CMDSTR "/MOU"
	.IFF TAP2 .IFF F112	.SETS CMDSTR CMDSTR+"/INI"
	.IFF TAP2 .IFT F112	.SETS CMDSTR CMDSTR+"/NOINI'UFDSWI'"
	.IFT SW$IM1		.SETS CMDSTR CMDSTR+"/IM:R"
	.IFT SW$IM2		.SETS CMDSTR CMDSTR+"/IM:S"
	.SETS REWSWI ""
	.IFT TAP2	.SETS REWSWI "/APP"
	.IFT SW$RWV	.SETS REWSWI "/REW"
	.IFT TAP1 .OR .IFT TAP2	.SETS CMDSTR CMDSTR+REWSWI
	.IFT TAP1		.SETS CMDSTR CMDSTR+D$$$1
	.IFT TAP2		.SETS CMDSTR CMDSTR+D$$$2
	.IFT SW$VEV		.SETS CMDSTR CMDSTR+"/VER"
	.IFT SW$EXV		.SETS CMDSTR CMDSTR+"/EXC"
	'MCR'			.SETS CMDSTR "BRU"+CMDSTR
	'DCL'	.IFNDF <PRIVIL>	.SETS CMDSTR "ARCHIVE"+CMDSTR
	'DCL'	.IFDF <PRIVIL>	.SETS CMDSTR "MCR BRU"+CMDSTR
	'CCL'			.SETS CMDSTR "MCR BRU"+CMDSTR

	.SETS PFISWI ""				! Assume preserve file IDs.
	.IFT TAP2	.GOTO GOTPFI		! If output to tape, true.
	.IFT SW$PRV	.GOTO GOTPFI		! If explicitly want, true.
	.IFT F112	.GOTO GOTPFI		! If mounted output, no switch.
	.SETS PFISWI "/NOPRE"			! Want the "NOPRESERVE".
	.IFNDF <PRIVIL>	.GOTO GOTPFI		! If "old" OS, no more.
.;	.IF IN1 = IN2 .IF MX1 = MX2 .GOTO GOTPFI !If same size, fine.
.;	.SETS PFISWI ""
	.IF IN1 <> IN2 .SETS PFISWI PFISWI+"/HEA:'IN2'"	! Initial headers.
	.IF MX1 <> MX2 .SETS PFISWI PFISWI+"/MAX:'MX2'"	! Maximum headers.
.GOTPFI:.SETS CMDSTR CMDSTR+PFISWI

.COPY:	.IFT F112	.SETF SW$BAV	! If FILES-11, no BAD.
	'MCR'	.IFT SW$BAV	BAD 'DEV2'/LI
	'CCL'	.IFT SW$BAV	MCR BAD 'DEV2'/LI
	'DCL'	.IFT SW$BAV	MCR BAD 'DEV2'/LI
	'CMDSTR' 'DEV1''FIL1' 'DEV2'
	.GOTO DMO
.;
.;
.;
.;		DEV -- Check for legal device.
.;
.DEV:
	.SETN D INDEX
	.INC INDEX
	.IFNDF P'D'	.SETS P'D' ""
.DEV003:.SETS S DIR'D'
	.DISABLE LOWERCASE
	.IF P'D' = ""	.ASKS P'D' Give 'S'put device
	.ENABLE LOWERCASE
	.IFF <ESCAPE>	.GOTO DEV006
	;
	; You must give the device name in the usual RSX format: two
	; alphabetic characters, followed (optionally) by an octal number
	; in the range 0-77, and a colon. For the input device only, you
	; can also specify a file name (or names), as many as will fit on
	; the final BRU command line. If you do not give a file name, the
	; colon after the device name is optional.
	;
	; This command file will insure that your device is in the system,
	; and is either a disk or tape.
	;
	.SETS P'D' ""
	.IFT PROMPT	.GOTO DEV003
	.EXIT 2
.DEV006:.PARSE P'D' ":/" S FIL'D' SWILST
	.TEST S
	.IFDF <PRIVIL>	.IFF <ALPHAN>	.GOTO DEV007
	.TESTFILE 'S':
	.SETF CON'D'
	.IF <FILERR> = 1	.GOTO DEV010
	.IF <FILERR> = 240.	.GOTO DEV010
	.IF <FILERR> = 230.	.GOTO DEV010
	.IF <FILERR> = 277	.IF <SYSTEM> = 6	.GOTO DEV009
	; Error -- 'S': not in system. I/O error = '<FILERR>' (Decimal).
	.SETS P'D' ""
	.IFT PROMPT	.GOTO DEV003
	.EXIT 2
.DEV007:; Error -- 'S': is an illegal device name.
	.SETS P'D' ""
	.IFT PROMPT	.GOTO DEV003
	.EXIT 2
.DEV009:.SETT CON'D'
.DEV010:
	.PARSE <FILSPC> ":" DEV'D' S
	.SETS S DEV'D'[3:5]
	.SETN O 'S'
	.SETS DEV'D' DEV'D'[1:2]+"'O':"
	.SETS S DEV'D'[1:2]
	.SETF TAP'D'
	.SETS D$$$'D' ""
	.IFDF D$'S''D'	.SETS D$$$'D' D$'S''D'
	.IFNDF <PRIVIL>	.GOTO DEV012
	.SETS S DEV'D'
	.TESTDEVICE 'S':
	.PARSE <EXSTRI> "," S S$UCW1 S$UCW2 S$UCW3 S$UCW4 S$FLGS
	.IF O$DUCW = 'S$UCW1'&(#O$DDNC)	.GOTO DEV014
	.SETT TAP'D'
	.IF O$TUCW = 'S$UCW1'&(#O$TDNC)	.GOTO DEV014
	.GOTO DEV013
.DEV012:.SETS S S[1:1]
	.IF S = "D"	.GOTO DEV014
	.SETT TAP'D'
	.IF S = "M"	.GOTO DEV014
.DEV013:.PARSE P'D' ":" S FIL'D'
	; Error -- 'S': not disk or tape.
	.SETS P'D' ""
	.IFT PROMPT	.GOTO DEV003
	.EXIT 2
.DEV014:.SETF DMO'D'			! Assume already mounted.
	.SETF F11'D'			! Assume not files-11
	.SETT FOR'D'			! Assume foreign.
	.SETF PUB'D'			! Assume not public.
	.SETS S DEV'D'			! Get the device name.
	.IFDF <PRIVIL>	.GOTO DEV015	! If have .TESTDEVICE, use it.
	.IFT TAP'D' .IF <SYSTEM> = 6 .SETT DMO'D' ! Mount tape in M+
	.IFT TAP'D'	.GOTO DEV060	! If tape, all done.
	.TESTFILE 'S'[0,0]INDEXF.SYS	! Is disk mounted FILES-11?
	.IF <FILERR> <> 1 .GOTO DEV060	! If not, all done.
	.SETT F11'D'			! Correct our
	.SETF FOR'D'			!    assumptions.
	.GOTO DEV060			! Go parse switches.
.DEV015:.TESTDEVICE 'S'			! Test the device.
	.TEST <EXSTRI> "ALO,"		! Is it allocated to another?
	.IF <STRLEN> > 0 .GOTO DEV019	! If so, an error.
	.TEST <EXSTRI> "FOR,"		! Is it already mounted foreign?
	.IF <STRLEN> > 0 .GOTO DEV060	! No need to mount it.
	.TEST <EXSTRI> "MTD,"		! Is it mounted at all?
	.IF <STRLEN> = 0 .GOTO DEV016	! If not, handle.
	.SETT F11'D'			! Must be mounted files-11.
	.SETF FOR'D'			! Not foreign.
	.GOTO DEV060			! Go parse switches.
.DEV016:.SETT DMO'D'			! Need to (dis)mount.
	.TEST <EXSTRI> "PUB,"		! Is it public?
	.IF <STRLEN> > 0 .SETT PUB'D'	! If so, report.
	.GOTO DEV060			! Go parse switches.
.DEV019:; Error -- Device 'S' is allocated to another terminal.
	.GOTO DEV
.DEV020:
	.PARSE SWILST "/" SWI SWILST
	.IF SWI = ""	.GOTO DEV060
	.SETT ASSERT
	.SETS S SWI[1:1]
	.IF S <> "-"	.SETS S SWI[1:2]
	.IF S <> "-" .IF S <> "NO"	.SETS S ""
	.IF S <> ""	.SETF ASSERT
	.TEST S
	.SETS SWI SWI[<STRLEN>+1:80.]
	.SETS S SWI[1:2]
	.TEST S
	.IF <STRLEN> <> 2	.GOTO DEV030
	.IFF <ALPHAN>		.GOTO DEV030
	.IFNDF SW$'S'P		.GOTO DEV030
	.IFT SW$'S'P		.GOTO DEV040
	.SET'ASSERT' SW$'S'V
	.SETT SW$'S'P
	.GOTO DEV060
.DEV030:; Error - Switch "/'SWI'" is illegal.
	.GOTO DEV050
.DEV040:; Error - Switch "/'SWI'" has already been specified.
.DEV050:.SETT ABORT
.DEV060:.IF SWILST <> ""	.GOTO DEV020
	.SET'SW$IMV' SW$IM'D'		! Pick up /IM for this device.
	.IFT TAP'D'	.SETF SW$IM'D'	! If tape, must be negated.
	.IFF ABORT	.GOTO DEV070
	.IFF PROMPT	.EXIT 2
	.SETF ABORT
	.SETS P'D' ""
	.GOTO DEV003
.DEV070:.IFNDF <PRIVIL>	.RETURN
	.SETS S DEV'D'
	.TESTDEVICE 'S'
	.PARSE <EXSTRI> "," S S SUCW2 SUCW3 S
	.SETN O1 'SUCW2'&377
	.SETN O2 'SUCW3'
	.SETS S DEV'D'[1:2]
	.IF S = "DX" .OR .IF S = "DY"	.SETN O1 0

	.SETN TM'D' O1&1*100000+(O2/2)		! Calc. theoretical
	.SETN TM'D' TM'D'-(TM'D'/27.)		!    maximum files
	.IF O1 > 1	.SETN TM'D' 65500.	!    on disk.

	.SETN MX'D' O1&17*10000+(O2/16.)	! Calc. maximum files
	.IF O1 > 17	.SETN MX'D' 65500.	!    to use.

	.SETN IN'D' MX'D'/2.			! Calc. initial index
	.IF MX'D' < 100.	.SETN IN'D' 16.	!    file alloc.
	.IF MX'D' < IN'D'	.SETN MX'D' IN'D'
	.IF MX'D' >= 25593.	.SETN IN'D' 25593.
	.IF MX'D' >= 51699.	.SETN IN'D' 51699.

	.IF MX'D' < 65000.	.RETURN		! If a small disk, fine.

	.; The /INF & /MXF calculation for huge disks would go here,
	.; if I ever figure it out.

	.RETURN
.;
.;
.;		MOU -- Mount devices as necessary.
.;
.MOU:
	.SETN D INDEX
	.INC INDEX
	.SETS S DEV'D'
	.IFF DMO'D'	.RETURN
	'MCR'	.IFT CON'D'	CON ONLINE 'S'
	'DCL'	.IFT CON'D'	MCR CON ONLINE 'S'
	'CCL'	.IFT CON'D'	MCR CON ONLINE 'S'
	.IF <EXSTAT> <> 1	.GOTO MOU99
	'MCR'	MOU 'S'/FOR
	'DCL'	MOUNT/FOREIGN 'S'
	'CCL'	MCR MOU 'S'/FOR
	.IF <EXSTAT> = 1	.RETURN
	.GOTO MOU099
.MOU091:; Error -- Device 'S' is allocated to another terminal.
	.GOTO MOU099
.MOU099:.DEC INDEX
	.GOTO DMO
.;
.;
.;		DMO -- Dismount devices as necessary.
.;
.DMO010:
	.DEC INDEX
	.SETN D INDEX
	.IF <SYSTEM> = 1	.IFNDF <PRIVIL>		.GOTO DMO001
	.IFF DMO'D'		.GOTO DMO001

	.SETS S DEV'D'
	.SETS S1 ""
	.IFF PUB'D'	.GOTO DMO020
	'MCR'	.SETS S1 "/DEV"
	'DCL'	.SETS S1 "/PUBLIC"
	'CCL'	.SETS S1 "/DEV"
.DMO020:'MCR'	DMO 'S''S1'
	'DCL'	DISMOUNT'S1' 'S'
	'CCL'	MCR DMO 'S''S1'
.DMO:	.SETS S$ETIM <TIME>
	.PARSE S$STIM ":" S$SH S$SM S$SS
	.PARSE S$ETIM ":" S$EH S$EM S$ES
	.SETN D$XS 60.+'S$ES'.-'S$SS'.
	.SETN D$XM 59.+'S$EM'.-'S$SM'.
	.SETN D$XH 23.+'S$EH'.-'S$SH'.
	.IF D$XS >= 60.	.INC D$XM
	.IF D$XS >= 60.	.SETN D$XS D$XS-60.
	.IF D$XM >= 60.	.INC D$XH
	.IF D$XM >= 60.	.SETN D$XM D$XM-60.
	.IF D$XH >= 24.	.SETN D$XH D$XH-24.
.DMO001:
	.IF INDEX > 1	.GOTO DMO010
;                              Finished: 'S$ETIM%R8'
;                               Started: 'S$STIM%R8'
	.SETS S$XTIM "'D$XH%DR2':'D$XM%DR2Z':'D$XS%DR2Z'"
	.IF D$XH > 0	.GOTO PRTXTM
	.SETS S$XTIM "'D$XM%DR2':'D$XS%DR2Z'"
	.IF D$XM > 0	.GOTO PRTXTM
	.SETS S$XTIM ":'D$XS%DR2Z'"
.PRTXTM:.;
;                               Elapsed: 'S$XTIM%R8'
	.EXIT <EXSTAT>
