verdef	macro
	db	' Kermit-MS V2.28'
	endm

BELL    EQU     07Q
TAB     EQU     11Q
LF      EQU     12Q
FF      EQU     14Q
CR      EQU     15Q
XON     EQU     21Q
XOFF    EQU     23Q
ESC     EQU     33Q
DEL     EQU     177Q
BS	EQU	08H
CTLZ	EQU	1AH
SOH     EQU     01H             ; Start of header char.

DOS     EQU     21H

CONIN   EQU     01H
CONOUT  EQU     02H
RDRIN   EQU     03H
PUNOUT  EQU     04H
LSTOUT  EQU     05H
DCONIO  EQU     06H
CONINQ	EQU	07H		; quiet console input
PRSTR   EQU     09H
CONSTAT EQU     0BH
SELDSK	EQU	0EH		; Select disk.
OPENF   EQU     0FH
CLOSF   EQU     10H
SFIRST  EQU	11H
SNEXT	EQU	12H
DELF    EQU     13H
READF   EQU     14H             ; Read from the file.
WRITEF  EQU     15H
MAKEF   EQU     16H
GCURDSK	EQU	19H		; Current disk.
SETDMA	EQU	1AH
PRSFCB	equ	29H		; parse an fcb.
DOSVER	equ	30H		; dos version #
OPEN2	EQU	3DH		; 2.0 open
CLOSE2	EQU	3EH		; 2.0 close
READF2	EQU	3FH		; 2.0 read.
LSEEK	EQU	42H		; 2.0 lseek
IOCTL	EQU	44H
WRITEF2	EQU	40H		; 2.0 write
GCD	equ	47H		; 2.0 get current directory.
GSWITCH	EQU	37h		; undocumented get/set switch character
SETBLK	equ	4ah		; modify allocated memory map
ALLOC	equ	48h		; allocate memory
FREEMEM	equ	49h		; free memory
chdir	equ	3bh		; change directory
gettim	equ	2CH		; Get the time of day. 


PAREVN	EQU	00H		; Even parity.
PARMRK	EQU	01H		; Mark parity.
PARNON	EQU	02H		; No parity.	
PARODD	EQU	03H		; Odd parity.
PARSPC	EQU	04H		; Space parity.

CMKEY   EQU     01H             ; Parse a keyword.
CMIFI   EQU     02H             ; Parse an input file spec (can be wild).
CMOFI   EQU     03H             ; Parse an output file spec.
CMCFM   EQU     04H             ; Parse a confirm.
CMTXT	EQU	05H		; Parse arbitrary text up to CR.

FLOXON	EQU	1113H		; Use XON/XOFF for flow control.
FLONON	EQU	0		; Don't do flow control.
DEFHAND	EQU	XON		; Use XON as default handshake.

DMASIZ	EQU	80H		; Size of DMA.
FCBSIZ	EQU	25H

MAXTAK	EQU	05H		; Max number of TAKE's allowed.
MAXTRY  EQU	05Q		; Default number of retries on a packet.
IMXTRY  EQU	20Q		; Default number of retries send initiate.

DEFESC  EQU     ']'-100Q        ; The default escape character.
DRPSIZ  EQU     94		; Default receive packet size.
DSPSIZ  EQU     94		; Default send packet size.
DSTIME  EQU     08H             ; Default send time out interval.
DRTIME  EQU     0DH             ; Default receive time out interval.
DSRVTM	EQU	30		; Default server timeout.
DSPAD   EQU     00H             ; Default send padding.
DRPAD   EQU     00H             ; Default receive padding.
DSPADC  EQU     00H             ; Default send padding char.
DRPADC  EQU     00H             ; Default receive padding char.
DSEOL   EQU     CR              ; Default send EOL char.
DREOL   EQU     CR              ; Default receive EOL char.
DSSOH	EQU	SOH		; Default send start-of-packet char.
DRSOH	EQU	SOH		; Default receive start-of-packet char.
DSQUOT  EQU     '#'             ; Default send quote char.
DRQUOT  EQU     '#'             ; Default receive quote char.
DQBIN	EQU	'&'		; Default 8-bit prefix.
DRPT	EQU	'~'		; Default repeat prefix.
DCHKLEN	EQU	1		; Default checksum length.
DEFPAR	EQU	PARNON		; Default parity (none.) 
IBMPAR  EQU	PARMRK		; IBM's parity (mark.)


bufsiz	equ	2048		; size of serial input buffer

portmax	equ	8		; # of serial ports

; baud rate definitions
B00455	EQU	0		; 45.5 baud
B0050	EQU	1		; 50 baud
B0075	EQU	2		; 75 baud
B0110	EQU	3		; 110 baud
B01345	EQU	4		; 134.5 baud
B0150	EQU	5		; 150 baud
B0300	EQU	6		; 300 baud
B0600	EQU	7		; 600 baud
B1200	EQU	8		; 1200 baud
B1800	EQU	9		; 1800 baud
B2000	EQU	10		; 2000 baud
B2400	EQU	11		; 2400 baud
B4800	EQU	12		; 4800 baud
B9600	EQU	13		; 9600 baud
B19200	EQU	14		; 19200 baud
B38400	EQU	15		; 38400 baud 

BAUDSIZ	EQU	16		; Number of options for baud rate.

; Structure definitions.

; Modem information.
mdminfo	struc
mddat	dw	0		; Default to port 1.
mdstat	dw	0		; Ditto. 
mdcom	dw	0		; Here too. 
mden	db	0
mddis	db	0
mdmeoi	db	0
mdintv	dw	0
mdminfo	ends

; Command information.
cmdinfo	struc	
cmstat  db      0               ; What is presently being parsed.
cmaflg  db      0               ; Non-zero when an action char has been found.
cmccnt  db      0               ; Non-zero if a significant char is found.
cmsflg  db      0               ; Non-zero when the last char was a space.
cmostp  dw      0               ; Old stack pointer for reparse.
cmrprs  dw      0               ; Address to go to on reparse.
cmprmp  dw      0               ; Address of prompt.
cmptab  dw      0               ; Address of present keyword table.
cmhlp   dw      0               ; Address of present help.
cmdbuf  db      80H DUP(0)      ; Buffer for command parsing.
cmfcb   dw      0               ; Pointer to FCB.
cmfcb2  dw      0               ; Pointer to position in FCB.
cmcptr  dw      0               ; Pointer for next char input.
cmdptr  dw      0               ; Pointer into the command buffer.
cmsiz	dw	0		; Size info of user input.
cmkptr  dw      0               ; Pointer to keyword.
cmsptr  dw      0               ; Place to save a pointer.
cmchr	db	0		; Save char when checking ambiguity.
cmrflg	db	0		; Assume parsing filename for send.
cmcr	db	0		; Say whether bare CR is allowed.
cmquiet	db	0		; non-zero for no echoing...
cmdinfo	ends

; Flags information.
flginfo	struc
belflg	db	1		; Use bell
comflg	db	1		; Use COM1 by default.
abfflg	db	1		; Discard incoming file if abort.
debug	db	0		; Debugging mode (default off).
flwflg  db      1               ; File warning flag (default on).
ibmflg  db      0               ; IBM flag (default off).
extflg  db      0               ; Exit flag (default off).
vtflg	db	1		; H-19 emulation.
droflg	db	0		; Override default disk drive.
nmoflg	db	0		; Override name from the F packet.
wldflg	db	0		; Assume no "*" in fn.
cxzflg	db	0		; ^X/^Z to interrupt file x-fer.
xflg	db	0		; Seen "X" packet.
filflg  db      0               ; Non-zero when nothing in DMA buffer.
eoflag  db      0               ; EOF flag; non-zero on EOF.
getflg	db	0		; Assume normal RECEIVE (not GET).
capflg	db	0		; On if capturing data.
takflg	db	0		; On if echo commands of TAKE file.
timflg	db	0		; Say if are timing out or not.
destflg	db	1		; Incoming files destination: disk or printer.
eofcz	db	0		; ^Z signals eof if non-zero.
remflg	db	0		; non-zero if in remote mode.
modflg	db	1		; non-zero if mode line on.
wrpflg	db	0		; non-zero if line wrap is to be done
flginfo	ends

; Transmission parameters
trinfo	struc
maxdat	db	0		; Max packet size for send.
chklen	db	1		; Number of characters in checksum.
seol	db	dseol		; Send EOL char.
reol	db	dreol		; Receive EOL char.
ssoh	db	dssoh		; Send start-of-packet character.
rsoh	db	drsoh		; Receive start-of-packet character.
squote  db	dsquot		; Send quote character.
rquote	db	drquot		; Receive quote character.
spsiz	db	dspsiz		; Send packet size.
rpsiz	db	drpsiz		; Receive packet size.
stime	db	dstime		; Send timeout. (Don't timeout).
rtime	db	drtime		; Receive timeout.
spad	db	dspad		; Send padding.
rpad	db	drpad		; Receive padding.
spadch	db	dspadc		; Send padding char.
rpadch	db	drpadc		; Receive padding char.
ebquot	db	'Y'		; Send 8-bit quote character.
escchr	db	defesc		; Escape character.
trinfo	ends

pktinfo	struc
pktnum  dw      0               ; Packet number.
numpkt  dw      0               ; Total number of packets sent.
numrtr  dw      0               ; Total number of retries.
numtry  db      0               ; Number of tries on this packet.
oldtry  db      0               ; Number of tries on previous packet.
state   db      0               ; Present state of the automaton.
argblk  dw      0               ; For subroutine arguments.
argbk1  dw      0
argbk2  dw      0
argbk3  dw      0
pktinfo	ends

takinfo	struc
takfcb	db	fcbsiz dup(0)
takbuf	db	dmasiz dup(0)
takptr	dw	0
takchl	db	0
takcnt	dw	0,0
takinfo ends

; Port Information.
prtinfo	struc
baud	dw	0		; Default baud rate.
ecoflg  db      0               ; Local echo flag (default off).
parflg  db	0		; Parity flag (default none.)
floflg	db	0		; If need flow control during file x-fer.
hndflg	db	0		; If need handshake during file x-fer.
hands	db	0		; Default handshake.
flowc	dw	0		; Do flow control with XON/XOFF.
prtinfo	ends

mkeyw	macro	key,val
	local	junk,oldval
oldval	equ	$
	db	junk,key,'$'
junk	equ	$-oldval-2
	dw	val
	endm


; definitions for terminal handler:

termarg	struc
flgs	db	?		; flags
prt	db	?		; port to use (0,1)
cols	db	?		; # columns on screen
rows	db	?		; # rows on screen
captr	dw	?		; routine to call with captured data
belld	dw	?		; bell divisor
klen	dw	?		; length of key redefinition table
ktab	dw	?		; address of key redefinition table
krpl	dw	?		; address of key replacement table
escc	db	?		; escape character
baudb	db	?		; baud rate bits.
parity	db	?		; parity
termarg	ends

; bits for flag byte
scrsam	equ	80h			; on if shouldn't redraw screen
capt	equ	40h			; capture output
emheath	equ	20h			; emulate heath
havtt	equ	10h			; have translate table
trnctl	equ	08h			; translate control chars
modoff	equ	04h			; mode line off
lnwrap	equ	02h			; auto-wrap long lines
lclecho	equ	01h			; local echo

; macro to save registers...

saveac	macro	regs
	local	cnt,lbl,xcnt
cnt	=	0
	irp	reg,<regs>
	push	reg
cnt	=	cnt+1
	endm
	call	lbl
	mov	bp,sp
xcnt	=	cnt
	irp	reg,<regs>
cnt	=	cnt-1
	mov	reg,[bp+2*cnt]
	endm
	mov	bp,ax		; store ax temporarily
	lahf			; preserve flags
	add	sp,2*xcnt
	sahf
	mov	ax,bp		; restore ax
	ret
lbl	label	near
	endm


