/*
 * CKMKEY.H 
 *
 * Key-Config is a keyboard configurator program for use with Columbia's
 * MacKermit.
 *
 * Bill Schilit, April 1985
 *
 *
 * Copyright (C) 1985, Trustees of Columbia University in the City of
 * New York.  Permission is granted to any individual or institution to
 * use, copy, or redistribute this software so long as it is not sold
 * for profit, provided this copyright notice is retained.
 *
 */

#define ABOUTID 257

typedef int PLONG;			/* pascal long in sumex */
typedef unsigned char BOOL;
typedef unsigned char CHAR;
#define NIL 0
#define NULL 0
#define NILPTR (Ptr) NIL
#define NILPROC (ProcPtr) NIL
#define NILCTRL (ControlHandle) NIL
#define TRUE 1
#define FALSE 0

#define btnOff	0
#define btnOn	1

/* Resource IDS for "Maybe Save" alert */

#define MAYBE_ALRT 2			/* alert number */
#define YES_MAYBE 1			/* each button */
#define NO_MAYBE 2
#define CANCEL_MAYBE 3

/* Resource IDS for "Set Modifier Keys" Dialog */

#define RSMK_OK 1
#define RSMK_CANCEL 2
#define RSMK_OPTNORM 4
#define RSMK_OPTCTRL 5
#define RSMK_OPTCAPS 6
#define RSMK_OPTMETA 7
#define RSMK_KLKNORM 9
#define RSMK_KLKCTRL 10
#define RSMK_KLKCAPS 11
#define RSMK_KLKMETA 12
#define RSMK_CMDNORM 14
#define RSMK_CMDCTRL 15
#define RSMK_CMDCAPS 16
#define RSMK_CMDMETA 17
#define RSMK_M8BIT 18
#define RSMK_MPREF 19
#define RSMK_METXT 20

#define dimHilite 255
#define noHilite 0

#define DLOG_RSMK 1001			/* set modifier key dialog */

#define OUR_ALRT 1

struct QDVar QDVar;

/* getctlhdl - same as above but for controls */

#define getctlhdl(item,dp) (ControlHandle) gethdl(item,dp)


#define MIN_MENU 1
#define APPL_MENU 1
#define  ABOU_APPL 1
#define FILE_MENU 2
#define  OPEN_FILE 1
#define  SAVE_FILE 2
#define  DECOM_FILE 3
#define  QUIT_FILE 4
#define SETK_MENU 3
#define  SKEY_SETK 1
#define  SMOD_SETK 2
#define  FCNK_SETK 3
#define MAX_MENU 3

/* Set function definitions item ids */

#define DLOG_SETF 1002			/* set function DLOG ID */

#define SETFD_SET 1
#define SETFD_QUIT 2
#define SETFD_ST1 3
#define SETFD_ET1 4
#define SETFD_ST2 5
#define SETFD_ET2 6
#define SETFD_ST3 7
#define SETFD_ET3 8
#define SETFD_ST4 9
#define SETFD_ET4 10
#define SETFD_ST5 11
#define SETFD_ET5 12
#define SETFD_SCR 13
#define SETFD_ETI 14			/* invisible edit text */

/* Set Key Dialog item ids */

#define DLOG_SETK 1000			/* set key DLOG ID */

#define SETKD_SET 1			/* set key button */
#define SETKD_QUIT 2			/* quit button */
#define SETKD_SETFK 3			/* set function key */
#define SETKD_KEYB 4			/* keyboard pict, user item */
#define SETKD_KEYT 5			/* text for key name prompt */
#define SETKD_KVAL 6			/* edit text */
#define SETKD_ITXT 7			/* invisible text */


#define K_UNIT 8
#define K_HEIGHT 4*K_UNIT		/* need 6/4, 7/4, 9/4 below... */

#define R1 K_HEIGHT		 	/* normal key size */
#define R2 6*K_UNIT 			/* backspace, tab, enter, option */
#define R3 7*K_UNIT			/* caps lock, return size */
#define R4 9*K_UNIT	 		/* shift size */
#define R5 (7*K_HEIGHT)			/* return size */

#define KC_CMD 0x37			/* scan code for cmd */
#define KC_SHF 0x38			/* code for shift */
#define KC_KLK 0x39			/* code for caps lock */
#define KC_OPT 0x3A			/* code for option */

#define KC_OPT2 0x81			/* "special" for second option key */
#define KC_SHF2 0x82			/* "special" for second shift key */
#define KC_NUN 0x84			/* "special" for no key */

extern Handle gethdl();
extern BOOL modified;			/* set if things have changed */

#define SYM(x) { \
   asm("unlk a6"); \
   asm("rts"); \
   asm(".asciz 'x'"); \
   asm(".even"); }

