.;************************************************************************
.;************************************************************************
.;***********************       S R D . C M D        *********************
.;************************************************************************
.;************************************************************************
.;
.;	S R D . C M D	V6.6	Jun-85
.;
.;	This command file was created along with version 6.0
.;	of SRD. It is intended for use with ...AT., and seems
.;	to work under IAS V3.0, and RSX-11M V3.1 and 3.2 and V4.0.
.;
.;	This command file will create the necessary files to build
.;	SRD, and optionally assemble and task-build.
.;
.;	Parameters which may be passed to the command file:
.;	  Parameter 1, 2, or 3 (in any order) may be:
.;
.;	  	"S"  -  Skip over sections which ask system options and
.;			default switches desired.
.;
.;		"L"  -	Generate macro listing files.
.;		"LX" -	Generate macro cross reference listing files.
.;
.;		"M"  -  Generate task builder map file.
.;		"MX" -  Generate task builder cross reference map file.
.;
.;	TO BUILD SRD FOR THE FOLLOWING SYSTEMS:
.;
.;	R$$11M	--	RSX-11M MAPPED
.;	R$$11U	--	RSX-11M UNMAPPED
.;	R$$11D	--	RSX-11D
.;	I$$AS	--	IAS V3.0
.;	R$$MPL	--	RSX-11M Plus V2.0
.;
.; MODIFICATIONS:
.;
.;	01-DEC-81	Bob Turkelson(RBD)
.;		Correct problem with wrong switch settings when <ESCAPE>
.;		used to display help.
.;		Move /00 default value to 3rd switch initialization word
.;		Remove some references to SYSLIB when building with FCSRES
.;
.;	10-Jul-82	Bob Denny
.;		Modified by Bob Denny for RSX-11M V4 to catch proper CLI
.;		and install proper task names.  Also, there were bugs in the
.;		switch defaulting and when running this file with a YES to
.;		"Have you already build SRDSYS?".  This file is now a merge
.;		(done by hand!!) of Turkelsons 01-Dec-81 file and the one
.;		that I originally did from V6.0 for RSX-11M V4.0.
.;		Finally, the ODL file produced for FCSRES on RSX V4.0 is
.;		set up for the PLAS FCSRES.  Had to add question for V4.0.
.;		Changed BIGMAC/BIGTKB to MAC/TKB for V4.0. Untested on
.;		V3.2!!  Support for help spawn to CLI... for M V4.0 so
.;		will go to proper CLI.  Do not use SRD to purge, else your
.;		possibly valuable V6.0 baseline files may be wiped out.
.;		(Hint: I set protection on em to [R,R,R,R]!)  Removed
.;		listings and maps specs from command lines.  Typical user
.;		just wants SRD to run!
.;
.;	18-May-83	Bob Turkelson
.;		Modified for the switches added in Glen Everhart's Spring
.;		and Fall 1982 versions (now merged into this version).
.;
.;	01-Jun-83	Carl E. Friedberg Seaport Systems Inc., NYC NY 10038
.;		Modified for /MU support under MPLUS; flattened out
.;		Incorporate MPlus supervisor mode library
.;		Add symbol INSSLP if installed here
.;		so we can remove it when finished
.;	19-Jul-83	Bob Turkelson
.;		Fixed incorect label in GOTO (0025); this distribution
.;		has correction files already applied, so skipped over
.;		sections to perform the SLP updates.
.;	21-Oct-83	Bob Turkelson
.;		For systems with extend task directive, remove EXTTSK= TKB
.;		  instruction, since it is not used.
.;		Add another unit number to SRD.BLD.  Previously the directory
.;		  reads and header reads used the same LUN, creating a problem
.;		  for directories which could not be completely read in.
.;		Created symbols for switch values, and global logical symbols
.;		  for switch settings.  The default switch values are calculated
.;		  after all the switch questions have been asked.
.;		Create SRDDEF.HLP describing the switch defaults selected.
.;		  SRD.HLP references this file.
.;		For now, make /-MU the default on IAS and 11D, since the code
.;		  for re-using some of the SRDINI instruction space for
.;		  directory buffers fails otherwise.
.;		Fix up SRD.ODL for IAS, removing some SYSLIB references.
.;		For IAS and 11D, branched around references to <DATE> symbol,
.;		  since it apparently is not in indirect in IAS V3.0.
.;	16-Jan-85	Bob Turkelson
.;		For working group use, check for special parameters passed to
.;		  instruct command file to generate macro regular or cross
.;		  reference listings and/or task builder regular or cross
.;		  reference map.  Create a separate file for the task builder
.;		  command line, SRDCML.BLD, which SRD.BLD references, so that
.;		  a map may be generated without having to know all the switch
.;		  defaults, etc.
.;		For RSX-11M-PLUS, do not ask if the build should be with FCSRES
.;		  if being built with FCSFSL supervisor mode library.  Switch
.;		  order of questions for FCSFSL and M-PLUS V2.0 or higher.
.;		Check for terminal set to DCL on RSX-11M-PLUS as well as on
.;		  RSX-11M.
.;		Add support for P/OS and Micro/RSX, which have named
.;		  directories.  (Changes and ideas provided by Bob Denny,
.;		  R. J. Kirkman, and B. Z. Lederman.)
.;		All sections dealing with SLP updating have been removed, since
.;		  they are no longer being used.
.;	12-Jun-85	Bob Turkelson
.;		For P/OS and Micro/RSX, ask if the build should be with FCSRES,
.;		  and build SRD flat to save overlay disk accesses.
.;		Remove questions asking if we should proceed after the Q/A and
.;		  file generation sections.
.;
.;
.;
.BEGIN:	.DISABLE	LOWERCASE
	.SETT	MAC
	.SETT	TKB
	.SETT	SRD
	.SETF	R$$MV4
	.SETF	M$$CLI
	.SETF	R$$11M
	.SETF	R$$11U
	.SETF	R$$MPL
	.SETF	R$SUPL
	.SETF	R$$MP2
	.SETF	D$$CAL
	.SETF	F$$CS
	.SETF	R$$11D
	.SETF	I$$AS
	.SETT	E$$IS
	.SETF	P$$OS
	.SETF	M$$CRO
	.SETF	E$$XTK
	.SETN	EXTEND	1024.
	.SETS	$C	""
.;
	.SETF	SKIP
	.SETF	LIST
	.SETF	LISTX
	.SETF	MAP
	.SETF	MAPX
	.IF P1 EQ "S"  .OR .IF P2 EQ "S"  .OR .IF P3 EQ "S"  .SETT SKIP
	.IF P1 EQ "L"  .OR .IF P2 EQ "L"  .OR .IF P3 EQ "L"  .SETT LIST
	.IF P1 EQ "LX" .OR .IF P2 EQ "LX" .OR .IF P3 EQ "LX" .SETT LISTX
	.IFT LISTX  .SETT LIST
	.IF P1 EQ "M"  .OR .IF P2 EQ "M"  .OR .IF P3 EQ "M"  .SETT MAP
	.IF P1 EQ "MX" .OR .IF P2 EQ "MX" .OR .IF P3 EQ "MX" .SETT MAPX
	.IFT MAPX  .SETT MAP
.IFT SKIP ; SKIPPING
.IFT LIST ; LISTING
.IFT LISTX ; XREF LISTING
.IFT MAP  ; MAP
.IFT MAPX ; XREF MAP
.;
.;	SWITCH MASK DEFINTIONS
.;
.SETN	NASW	100000		; SORT BY NAME SW
.;.SETN	MISW	40000		; Middle Listing
.;.SETN	PUSW	20000		; PURGE THE FILES SELCTED
.;.SETN	SPSW	10000		; SPOOL FILE
.;.SETN	AESW	4000		; After/on Date Switch
.;.SETN	AFSW	2000		; After Date Switch
.;.SETN	BESW	1000		; Before/on Date Switch
.;.SETN	BFSW	400		; Before Date Switch
.;.SETN	NESW	200		; NEGATE SELECTION DECISION
.;.SETN	SVSW	100		; SELECT VERSION SWITCH
.;.SETN	SDSW	40		; SELECTIVE DELETE
.;.SETN	FUSW	20		; FULL LISTING
.;.SETN	DASW	10		; DATE SELECTION ACTIVE
.;.SETN	SESW	4		; SELECTIVE LISTING SWITCH
.SETN	LISW	2		; LISTING SWITCH
.;.SETN	DESW	1		; DELETE ALWAYS
.;
.;	2ND SWITCH MASK WORD DEFINITIONS
.;
.SETN	M2SW	100000		; 2nd type of Middle-Sized Listing
.;.SETN	HESW	40000		; Help
.SETN	WISW	20000		; Automatic wildcarding
.SETN	WDSW	10000		; Automatic wildcarding on delete
.;.SETN	HVSW	4000		; SELECT HIGHER VERSION
.;.SETN	ZESW	2000		; SELECT FILES WITH ZERO BLOCKS USED
.SETN	ATSW	1000		; Attach output device if terminal
.SETN	SYSW	400		; Include system directories in [*,*]
.;.SETN	WBSW	200		; WRITE BACK SWITCH
.SETN	SRSW	100		; Sort the directory
.SETN	RDSW	40		; Use Revision Date for date checks
.;.SETN	SISW	20		; DISPLAY INTERNAL BUFFER SIZE
.;.SETN	IDSW	10		; LIST SRD VERSION
.;.SETN	COSW	4		; SELECT CONTIGUOUS FILES
.;.SETN	LOSW	2		; SELECT LOCKED FILES
.;.SETN	MUSW	1		; SELECT MULTI-HEADER FILES
.;
.;	3RD SWITCH MASK WORD DEFINITIONS
.;
.SETN	TBSW	100		; Print total blocks
.;.SETN	GTSW	40		; Select files larger or equal to value
.;.SETN	ERSW	20		; Select files with header read errors
.SETN	BKSW	10		; Include 2 blanks ahead of file names
.SETN	HDSW	4		; Include command line in header
.SETN	SMSW	2		; Include summary in listing
.SETN	ZDSW	1		; Include [0,0] in [*,*] searches (/00)
.;
	.ENABLE	SUBSTITUTION
	.ENABLE	ESCAPE
	.SETS	END	".END"
.; We have to do this to stop AT. getting upset
;
;	Question/Answer phase
;
;	To get help hit ESCAPE from any prompt.
;
.0003:	.ASK	P$$OS	Are you using P/OS
	.IFF	<ESCAPE>	.GOTO	0004
;
;	If your system has the P/OS operating system, answer Yes
;
	.GOTO	0003
.; .0004:	.IFT	P$$OS	.GOTO	0007
.0004:	.IFF	P$$OS	.GOTO	0005
;----------------------------------------------------------------------
; Note:  This command file has the following restriction:
;   If you are building SRD for a P/OS system, but are running this
;   command file from RSX-11M or RSX-11M-PLUS, your terminal must be
;   set to DCL.  (If you are in MCR, type Control-Z at the next prompt,
;   enter SET /DCL=TI:, then @SRD .)
;----------------------------------------------------------------------
	.GOTO	0007
.0005:	.ASK	M$$CRO	Are you using Micro/RSX
	.IFF	<ESCAPE>	.GOTO	0006
;
;	If your system has the Micro/RSX operating system, answer Yes
;
	.GOTO	0005
.0006:	.IFF	M$$CRO	.GOTO	0008
.;  For P/OS and Micro/RSX:
.0007:	.SETT	R$$11M
	.SETT	R$$MV4
.;
.; EIS, Dynamic Checkpoint and Extend-Task support assumed
.; No multiple CLI's
.;
	.SETT	E$$IS
	.SETT	E$$XTK
	.SETT	D$$CAL
.;;	.SETF	F$$CS
	.SETF	M$$CLI
	.IFT	P$$OS	.SETS	SY$TEM	"P/OS"
	.IFT	M$$CRO	.SETS	SY$TEM	"Micro/RSX"
	.SETS	OPTNS	"/MM"
	.GOTO	0040
.;      If all required files have been built satisfactorily before,
.;	skip down to the macro assembly section.
.;      We are not able to skip the first section if a map is requested.
	.IFF  MAP  .IFT	 SKIP	.GOTO	0440
.0008:	.IFNINS ...MAC .SETF MAC
	.IFNINS ...TKB .SETF TKB
	.ASK	R$$MPL	Are you using RSX-11M-PLUS
	.IFF	<ESCAPE>	.GOTO	0011
;
;	If you are using any version of the M-Plus
;	Operating System, answer Yes
;
	.GOTO	0008
.0011:	.IFF	R$$MPL	.GOTO	0015
	.ASK	R$$MP2	Is this version 2.0 or higher
	.IFF	<ESCAPE>	.GOTO	0012
;
;       If you are running M Plus Version 2.0 or higher, this sets the
;	format of commands to MCR if you are running under DCL
;
;	If you are running M Plus Version 1.0 answer NO
;
	.GOTO	0011
.0012:
	.ASK	R$SUPL	Do you want to build using the FCSFSL Supervisor Mode Library
	.IFF	<ESCAPE>	.GOTO	0013
;
;	If your M-Plus system has a resident supervisor
;	mode library (FCSFSL) answer Yes
;
	.GOTO	0012
.0013:
	.SETT	E$$IS
	.SETT	E$$XTK
	.SETT	D$$CAL
	.SETT	M$$CLI
	.SETS	OPTNS	"/MM/MU"
	.SETS	SY$TEM	"RSX-11M Plus V 1.0"
	.IFT	R$$MP2	.SETS	SY$TEM	"RSX-11M Plus V2.0"
	.IF <CLI> NE "MCR" .SETS $C "MCR "
	.IFF	R$$MPL	.GOTO	0014
	.IFNINS	TKB	INS	$TKBFSL
	.IFNINS	MAC	INS	$MACFSL
.0014:	.IFNINS	TKB	INS	$TKBRES
	.IFNINS	TKB	INS	$TKB
	.IFNINS	MAC	INS	$MACRES
	.IFNINS	MAC	INS	$MAC
	.GOTO	0040
.0015:	.ASK	SYSTEM	Are you using RSX-11M, MAPPED
	.IFF	<ESCAPE>	.GOTO	0020
;
;	If you are using RSX-11M V3.0 or later, and you
;	are using the MAPPED system, answer yes to this
;	question.
;
	.GOTO	0015
;
.0020:	.IFF	SYSTEM	.GOTO	0100
	.SETT	R$$11M
	.SETS	OPTNS	"/MM"
.0021:	.ASK	R$$MV4	Are you running RSX-11M Version 4.0 or later
	.IFF	<ESCAPE> .GOTO 0022
;
;       If you are running RSX-11M Version 4.0, This sets the
;       format of commands to MCR if you are running under DCL,
;       and determines the overlay description that will be used
;       with FCSRES.  The PLAS overlayed FCSRES is assumed.
;
;	If you are running RSX-11M Version 3.2 or earlier, answer NO
;	to this question.
;
	.GOTO	0021
.0022:	.IFT	R$$MV4	.GOTO 0023
	.SETS	SY$TEM	"RSX-11M V3.2 or earlier, Mapped"
	.IFF MAC INS $BIGMAC
	.IFF TKB INS $BIGTKB
	.GOTO	0025
.0023:
	.IF <CLI> NE "MCR" .SETS $C "MCR "
	.SETS	SY$TEM	"RSX-11M V4.0 Mapped"
	.IFF MAC INS $MAC
	.IFF TKB INS $TKB
.0024:	.ASK	M$$CLI	Do you have DCL or User-written CLI support
	.IFF	<ESCAPE>	.GOTO	0025
;
;	If you have DCL or User-written CLI support in your
;	system, SRD will spawn a command for HELP to the
;	CLI to which the users terminal is currently
;	connected.  If you answer YES to this question, the
;	/HE switch will spawn "HELP SRD" to "CLI..." (terminals
;	current CLI).  If you answer NO to this question, the
;	"HELP SRD" command will be always be spawned to MCR.
;
	.GOTO	0024
.0025:	.ASK	E$$XTK	Do you have the extend task directive
	.IFF	<ESCAPE>	.GOTO	0030
;
;	If your system has the extend-task directive, SRD
;	will take advantage of it, growing and shrinking
;	as required to process directories.  If you want
;	SRD to take advantage of this, answer YES to the
;	following question.
;
	.GOTO	0025
.0030:	.ASK	D$$CAL	Are you using dynamic checkpoint allocation
	.IFF	<ESCAPE>	.GOTO	0040
;
;	If your system is generated with dynamic checkpoint
;	allocation, and you want SRD to take advantage of
;	it, answer yes to the following question.
;
	.GOTO	0030
;
.0040:	.IFT	R$SUPL	.GOTO 0050
	.ASK	F$$CS	Do you want to build SRD using FCSRES
	.IFF	<ESCAPE>	.GOTO	0050
;
;	If you have built FCSRES on your system, it will be
;	used by SRD, thus decreasing the total size of SRD
;	by approximately 3 k-words.  The ODL file produced
;	will be tailored to Version 3.2 or earlier, or to
;	the PLAS overlayed FCSRES that is available from
;	SYSGEN.
;
	.GOTO	0040
;
.0050:	.IFT	R$$MPL	.GOTO	0410
	.IFT	M$$CRO	.GOTO	0410
	.IFT	P$$OS	.GOTO	0410
	.ASK	E$$IS	Does your machine have EIS
	.IFF	<ESCAPE>	.GOTO	0410
;
;	EIS stands for the Extended Instruction Set. This question
;	is asked so that the SOB instruction can be correctly
;	simulated on a non-EIS machine. (E.G. 11-03,11-40, etc)
;
	.GOTO	0050
;
.0100:	.ASK	SYSTEM	Are you using RSX-11M, UNMAPPED
	.IFF	<ESCAPE>	.GOTO	0110
;
;	If you are using RSX-11M UNMAPPED, answer yes
;	to the following question. This merely tells the
;	taskbuilder to build the task with the /-MM switch.
;
	.GOTO	0100
;
.0110:	.IFF	SYSTEM	.GOTO 0200
	.SETT	R$$11U
	.SETS	OPTNS	"/-MM"
	.SETS	SY$TEM	"RSX-11M Unmapped"
	.IFF MAC INS $MAC	!Install small MAC
	.IFF TKB INS $TKB	!Install small TKB
;
.0150:	.ASK	E$$IS	Does your machine have EIS
	.IFF	<ESCAPE>	.GOTO	0410
;
;	EIS stands for the Extended Instruction Set. This question
;	is asked so that the SOB instruction can be correctly
;	simulated on a non-EIS machine. (E.G. 11-03,11-40, etc)
;
	.GOTO	0150
;
.0200:	.ASK	SYSTEM	Are you using RSX-11D
	.IFF	<ESCAPE>	.GOTO	0210
;
;	If you are using RSX-11D V6.2 or before, then answer yes to
;	the following question. Note that this will produce
;	the exact same SRD as for IAS, except that the naming
;	conventions will be different.
;
	.GOTO	0200
;
.0210:	.IFF	SYSTEM  .GOTO 0300
	.SETS	OPTNS	"/-MU"
	.SETT	R$$11D
	.SETS	SY$TEM	"RSX-11D"
	.IFF MAC INS $BIGMAC
	.IFF TKB INS $BIGTKB
	.GOTO	0410
;
.0300:	.ASK	SYSTEM	Are you using IAS
	.IFF	<ESCAPE>	.GOTO	0310
;
;	If you are using any of the three flavors of IAS V3.0 or
;	IAS V2.0, answer yes to the following question. Note that
;	in the task-build command file, that SYSRES is used as the
;	default system library.
;
	.GOTO	0300
;
.0310:	.IFF	SYSTEM  .GOTO BEGIN
	.SETS	OPTNS	"/-MU"
	.SETT	I$$AS
	.SETS	SY$TEM	"IAS"
	.IFF MAC INS $BIGMAC
	.IFF TKB INS $BIGTKB
	.GOTO	0410
;
.0410:
	.IFT  SKIP  .GOTO 0422
	.IFT E$$XTK .GOTO 0420
	.ASKN [1024.:24576.:8192.] EXTEND	Enter task extension
	.IFF	<ESCAPE>	.GOTO	0420
;
;	The task extension defines the buffer area used by SRD to
;	read the directory file into. The task extension must be
;	specified in units of 256. word blocks. A good means of
;	determining the size needed is to look at the [0,0] directory
;	for the largest directory file, and have this extension large
;	enough to handle it. The smallest extension(1024.) will handle
;	directories up to 4. blocks long, where the largest extension
;	(24576.) will handle directories up to 98. blocks long. The
;	default extension will handle directories up to 32. blocks long.
;
	.GOTO 0410
;
.0420:;
;	Creating Switch Defaults
;
	.SETN	SWINI 0
	.SETN	SW2INI 0
	.SETN	SW3INI 0
; The next few questions are for users who are familiar with the available
;   SRD switches.  Some of the switches are presented in groups, allowing you
;   to choose the entire group as a default.  Simply answer N if you do not
;   want the entire group - questions for the individual switches will then be
;   presented later.
;
; Do you want these switch defaults:
	.ASK	X	/LI  /SR  /-WD  /-00
	.IFT	X	.SETT	$LI
	.IFT	X	.SETT	$SR
	.IFT	X	.SETF	$WD
	.IFT	X	.SETF	$00
	.ASK	X	/AT  /M2  /WI       
	.IFT	X	.SETT	$AT
	.IFT	X	.SETT	$M2
	.IFT	X	.SETT	$WI
	.ASK	X	/BK  /HD  /SM       
	.IFT	X	.SETT	$BK
	.IFT	X	.SETT	$HD
	.IFT	X	.SETT	$SM
	.ASK	X	/-NA /-RD           
	.IFT	X	.SETF	$NA
	.IFT	X	.SETF	$RD
;
; In the following section, you will be asked which switches you would
;   like to have as the default.  Help is also available at these
;   prompts by typing the ESCAPE key.  Answer Y for any switch default
;   you would like.
;
;   As a default, would you like switch ...
	.IFDF	$NA	.GOTO	DFLI
.QNA:	.ASK	$NA	/NA - the sort to be in name order
	.IFF	<ESCAPE>	.GOTO	DFLI
;
;	If you answer Y, the default sort order will be
;		Name, Extension, Version
;	If you answer N, the default sort order will be
;		Extension, Name, Version
;
	.GOTO	QNA
.DFLI:	.IFDF	$LI	.GOTO	DFRD
.QLI:	.ASK	$LI	/LI - the directory to be listed by default
	.IFF	<ESCAPE>	.GOTO	DFRD
;
;	If you answer Y to this question, an implicit /LI will
;	be included in every SRD operation.  If you answer no,
;	no files will be listed unless you use an explicit
;	/LI, /FU or /MI.
;
	.GOTO	QLI
.DFRD:	.IFDF	$RD	.GOTO	DFSR
.QRD:	.ASK	$RD	/RD - to use the Revision Date in Date Matches
	.IFF	<ESCAPE>	.GOTO	DFSR
;
;	If you answer Y to this question then, by default, the
;	Revision Date will be included in all matches including
;	a date (/DA, /AF, /AE, /BF, /BE).
;	If you answer N the Creation Date will be used.
;
	.GOTO	QRD
.DFSR:	.IFDF	$SR	.GOTO	DFSY
.QSR:	.ASK	$SR	/SR - the listings sorted by default
	.IFF	<ESCAPE>	.GOTO	DFSY
;
;	If you answer Y to this question any directory listings you
;	request will automatically be sorted (unless you specify /-SR).
;	If you answer N the directory will only be sorted if you specify
;	/SR.
;
	.GOTO	QSR
.DFSY:	.IFDF	$SY	.GOTO	DF00
.QSY:	.ASK	$SY	/SY - System Accounts in [*,*] searches
	.IFF	<ESCAPE>	.GOTO	DF00
;
;	If you answer Y to this question any directory listings in
;	which the group part of the UIC is wild (*) will include
;	System Accounts (those with a group code of 0-10).
;	If you answer N such accounts will be excluded by default.
;
	.GOTO	QSY
.DF00:	.IFDF	$00	.GOTO	DFAT
.Q00:	.ASK	$00	/00 - to include [0,0] in [*,*] searches
	.IFF	<ESCAPE>	.GOTO	DFAT
;
;	If you answer Y to this question any directory listings in
;	which the group part of the UIC is wild (*) will include
;	the Master File Directory ([0,0]).
;	If you answer N the MFD will be excluded by default.
;
	.GOTO	Q00
.DFAT:	.IFDF	$AT	.GOTO	DFWI
.QAT:	.ASK	$AT	/AT - output device attached if terminal
	.IFF	<ESCAPE>	.GOTO	DFWI
;
;	If you answer Y to this question then, by default, the
;	output device, if it is a terminal, will be attached.
;	If you answer N it will not be attached.
;
	.GOTO	QAT
.DFWI:	.IFDF	$WI	.GOTO	DFWD
.QWI:	.ASK	$WI	/WI - implicit wildcarding
	.IFF	<ESCAPE>	.GOTO	DFWD
;
;	If you answer Y to this question then, by default, all
;	file specifications you enter will be treated as if they
;	were terminated by an *.
;	If you answer N to this question then this implicit
;	wildcarding is disabled.
;
	.GOTO	QWI
.DFWD:	.IFDF	$WD	.GOTO	DFM2
.QWD:	.ASK	$WD	/WD - Do you REALLY want implicit wildcarding during delete
	.IFF	<ESCAPE>	.GOTO	DFM2
;
;	If you answer Y to this question then, by default, if /WI
;	is specified, explicitly or implictly, then all
;	file specifications you enter will be treated as if they
;	were terminated by an *. even during a delete operation.
;	If you answer N to this question then this implicit
;	wildcarding during delete is disabled.
;
;	CAUTION: This option is dangerous when defaulted!!
;
	.GOTO	QWD
.DFM2:	.IFDF	$M2	.GOTO	DFHD
.QM2:	.ASK	$M2	/M2 - the Type 2 Middle Size Listing
	.IFF	<ESCAPE>	.GOTO	DFHD
;
;	If you answer Y to this question then, by default, specifying
;	the /MI switch for a Middle Size listing will list out:-
;
;		Filename  Filesize  Creation Date/Time  File ID
;
;	If you answer N to this question it will list out:-
;
;		Filename  Creation Date/Time  Revision Date/Time
;
	.GOTO	QM2
.DFHD:	.IFDF	$HD	.GOTO	DFSM
.QHD:	.ASK	$HD	/HD - the command line to appear in the header
	.IFF	<ESCAPE>	.GOTO	DFSM
;
;	If you answer Y to this question then, by default, the SRD
;	command line will appear in the header following the line
;	showing the UIC.  If you answer no, the command line will
;	not be listed unless you use an explicit /HD.
;
	.GOTO	QHD
.DFSM:	.IFDF	$SM	.GOTO	DFBK
.QSM:	.ASK	$SM	/SM - the summary listing by default
	.IFF	<ESCAPE>	.GOTO	DFBK
;
;	If you answer Y to this question then, by default, a summary
;	line will appear after the files listed for each directory
;	stating the number of files selected and the total number of
;	files in the directory.  If switch /FU, /MI, /DA, /AF, /AE,
;	/BF, or /BE is specified, then an additional summary line
;	will give the number of blocks used and allocated for the
;	files selected.  If you answer N, the summary is omitted
;	unless you use an explicit /SM switch.
;
	.GOTO	QSM
.DFBK:	.IFDF	$BK	.GOTO	INISWI
.QBK:	.ASK	$BK	/BK - two blanks preceding file names listed
	.IFF	<ESCAPE>	.GOTO	INISWI
;
;	If you answer Y to this question then, by default, two blank
;	characters appear on each file listing line ahead of the file
;	name.  Some widely used versions of SRD inserted these two
;	blanks, while others did not.  Some users have programs written
;	to read SRD output listings which expect one of the two formats.
;	If you answer N, no blank characters appear ahead of the file
;	name unless you use an explicit /BK switch.
;
	.GOTO	QBK
.INISWI:
	.IFT	$NA	.SETN	SWINI	SWINI+NASW
	.IFT	$LI	.SETN	SWINI	SWINI+LISW
	.IFT	$RD	.SETN	SW2INI	SW2INI+RDSW
	.IFT	$SR	.SETN	SW2INI	SW2INI+SRSW
	.IFT	$SY	.SETN	SW2INI	SW2INI+SYSW
	.IFT	$00	.SETN	SW3INI	SW3INI+ZDSW
	.IFT	$AT	.SETN	SW2INI	SW2INI+ATSW
	.IFT	$WI	.SETN	SW2INI	SW2INI+WISW
	.IFT	$WD	.SETN	SW2INI	SW2INI+WDSW
	.IFT	$M2	.SETN	SW2INI	SW2INI+M2SW
	.IFT	$HD	.SETN	SW3INI	SW3INI+HDSW
	.IFT	$SM	.SETN	SW3INI	SW3INI+SMSW
	.IFT	$BK	.SETN	SW3INI	SW3INI+BKSW
.;
;
;	Q/A complete
;
;	Creating SRDDEF.HLP
	.DISABLE SUBSTITUTION
	.OPEN SRDDEF.HLP
	.DATA  
	.DATA  The following SRD switch defaults apply on this system:
	.DATA  
.IFT $NA .DATA   /NA - sort by file name first, then by file type
.IFF $NA .DATA  /-NA - sort by file type first, then by file name
.IFT $LI .DATA   /LI - list the selected file names
.IFF $LI .DATA  /-LI - do not list the selected file names
.IFT $RD .DATA   /RD - use revision date in date selection and in /MI/M2 listing
.IFF $RD .DATA  /-RD - use creation date in date selection and in /MI/M2 listing
.IFT $SR .DATA   /SR - sort the file names before listing
.IFF $SR .DATA  /-SR - do not sort the file names before listing
.IFT $SY .DATA   /SY - include system UFD's (group 1-10) in [*,*] and [*,n] searches
.IFF $SY .DATA  /-SY - do not include system UFD's (group 1-10) in [*,*] and [*,n] searches
.IFT $00 .DATA   /00 - include [0,0] in [*,*] searches
.IFF $00 .DATA  /-00 - do not include [0,0] in [*,*] searches
.IFT $AT .DATA   /AT - attach output device if a terminal
.IFF $AT .DATA  /-AT - do not attach terminal
.IFT $WI .DATA   /WI - implicit wildcarding
.IFF $WI .DATA  /-WI - no implicit wildcarding
.IFT $WD .DATA   /WD - implicit wildcarding during delete operations
.IFF $WD .DATA  /-WD - no implicit wildcarding during delete operations
.IFT $M2 .DATA   /M2 - use type 2 middle directory listing when /MI specified
.IFF $M2 .DATA  /-M2 - use type 1 middle directory listing when /MI specified
.IFT $HD .DATA   /HD - display command line in the heading
.IFF $HD .DATA  /-HD - do not display command line in the heading
.IFT $SM .DATA   /SM - include summary lines following the file listing
.IFF $SM .DATA  /-SM - do not include summary lines following the file listing
.IFT $BK .DATA   /BK - precede each file name with two blank characters
.IFF $BK .DATA  /-BK - do not precede each file name with two blank characters
	.CLOSE
	.ENABLE SUBSTITUTION
;	Creating SRDCML.BLD
	.OPEN	SRDCML.BLD
.SETS  MSPEC  ""
.IFT  MAP  .SETS  MSPEC  ",SRD/-SP"
.IFT  MAPX .SETS  MSPEC  ",SRD/-SP/CR"
	.ENABLE DATA
;
;	SRDCML.BLD - Task build command line referenced by SRD.BLD
;
SRD'OPTNS'/-FP/CP'MSPEC'=SRD/MP
;
.DISABLE DATA
	.CLOSE
	.IFT	SKIP  .GOTO  0440
;	Creating SRD.BLD
	.OPEN	SRD.BLD
	.ENABLE	DATA
;
;	SRD.BLD - Task Build file for an 'SY$TEM' system
.DISABLE DATA
.IFT I$$AS  .OR .IFT R$$11D .GOTO 0500
.IFT R$$MP2 .OR .IFT R$$MV4 .DATA ;	Built by SRD.CMD on '<DATE>' at '<TIME>'
.0500:
.ENABLE DATA
;
@SRDCML.BLD
;
TSKV	=SSTVC$:7
STACK	=128
.DISABLE DATA
.IFT R$SUPL .DATA SUPLIB=FCSFSL:SV
.ENABLE DATA
ASG	=TI:1
ASG	=SY:2:3:4
ASG	=TI:5
UNITS	=5
GBLDEF	=..RWLG:1
GBLDEF	=SWINI:'SWINI'
;	SWINI defines the initial switch settings of the first mask:-
;	       2 = /LI - List the directory
;	  100000 = /NA - Sort by Name first
GBLDEF	=SW2INI:'SW2INI'
;	SW2INI defines the initial switch settings of the second mask:-
;	      40 = /RD - Use Revision Date for date checks
;	     100 = /SR - Sort the directory
;	     400 = /SY - Include system accounts in [*,*]
;	    1000 = /AT - Attach output device if terminal
;	   10000 = /WD - Implicit wildcarding in delete
;	   20000 = /WI - Implicit wildcarding in listing
;	  100000 = /M2 - Type 2 Middle Size Listing
GBLDEF	=SW3INI:'SW3INI'
;	SW3INI defines the initial switch settings of the third mask:
;	       1 = /00 - Include [0,0] in [*,*]
;	       2 = /SM - Include summary lines in listing
;	       4 = /HD - Include command line in listing
;	      10 = /BK - Put in 2 blanks ahead of file names
;
.DISABLE	DATA
	.IFT	I$$AS .OR  .IFT R$$11D .DATA LIBR	=SYSRES:RO
	.IFT	I$$AS	.DATA TASK	=$$$SRD
	.IFT	R$$11D	.DATA TASK=...SRD
	.IFT	R$$11M	.IFF	P$$OS	.IFF	M$$CRO	.DATA TASK=...SRD
	.IFT	R$$MPL	.IFF	P$$OS	.IFF	M$$CRO	.DATA TASK=...SRD
	.IFT	F$$CS	.DATA LIBR	=FCSRES:RO
	.IFF	E$$XTK	.DATA EXTTSK	='EXTEND'
.ENABLE	DATA
/
.DISABLE	DATA
.CLOSE
;	Creating SRD.ODL
	.OPEN	SRD.ODL
	.IFT M$$CRO .GOTO 0900
	.IFT P$$OS  .GOTO 0900
	.IFT R$$MPL .GOTO 0900
	.IFT R$$MV4 .AND .IFT F$$CS .GOTO 1000
	.ENABLE	DATA
;
;		SRD.ODL
;
;	** SRD OVERLAY DESCRIPTION **
;	For an 'SY$TEM' system.
;
; UPDATED	01-DEC-81	(Turkelson)
;		21-OCT-83	(Turkelson)
;
;
	.NAME	OV1INI
	.NAME	OPNFNB
	.NAME	CSI12
	.ROOT	SRDR-*(O1,O2A,O2B,O2C,O4,O5)
SRDR:	.FCTR	SRDROT-SRDATA-SRDSUB-SRDTRP-LIBR
.DISABLE DATA
	.IFT	F$$CS	.GOTO 0540
	.IFT	I$$AS	.GOTO 0560
	.ENABLE DATA
LIBR:	.FCTR	LB:[1,1]SYSLIB/LB:ASSLUN:ARITH:CBTA:DIRECT:DEL:EOFCHK-LIBR2
LIBR2:	.FCTR	LB:[1,1]SYSLIB/LB:MKDL:MOVREC:PGCS:RDWAIT:RETADR:WATSET
.DISABLE DATA
	.GOTO	0580
.0560:
	.ENABLE DATA
LIBR:	.FCTR	LB:[1,1]SYSLIB/LB:ARITH:CBTA:PGCS
.DISABLE DATA
	.GOTO	0580
.0540:	.ENABLE	DATA
LIBR:	.FCTR	LB:[1,1]SYSLIB/LB:CBTA:EOFCHK-LIBR2
LIBR2:	.FCTR	LB:[1,1]SYSLIB/LB:MOVREC:PGCS:RDWAIT:RETADR:WATSET
.DISABLE DATA
.0580:	.ENABLE DATA
O1:	.FCTR	SRDINI-SRDREP-*(O11)
O2A:	.FCTR	SRDNUD
O2B:	.FCTR	SRDOPR-SRDXX1
O2C:	.FCTR	SRDSRT-SRDXX2
O5:	.FCTR	SRDDBF
.DISABLE	DATA
	.IFF	R$$11D .AND .IFF I$$AS .GOTO 0600
	.ENABLE	DATA
O4:	.FCTR	SRDLST-SRDTST-SRDXX3
O11:	.FCTR	OV1INI-*(OP1,CSI1)
OP1:	.FCTR	OPNFNB-LB:[1,1]SYSLIB/LB:PRINT
.DISABLE	DATA
	.GOTO	0700
.0600:	.IFT	F$$CS	.GOTO 0640
	.ENABLE	DATA
O4:	.FCTR	SRDLST-SRDTST-LB:[1,1]SYSLIB/LB:PUTSQ-SRDXX3
O11:	.FCTR	OV1INI-*(OP1,PRS1,CSI1)
OP1:	.FCTR	OPNFNB-LB:[1,1]SYSLIB/LB:OPFNB:$PRINT
	.NAME	PRSFNB
PRS1:	.FCTR	PRSFNB-LB:[1,1]SYSLIB/LB:PARSE
.DISABLE	DATA
	.GOTO	0700
.0640:	.ENABLE	DATA
O4:	.FCTR	SRDLST-SRDTST-SRDXX3
O11:	.FCTR	OV1INI-CSI1
.DISABLE DATA
.0700:	.ENABLE	DATA
CSI1:	.FCTR	CSI12-LB:[1,1]SYSLIB/LB:.CSI1:.CSI2
	'END'
.DISABLE	DATA
.GOTO 1010
.0900:
.MPLODL:
	.ENABLE	DATA
;	Carl E. Friedberg 1-June-1983
; this is flattened out version for /MU
;
;	SRD.ODL - Overlay descr. file for an RSX-11M-PLUS system
;
	.ROOT	SRDROT-SRDATA-SRDSUB-SRDTRP-SRDINI-SRDREP-SRDNUD-F1
F1:	.FCTR	SRDOPR-SRDXX1-SRDSRT-SRDXX2-SRDDBF-SRDLST-SRDTST-SRDXX3
	'END'
.DISABLE	DATA
.GOTO	1010
.1000:
.ENABLE DATA
;
;		SRD.ODL
;
;	** SRD OVERLAY DESCRIPTION **
;	For an 'SY$TEM' system.
;
;	Built by SRD.CMD on '<DATE>' at '<TIME>'
;
	.ROOT	SRDR-*(O1,O2A,O2B,O2C,O4,O5)
SRDR:	.FCTR	SRDROT-SRDATA-SRDSUB-SRDTRP
O1:	.FCTR	SRDINI-SRDREP
O2A:	.FCTR	SRDNUD
O2B:	.FCTR	SRDOPR-SRDXX1
O2C:	.FCTR	SRDSRT-SRDXX2
O4:	.FCTR	SRDLST-SRDTST-SRDXX3
O5:	.FCTR	SRDDBF
	'END'
.DISABLE DATA
.1010:	.CLOSE
;	Creating SRDSYS.MAC
	.OPEN	SRDSYS.MAC
	.ENABLE	DATA
;
;	Version 6.6 of SRD
;
	.NLIST
;
; SRD PRE-PREFIX FILE
;
;	UPDATED: 1-DEC-76
;
;	UPDATED: 08-MAR-79
;
;	UPDATED: 05-AUG-79
;
;	UPDATED: 19-NOV-79	H.R.TUMBLIN, DUMC
;
;	UPDATED: 28-Nov-80	Phil Stephensen-Payne, SYSTIME
;
;	UPDATED: 13-JUL-82	Bob Denny, Creative System Design Co.
;
;	UPDATED: 01-June-83	Carl E. Friedberg Seaport Systems Inc.
;
;	UPDATED: 16-Jan-85	SRD Working Group
;
.DISABLE DATA
.IFT I$$AS  .OR .IFT R$$11D .GOTO 0501
.IFT R$$MV4 .OR	.IFT R$$MP2 .DATA ;	Built by SRD.CMD on '<DATE>' at '<TIME>'
.0501:
.ENABLE DATA
;
; CONDITIONALS DEPENDING ON THE SYSTEM FOR WHICH THIS IS
; BEING ASSEMBLED...
;
.DISABLE	DATA
	.IFT	P$$OS	.DATA P$$OS	=1 ;Define this symbol for P/OS
	.IFT	M$$CRO	.DATA M$$CRO	=1 ;Define this symbol for Micro/RSX
	.IFT	R$$11M	.DATA R$$11M	=1 ;DEFINE THIS SYMBOL FOR RSX-11M
	.IFT	R$$MPL	.DATA R$$11M	=1 ;DEFINE FOR RSX-11M OR RSX-11M-PLUS
	.IFT	R$$MPL	.DATA R$$MPL	=1 ;DEFINE FOR RSX-11M-PLUS
	.IFT	R$$MV4	.DATA R$$MV4	=1 ;Define this for RSX-11M V4 or later
	.IFT	E$$IS	.DATA E$$IS	=1 ;DEFINE THIS FOR EIS SYSTEMS
	.IFT	R$$11D	.DATA I$$AS	=1 ;DEFINE THIS SYMBOL FOR RSX-11D
	.IFT	I$$AS	.DATA I$$AS	=1 ;DEFINE THIS SYMBOL FOR IAS
	.IFT	D$$CAL	.DATA D$$CAL	=1 ;DEFINE THIS SYMBOL (AND R$$11M) FOR
	.IFT	D$$CAL	.DATA 		   ; DYNAMIC CHECKPOINTING
	.IFT	M$$CLI	.DATA M$$CLI	=1 ;SPAWN TO CLI... FOR RSX-11M W/CLI
	.IFT	P$$OS	.DATA N$$DIR	=1 ;Define for named directory support
	.IFT	M$$CRO	.DATA N$$DIR	=1 ;Define for named directory support
	.CLOSE
.0440:
;
;	Assemble the source modules
;
.ASK ALL Do you want to assemble all the modules
.IFT ALL .GOTO 0460
.0450:
.ASKS MOD Which module do you want to assemble?
.IFF <ESCAPE> .GOTO 0455
;
;	Possible choices are:
; SRDATA SRDDBF SRDINI SRDLST SRDNUD SRDOPR SRDREP SRDROT
; SRDSRT SRDSUB SRDTRP SRDTST SRDXX1 SRDXX2 SRDXX3
;	Give the 6 character file name for each module
;	you wish to assemble, one at a time. When you have
;	assembled all the modules you wanted, just enter
;	<RETURN> (i.e., a carriage return)
.GOTO 0450
.0455:
.IF MOD = "" .GOTO 0470
.GOSUB MAC
.GOTO 0450
.0460: .SETS MOD "SRDATA"
.GOSUB MAC
.SETS MOD "SRDINI"
.GOSUB MAC
.SETS MOD "SRDLST"
.GOSUB MAC
.SETS MOD "SRDNUD"
.GOSUB MAC
.SETS MOD "SRDOPR"
.GOSUB MAC
.SETS MOD "SRDROT"
.GOSUB MAC
.SETS MOD "SRDSRT"
.GOSUB MAC
.SETS MOD "SRDSUB"
.GOSUB MAC
.SETS MOD "SRDTST"
.GOSUB MAC
.SETS MOD "SRDTRP"
.GOSUB MAC
.SETS MOD "SRDREP"
.GOSUB MAC
.SETS MOD "SRDDBF"
.GOSUB MAC
.SETS MOD "SRDXX1"
.GOSUB MAC
.SETS MOD "SRDXX2"
.GOSUB MAC
.SETS MOD "SRDXX3"
.GOSUB MAC
.GOTO 0470
.MAC:	.SETS  LSPEC  ""
.IFT	P$$OS	.GOTO	DCLMAC
.IFT LIST  .SETS  LSPEC  ",'MOD'/-SP"
.IFT LISTX .SETS  LSPEC  ",'MOD'/-SP/CR"
.IF MOD = "SRDATA"  '$C'MAC SRDATA'LSPEC'=SRDSYS,SRDPRE,SRDATA
.IF MOD <> "SRDATA" '$C'MAC 'MOD''LSPEC'=SRDSYS/PA:1,SRDPRE/PA:1,'MOD'
.RETURN
.DCLMAC:
.IFT LIST  .SETS  LSPEC  "/LIS:'MOD'"
.IFT LISTX .SETS  LSPEC  "/LIS:'MOD'"
.IF MOD = "SRDATA"  MAC/OBJ:SRDATA'LSPEC' SRDSYS+SRDPRE+SRDATA
.IF MOD <> "SRDATA" MAC/OBJ:'MOD''LSPEC'  SRDSYS/PASS:1+SRDPRE/PASS:1+'MOD'
.RETURN
.0470:;
;	Now taskbuild SRD
;
.IFF	P$$OS	'$C'TKB @SRD.BLD
.IFT	P$$OS	LINK @SRD.BLD
;
;	SRD Build complete
;
.END:
	.IFF P$$OS .IFF MAC REM MAC
	.IFF P$$OS .IFF TKB REM TKB
.THEEND:
