c Useful statement functions:
c	1) type checking of single character
c	2) quick binary to 2-digit bcd conversion, and vice versa
c	3) Check for leap-year (Gregorian)
c	4) Hashdate for DTC appointment matching
c
	logical numeric, chnumeric,		! Character type checking
	1	lcalpha, alpha,
	2	islpyr				! value check
	byte ch					! Single argument
	character*1 chch
	integer*2 icvtbcd, ich2			! Conversion routines
	integer icvtbin, icvtbn1, inum, ihymd,	! Compilation default
	1  izyr, izmo, izdy			! ..
c
	numeric(ch) = (ch .GE. '0') .AND. (ch .LE. '9')
	chnumeric(chch) = (chch .GE. '0') .AND. (chch .LE. '9')
	lcalpha(ch) = (ch .GE. 'a') .AND. (ch .LE. 'z')
	alpha(ch) = ((ch .AND. '5f'x) .GE. 'A')
	1     .AND. ((ch .AND. '5f'x) .LE. 'Z')
c
	icvtbcd(inum) = ((MOD(inum, 10) * 256) .OR. inum/10) .OR. '00'
	icvtbin(ich2) = ((ich2 .AND. '000F'X) * 10)
	1	      + ((ich2 .AND. '0F00'X)/256) ! Works w/space as first char
	icvtbn1(ch) = ch .AND. '0F'X		! Convert single character
c
	islpyr(izyr) = (mod(izyr, 400) .EQ. 0) .OR.
	1 ((izyr .AND. 3) .EQ. 0) .AND. (mod(izyr, 100) .NE. 0)
c
	ihymd(izyr, izmo, izdy) = (((izyr * 16) + izmo) * 32) + izdy
c
c End statement functions
