/*
BEGIN DOCUMENTATION

Name: TCMPDELTXT.C 				Created: 05/11/84  DTS
					    Last Update: 05/15/84
Title: TCM TXTDEL PL/I User Interface

Index: text editor, editor, TCM, TXTDEL

Abstract: Invokes separate TCM task to delete textual data from a tcm
	  text window.

Usage: See "TCM.DOC" for PL/I usage

Parameters: See "TCM.DOC"

Environment: RSX11M V4.0 & RSX11M PLUS V2.1, DECUS C Compiler,
	     AIS PL/I Compiler, MMR PL/I Interface

See Also: TCM.C, TCMPLI.C

Description: This is the user entry for the text collection management (TCM)
	     function TXTDEL.  This function deletes text from a given
	     location within a text window.  The text delete function is
	     actually executed by a separate slave task.  All data passes
	     between the caller (this program) and the slave through a common
	     set of task to task communication routines. 

Example(s):

Uses:

Internal:

Update History:

END DOCUMENTATION
*/



#include <clang.c>
#include <stdio.h>
#include <cx.h>
#include <signal.c>
#include <plistring.c>
#include "tcmdefs.h"
#include "tcmerr.h"
#include "tcmedopt.h"

#define TILUN 5			/* PL/I terminal lun for attach */
#define plinull -1		/* Null PL/I pointer */

/* External Routines */

extern charpointer plistr();
extern plient();
extern int tsndcmd();		/* Send srbuf & command to slave task */
extern tcm_status();		/* Return current status of edit task */
extern tcmdet();		/* Detach terminal */
extern tcmatt();		/* Attach terminal */

/* external globals */

extern struct rad50 tcmslv;	/* External task name */
extern struct cmdbuff srbuf;	/* Send buffer for commands */
extern int tcmdsw;		/* DSW of last directive */
extern struct retbuf ret;	/* Parameters returned from slave task */

/* TXTDEL: (INPUT: w_name,start_pos,end_pos; OUTPUT: start_pos,rc);

Send command to delete text from a TCM window on screen

Program Logic for TXTDEL:

	IF tcm_status() != TS_SUC
	    exit with rc = tcm_status;
	ELSE
	    srbuf.name := w_name;
	    srbuf.row := start_pos.line;
	    srbuf.col := start_pos.column;
	    srbuf.height := end_pos.line;
	    srbuf.width := end_pos.column;
	    Send (cmd := 'T')
	    Receive status (rc)
	    set c_pos from returned position
	ENDIF
*/

txtdel(narg,w_name,start_pos,end_pos,rc)
    int narg;
    plistring w_name;
    struct plicursor **start_pos;
    struct plicursor **end_pos;
    pointer rc;
{
    register struct pliwdef *win_def;

	plient("TXTDEL");
	iff narg != 4 then
	    signal(NUMARGS);
	iff (*rc = tcm_status()) == TS_SUC then
	{
	    setname(w_name);			/* Put window name to srbuf */
	    srbuf.row = (*start_pos)->line;	/* C_POS pointers to srbuf */
	    srbuf.col = (*start_pos)->column;
	    srbuf.height = (*end_pos)->line;
	    srbuf.width = (*end_pos)->column;
	    tcmdet(TILUN);			/* Detach terminal */
	    iff (tcmdsw = tsndcmd('K')) == IS_SUC then
	    {
		recv_status(rc);
		(*start_pos)->line = ret.bline;
		(*start_pos)->column = ret.bcol;
	    }
	    else
		*rc = TE_SRV;
	    tcmatt(TILUN);			/* Attach terminal */
	}
} /* end txtdel */
