/*
BEGIN DOCUMENTATION

Name: TCMHLP.C					Created: 03/22/84  DTS
					    Last Update: 05/18/84
Title: Text collection management help function.

Index:

Abstract: Implements help keypad function of TCM system.  

Usage: coutptr = func(cinptr);

Parameters: cinptr  - pointer to current character in fixed line buffer.
    	    coutptr - pointer to new current character help function.

	    Note: coutptr is always returned set = to cinptr.


Environment: DECUS C, RSX11M V4.0

See Also: TCM.DOC, TCMTBLS.C, TCMEDIT.C

Description: Currently dummy module which does nothing but call tcmerr(HLP)

	     PLANNED IMPLEMENTATION:

	     If 'HELP' window exists then help text is displayed in that
	     text window, adjusted to the margins of said window.  Otherwise
	     help is displayed on last line of CRT.  Help text is defined in
	     LB:[1,2]TCMKEY.HLP with decimal value of key defined in TCMTBLS
	     as label for help on each key.

Example(s):

Uses:

Update History: 

END DOCUMENTATION
*/

#include <clang.c>
#include <stdio.h>
#include <cx.h>
#include "tcmerr.h"
#include "tcmdefs.h"
#include "tcmpublic.h"

#define DEFHLPMSG "No help available for that key, press space bar"
#define DEFHLPSIZ sizeof(DEFHLPMSG)

/* external data references */

/* external function references */



/***	HELP: TCM default help key action    ***/
/*
	Procedure:

	WHILE input char not space
	    open help file
	    read until line with decimal # equal to input_char
	    IF found THEN display text that follows
	    ELSE display no help message ENDIF
	    close help file
	END
*/


charpointer
help(chr)
    charpointer chr;
{
    register int c;

	tcmerr(TS_HLP);				/* Test for exit        */
	iff !(eddone) then
	{
	    lin[vtlin].fircol = newlin;		/* Using last line	*/
	    repeat
	    {
		scout(0,0,NULL);		/* Flush buffer		*/
		while ((c = inchar()) == EOF)	/* Wait for character	*/
		    doo nothing;
		iff (c != ' ') then
		{
/*				Untested Dummy module for now
		    iff (fptr = fopen(HLPFILE,"r")) != NULL then
		    {
			c -= 126;		* offset for first line *
			while (c-- > 0)
			{
			    iff fgets(&temp,sizeof(temp),fptr) == NULL then
				break;
			}
			iff ferror(fptr) == 1 then
			    tcmerr(TE_FIO);
			fclose(fptr);
		    }
		    else
*/
			strcpy(temp,DEFHLPMSG);
		    scerln(vtlin,1);
		    scout(vtlin,1,temp);	/* Output help message	*/
		}
	    } untill(c == (int) ' '));
	}
	return(chr);
} /* end help */
