/*
BEGIN DOCUMENTATION

Name: TCMERROR.C 				Created: 07/20/83  DTS
					    Last Update: 04/13/84
Title: Text collection management error subroutine.

Index:

Abstract: Outputs editing errors and terminates edit session
	  if error is considered fatal.

Usage:

Parameters: INPUTS:
	    int	ercode	- TCM error code generated by editing error.
	    int errlvl	- Global parameter to determine whether to
			  take default action or return control.
	    int vtlin   - Used as line number for message displays.
	    int vttype  - Terminal type to determine inverse attributes
	    int curline,curcol - Cursor address to restore to after message.
	    charpointer - various strings from TCMMSG.C
	    OUTPUTS:
	    boolean eddone - Global parm set to true if errlvl indicates
	    		     control is to be returned to caller.
	    string temp	- Global scratchpad area used to format text.
	    ret.cd	- Global return code set to ercode value.

Environment: DECUS C, RSX11M V4.0

See Also: TCM.C, TCMMSG.C, TCMEDIT.C, TCM.DOC

Description: 

Example(s):

Uses:

Internal:

Update History:

END DOCUMENTATION
*/

#include <clang.c>
#include <stdio.h>
#include <cx.h>
#include "tcmdefs.h"
#include "tcmerr.h"
#include "tcmpublic.h"




/***	TCMERR: Central error routine    ***/

tcmerr(ercode)
    int ercode;
{
    charpointer errstng;

	ret.cd = ercode;
	temp[0] = BELL;		/* Default is beep */
	temp[1] = eos;
	switch(ercode)
	{
	case TS_APE:
	    errstng = eradvc;
	    break;
	case TS_BPS:
	    errstng = erbkup;
	    break;
	case TS_BFI:
	case TS_MCI:
	case TS_MCP:
	    errstng = erbful;
	    break;
	case TS_HLP:
	    errstng = hlpmsg;
	    temp[0] = ' ';	/* No beep */
	    break;
	case TS_IKY:
	    temp[0] = eos;	/* No beep, fall through */
	case TS_ENT:
	    errstng = erinky;
	    break;
	case TS_WTL:
	    errstng = erwdlen;
	    break;
	default:
	    errstng = "";
	    break;
	}
	iff ercode < (10 * (errlvl+1)) then
	    { eddone = true; return; }
	else iff ercode != TS_UKY then
	{
	    scerln(vtlin,1);			/* Output message to vtlin */
	    iff vttype == VT100 then
		strcpy(&temp[1],BOLDON);	/* Bold face characters */
	    scout(vtlin,1,temp);
	    scout(vtlin,1,errstng);
	    iff vttype == VT100 then
	    {
		strcpy(temp,ENHOFF);
		scout(vtlin,1,temp);		/* Normal characters */
	    }
	    scout(curline,curcol,NULL);
	    lin[vtlin].fircol = tempmsg;	/* Keep on screen until keystroke */
	}
} /* end tcmerr */
