.; [2,24]BACKUPSYS.CMD			R RHODERICK		APRIL 1984
.;
.; Automatic complete duplication of LB0: (system pack) to logical LB1:
.;
.; 1) This procedure must find the file [2,24]INITDATE.DAT on the current
.;    SYSTEM pack, in order to assure that if several packs are rotated as
.;    the SYSTEM pack, the one being copied from is more recent than the
.;    pack to be erased and copied to (eg, pack 'A' online as the current
.;    SYSTEM pack, pack 'B' spun up offline for nightly incremental backup,
.;    pack 'C', the previous SYSTEM pack, safely stored somewhere).  The
.;    [2,24]INITDATE.DAT file format is:
.;      First record:	Pack initialized as a SYSTEM pack :
.;      Second record:	dd-yyy-yy
.;    where 'dd-mmm-yy' is the date the pack was created.  When this
.;    procedure completes, it will put a new [2,24]INITDATE.DAT file on the
.;    new SYSTEM pack it has created.
.; 2) The system command file executed when the system is booted
.;    ( LB0:[1,2]STARTUP.CMD ) should be modified to include the following
.;    two commands:
.;    after the system is time'd:
.;		.; if this is a reboot after weekly disk backup, then we
.;		.; need to initialize this new week's nightly backup pack
.;		.TESTFILE LB:[1,2]STARTUP.CMD
.;		.PARSE <FILSPC> ";" FIL EXT
.;		.IF EXT EQ "77777" @LB:[1,2]INITNB0.CMD
.;		.;
.;    just before the ending 'BYE' command:
.;		PIP LB:[1,2]STARTUP.CMD;77777/DE/NM

.ENABLE SUBSTITUTION
.GETIME:
.ASKS TIM Please enter time and date (HH:MM DD-MMM-YY)
.; Check that user entered both time and date
.IF TIM EQ "" .GOTO GETIME
.TEST TIM "-"
.IF <STRLEN> EQ 0 .GOTO TIMERR
.TEST TIM ":"
.IF <STRLEN> EQ 0 .GOTO TIMERR
.ENABLE QUIET
TIM 'TIM'
.DISABLE QUIET
.IF <EXSTAT> EQ 1 .GOTO DONTIM
.TIMERR:
;
; Enter time and date as HH:MM DD-MMM-YY  eg.,
;  if the time is 5:23 pm on March 21, 1983, enter   17:23 21-MAR-83
;
.GOTO GETIME
.;
.DONTIM:
.;
.ENABLE DECIMAL
.;
; Logical LB1: should be assigned to the disk drive to copy the system to,
; and nothing should be running on the current system.  Logins will be
; DISABLED when this is run, to avoid ANY disk activity.
.ASK ANS Do you want to continue
.IFF ANS .EXIT
.;
.TESTDEVICE LB1:
.TEST <EXSTRI> "ONL"
.IF <STRLEN> GT 0 .GOTO GOTLB1
;
; ERROR - unable to identify device LB1:.  Please be sure you have
;	  assigned logical LB1: to an existing disk drive (eg,
;	   ASN DR3:=LB1:/GBL ), and rerun this procedure.
;
.EXIT
.;
.GOTLB1:
.PARSE <EXSTRI> "," LB1DEV REST
.TESTDEVICE LB0:
.PARSE <EXSTRI> "," LB0DEV REST
.IF LB0DEV NE LB1DEV .GOTO LB1OK
;
; ERROR - Assignment of LB1: is to the SYSTEM pack.  Please assign
;	  LB1: to a different drive, then rerun this procedure.
;
.EXIT
.;
.LB1OK:
.SETS MCR ""
.IF <CLI> NE "MCR" .SETS MCR "MCR"
.ENABLE QUIET
'MCR' SET /NOLOGON
.DISABLE QUIET
.;
.OPEN LB0:[1,2]NOLOGIN.TXT
.ENABLE DATA
The system is currently down for disk backup - try again in 10 or 15 minutes.
.DISABLE DATA
.CLOSE
;
.SETS DAYS " 01 02 03 04 05 06 07 08 09 10 11 12 13 14 15 16 17 18 19 20 21 22 23 24 25 26 27 28 29 30 31"
.SETS MONTHS "JANFEBMARAPRMAYJUNJULAUGSEPOCTNOVDEC"
.SETS YEARS "84858687888990919293949596979899"
.TESTFILE LB0:[2,24]INITDATE.DAT
.IF <FILERR> EQ 1 .GOTO CHK0
;
;	ERROR - Pack initialization date file ([2,24]INITDATE.DAT)
;		not found on LB0:.  Cannot proceed with backup procedure.
;
.EXIT
.CHK0:
.; get pack initialization date for the running system pack on LB0:
.OPENR LB0:[2,24]INITDATE.DAT
.READ INIDAT
.READ INIDAT
.CLOSE
.; compute Julian initialization date
.TEST DAYS INIDAT[1:2]
.SETN JULDA0 (<STRLEN>+1)/3
.TEST MONTHS INIDAT[4:6]
.SETN JULDA0 JULDA0+(((<STRLEN>+2)/3)*31)
.TEST YEARS INIDAT[8:9]
.SETN JULDA0 JULDA0+(((<STRLEN>+1)/2)*366)+83
.ENABLE QUIET
MOU LB1:/OVR
.DISABLE QUIET
.IF <EXSTAT> NE 1 .GOTO BADMOU
.TESTFILE LB1:[2,24]INITDATE.DAT
.IF <FILERR> EQ 1 .GOTO CHK1
.ENABLE QUIET
DMO LB1:
.DISABLE QUIET
;
;	WARNING - Pack initialization date file ([2,24]INITDATE.DAT)
;		not found on LB1:.  This file is expected if the LB1:
;		pack has previously been used as a SYSTEM pack.  If
;		the LB1: pack has not previously been used as a
;		SYSTEM pack, it may be erased and initialized as a
;		new SYSTEM pack by this procedure.
;
.ASK ANS		Continue with the current LB1: pack
.IFT ANS .GOTO BAKUP
.EXIT
.CHK1:
.; get pack initialization date for the backup pack on LB1:
.OPENR LB1:[2,24]INITDATE.DAT
.READ INIDAT
.; if pack on LB1: is/was a BACKUP pack (ie, not a SYSTEM pack), we can reuse it
.SETF BKPACK
.TEST INIDAT "BACKUP"
.IF <STRLEN> GT 0 .SETT BKPACK
.READ INIDAT
.CLOSE
.ENABLE QUIET
DMO LB1:
.DISABLE QUIET
.IFT BKPACK .GOTO BAKUP
.; isn't a backup pack - compute Julian initialization date
.TEST DAYS INIDAT[1:2]
.SETN JULDA1 (<STRLEN>+1)/3
.TEST MONTHS INIDAT[4:6]
.SETN JULDA1 JULDA1+(((<STRLEN>+2)/3)*31)
.TEST YEARS INIDAT[8:9]
.SETN JULDA1 JULDA1+(((<STRLEN>+1)/2)*366)+83
.; check that running system pack on LB0: is more recent than pack on LB1:
.IF JULDA0 GT JULDA1 .GOTO BAKUP
;
;	ERROR - LB1: pack is more recent than LB0: pack ...
;		Please boot the most recent running SYSTEM pack, and
;		 assign logical LB1: to the old SYSTEM pack to be erased
;		 and rewritten.
;
.EXIT
.BADMOU:
;
;	ERROR - Could not logically mount LB1:
;		If the LB1: pack is a previously unused pack
;		 (no previous RSX11M file structure), then pack
;		 initialization date checking can be skipped.
.ASK ANS		Is the LB1: pack a previously unused pack
;
.IFF ANS .EXIT
.BAKUP:
.DISABLE QUIET
; Checking pack on 'LB1DEV' for bad blocks
.ENABLE QUIET
ALL LB1:
BAD LB1:/LI
.OPEN LB0:[1,4]BRUSYS.CMD
.DATA /MOUNTED/INITIALIZE/VERIFY/EXCLUDE
.DATA LB0:[1,2]NOLOGIN.TXT,[1,3],[1,4]BRUSYS.CMD
.DATA LB1:
.CLOSE
.DISABLE QUIET
;
;                Starting backup of 'LB0DEV' to 'LB1DEV' at '<TIME>'
;
.; Duplicate current system disk
.ENABLE QUIET
BRU @LB0:[1,4]BRUSYS
.; Make sure the backup worked
.IF <EXSTAT> GT 1 .EXIT
.;
MOU LB1:/OVR
UFD LB1:[1,3]
.; Reflect the latest backup date/time for the nightly backup job
.TESTFILE LB1:[2,24]AUTOBCKUP.DAT
.IF <FILERR> EQ 1 .GOTO OPN1$
.DISABLE QUIET
; WARNING - LB1:[2,24]AUTOBCKUP.DAT not found
.OPN1$:
.OPEN LB1:[2,24]AUTOBCKUP.DAT
.DATA LAST AUTOMATIC BACKUP
.DATA '<DATE>' '<TIME>'
.CLOSE
.;
.; Reflect the new pack's initialization date
PIP LB1:[2,24]INITDATE.DAT;*/DE/NM
.OPEN LB1:[2,24]INITDATE.DAT
.DATA Pack initialized as a SYSTEM pack :
.DATA '<DATE>'
.CLOSE
.;
.; Make a version ;77777 copy of the current startup command file
.TESTFILE LB1:[1,2]STARTUP.CMD
PIP LB1:[1,2]STARTUP.CMD;77777='<FILSPC>'
.;
DMO LB1:
.;
.DISABLE QUIET
;
; The current system pack is now the ARCHIVE pack, and the pack just created
;  is now the running SYSTEM pack.
; You should IMMEDIATELY HALT the SYSTEM, remove and place in safe storage the
;  new ARCHIVE pack, and boot the new SYSTEM pack.  
.ENABLE QUIET
PIP [1,2]NOLOGIN.TXT;*/DE/NM
.; disable the user's terminal, to encourage immediate rebooting
'MCR' SET /SLAVE=TI:
.DISABLE QUIET
;
;                Finished backup of 'LB0DEV' to 'LB1DEV' at '<TIME>'
;
