@Part(MSKERMIT,root="KER:KUSER")
@string(-msversion="@q<2.26>")
@Chapter<MS-DOS KERMIT>

@Begin<Description,Leftmargin +12,Indent -12,spread 0>
@i(Program:)@\Daphne Tzoar and Jeff Damens, Columbia
University; contributions by many others.

@i(Language:)@\Microsoft Macro Assembler (MASM)

@i(Documentation:)@\Frank da Cruz, Columbia University; Herm
Fischer, Litton Data Systems, Van Nuys CA.

@i(Version:)@\@value(-msversion)

@i(Date: )@\July 1984
@end<Description>

@subheading<Kermit-MS Capabilities At A Glance:>
@begin<format,leftmargin +2,above 1,below 1>
@tabclear()@tabset(3.5inches,4.0inches)
Local operation:@\Yes
Remote operation:@\Yes
Transfers text files:@\Yes
Transfers binary files:@\Yes
Wildcard send:@\Yes
@q<^X/^Y> interruption:@\Yes
Filename collision avoidance:@\Yes
Can time out:@\Yes 
8th-bit prefixing:@\Yes
Repeat count prefixing:@\Yes
Alternate block checks:@\Yes
Terminal emulation:@\Yes
Communication settings:@\Yes
Transmit BREAK:@\Yes 
IBM mainframe communication:@\Yes
Transaction logging:@\No
Session logging:@\Yes
Raw transmit:@\No
Act as server:@\Yes
Talk to server:@\Yes
Advanced server functions:@\No
Advanced commands for servers:@\Yes
Local file management:@\Yes
Handle file attributes:@\No
Command/init files:@\Yes
Command macros:@\Yes
@end<format>

@Index[PC-DOS]
@Index[IBM PC]
@Index[MS-DOS]
Kermit-MS is a program that implements the KERMIT file transfer protocol for
the IBM PC and several other machines using the same processor family (Intel
8088 or 8086) and operating system family (PC-DOS or MS-DOS, henceforth
referred to collectively as MS-DOS, versions 1.1, 2.0, and 2.1, and
thereafter).  This section will describe the things you should know about the
MS-DOS file system in order to make effective use of Kermit, and then it will
describe the Kermit-MS program.

Version 2 of MS-DOS Kermit runs on a variety of systems, including the IBM PC
and XT, the HP-150, the DEC Rainbow 100 and 100+ (MS-DOS 2.05 and above), the
Wang PC, and there is a "generic" MS-DOS version.  Version 1 was adapted at
various stages of development to run on other systems as well, including the
Heath/@|Zenith 100, Tandy 2000, Victor 9000 (Sirius-1), and Seequa Chameleon,
and is still available for those systems until support for them and others is
added to version 2.

The program operates under version 1.1 or 2.0 and above of DOS, although some
features require the functionality of 2.0.  It runs in approximately 80K of
memory -- over and above the memory used by DOS -- which means that your system
should have at least 128K of RAM to use version 2 of MS-DOS Kermit; smaller
systems may still use Version 1.

@Section<The MS-DOS File System>

The features of the MS-DOS file system of greatest interest to KERMIT users are
the form of the file specifications, and the distinction between pre-MS-DOS 2.0
file names and newer file names which allow directory paths.

@subsection<File Specifications>

MS-DOS 2@q(.)@i(x) file specifications are of the form
@example(DEVICE:\PATHNAME\NAME.TYPE)
where the DEVICE is a single character identifier (for instance, A for the
first floppy disk, C for the first fixed disk, D for a RAM disk emulator),
PATHNAME is up to 63 characters of identifier(s) (up to 8 characters each)
surrounded by reverse slashes, NAME is an identifier of up to 8 characters, and
TYPE is an identifier of up to 3 characters in length.  Device and pathname may
be omitted.  The first backslash in the pathname may be omitted if the
specified path is relative to the current directory.  In the path field, @qq<.>
means current directory, @qq<..> means parent directory.  Some DOS
implementations (like Wang) may use slash @qq</> rather than backslash in the
path field.

Pathname is normally omitted, and cannot be specified for MS-DOS 1.x
or with those commands which allow MS-DOS 1.x use.  Device and directory
pathnames, when omitted, default to either the user's current disk and
directory, or to the current directory search path
as specified in the DOS PATH environment variable, depending on the context in
which the file name appears.
@Begin(Quotation)
When this manual says that a file is searched for "in the current path," it
means that the PATH is searched @i(first), and if the file is not found,
@i(then) Kermit-MS looks on the current disk and directory.  If the PATH
environment variable is empty, Kermit looks only at the current disk and
directory.
@End(Quotation)
@q<NAME.TYPE> is normally sufficient to specify a
file, and only this information is sent along by Kermit-MS with an outgoing
file. 

The device, path, name, and type fields may contain uppercase letters, digits,
and the special characters @qq<-> (dash), @qq<_> (underscore), and @qq<$>
(dollar sign).  (For use only among MS-DOS processors, additional filename
special characters allowed are @qq<#&!%'`(){}>.  DOS 1.x allows others as
well.).  There are no imbedded or trailing spaces.  Other characters may be not
be included; there is no mechanism for "quoting" otherwise illegal characters
in filenames.  The fields of the file specification are set off from one
another by the punctuation indicated above.

The name field is the primary identifier for the file.  The type, also called
the extension or suffix, is an indicator which, by convention, tells what kind
of file we have.  For instance @q<FOO.BAS> is the source of a BASIC program
named FOO; @q<FOO.OBJ> might be the relocatable object module produced by
compiling @q<FOO.BAS>; @q<FOO.EXE> could be an executable program produced by
linking @q<FOO.OBJ>, and so forth.  @q(.EXE) and @q(.COM) are the normal
suffixes for executable programs.

@index<Wildcard>
The MS-DOS allows a group of files to be specified in a single file
specification by including the special "wildcard" characters, @qq<*> and
@qq<?>.  A @qq<*> matches any string of characters from the current position 
to the end of the field, including no characters
at all; a @qq<?> matches any single character.  Here are some examples:
@Begin(Description,spread 0.5,leftmargin +10, indent -8)
@q<*.BAS>@\All files of type @q<BAS> (all BASIC source files) in the
current directory.
	
@q<FOO.*>@\Files of all types with name @q<FOO>.
	
@q<F*.*>@\All files whose names start with F.

@q<F?X*.*>@\All files whose names start with F and contain X in 
the third position, followed by zero or more characters.

@q<?.*>@\All files whose names are exactly one character long.
@End(Description)
Wildcard notation is used on many computer systems in similar ways, and it is
the mechanism most commonly used to instruct Kermit to send a group of files.

@begin(quotation)
@i(Note:) Kermit-MS uses the @qq<?> character for help while commands are being
typed, so the single-@!character wildcard in Kermit-MS commands is @qq<=>
rather than @qq<?>.  For example
@example(Kermit-MS>@ux[send =.*])
would send files of all types whose names were exactly one character long.
@end(quotation)

Kermit-MS users should bear in mind that other (non-@|MS-DOS) systems may use
different wildcard characters.  For instance the DEC-20 uses @qq(%) instead of
@qq(?) as the single character wildcard; when using Kermit-MS to request a
wildcard file group from a KERMIT-20 server, the Kermit-MS @qq<=> must be
replaced by the DEC-20 @qq<%>.

@subsection<File Formats>

MS-DOS systems store files as bulk collections of 8 bit bytes, with no
particular differences between text, program code, and binary files.  ASCII
text files consist of lines separated by carriage-@|return-@|linefeed sequences
(CRLFs), which conforms exactly to the way Kermit represents text files during
transmission.  Since a non-@|MS-DOS receiving system might need to make
distinctions as to file type, you may need to use various SET functions on
the remote system to inform it that the incoming file is of some particular
(non-@|default) type, such as binary.  In transmitting files between
Kermit-MS's, regardless of file contents, the receiving MS-DOS system is
equally capable of processing text, code, and data, and in fact has no
knowledge of how the bytes in the file are used.

@index[End Of File]
MS-DOS (unlike CP/M) is capable of pinpointing the end of file with precision
by keeping a byte count in the directory, so one would expect no particular
confusion in this regard.  However, certain MS-DOS programs continue to use the
CP/M convention of terminating a text file with a Control-Z character, and
won't operate correctly unless this terminating byte is present.  Therefore,
Kermit-MS users should be aware of a special SET EOF option for both incoming
and outbound files, described below.

Non-@|MS-DOS systems may well be confused by nonstandard ASCII files from
Kermit-MS.  Files produced by Easywriter or Word Star, for example, may need to
be converted to conventional ASCII format prior to transmission by commonly
available "exporter" programs.  Spreadsheet or database files usually need
special formatting to be meaningful to non-@|MS-DOS recipients (though they can
be transmitted between MS-DOS systems with Kermit-MS).  Furthermore, files
created by word processors (such as BLUE or Easy Writer) that store formatting
data at the end of the file, after the control-Z and before physical end, will
require special processing via SET EOF to strip the formatting data, lest they
confuse non-@|MS-DOS recipients.

@section<Program Operation>

Kermit-MS can be run interactively, from a batch file, or as an "external" DOS
command.  Commands consist of one or more fields, separated by "whitespace" --
one or more spaces or tabs.

Upon initial startup, the program executes any commands found in the
file @q(MSKERMIT.INI) in the current path.
This initialization file may contain command macro definitions, communications
settings for one or more ports, or any other Kermit-MS commands.  Here is a
sample @q(MSKERMIT.INI) file:
@begin(example)
set warning on  ; Enable filename collision avoidance.
;
; Define some macros
;
define unix set local-echo off, set flow xon, set timer off
def ibm set parity odd, set local on, set handsh xon, set timer on
def modem set port 2, set baud 1200
def noisy set block-check 3, set send packet-length 40
;
; Select a port
;
set port 1      ; Select COM1 for communications,
set baud 4800   ; setting the speed to 4800 baud,
connect		; and make a terminal connection.
@end(example)
Note that comments may be included by prefixing them with a semicolon.
The program can be run in several ways.

@subheading(Interactive Operation:)

To run Kermit-MS interactively, invoke the program from DOS command level by
typing its name.  When you see the command's prompt,
@example(Kermit-MS>)
you may type Kermit commands repeatedly until you are ready to exit the
program, for example:
@Begin(Example)
A>
A>@ux[kermit]

IBM PC Kermit-MS V@value(-msversion)
Type ? for help

Kermit-MS>@ux[send foo.*]

  @i(informational messages about the files being sent)

Kermit-MS>@ux[get bar.*]

  @i(informational messages about the files being received)

Kermit-MS>@ux[exit]
A>
@end[example]

@index<Help>
During interactive operation, you may edit the command you're currently typing
to erase the character most recently typed (BACKSPACE or DEL), the most recent
field (CTRL-W), or the entire command (CTRL-U).  In addition, you may use the
help (@qq<?>) and
@index<Recognition>
recognition (ESC) features freely while typing Kermit-MS commands.  A question
mark typed at almost any point in a command produces a brief description of
what is expected or possible at that point; for this reason, Kermit-MS uses "="
for the single-@|character match wildcard in local filenames.  ESC typed at any
point, even in a local filename, will cause the current field to be filled out
if what you have typed so far is sufficient to identify it, and will leave you
in position to type the next field (or to type a "?" to find out what the next
field is); otherwise, the program will beep at you and wait for you to type
further characters.

Some Kermit-MS commands, like GET, SHOW KEY, SET KEY, may prompt for additional
information on subsequent lines.  If you have reached one of these prompts and
then wish to cancel the command, you may type Control-C.

Summary of Kermit-MS Command Characters:
@begin(description,indent -14)
BACKSPACE@\Delete the character most recently typed.  May be typed repeatedly
to delete backwards.  You may also use DELETE, RUBOUT, or equivalent keys.

CTRL-W@\Delete the most recent "word", or field, on the command line.  May be
typed repeatedly.

CTRL-U@\Delete the entire command line.

CTRL-C@\Cancel the current command and return to the "@q(Kermit-MS>)" prompt.

@q<?>@\Type a brief message describing what you are expected to type in the
current field.

ESC@\If enough characters have been supplied in the current field (keyword
or file name) to uniquely identify it, supply the remainder of the field and
position to the next field of the command.  Otherwise, sound a beep.

@q<=>@\Wildcard character for matching single characters in filenames,
equivalent to MS-DOS @qq<?>.
@end(description)

@subheading(Command Line Invocation:)

Kermit-MS may also be invoked with command line arguments from DOS command
level, for instance:
@Begin(Example,below 0.5)
A>@ux(kermit send foo.bar)
@End(Example)
or
@Begin(Example,above 0.5)
A>@ux(kermit set port 1, set baud 9600, connect)
@End(Example)
In this case, help and recognition are not available (because the program won't
start running until after you type the entire command line), and Kermit-MS will
exit after completing the specified command or commands.  Therefore, when
invoked with command line arguments, Kermit-MS will behave as if it were an
external DOS command, like MODE.  Note that several commands may be given on
the command line, separated by commas.

@subheading(Batch Operation:)

@index(Batch Operation of Kermit-MS)
Like other MS-DOS programs, Kermit-MS may be operated under batch with either
command line arguments and/or TAKE files; Kermit will also run interactively
if invoked from batch, but it will read commands from the keyboard and not the
batch file.

@Section<Kermit-MS Commands>

MS-DOS Kermit implements a large subset of the commands of "ideal"
Kermit.  Here's a brief summary:
@Begin(Format,spread 0)
@tabclear()@tabset(1.25inches)
@>BYE@\  to remote server.
@>CLOSE@\  log file and stop logging remote session.
@>CONNECT@\  as terminal to remote system.
@>DEFINE@\  macros of Kermit-MS commands.
@>DELETE@\  local files.
@>DIRECTORY@\  listing of local files.
@>DO@\  a macro expansion.
@>EXIT@\  from Kermit-MS.
@>FINISH@\  Shut down remote server.
@>GET@\  remote files from server.
@>HELP@\  about Kermit-MS.
@>LOCAL@\  prefix for local file management commands.
@>LOG@\  remote terminal session.
@>LOGOUT@\  remote server.
@>PUSH@\  to MS-DOS command level.
@>QUIT@\  from Kermit-MS
@>RECEIVE@\  files from remote Kermit.
@>REMOTE@\  prefix for remote file management commands.
@>RUN@\  an MS-DOS program.
@>SEND@\  files to remote Kermit.
@>SERVER@\  mode of remote operation.
@>SET@\  various parameters.
@>SHOW@\  various parameters.
@>SPACE@\  inquiry.
@>STATUS@\  inquiry.
@>TAKE@\  commands from file.
@End(format)

The remainder of this section concentrates on the commands that have special
form or meaning for MS-DOS Kermit.  Not all of the following commands are
necessarily available on all MS-DOS systems, and some of the commands may work
somewhat differently between DOS versions.

@subsection(Commands for File Transfer)

The file transfer commands are SEND, GET, and RECEIVE.

@Heading<The SEND Command>

Syntax:  @q<SEND> @i{filespec1} [@i(filespec2)]

The SEND command causes a file or file group to be sent from the local MS-DOS
system to the Kermit on the remote system.  The remote Kermit may be running in
either server or interactive mode; in the latter case, you should already have
given it a RECEIVE command and escaped back to your PC.

@i(filespec1) may contain a device designator, like @qq<A:> and the
wildcard characters @qq<*> and/or @qq<=>.  The current release of Kermit-MS,
however, does not allow pathnames in the SEND command file specification.

If @i{filespec1} contains wildcard characters then all matching files will
be sent, in the same order that MS-DOS would show them in a directory listing.
If @i{filespec1} specifies a single file, you may direct Kermit-MS to send that
file with a different name, given in @i{filespec2}.  For instance, in the
command 
@example(Kermit-MS>@ux[send foo.bar framus.widget])
@i(filespec2) begins with the first nonblank character after @i(filespec1) and
ends with the carriage return; thus it may contain blanks or other unusual
characters that may be appropriate on the target machine.  Lower case letters
in @i(filespec2) are raised to upper case for transmission.

If a file can't be opened for read access, standard MS-DOS recovery procedures
will take place.  For example:
@Begin(Example)
Not ready error reading drive A
Abort, Retry, Ignore?
@End(Example)
If you select "Abort," you will be returned to DOS.

Files will be sent with their MS-DOS filename and filetype (for instance
@q<FOO.TXT>, no device or pathname).  Each file is sent as is, with no
conversions done on the data, except for possibly adding or deleting a
terminating Control-Z character (see the SET EOF command).

Once you give Kermit-MS the SEND command, the name of each file will be
displayed on your screen as the transfer begins; packet, retry, and other
counts will be displayed along with informational messages during the transfer.
If the file is successfully transferred, you will see @qq<Complete>, otherwise
there will be an error message.  When the specified operation is done, the
program will sound a beep. 

@index<Control-X>@index<Control-Z>@Index<Cancelling a File Transfer>
Several single-character commands may be given while a file transfer is in
progress:
@Begin(Description,leftmargin +6,indent -4)
@q(^X)@\(Control-X) Stop sending the current file and go on to the next one, if
any.

@q(^Z)@\Stop sending this file, and don't send any further files.

@q(^C)@\Return to Kermit-MS command level immediately without sending any kind
of notification to the remote system.

@q(^E)@\Like @q(^C), but send an Error packet to the remote Kermit in an
attempt to bring it back to server or interactive command level.

@q(CR)@\Simulate a timeout: resend the current packet, or NAK the expected one.
@End(Description)
Control-X and Control-Z send the proper protocol messages to the remote Kermit
to bring it gracefully to the desired state.  Control-C leaves the remote
Kermit in whatever state it happens to be in.  Control-E "aborts" any protocol
that is taking place.

@Heading<The RECEIVE Command>
@Index[RECEIVE]
Syntax: @q<RECEIVE [@i{filespec}]>

The RECEIVE command tells Kermit-MS to receive a file or file group from the
other system.  Kermit-MS simply waits for the file to arrive; this command is
not to be used when talking to a Kermit server (use GET for that).  You should
already have issued a SEND command to the remote Kermit and escaped back to
Kermit-MS before issuing the RECEIVE command.

If the optional filespec is provided, store the incoming file under that name.
The filespec may include a device designator, or may consist of only a device
designator.  The incoming file is stored on the default or specified device
(current directory in DOS 2.0 and thereafter).  If no name was specified, the
name from the incoming file header packet is used; if that name is not a legal
MS-DOS file name, Kermit-MS will delete excessive characters from
it, and will change illegal characters to the @w(letter X).

If the optional filespec was provided, but more than one file arrives, the
first file will be stored under the given filespec, and the remainder will be
stored under their own names, but on the specified device.

@Index<Incomplete File Disposition> If an incoming file does not arrive in its
entirety, Kermit-MS will normally discard it; it will not appear in your
directory.  You may change this behavior by using the command SET INCOMPLETE
KEEP, which will cause as much of the file as arrived to be saved in your
directory.

@index<Control-X>@index<Control-Z>@Index<Cancelling a File Transfer>
The same single-character commands are available as during SEND:
@Begin(Description,leftmargin +6,indent -4)
@q(^X)@\Request that the remote Kermit stop sending the current file, and
proceed to the next one immediately.  Since this is an optional feature of the
Kermit protocol, the remote Kermit might not honor the request.

@q(^Z)@\Request that the remote Kermit terminate the entire transfer; this is
also an optional feature that may or may not be supported by the remote Kermit.

@q(^C), @q(^E), and @q(CR) operate in the same way as they do during SEND.
@End(Description)

If the incoming file has the same name as a file that already exists, and
WARNING is set ON, Kermit-MS will change the incoming name (and inform you how
it renamed it) so as not to obliterate the pre-@|existing file.  If WARNING is
OFF, the original file will be overwritten; if you type @q(^X) or @q(^Z) to
interrupt the transfer, you'll either get a partial new file, or else both the
old and the new file of that name will be lost, depending on SET
INCOMPLETE.  In any case, when WARNING is off, files with the same name as
incoming files will not survive.

@i(Caution:) If an incoming file's name (the part before the dot) corresponds
to an MS-DOS device name, such as NUL, COM1, CON, AUX, or PRN, output will go
to that device, rather than to a file with that name.  This is a feature of
MS-DOS.

@Heading<The GET Command>

Syntax: @q<GET @i{remote-filespec}>

The GET command requests a remote KERMIT server to send the file or file group
specified by @i<remote-filespec>.  This command can be used only when Kermit-MS
has a KERMIT server on the other end of the connection.  This means that you
must have CONNECTed to the other system, logged in, run KERMIT there, issued
the SERVER command, and escaped back (e.g. @q<^]C>) to the local Kermit-MS.
If the remote Kermit does not have a SERVER command, then you should use SEND
and RECEIVE as described above.

You may use the GET command to specify a different name for storing the
incoming.  Just type GET alone on a line, and you will be prompted separately
for the remote filespec and the local filespec:
@Begin(Example)
Kermit-MS>@ux(get)
 Remote Source File: @ux(com1.txt)
 Local Destination File: @ux(xcom1.txt)
@End(Example)
If more than one file arrives, only the first will be renamed.

The remote filespec is any string that can be a legal file specification for
the remote system; it is not parsed or validated locally.  It can contain
whatever wildcard or file-@|group notation is valid on the remote system.  As
files arrive, their names will be displayed on your screen, along with packet
traffic statistics and status messages.  You may type @q<^X> to request that
the current incoming file be cancelled, @q<^Z> to request that the entire
incoming batch be cancelled, and @q<^C> or @q<^E> to return immediately to the
@q(Kermit-MS>) prompt, exactly as described for the RECEIVE command.

@subsection(Commands for Connecting and Disconnecting)

The CONNECT command connects your PC as a terminal to the remote system, so
that you can start up Kermit there.  The BYE, FINISH, and LOGOUT commands allow
you to shut down a remote Kermit server.
@Begin(Description)
BYE@\When communicating with a remote KERMIT server, use the BYE command to
shut down the server, log out its job, and exit from Kermit-MS to DOS.

FINISH@\Like BYE, FINISH shuts down the remote server.  However, FINISH does
not log out the server's job.  You are left at Kermit-MS prompt level so that
you can connect back to the job on the remote system.

LOGOUT@\The LOGOUT command is identical to the BYE command, except you will
remain at Kermit-MS prompt level, rather than exit to DOS, so that you can
establish another connection.
@End(Description)

@subheading<The CONNECT Command>

Establish an interactive terminal connection to the system connected to the
currently selected communications port (e.g. COM1 or COM2) using full duplex
(remote) echoing and no parity unless otherwise specified in previous SET
commands.  Get back to Kermit-MS by typing the escape character followed by the
letter C.  The escape character is Control-@q(]) by default.

You can use the SET ESCAPE command to define a different escape character,
and on some systems (including the PC and XT) you can SET BAUD to change the
baud rate, and SET PORT to switch between ports.

Terminal emulation is described in greater detail in section @ref(-msterm)
below.

@subsection(Commands for File Management)

Kermit-MS provides commands or managing both local and remote files.

@Heading<The REMOTE Commands>

The REMOTE keyword is a prefix for a number of commands.  It indicates that the
command is to be performed by the remote Kermit, which must be running as a
server.  Note that not all Kermit servers are capable of executing all these
commands, and some Kermit servers may be able to perform functions for which
Kermit-MS does not yet have the corresponding commands.  In case you send a
command the server cannot execute, it will send back a message stating that the
command is unknown to it.  If the remote server can execute the command, it
will send the results to your screen.  Here are the REMOTE commands which
Kermit-MS may issue:
@begin<description>
CWD [@i<directory>]@\Change Working Directory on the remote host.  Change the
default source and destination area for file transfer and management.  You will
be prompted for a password, which will be erased as you type it.  If you do not
supply a password (i.e. you type only a carriage return), the server will
attempt to access the specified directory without a password.  If you do not
supply a directory name, your default or login directory on the remote system
will be assumed.

DELETE @i<filespec>@\Delete the specified file or files on the remote system.
In response, the remote host should display a list of the files that were or
were not successfully deleted.

DIRECTORY [@i<filespec>]@ @ The remote system will provide a directory listing
of the specified files.  If no files are specified, then all files in the
default area (the current working directory) will be listed.

HELP@\The remote host tells what server functions it is capable of.

HOST [@i<command>]@\Send the command to the remote system's command processor
for execution.

SPACE [@i<directory>]@\Provide a brief summary of disk usage in the specified
area on the remote host.  If none specified, the default or current area will
be summarized.

TYPE @i<filespec>@\Display the contents of the specified remote file or files
on the screen.
@end<description>

@Heading<The LOCAL Command>

The LOCAL keyword is a prefix for a number of commands.  It indicates that the
specified command is to be executed on the local MS-DOS system.  The LOCAL
prefix may be omitted.  The local commands available are:
@begin(description)
DELETE @i(filespec)@\Deletes the specified file or files.  As in DOS, the
names of the deleted files are not listed, only the message "file(s) deleted"
or "file(s) not found", and if you give the command "delete @q<*.*>", Kermit-MS
will prompt "Are you sure?", like DOS.

DIRECTORY @i([filespec])@ @ Lists the names, sizes, and creation dates of files
that match the given file specification.  If no filespec is given, the command
is equivalent to @q(DIR *.*).

SPACE@\Performs the MS-DOS CHKDSK function by running the CHKDSK program
from the current path, or default disk under DOS @q<1.1>.

RUN @i(filespec)@\Runs the specified file, which must be in @q(.EXE) or
@q(.COM) format, from the specified path or according to the value of the PATH
variable if no path was included in the filespec.  This command requires
MS-DOS 2.0 or higher.

PUSH@\Invokes an MS-DOS command processor "under" Kermit-MS, either
@q(COMMAND.COM) or whatever shell you have specified with COMSPEC.  When you
return to Kermit-MS (for instance, by typing the MS-DOS EXIT command), you will
find Kermit-MS as you left it, with all settings intact.  This command only
works in MS-DOS 2.0 or higher.
@end(description)
The local RUN command has various uses, one of which is to supplement the
features of Kermit-MS.  For instance, suppose there
is an involved procedure that you regularly perform on a certain remote system
-- this might include giving commands to a modem to dial the system, looking
for a particular herald or prompt, performing a login command sequence, running
a selected application, and then running Kermit to send the results back to
your PC.  You could write a program in the compiled language of your choice,
say C or BASIC, to send the desired commands to your modem and the remote
system and to look for the appropriate responses.  You could put all this in a
Kermit-MS TAKE command file (see below), like
@begin(example)
run update.com
receive
@end(example)
The program, called UPDATE in this case, does everything up to and including
starting Kermit sending from the remote system.  When the program terminates,
the next Kermit-MS command, "receive," is executed from the command file.  When
the end of the command file is reached, interactive operation is resumed.

@Heading<The TAKE Command>

Syntax: @q<TAKE @i{filespec}>

Execute Kermit commands from the specified file, which may include an explicit
path; if no path is specified, the value of the PATH variable is used; if PATH
has no value, then the current disk and directory are searched.  The command
file may include TAKE commands, but it cannot include characters to be sent to
a remote host during terminal emulation (i.e. after a CONNECT command).  A
command file may include comments prefixed by semicolons.

@Heading<The LOG Command>

Syntax: @q(LOG @i{filespec})

Specifies that all characters that appear on your screen during CONNECT will be
recorded in the specified file.  This allows you to "capture" files from a
remote system that doesn't have Kermit, as well as to record remote command
typescripts.  The log is closed when you EXIT from Kermit-MS or when you issue
an explicit CLOSE command.

@subsection<The SERVER Command>

Kermit-MS is capable of acting as a Kermit server, providing file transfer
for users coming in through one of the communication ports.  The current
version of Kermit-MS can send files (the user on the other end types the
GET command), receive files (the user types SEND), and terminate, giving
control back to the console (user types BYE).

To put Kermit-MS into server mode, first issue any desired SET commands to
select and configure the desired port, and then type the SERVER command.
Kermit-MS will await all further instructions from the user Kermit on the other
end of the connection, which may be hardwired or connected through an
autoanswer modem.  For example:
@Begin(Example)
Kermit-MS>@ux(set port 1)
Kermit-MS>@ux(set baud 1200)
Kermit-MS>@ux(set timer on)
Kermit-MS>@ux(set warning on)
Kermit-MS>@ux(server)
@End(Example)

@Subsection<The SET Command>

Syntax: @q<SET @i{parameter} [@i{value}]>

Establish or modify various parameters for file transfer or terminal
connection.  You can examine their values with the SHOW command.  Note that
there is no "set ibm" command; IBM mainframe communication parameters may be
selected with a command macro (see below).  The following SET commands are
available in Kermit-MS:
@Begin(Format,spread 0)
@tabclear()@tabset(2.0inches)
@>BAUD@\  Communications port line speed
@>BELL@\  Whether to beep at the end of a transaction
@>BLOCK-CHECK-TYPE@\  Level of error checking for file transfer
@>DEBUG@\  Display packet contents during file transfer
@>DEFAULT-DISK@\  Default disk drive for file i/o
@>DESTINATION@\  Default destination device for incoming files
@>END-OF-LINE@\  Packet terminator
@>EOF@\  Method for determining or marking end of file
@>ESCAPE@\  Escape character for CONNECT
@>FLOW-CONTROL@\  Enable or disable XON/XOFF
@>HANDSHAKE@\  Half-duplex line turnaround option
@>HEATH19@\  Heath/Zenith-19 terminal emulation
@>INCOMPLETE@\  What to do with an incompletely received file
@>KEY@\  Specify key redefinitions, or "keystroke macros"
@>LOCAL-ECHO@\  Specify which host does the echoing during CONNECT
@>PARITY@\  Character parity to use
@>PORT@\  Select a communications port
@>PROMPT@\  Change the "Kermit-MS>" prompt to something else
@>RECEIVE@\  Request remote Kermit to use specified parameters
@>REMOTE@\  For running Kermit-MS interactively from back port
@>SEND@\  Use the specified parameters during file transfer
@>TAKE-ECHO@\  Control echoing of commands from TAKE files
@>TIMER@\  Enable/disable timeouts during file transfer
@>WARNING@\  Specify how to handle filename collisions
@End(format)

The SET commands that are peculiar to MS-DOS Kermit are now described in
greater detail.  The others behave as in "ideal" Kermit.

@Subheading<SET BAUD>

Syntax: @q<SET BAUD @i{rate}>

@Index<Baud Rate>
Set the speed of the currently selected terminal communications port (COM1 by
default) to 300, 1200, 1800, 2400, 4800, 9600 or other common baud rate.  Some
implementations do not support this command.   In any case, Kermit-MS leaves
the current communication port settings alone unless you issue explicit SET
commands to change them.

@Subheading<SET BELL>
@Index<Bell> @Index<Beeper>
Syntax: @q<SET BELL ON @i(or) OFF>

Specifies whether bell (beeper) should sound upon completion of a file transfer
operation.

@Subheading<SET DEBUG>
@Index<Debugging>

Syntax: @q<SET DEBUG ON @i(or) OFF>
@Begin(Description,leftmargin +8,indent -8,spread 0.5)
ON@\Display the Kermit packet traffic on your screen during file
transfer.  If the debugger is loaded, transfer control to it when CTRL-C is
typed.  In Heath-19 terminal emulation on the IBM PC, display unusual control
characters in uparrow notation.

OFF@\Don't display debugging information (this is the default).  If
debugging was in effect, turn it off.
@End(Description)

@subheading<SET DEFAULT-DISK>
Syntax: @q<SET DEFAULT-DISK @i(x):>

Specify the default disk drive to use for file transfer, directory listings,
and so forth.  Equivalent to typing the DOS command for changing disks.

@Subheading<SET DESTINATION>
Syntax: @q<SET DESTINATION> @i(device)

Specify the device for incoming files, DISK or PRINTER.  SET
DESTINATION PRINTER will cause incoming files to be spooled directly to the
printer.  The normal destination is DISK.

@subheading(END-OF-LINE)
Syntax: @q(SET END-OF-LINE) @i{number}

If the remote system needs packets to be terminated by anything other than
carriage return, specify the decimal value of the desired ASCII character.

@subheading(SET EOF)
@Index(EOF)@Index(End Of File)
Syntax: @q(SET EOF @i{option})

Controls how the end of file is handled.  The options are:
@Begin(Description)
CTRL-Z@\Append a Control-Z character to the end of an incoming file, unless it
already ends with a Control-Z.  Certain MS-DOS text editors and other
applications require files to be in this format.  For outbound files, treat the
first Control-Z as the end of file, and do not send it nor any characters
following it.

NOCTRL-Z@\(Default) Store incoming files exactly as is, and send MS DOS files
exactly as is (according to their byte count).
@End(Description)

@Subheading<SET ESCAPE>
@Index<Escape Character for CONNECT>
Syntax: @q<SET ESCAPE @i{character}>

Specify the control character you want to use to "escape" from remote
connections back to Kermit-MS.  The default is normally @q(^])
(Control-@|Rightbracket). The character is entered literally, and should
normally be chosen from the ASCII control range.

@Subheading<SET FLOW-CONTROL>
@Index<Flow Control>
Syntax: @q<SET FLOW-CONTROL @i{option}>

Specify the full duplex flow control to be done on the currently selected port.
The current options are XON/XOFF and NONE.  The specified type of flow control
will be done during both terminal emulation and file transfer.  If set to
XON/XOFF, HANDSHAKE is automatically set to OFF.

@Subheading<SET HANDSHAKE>
@Index<Handshake>
Syntax: @q<SET HANDSHAKE @i{option}>

Specify any half-@|duplex handshaking to be done on the currently selected
port.  The options are BELL, CR, LF, NONE, XOFF, or XON.  The specified
handshaking will be done during file transfer only.  If HANDSHAKE is set to
anything other than NONE, FLOW-CONTROL is automatically set to OFF.

@Subheading<SET HEATH19>
@Index<Heath-19 Terminal Emulation>
Syntax: @q<SET HEATH19 ON @i(or) OFF>

Specify whether Kermit-MS should use its built-in software facility for
emulating a Heath/@|Zenith-19 (H19) terminal.
@Begin(Description,spread 0.5,leftmargin +8,indent -8)
ON@\During CONNECT, incoming characters are to be examined for H19
terminal screen control commands (escape sequences), and if
encountered, the commands are to be emulated on the PC screen.  The H19
codes are a superset of the popular DEC VT52 codes, so if your system does not
support the Heath-19, you may tell it that your terminal type is VT52 (or one
of the many VT52 compatibles).  The Heath-19 codes are listed in section
@ref(-h19codes), below.
 
@index(ANSI.SYS)
OFF@\All incoming characters will be sent to the screen "bare", through DOS.
If you have loaded a device driver into DOS for the @q<CON:> device, such as
@q<ANSI.SYS>, then that driver will be able to interpret the codes itself. Most
non-IBM systems have their own screen control code interpreter built into DOS
or firmware, or available as a loadable device driver.
@End(Description)
See section @ref(-msterm) for details about terminal emulation.

@Subheading<SET KEY>
@Index(Key Redefinition)
Syntax: @q<SET KEY @i(key-specifier)>

Specifies that when the designated key is struck during terminal emulation,
the associated character string is sent.  The key-@|specifier is one of the
keywords F1, F2, @q<...>, or SCAN followed by a scan code.  Systems that
have a BACKSPACE key also include BACKSPACE as a keyword.

If SCAN is used, it is followed by a @i(decimal) number to indicate the scan
code of the key, which you would ascertain from your system reference manual,
or else by using the Kermit-MS SHOW KEY command.  SET KEY prompts you on a new
line for the definition string.  Certain characters, like ESC and CR, may not
be entered literally into the string, but can be included by inserting escape
codes of the form @q(\ooo), a backslash followed by a 2- or 3-digit @i(octal)
number corresponding to the ASCII value of the desired character.  If some
other key redefinition package, like ProKey, has been loaded, then its
redefinitions will take precedence over Kermit's.

The SET KEY command is illustrated in the terminal emulation section,
@ref(-msterm), below.

@Subheading<SET LOCAL-ECHO>
@Index<Local Echoing>
Syntax: @q<SET LOCAL-ECHO @i{option}>

Specify how characters are echoed during terminal emulation on the currently
selected port.  ON specifies that characters are to be echoed by Kermit-MS
(because neither the remote computer nor the communications circuitry has been
requested to echo), and is appropriate for half-@|duplex connections.
LOCAL-ECHO is OFF by default, for full-@|duplex, remote echo operation.

When you SET LOCAL-ECHO ON, the current HANDSHAKE (if any) is automatically
enabled and full-@|duplex FLOW-CONTROL is automatically turned off.  When you
SET LOCAL-ECHO OFF, HANDSHAKE is also disabled, and the current mode of
FLOW-CONTROL (if any) is enabled.  If this behavior is undesired, you may
override it by typing explicit SET HANDSHAKE or SET FLOW commands after
entering the SET LOCAL-ECHO command.

@Subheading<SET PARITY>
@Index<Parity>
Syntax: @q<SET PARITY @i{keyword}>

Specify the character parity to be used on the currently selected port.
The choices for SET PARITY are NONE (the default), ODD, EVEN, MARK, and SPACE.
NONE means no parity processing is done, and the 8th bit of each character can
be used for data when transmitting binary files.

You will need to SET PARITY to ODD, EVEN, MARK, or possibly SPACE when
communicating with a system, or over a network, or through modems,
concentrators, multiplexers, or front ends that require or impose character
parity on the communication line.  For instance, GTE @index(Telenet) Telenet
requires MARK parity.  If you neglect to SET PARITY when the communications
equipment requires it, the symptom may be that terminal emulation works
partially, and file transfer does not work at all.

@Index<Eighth-Bit Prefix>@Index<Binary Files> If you have set parity to ODD,
EVEN, MARK, or SPACE, then Kermit-MS will request that binary files will be
transferred using 8th-bit-@|prefixing.  If the other side knows how to do
8th-bit-@|prefixing (this is an optional feature of the KERMIT protocol, and
not all implementations of KERMIT have it), then binary files can be
transmitted successfully.  If NONE is specified, 8th-bit-@|prefixing will not
be requested.  Note that there is no advantage to using parity; it only slows
Kermit file transfer down.  The SET PARITY command is provided only to allow
Kermit to adapt to hardware that insists upon using parity.

@Subheading<SET PORT>
Syntax: @q<SET PORT @i(number)>

On machines with more than one communications port,
select the port to use for file transfer and CONNECT.  This command
lets you use a different asynchronous adapter, or switch between two or more
simultaneous remote sessions.  Subsequent SET BAUD, PARITY, HANDSHAKE, FLOW,
and LOCAL-ECHO commands will apply to this port only.  SET @w(PORT 1) selects
COM1, SET @w(PORT 2) selects COM2.

@Subheading[SET REMOTE]
Syntax: @q(SET REMOTE ON @i<or> OFF)

If you wish to run Kermit-MS interactively through the back port, for instance
after the operator has done CTTY COM1, you must give the command SET REMOTE ON;
this suppresses the file transfer display screen, so that the display won't
interfere with the file transfer itself.

@Subheading[SET RECEIVE]
Syntax: @q(SET RECEIVE @i[parameter value])

At the beginning of a protocol operation, request the remote Kermit to use the
given value specified parameter, or inform Kermit-MS that the remote Kermit
will be using it.
@Begin(Description)
PACKET-LENGTH@\Ask the remote Kermit to use the specified maximum length for
packets that it sends to Kermit-MS.  The normal (and maximum) length is 94.
Use this command to shorten packets if the communication line is noisy; this
will decrease the probability that a particular packet will be corrupted, and
will reduce the retransmission overhead when corruption occurs, but it will
increase the protocol overhead.

PADCHAR@\Ask the remote Kermit to use the given character for interpacket
padding.  Kermit-MS should never require any padding.

PADDING@\Ask the remote Kermit to insert the given number of padding characters
before each packet it sends.  This should never be necessary.

START-OF-PACKET@\The remote Kermit will be marking the beginning of packets
with something other than Control-A.  This will be necessary only if the hosts
or communication equipment involved cannot pass a Control-A through as data.

TIMEOUT@\Ask the remote Kermit to time out after the given number of seconds if
a packet expected from Kermit-MS has not arrived.  Use this command to change
the normal timeout interval.
@End(Description)

@Subheading[SET SEND]
Syntax: @q(SET SEND @i[parameter value])

@Begin(Description)
PACKET-LENGTH@\Use the specified maximum length for outbound packets.
Normally, Kermit-MS uses whatever length the other Kermit requests.

PADCHAR@\Use the specified character for interpacket padding.  Some hosts may
require some padding characters (normally NUL or DEL) before a packet.

PADDING@\How many padding characters to use between packets, normally zero.

QUOTE@\Use the indicated printable character for prefixing (quoting) control
characters and other prefix characters.  The only reason to change this would
be for sending a very long file that contains very many @qq(#) characters (the
normal control prefix) as data.

START-OF-PACKET@\Mark the beginning of outbound packets with some control
character other than Control-A.  This will be necessary only if the remote host
or the communication channel involved cannot accept a Control-A as data.  The
remote host must have been given the corresponding SET RECEIVE
START-@|OF-@|PACKET command.

TIMEOUT@\Change Kermit-MS's normal timeout interval; this command is effective
only if TIMER is set to be ON; it is normally OFF so that the remote KERMIT can
control timeouts.
@End(Description)

@Subheading<SET TAKE-ECHO>
@Index(Command Files)
Syntax: @q<SET TAKE-ECHO ON @i(or) OFF>

Specifies whether screen display should occur during implicit or explicit TAKE
operations on @q(MSKERMIT.INI) or other Kermit-MS command files, and during
evaluation of macro definitions.  Handy for finding errors in command files.

@Subheading(SET TIMER)
@Index[Timeout]
Syntax: @q(SET TIMER ON @i[or] OFF)

Enable or disable the timer that is used during file transfer to break the
deadlock that occurs when an expected packet does not arrive.  By default, the
timer is OFF, because Kermit-MS is usually used in conjunction with a mainframe
that is doing its own timeouts.  During a file transfer, it is sufficient for
one side to do the timing out and the mainframe is usually better equipped to
adjust timeout intervals based on system load or other conditions.  The timer
should be set ON if you are communicating with a system that cannot do
timeouts, such as IBM VM/CMS Kermit.

@Subheading<SET WARNING>
@Index<File Warning>@Index(File Renaming)@index(Warning)
Syntax: @q<SET WARNING @i{option}>

Specify what to do when an incoming file has the same name as an existing file
in the default directory of the default device.  If ON, Kermit will warn you
when an incoming file has the same name as an existing file, and automatically
rename the incoming file (as indicated in the warning message) so as not to
destroy (overwrite) the pre-@|existing one.  If OFF, the pre-@|existing file is
destroyed, even if the incoming file does not arrive completely.

@subsection[The SHOW Command]

Syntax: @q(SHOW )@i(option)

Currently, most parameters that may be altered with SET commands are displayed
by the STATUS command.  The SHOW command is used for displaying macro
definitions and key redefinitions.

The SHOW MACROS command displays the definitions of all currently defined
macros.

The SHOW KEY command allows you to determine the scan code produced by
pressing a given key, so that you can construct a SET KEY command to
redefine the key.  If the key already has a redefinition in effect, that
too will be displayed.  In this example, a DEC Rainbow user determines the
scan code for the accent grave key, and then redefines that key to send
ESC:
@Begin(Example)
Kermit-MS>@ux(show key)
Press a key: @ux(`)
  Scan Code:  96
  Definition:
Kermit-MS>@ux(set key scan 96)
Definition string: @ux(\33)
Kermit-MS>@ux(show key)
Press a key: @ux(`)
  Scan Code:  96
  Definition: \33
Kermit-MS>
@End(Example)
The SHOW KEY command only works on certain systems.

@subsection[Command Macros]

Kermit-MS provides a facility for combining commands into "macros."  Command
macro definitions may be included in your @q[MSKERMIT.INI] file, TAKEn
explicitly from a specified file, or typed interactively, and may be invoked
with the DO command.

@Heading<The DEFINE Command>

@index[DEFINE]@index[Macro]@index[Command Macro]
Kermit-MS command macros are constructed with the DEFINE command.  The
syntax is
@example(DEFINE @i[macro-name]  [@i(command) [, @i(command) [, ...]]])
Any Kermit-MS commands may be included.  Example:
@begin(example)
define telenet set parity mark, set baud 1200, connect
@end(example)

@Heading<The DO Command>

@index[DO Command]
A Kermit-MS command macro is invoked using the DO command.  For instance,
Kermit-MS comes with a predefined macro to allow convenient setup for IBM
communications; to invoke it, you would type
@Example[do ibm]
The IBM macro is defined as "parity mark, handshake xon, local-echo on, timer
on".  You can delete or replace this definition by adding a new (perhaps null)
definition, such as
@Example[define ibm parity even, handshake cr, local-echo on, timer on]
or
@Example[define ibm]

@Section<Terminal Emulation>
@label(-msterm)
@index[CONNECT]@index[Autodialer]@index[Smart Modem]@index[Modem] When you
issue the CONNECT command, your PC acts as a terminal connected to a remote
computer through the currently selected port.  The characters you type are sent
out the port, and characters that arrive at the port are displayed on your
screen.  If you have not previously issued a SET PORT command, COM1 is used.
If you have SET LOCAL-ECHO ON for the selected port, then Kermit-MS will
display characters on the screen as you type them.  If LOCAL-ECHO is OFF, then
XON/XOFF flow control will be done unless you have SET FLOW-CONTROL OFF.  If
you have SET PARITY to anything other than NONE, Kermit-MS will add the
appropriate parity to each outbound character, and strip any parity from
incoming ones.  While CONNECTed, you can also communicate with an
autodialer or "smart modem" to control the communications line, hang it up, and
the like; for instance, typing @q<+++> to a Hayes-@|like modem will allow you
to follow that by dialing or hangup commands.

@Index(Heath-19 Terminal Emulation)
If Heath-19 emulation is being done, incoming characters will be monitored for
H19/@|VT52 escape sequences.  These will be interpreted according to the table
in section @ref(-h19codes).  In addition, keys on the numeric keypad will send
H19/@|VT52 sequences unless you disable this feature in some way, for instance
by pressing Num Lock on the IBM PC keyboard, or with key redefinitions.

@Begin(Quotation)
@i(Caution:) On some systems, such as the IBM PC and XT, Kermit-MS accesses the
screen memory memory directly to perform certain H19 emulation functions such
as character insert/@|delete and screen scroll.  Without direct screen memory
access, these functions would be painfully slow.  Although Kermit-MS has been
tested successfully on a variety of monochrome and color adapters and monitors,
there may be combinations for which this method could cause video problems,
such as snow.  Should this occur, you can alleviate the problem by setting
HEATH19 emulation OFF.  In that case, however, you remove not only the
problems, but also the desirable features of emulation.  But Kermit-MS does
permit you to load an external console device driver, such as
IBM's @q(ANSI.SYS), to provide any desired screen control.
@End(Quotation)

Here are the terminal emulation options for the systems presently supported by
Kermit-MS:
@begin<format,leftmargin +2,above 1,below 1,group>
@tabclear()@tabset(1.5inches,2.5inches,3.8inches)
@ux(System)@\@ux(EscChar)@\@ux(Cabilities)@\@ux(Terminal Service)
IBM PC, XT   @\  @q(^])   @\R M P K@\Heath19 emulation
DEC Rainbow  @\  @q(^])   @\R   P K@\VT102 firmware
HP-150       @\  @q(^])   @\R      @\HP-2623 firmware
Wang PC      @\  @q(^A)   @\       @\Wang firmware
Generic DOS  @\  @q(^])   @\       @\Depends on system
@end(format)
Under Capabilities, R means rollback, M means mode line, P means printer
control, and K means key redefinition.

IBM PC/XT Kermit can disable Heath-19 emulation and use an external console
device driver like @q(ANSI.SYS) instead.

@index[Mode Line]
When you first issue the CONNECT command, a message (on some systems, an
inverse video "mode line") will display the most important facts about the
connection you've just established, so that you can quickly diagnose any
problems.  The items displayed in the mode line include the escape
character, port number, the baud rate, the parity, the echo, and how to
get help, for instance:
@begin(example,leftmargin +0,longlines keep)
+---------------------------------------------------------------------+
|EscChar:^],Port:1,Baud:9600,Parity:None,Echo:Remote,Type ^]? for Help|
+---------------------------------------------------------------------+
@end(example)
The escape character is used to regain the attention of Kermit-MS.
When you type the escape character, Kermit-MS waits for you to follow it with a
single character command.  For instance, the single-@|character-@|command
@qq(?) produces a list of available single character commands, such as this:
@Begin(Description,leftmargin +6,indent -4, spread 0)
@q<?>@\Help -- prints the available single-@|character commands.

@q<C>@\Close the connection and return to Kermit-MS prompt level.

@q<S>@\Show the status of the connection.

@q<B>@\Send a BREAK signal to the port.

@q<0>@\(the digit zero) Send a NUL (ASCII 0) to the port.
 
@q<Q>@\Temporarily quit logging the remote session.

@q<R>@\Resume logging the remote session.
      
@q<M>@\Toggle the mode line, i.e. turn it off if it is on & vice versa.

@q<^]>@\(or whatever you have set the escape character to be)@\Typing the
escape character twice sends one copy of it to the connected host.
@End(Description)
Typing any other character (except the space bar, which is the "null
command") after the escape character will cause Kermit-MS to beep, but
will do no harm.  The escape character can be changed to something other
than Control-@|Rightbracket by using the SET ESCAPE command.

Kermit-MS includes several advanced features for use during terminal emulation,
including screen scroll, printer control, and key redefinitions.

@subheading(  Screen Scroll)

Kermit-MS provides several pages of screen memory, which may be
scrolled up and down using keys as follows:
@begin<format,leftmargin +2,above 1,below 1,longlines keep>
@tabclear()@tabset(2.0inches,3.2inches,5.0inches)
@ux(Function)    @\@ux(IBM PC/XT)@\@ux(Rainbow)@\@ux(HP-150)
Screen Down      @\PgDn     @\PrevScreen     @\Prev
Line Down        @\Ctrl-PgDn@\Ctrl-PrevScreen@\Shift-UpArrow
Screen Up        @\PgUp     @\NextScreen     @\Next
Line Up          @\Ctrl-PgUp@\Ctrl-NextScreen@\Shift-DownArrow
Top of Memory    @\Home
Bottom of Memory @\End
@end(format)
There is presently no way to assign these functions to other keys.

@subheading(  Printer Control)

A locally attached printer may be controlled in the normal manner, on most
systems.  Pushing the "Print Screen" key (shifted on some systems) will cause
the current contents of the screen to be printed or spooled; holding down CTRL
while depressing Print Screen will start or stop the spooling of incoming
characters to the printer.  @q(^P) or @q(^N) are sent to the host during
terminal emulation, and do not toggle printing, as they do when you're talking
directly to DOS.

CTRL-Print-Screen can be simulated with the Kermit-MS LOG PRN and CLOSE
commands.

@subheading(  Key Redefinitions)

Key redefinitions are useful for defining "keystroke macros" of login
sequences, frequently issued commands, and so forth, and for setting up the
terminal for use with host resident software designed to work with terminals
that send predefined sequences from their function keys.  For instance, here's
a key redefinition file for arranging the DEC Rainbow keyboard into the normal
ASCII keyboard layout:
@begin(example)
; Make shift-comma send a left angle bracket
set key scan 556
<
; Shift-period sends a right angle bracket
set key scan 558
>
; Accent grave is where ESC is supposed to be
set key scan 96
\33
; Put accent grave on the ESC function key
set key f11
`
@end(example)

@index(EMACS)@index(META Key)
The SET KEY facility may be used provide the PC with a "meta" key for use with
editors like EMACS or TVEDIT that can use "meta characters" as commands.  A
meta key is a shift key whose effect is to turn on the 8th (parity) bit of the
character.  For instance, on the IBM PC the scan codes produced by holding down
ALT together with other keys can be determined using SHOW KEY, and then 8-bit
ASCII equivalents with the 8th bit turned on can be defined using SET KEY; if
the scan code produced by typing ALT-a, i.e. the letter "a" (ASCII 141, octal)
with the ALT key held down, is 2078 (decimal), you would set the META
equivalent to 141+200=341 (octal), or @qq(\341) in octal SET KEY notation:
@begin(example)
Kermit-MS>@ux(sho key)
Press a key: @i(@ux<ALT-a>)
  Scan Code: 2078
  Definition:
Kermit-MS>@ux(set key scan 2078)
Definition String: @ux(\341)
@end(example)
Whenever you type ALT-a with this definition in effect, Kermit-MS will transmit
octal 341, rather than 141.

@Section<Installation of Kermit-MS>

@center(@i<by Bill Catchings, Columbia University>)

If you already have Kermit on your PC, you can use it to obtain new versions
of Kermit-MS when they appear on the central system at your site.  If you do
not have Kermit or any other reliable file capture facility on your PC, and
there is no one from whom you can borrow a floppy disk to copy Kermit, then you
should read the following instructions for initially "bootstrapping" Kermit-MS
from a mainframe where it is stored onto your microcomputer.

There are at least three methods of initially getting Kermit-MS onto your PC:
@begin(enumerate,spread 0.5)
Try again to find a copy on diskette.

Use another file capture facility to get it.

Type in and run a bootstrapping program.
@end(enumerate)

@subsection(Try Again To Find A Kermit Disk)

Before explaining how to bootstrap Kermit onto your PC, a disclaimer must
be made.  Although a fair amount of thought and time has gone into these
procedures, they are far from error free.  If they were foolproof, there
would be no need for a protocol such as Kermit.  There are many places
where things can go wrong, from something as simple as a typing mistake to
something as unavoidable and probably inevitable as a communications line
failure.  By far the easiest and best way to install Kermit is from a
floppy disk.  Before you embark on any of the following procedures it is a
good idea to check once again for a diskette to copy, even it it contains
an old version of Kermit.  The time you spend searching is likely to be
far less frustrating than the time you spend trying to bootstrap Kermit by
the methods described below.

@subsection(Bootstrapping From the Communication Line)

If you can't find a diskette with Kermit on it, there are two other methods
available for bootstrapping MS-DOS Kermit onto your PC.  The first method is to
use a file capture method or other file transfer protocol to transfer the file
to your PC.  Some systems come supplied with facilities like
this, and various public domain or commercial packages are available.
The second method requires you to type in your own downloading program.

In either case, you must transmit the file from the system
where it resides over a communication line and into your PC.  Since version 2
of MS-DOS Kermit is much larger than version 1, it comes with a new
bootstrapping procedure in which the executable program is encoded much more
compactly than in the earlier "fix" files.  The new encoding packs 3 @q(.EXE)
file bytes into 4 printable characters in the @q(MS@i<xxx>.BOO) file, and also
compresses adjacent zero bytes (of which there are many).  The @q(.BOO) file
contains only printable characters, to ensure that downloading can take place
regardless of parity or other peculariaries of the communication channel.

@paragraph(Use An Existing File Capture Facility)

In the rest of this discussion of bootstrapping, the host-@|resident boot
@q(.BOO) file will be referred to as @q(MSKERMIT.BOO).  In fact, the actual
name will depend on which MS-DOS system you are using -- @q(MSIBMPC.BOO) for
the IBM PC or XT, @q(MSRB100.BOO) for the Rainbow 100, etc.

Use your file capture facility, whatever it may be, to get the file
@q(MSKERMIT.BOO) onto your PC's disk, but first make sure you have enough room
for it.  Once the file is on your disk, you must run the BASIC program
@q(MSPCTRAN.BAS) to decode the file back into @q(KERMIT.EXE).  This program can
be downloaded by the same method you used with @q(MSKERMIT.BOO).  The program
looks on your current disk and directory for the file @q(MSKERMIT.BOO) and
outputs @q(KERMIT.EXE) to the same place.  @q(KERMIT.EXE) is about 80K
bytes, so make sure there is space for it on your disk or else you will have to
start the program over.  Since the program will take about twenty minutes
to completely translate the file you will want to avoid running it more than
once.

@paragraph(Type In Your Own Bootstrap)

If you can't find some method for downloading the @q(.BOO) file and the BASIC
program, the second way of bootstrapping Kermit is to use the programs
@q(MSPCBOOT.BAS) and @q(MSBOOT.FOR) to download via your PC's asynchronous port
from your host and translate it directly, "on the fly."  You run the program
@q(MSBOOT.FOR) on your host and then run the program @q(MSPCBOOT.BAS) in BASIC
on your PC.  The FORTRAN program sends the encoded @q(.EXE) file to the BASIC
program, which decodes it and stores it in executable form on your current
directory as @q(KERMIT.EXE).  A very rudimentary form of error checking is done
to allow obviously corrupted records to be retransmitted.  Follow this
procedure:
@Begin(Enumerate)
First, you must establish a connection from your PC to the host system.  A high
speed connection is preferable; a "clean" line is preferable to a noisy one.
In fact, a clean line is essential for this procedure.  You must be able to log
in to the host system over this connection.  If your PC already has a terminal
emulation facility, use that.  If not, you might need to put your PC next to a
real terminal and use that for logging in, then switch the connector to the PC
at the crucial moment.  If you are using a terminal, make sure the terminal and
PC have their communication ports set to the same speed.

Ensure that the files @q(MSBOOT.FOR) and @q(MSKERMIT.BOO) are present on the
host system.  @q(MSBOOT.FOR) is listed below, in case you need to type it in.

Get back to your PC and type in @q(MSPCBOOT.BAS) on your PC; a listing appears
below.  There is no need to type in the comments (anything following an
apostrophe); they are only there to clarify what the program is doing.  Check
very carefully for errors.  You should check line 80 in the program to see that
it reflects the way your system is actually set up.  If necessary, substitute
the correct baud rate for the supplied rate of 9600, and if you are not using
@q(COM1:) make that change as well.  If you are downloading from an IBM or
other half-@|duplex mainframe, leave line 1000 as it is; otherwise, replace it
by a RETURN statement.  If you type it in directly to BASIC make sure you save
the program before you run it, so you won't have to type it in again in case of
error.

Get back to your host system and 
compile @q<MSBOOT.FOR>, if it needs compiling.
Define logical unit numbers 5 and 6 to be the controlling terminal, and logical
unit 7 to be the file @q<MSKERMIT.BOO>.  On VAX/VMS systems, for example, use
these commands:
@begin<example>
$@ux(assign sys$input for005)
$@ux(assign sys$output for006)
$@ux(assign mskermit.boo for007)
@end<example>
On a DECSYSTEM-20, do:
@begin<example>
@@@ux<define 5: tty:>
@@@ux<define 6: tty:>
@@@ux<define 7: mskermit.boo>
@end<example>
On a DECsystem-10, do something like this:
@begin<example>
.@ux<assign tty: 5:>
.@ux<assign tty: 6:>
.@ux<assign dsk: 7:>
.@ux<rename for007.dat=mskerm.boo>
@end<example>
On an IBM system under VM/CMS, do this:
@begin<example>
.@ux<filedef 5 term ( lrecl 80 recfm v>
.@ux<filedef 6 term ( lrecl 80 recfm v>
.@ux<filedef 7 disk mskermit boo ( lrecl 77 recfm f perm>
@end<example>

Set your host system up for downloading:
@Begin(Itemize)
Ensure that your terminal does not automatically pause at the end of a
screenful of output.  For instance, on a DEC-20 you would issue the
command "terminal no pause end-of-page".

Do whatever you can to disable messages from appearing at your terminal while
these programs are running.  This would include messages from other users, mail
notification, alarms or alerts, system messages, and so forth.  Such messages
will interfere with the procedure, and probably render the result useless.

You should put your host terminal in "local echo" or "half duplex" mode, if
possible.
@End(Itemize)

Start the @q(MSBOOT) program on your host system.

Get back to the PC.  If you have been using a terminal, switch the connector
to the PC.

Now run the BASIC program, @q(MSPCBOOT.BAS).  This procedure will take at least
twenty minutes and possibly longer depending on line speed.  Watch your modem
and/or disk lights for reassurance that something is happening.
@End(Enumerate)

By using one of these installation methods, you should now have a working
version of Kermit.  If you experience any problems or quirky behavior with the
program, it's possible that some part of it was corrupted during the
downloading procedure.  Perhaps enough usable code remains to allow you to
transfer @q(MSKERMIT.EXE) from the host.  If not, you will have to repeat the
downloading procedure.

Once you have Kermit-MS on your disk, you should make the disk available to
other users for copying, so that they can be spared the tedium of this
bootstrap procedure.

Here is a listing of @q(MSPCBOOT.BAS).  The "outdented" PRINT statements with
line numbers ending in 5 may be included if you want incoming records to be
displayed on the screen.  You don't need to include the comments.
@Begin(Example,leftmargin +0,longlines keep)
@include(KER:MSPCBOOT.BAS)
@End(Example)

@begin(text,need 15,above 2)
Here is a listing of @q(MSBOOT.FOR), in case you can't find it on your host
system: 
@end(text)
@Begin(Example,leftmargin +0,longlines keep)
@include(KER:MSBOOT.FOR)
@End(Example)

@Section<Compatibility with Older Versions of MS-DOS Kermit>

@label<-msdosnew>
MS-DOS Kermit supports many different systems.  Like CP/M-80 KERMIT, this
support was added to the program piecemeal, at many sites, using conditional
assembly.  However, before allowing the program to grow into a complicated
monolith like CP/M-80 KERMIT, we have broken the program up into separate
modules, with system dependencies isolated into a single module consisting of
compact collections of low-@|level primitives for console and port i/o.

The last monolithic (single source file) release of MS-DOS Kermit was 1.20.
To this and earlier versions was added support for systems like the Seequa
Chameleon, the Tandy 2000, the Victor 9000, the Heath/@|Zenith 100, and others.
Eventually, support for these systems may be integrated with the new
modular version.  Meanwhile, implementations based on these old versions will
have at least the following incompatibilies from the version described here:
@begin<itemize,spread 0.2>
RECEIVE @i<filespec> is used instead of GET @i<filespec>.  There is no GET
command in older versions, and no way to specify a new name for an incoming
file. 

No LOCAL or REMOTE commands.

No 8th-bit prefixing, repeat counts, CRCs or 2-character checksums.

No TAKE or initialization files.

No command macros or command line arguments.

No terminal session logging.
@end<itemize>
and others, depending on the specific version.

@Section(What's Missing)

Kermit-MS has plenty of room for improvement.  Features that need to be
improved or added include:
@begin(itemize)
A built-in facility for sending files "raw" to the remote system, obeying
current settings for parity, flow control, handshake, and so forth.  This might
include a script interpretation facility to allow remote sessions to be
conducted automatically.  For the present, this can be accomplished with a
user-@|supplied program invoked with the Kermit-MS RUN command.

Additional functionality when running in server mode -- directory listings,
file deletion, execution of DOS commands, etc.

More commands when talking to remote servers -- REMOTE RENAME, COPY, STATUS,
WHO, etc.

Filename conversion options (normal form, handling of fully qualified
filespecs, etc.).

Transaction file logging.

Improved command parsing; for instance, accept default values for omitted
trailing fields.

A better built-in help facility.

Support for Kermit file attribute packets.

The Kermit-MS program is quite large.  Much of the size is due to the
deliberate decision to provide support for versions of MS-DOS prior to 2.0.
At some point, this support should be removed.  This will not only reduce the
size of the program considerably, but also provide much more flexibility.
@end(itemize)

@Section<Program Organization>

Kermit-MS version 2 is composed of separate assembler source files, assembled
separately, and linked together.  The modules are:

@i(System/Device Independent:)
@begin(description,leftmargin +16,indent -12,spread 0)
@Q(MSKERM.ASM)@\Main program

@Q(MSSEND.ASM)@\File sender

@Q(MSRECV.ASM)@\File receiver

@Q(MSSERV.ASM)@\Server operation

@Q(MSFILE.ASM)@\File i/o

@Q(MSCMD.ASM)@\Command parser

@Q(MSTERM.ASM)@\CONNECT command

@Q(MSCOMM.ASM)@\Communications port buffering & flow control

@Q(MSSET.ASM)@\SET, SHOW, and STATUS commands

@Q(MSDEFS.H)@\Data structure definitions and equates
@end(description)
@i(System/Device Dependent:)
@begin(description,leftmargin +16, indent -12, spread 0)
@Q(MSX@i<xxx>.ASM)@\System-dependent code for system @i(xxx)

@Q(MSY@i<xxx>.ASM)@\System-dependent screen and keyboard code

@Q(MSZ@i<xxx>.ASM)@\Modem control (modem-dependent)
@end(description)
The modular organization allows easier modification of the program,
quicker transfer of modified portions from system-to-system.  The modules
are designed to be well-defined and self-contained, such that they can
be easily replaced.  For instance, someone who prefers windows and mice
to typing commands could replace the command parsing module without having
to worry about the effect on the other modules.

To assemble any of the kermit modules, file @q(MSDEFS.H) must be on the
default disk. 

All the Kermit implementations require the modules
MSCMD, MSCOMM, MSFILE, MSKERM, MSRECV, MSSEND, MSSERV, MSSET, MSTERM.

The IBM PC version requires MSXIBM and MSYIBM as well.

The Rainbow version requires MSXRB and MSXDMB; MSXDMB must be the first
object file given to the linker for Kermit to link properly for the Rainbow.

The HP150 version requires MSXHP150, the Wang version requires MSXWNG,
and the generic version requires MSXGEN.

Once all the required object modules exist, they may be linked together
to produce Kermit.  For example, on the Rainbow:
@begin(example)
A>@ux(link)

   Microsoft Object Linker V2.00
(C) Copyright 1982 by Microsoft Inc.

Object Modules [.OBJ]: @ux(msxdmb mskerm msxrb mscomm msset mssend +)
@ux(msrecv msserv msfile msterm mscmd)
Run File [MSXDMB.EXE]: @ux(kermit)
List File [NUL.MAP]: @ux(kermit)

A>
@end<example>

@Section<Adding Support For New Systems>

You can bring Kermit-MS to systems that are not explicitly supported in one of
two ways -- attempt to run the "generic" MS-DOS Kermit on it, or add explicit
code to support your system.

@subsection<Generic MS-DOS Kermit>

@Index<Generic MS-DOS Kermit>
To get started with Kermit on a new system, try running "generic" MS-DOS
Kermit; in many cases, it will run as is.  The generic version accomplishes all
its port and console i/o through DOS calls, and during terminal connection does
not attempt to emulate any particular kind of terminal.  In some cases, the
generic version may still require some fiddling to run on a new system; for
instance, different systems refer to their communication ports in different
ways -- COM1, AUX, etc.  It attempts to do this automatically by trying
various DOS file handles for the communication port, and asking you to
supply one if it does not succeed.

Generic MS-DOS Kermit will probably run no faster than 1200 baud, and it
only works with DOS 2@q<.>0 or later.

@subsection<Adding System-Dependent Code>

The following is a guide to the system dependent module of Kermit-MS.

@include(KER:MSXSYS)

@Section(Heath/Zenith-19 Control Codes)
@label(-h19codes)@index(Heath-19 Terminal Emulation)

The Heath/Zenith-19 terminal is equivalent to the DEC VT52 with extensions
for line and character insertion and deletion.  Items marked with an asterisk
are not currently supported by Kermit-MS H19 emulation.

@begin<format,leftmargin +2,above 1,below 1>
@tabclear()@tabset(1.2inches,2.4inches)
@subheading(Cursor Functions)
@u(Sequence@\Mnemonic@\Definition)
 ESC H@\HCUH@\Cursor Home
 ESC C@\HCUF@\Cursor Forward
 ESC D@\HCUB@\Cursor Backward
 ESC B@\HCUD@\Cursor Down
 ESC A@\HCUU@\Cursor Up
 ESC I@\HRI@\Reverse Index
*ESC n@\HCPR@\Cursor Position Report
*ESC j@\HSCP@\Save Cursor Position
*ESC k@\HRCP@\Set Cursor to Previously Saved Position
 ESC Y@\HDCA@\Direct Cursor Addressing, 1-based:
           @\@\31+line# 31+col# (same as VT52)
@hinge
@subheading(Erasing and Editing)
@u(Sequence@\Mnemonic@\Definition)
 ESC E@\HCD@\Clear Display (Shift Erase)
 ESC b@\HBD@\Erase Beginning of Display
 ESC J@\HEOP@\Erase to End of Page (Erase Key)
 ESC l@\HEL@\Erase Entire Line
 ESC o@\HEBL@\Erase Beginning of Line
 ESC K@\HEOL@\Erase to End of Line
 ESC L@\HIL@\Insert Line
 ESC M@\HDL@\Delete Line
 ESC N@\HDCH@\Delete Character
 ESC @@@\HEIM@\Enter Insert Character Mode
 ESC O@\HERM@\Exit Insert Character Mode
@hinge
@subheading(Configuration)
@u(Sequence@\Mnemonic@\Definition)
*ESC z@\HRAM@\Reset to Power-Up Configuration
*ESC r Bn@\HMBR@\Modify Baud Rate: Bn=
@\@\  A=110,  B=150,  C=300, D=600,  E=1200,
@\@\  F=1800, G=2000, H=2400, I=3600, J=4800,
@\@\  K=7200, L=9600, M=19200
@hinge
*ESC x Ps@\HSM@\Set Mode(s): Ps=
@\@\  1 = Enable 25th line
@\@\  2 = No key click
@\@\  3 = Hold screen mode
@\@\  4 = Block cursor
@\@\  5 = Cursor off
@\@\  6 = Keypad shifted
@\@\  7 = Alternate keypad mode
@\@\  8 = Auto line feed on CR
@\@\  9 = Auto CR on line feed
@hinge
*ESC y Ps@\HRM@\Reset mode(s): Ps=
@\@\  1 = Disable 25th line
@\@\  2 = Enable key click
@\@\  3 = Exit hold screen mode
@\@\  4 = Underscore cursor
@\@\  5 = Cursor on
@\@\  6 = Keypad unshifted
@\@\  7 = Exit alternate keypad mode
@\@\  8 = No auto line feed
@\@\  9 = No auto CR

*ESC <@\HEAM@\Enter ANSI Mode
@hinge
@subheading(Modes of Operation)
@u(Sequence@\Mnemonic@\Definition)
*ESC [@\HEHS@\Enter Hold Screen Mode
*ESC \@\HXHS@\Exit Hold Screen Mode
 ESC p@\HERV@\Enter Reverse Video Mode
 ESC q@\HXRV@\Exit Reverse Video Mode
*ESC F@\HEGM@\Enter Graphics Mode
*ESC G@\HXGM@\Exit Graphics Mode
*ESC t@\HEKS@\Enter Keypad Shifted Mode
*ESC u@\HXKS@\Exit Keypad Shifted Mode
*ESC =@\HAKM@\Enter Alternare Keypad Mode
*ESC >@\HXAM@\Exit Alternate Keypad Mode
@hinge
@subheading(  Additional Operations)
@u(Sequence@\Mnemonic@\Definition)
*ESC }@\HDK@\Keyboard Disable
*ESC {@\HEK@\Keyboard Enable
 ESC v@\HEWA@\Wrap Around at End of Line
 ESC w@\HXWA@\Discard at End of Line
 ESC Z@\HID@\Identify as VT52 (ESC / K)
*ESC ]@\HX25@\Transmit 25th Line
*ESC #@\HXMP@\Transmit Page
@begin(text,above 1, below 1)
@i(The Heath-19 transmits the following sequences, but it will not
respond to them if they are received.  Kermit-MS will transmit them
only if they are programmed with SET KEY.)
@end(text)
 ESC S@\HF1@\Function Key #1
 ESC T@\HF2@\Function Key #2
 ESC U@\HF3@\Function Key #3
 ESC V@\HF4@\Function Key #4
 ESC W@\HF5@\Function Key #5
 ESC P@\HF7@\Function Key #7
 ESC Q@\HF8@\Function Key #8
 ESC R@\HF9@\Function Key #9
@end(format)
