@make(manual)
@Style<Justification On, Hyphenation On, WidestBlank 1.4, Spacing 1,
        Spread 1, Indent 0, HyphenBreak Off, SingleSided>
@modify(hd1,spacing 2,above 1,below 1)
@modify(hd2,spacing 2,above 1,below 1)
@modify(hd3,spacing 2,above 1,below 1)
@modify(hd4,spacing 2,above 1,below 1)
@PageHeading<Center "">

@tabclear
@tabs(12,42,54)
@begin(Titlepage)
@begin(Titlebox)
@majorheading(KERMIT-65 USERS GUIDE)
@heading(C64 Version 1.0
Beta Test)
@end(Titlebox)
@begin(heading)
Compiled By:
Eric Lavitsky
@value(Date)

Center For Computer and Information Services
Rutgers University
Piscataway, New Jersey
@end(heading)
@end(titlepage)

@newpage(1)
@set(page=1)
@PageHeading(Even,Left="Page @ref(page)",Right="@b<C64 KERMIT User Guide>")
@PageHeading(Odd,Left="@b<@Title[Chapter]>",Right="Page @ref(page)")

@chapter(Introduction)
@section(Overview)

KERMIT-65 is a program that implements the KERMIT file transfer
protocol for the Commodore 64 micro computer system. It is written
in 6502 assembly language and should run on any C64. KERMIT-65 also
Converts your C64 into a powerful computer terminal. It emulates the
popular Digital Equipment Corporation VT52 terminal or a simple
glass TTY. 

C64 Kermit-65 was translated by Dave Dermott from the original
Apple version 1.0 by Antonio J. Mione. Several enhancements and bug
fixes including many from Apple version 2.1 were added by Eric Lavitsky.

@i<C-64 Kermit-65 Capabilities At A Glance:>
@begin<format,leftmargin +2>
@tabclear()@tabset(3.5inches,4.0inches)
Local operation:@\Yes
Remote operation:@\No
Transfers text files:@\Yes
Transfers binary files:@\No?
Wildcard send:@\No
^X/^Y interruption:@\No
Filename collision avoidance:@\No
Can time out:@\No
8th-bit prefixing:@\No?
Repeat count prefixing:@\No
Alternate block checks:@\No
Terminal emulation:@\Yes (VT52)
Communication settings:@\Yes; local echo, parity
Transmit BREAK:@\Yes
IBM communication:@\Yes?
Transaction logging:@\No
Session logging (raw download):@\No
Raw upload:@\No
Act as server:@\No
Talk to server:@\Yes
Advanced commands for servers:@\No
Local file management:@\Yes
Handle file attributes:@\No
Command/init files:@\No
Printer control:@\No
@end(format)

@tabs(12,42,54)
@section(System Requirements)

What you will need:
@begin(itemize, spread 0)

C64 and Disk drive

Modem - any will do (300/1200, VIC, RS232)

Supermon64.V1	(or any equivalent relocatable monitor)

@end(itemize)

@chapter(Known Bugs, Deficiencies)


KERMIT-65 is currently missing some features which exist in Apple
KERMIT-65. There are also some restrictions which apply.

	The differences and restrictions are as follows:
@begin(itemize,spread 0)

 IBM mode is not supported.

 The FILE-WARNING option is not implemented. If a file already
exists, a fatal error occurs.

 The SET PARITY option is not implemented. Parity must be set with
SET RS232-REGISTERS.
@end(itemize)

@section(HINTS)


  If you wish to  edit BASIC programs on  the mainframe system,  you
should convert them to  text files on the  C64 before you send  them
since the  BASIC interpreters  store  keywords as  single  character
tokens. If the receiving system does not handle eight-bit ASCII or
CBM ASCII characters well, KERMIT-65 should have its FILE-BYTE-SIZE
set to SEVEN-BIT. It will send standard seven-bit ASCII to the
receiving KERMIT. When KERMIT-65 is receiving from such a system,
this will pick up the seven-bit characters and write out CBM ASCII
on the disk file.

@chapter(Running KERMIT)
@section(Booting KERMIT)

Insert your working KERMIT-65 disk into the 1541 drive label side up.
Type the following:
@begin(verbatim)

	LOAD"KERMIT",8 <cr>
	RUN <cr>
@end(verbatim)

 The screen will come up with the following message:

@begin(format)

@\@b[C64 Kermit-65 V1.1 40 Column Mode]

@\@b[Kermit-65>]

@end(format)

 You are now in the KERMIT-65 parser which is modeled after the COMND parser
of the TOPS-20 Operating System from Digital Equipment Corporation. You may
now type commands to the parser to set options or begin actions.

During interactive operation, you may use the ?-prompting help feature
("?") and recognition (ESC) features while typing commands.  A
question mark typed at any point in a command displays the options available at
that point; typing an ESC character causes the current keyword to
be completed (or default value to be supplied).  If you have not
typed sufficient characters to uniquely specify the keyword or filename (or if
there is no default value) then a beep will be sounded and you may continue
typing. Keywords may be abbreviated to any prefix that is unique.

@section(Commands in KERMIT)

Commands available in version 1.1 of Kermit-65 are:
@tabclear
@tabdivide(7)
@begin(format)
@b[
@\BYE@\CONNECT@\DOS@\EXIT@\FINISH@\GET
@\QUIT@\RECEIVE@\SEND@\SET@\SHOW@\STATUS]
@end(format)

@begin(description)
@b[BYE]@\@\    This command will cause  Kermit-65  to tell a server Kermit
          at the other end of the connection to exit from Kermit and,
          if applicable, terminate its job (or  process, etc.).  When
          Kermit-65  receives the acknowledgement that this is  being
          done, it will exit to DOS.


@begin(center)                     
@b[KERMIT-65>]BYE
@end(center)

@end(description)
@begin(description)
@b[CONNECT]@\@\The  CONNECT  command will allow you to connect to a  remote
          job over the terminal line as a virtual terminal. The format
          of the CONNECT command is:


@begin(center)
@b[KERMIT-65>]CONNECT
@end(center)

@end(description)

@begin(description)
DOS@\@\The DOS command will invoke a separate parser to allow the
sending of commands to the disk drive. The format is:

@begin(center)
@b[KERMIT-65>]DOS
@end(center)

@\Commands are in standard DOS format as decribed in the disk manual.
They include $ for directory (note block counts are in hex!), S to
scratch files. A blank line (RETURN) will display the disk error
status if any. Enter Q to return to KERMIT.  eg:

@tabclear
@tabdivide(9)
@begin(format)
@\@\@b[DOS>]$KER*@\-- directory of ker* files
@\@\@b[DOS>]S0:a*@\-- delete files A* 
@\@\@b[DOS>]Q@\-- returns to KERMIT     
@end(format)
@tabdivide(7)

@end(description)

@begin(description)
EXIT@\@\The EXIT command will cause Kermit to return to BASIC command
level. This command is the same as the QUIT command. An example of
this command is: 

@begin(center)
@b[KERMIT-65>]EXIT
@end(center)

@end(description)
@begin(description)
@b[FINISH]@\@\This command will cause  Kermit-65  to tell a server Kermit
          at  the  other end of the connection to exit  from  Kermit.
          When  Kermit-65  receives the acknowledgement that  this is
          being done, Kermit-65 will prompt for another command.


@begin(center)
@b[KERMIT-65>]FINISH
@end(center)

@end(description)
@begin(description)
@b[GET]@\@\   This command can only be used in 'user' mode.  It will cause
          Kermit-65  to  request  that the other Kermit (which must be
          running  in  server mode)  transmit  the  specifed  file  to
          Kermit-65.


@begin(center)
@b[KERMIT-65>]GET file-specification
@end(center)

@\@\Where "file-specification"  is a  valid file  specification for  the
system on which the other Kermit is running.
@end(description)

@begin(description)
@b[QUIT]@\@\  This command will cause Kermit-65 to return to BASIC command
          level. This is the same as the EXIT command.


@begin(center)
@b[KERMIT-65>]QUIT
@end(center)


@end(description)
@begin(description)
@b[RECEIVE]@\@\The RECEIVE command is used to  put  Kermit-65  into  remote
          mode  waiting for a single file transfer transaction.  If no
          file specification is given, Kermit-65 will wait for a  file
          transfer  initialization sequence from the other Kermit.  If
          a file specification is given, that file specification  will
          be  used  to  store the received file(s), regardless of what
          name is supplied by the other Kermit.


@begin(center)
@b[KERMIT-65>]RECEIVE
@end(center)

          or

@begin(center)
@b[KERMIT-65>]RECEIVE file-specification
@end(center)

@\@\Where "file-specification" is any valid  CBM  DOS  file specification.
@end(description)

@begin(description)
@b[SEND]@\@\  The  SEND  command will allow you  to send  a  file  to  the
          other  Kermit.  The command format is:


@begin(center)
@b[KERMIT-65>]SEND file-specification
@end(center)

@\@\Where "file-specification" is any normal CBM DOS file specification.
@end(description)

@begin(description)
@b[SET]@\@\   The SET command is used to set various parameters in Kermit.
          The format of the command is:


@begin(center)
@b[KERMIT-65>]SET <option> <suboption> ...
@end(center)

@\@\The options available to SET are:
@end(description)

@begin(format)
@tabclear
@tabdivide(4)
@b[
@\DEBUGGING@\EIGHT-BIT-QUOTING@\ESCAPE
@\FILE-BYTE-SIZE@\FILE-TYPE@\FILE-WARNING
@\IBM@\LOCAL-ECHO@\PARITY
@\RECEIVE@\RS232-REGISTERS@\SEND
@\VT52-EMULATION]
@end(format)
@tabclear
@tabdivide(7)

@\@\A description of the options and suboptions follows.

@begin(description)
@b[SET DEBUGGING]@\@\The SET DEBUGGING command is used to set  the
debug  type  out on the user's terminal. 


@begin(center)
@b[KERMIT-65>]SET DEBUGGING keyword
@end(center)

@\@\Where keyword is either OFF, TERSE, or VERBOSE.  OFF  causes
all debugging output to be suppressed.  TERSE directs a copy
of each packet to the screen printing any control characters
as '^char'.  VERBOSE  prints identifying text for each field
in the header  and  prints the actual data  section  of  the
packet in the same manner TERSE uses.
@end(description)

@begin(description)
@b[SET EIGHT-BIT-QUOTING]@\This  command  will turn on or turn  off  the
          eight-bit-quoting feature.  If set ON,  it forces  Kermit-65
          to  use  eight-bit-quoting  which may be handy  if  it  must
          receive  a text file in which some or all of the  characters
          are  not in CBM ascii.  The command takes  ON or OFF as
          options.

@end(description)
@begin(description)
@b[SET ESCAPE]@\@\ This command will set  the  escape  character
          for  the CONNECT processing.  The command will take the  hex
          value of the character to use as the escape character.  This
          is the character which is used to "escape" back to KERMIT-65
          after using the CONNECT command. It defaults to ^@ (hex 00).
          It is usually a good idea to set this character to something
          which is not used  (or at least not used very much)  on  the
          system to which KERMIT-65 is CONNECTing.


@begin(center)
@b[KERMIT-65>]SET ESCAPE hex-character-value
@end(center)

@\@\Where   hex-character-value  is  the  ASCII  value  of   the
character to use as the escape character (in hex).
@end(description)

@begin(description)
@b[SET FILE-BYTE-SIZE]@\This command sets  the  byte  size  KERMIT-65
          will use for files being received or transmitted.  SEVEN-BIT
          bytes should be used for ASCII text files which  are  to  be
          used  as text files on the  CBM  DOS system. EIGHT-BIT bytes
          should  be  used for binary files being transferred  to  and
          from the  C64.  This  allows the file to be returned without
          any changes.


@begin(center)
@b[KERMIT-65>]SET FILE-BYTE-SIZE size
@end(center)

@\@\Where size is SEVEN-BIT or EIGHT-BIT.
@end(description)

@begin(description)
@b[SET FILE-TYPE]@\This  command tells Kermit-65 what type of  file
          is  being  sent  or  received.  It is  important  that  this
          parameter  is  set correctly since it is used  to  determine
          the  exact  file  length when sending files in  addition  to
          determining  special  processing which may have to  be  done
          (i.e.  When  receiving a text  file,  write  all  characters
          in CBM ASCII.). The format of this command is:


@begin(center)
@b[KERMIT-65>]SET FILE-TYPE type
@end(center)

@\@\Where type is ASCII, BINARY, PETASCI or SCRIPT. BINARY is  a
core image (and is normally transferred in eight-bit mode). ASCII 
is any file of ASCII text. PETASCI is a CBM ASCII file. SCRIPT is a
file produced by the SPEEDSCRIPT wordprocessor, which was published
in the Gazzette! Magazine.
@end(description)

@begin(description)
@b[SET FILE-WARNING]@\This command determines what  KERMIT-65  will
          do  when  it  receives  a file with a file name that already
          exists.  If FILE-WARNING is turned ON,  KERMIT-65  will  not
          supersede  the old file.  Instead it will create a file with
          the original file name plus a '.0' appended to it.  It  will
          increment the 'version' number until it succeeds in creating
          a  unique file name.  If  FILE-WARNING  is turned  OFF  (the
          default), Kermit-65 will supersede the old file.


@begin(center)
@b[KERMIT-65>]SET FILE-WARNING keyword
@end(center)

@\@\Where keyword is either ON or OFF. (This option does not work in
this version of Kermit).
@end(description)

@begin(description)
@b[SET IBM]@\@\The  SET IBM  command  allows  KERMIT-65   to
          be  put  into  a  mode  which will allow transfers to an IBM
          host.  This causes KERMIT-65 to wait for the IBM  turnaround
          character (XON, CTRL-Q) before sending any characters to the
          other Kermit.  It also forces the parity type  to  be  mark,
          and turns on local echo for the CONNECT command.


@begin(center)
@b[KERMIT-65>]SET IBM keyword
@end(center)

@\@\Where keyword is either ON or OFF.
@end(description)

@begin(description)
@b[SET LOCAL-ECHO]@\ The SET LOCAL-ECHO command specifies  whether
          characters  should  be  echoed  locally  when  CONNECTing to
          another system.  If LOCAL-ECHO is set to ON,  any  character
          typed  on  the  terminal  will  be echoed immediately to the
          terminal, as well as being sent to  the  other  system.   If
          LOCAL-ECHO is set to OFF (the default), the characters typed
          on the terminal are only sent to  the  other  system  (which
          would normally be echoing the characters).


@begin(center)
@b[KERMIT-65>]SET LOCAL-ECHO keyword
@end(center)

@\@\Where keyword is either ON or OFF.
@end(description)

@begin(description)
@b[SET PARITY]@\@\      This command determines the type of parity to
          use   on   the  transmission  line.   Kermit  normally  uses
          characters which consist of eight data bits with  no  parity
          bit.   For  systems  or  transmission  media which require a
          specific parity type, Kermit can send  characters  as  seven
          data bits plus a parity bit.


@begin(center)
@b[KERMIT-65>]SET PARITY keyword
@end(center)

@\@\Where keyword is one of:

@begin(enumerate)
@b[NONE] (default) - eight data bits and no parity bit.

@b[MARK] - seven data bits with the parity bit set to one.

@b[SPACE] - seven data bits with the parity bit set to zero.

@b[EVEN] - seven data bits with the parity bit set  to  make
the overall parity even.

@b[ODD] - seven data bits with the parity bit  set  to  make
the overall parity odd.
@end(enumerate)

Note that this command currently does not actually set the parity.
You must use SET RS232-REGISTERS to manually select communication
settings. 
@end(description)

@begin(description)
@b[SET RECEIVE]@\@\     It is  possible  to  set  various  parameters
          associated  with  the  receiving of the data from the remote
          Kermit.  SET RECEIVE will enable  you  to  set  the  various
          receive parameters.

@\@\The suboptions of this SET command are:

@end(description)

@begin(format)
@tabclear
@tabdivide(6)
@b[
@\EIGHT-BIT-QUOTE-CHAR@\END-OF-LINE@\PACKET-LENGTH
@\PAD-CHAR@\@\PADDING@\QUOTE-CHAR
@\TIMEOUT]
@end(format)
@tabclear
@tabdivide(7)

@begin(description)
@b[SET RECEIVE EIGHT-BIT-QUOTE-CHAR]@\ This    command    sets    the
          character  to  be  used (when necessary) to quote characters
          which have the eighth bit (parity bit) set.  This is used to
          transfer eight-bit bytes on a transmission medium which only
          supports seven data bits.  The default value  is  26  (ASCII
          "&").  Eight-bit-quoting  will only be used if both Kermit's
          can handle it, and the tranmission medium does not  transmit
          8 data bits (as indicated by the SET PARITY command).

@blankspace(1 line)
@begin(center)
@b[KERMIT-65>]SET RECEIVE EIGHT-BIT-QUOTE-CHAR nn
@end(center)

@\@\Where  nn  is the ASCII value of the character  (in hex)  to
use for quoting characters which have the eighth bit set.
@end(description)

@begin(description)
@b[SET RECEIVE END-OF-LINE]@\This will set the end of line  character that
          KERMIT-65  expects  to receive from the remote Kermit.  This
          is the character which terminates  a  packet.   The  default
          value is 0F (ASCII CR, CTRL-M).

@blankspace(1 line)
@begin(center)
@b[KERMIT-65>]SET RECEIVE END-OF-LINE nn
@end(center)

@\@\Where nn is the ASCII value of the character to use for  the
end of line character (in hex).
@end(description)

@begin(description)
@b[SET RECEIVE PACKET-LENGTH]@\       This  will  set  the   receive
          packet length.  The value for this parameter must be between
          10 and  96.   Packet  lengths  outside  of  this  range  are
          illegal.  The default value is 5E (94 decimal).

@blankspace(1 line)
@begin(center)
@b[KERMIT-65>]SET RECEIVE PACKET-LENGTH nn
@end(center)

@end(description)
@begin(description)
@b[SET RECEIVE PAD-CHAR]@\This parameter is the padding character  that
          is expected from the remote Kermit.  The parameter must be a
          hex  number  in the range of  0  to  1F  or  7F.  All  other
          values are illegal.  The default value is 0 (an ASCII NUL).

@blankspace(1 line)
@begin(center)
@b[KERMIT-65>]SET RECEIVE PAD-CHAR nn
@end(center)

@\@\Where nn is the  ASCII value of  the character to be  used as a  pad
character (in hex).
@end(description)

@begin(description)
@b[SET RECEIVE PADDING]@\This command will set the number  of  padding
          characters that will be expected from the other Kermit.  The
          default value is 0.

@blankspace(1 line)
@begin(center)
@b[KERMIT-65>]SET RECEIVE PADDING nn
@end(center)

@\@\Where nn is the hex number of padding characters to use.
@end(description)

@begin(description)
@b[SET RECEIVE QUOTE-CHAR]@\This will  set  the  quoting  character  that
          KERMIT-65  will  expect  on  incoming messages.  This is the
          character used to quote  control  characters.   The  default
          value is 23 (ASCII "#").

@blankspace(1 line)
@begin(center)
@b[KERMIT-65>]SET RECEIVE QUOTE-CHAR nn
@end(center)

@\@\Where  nn is the ASCII value of the  quoting  character  (in hex).
@end(description)

@begin(description)
@b[SET RECEIVE TIMEOUT]@\This  will set the number  of  seconds  after
          which  KERMIT-65  is requesting a timeout  from  the  remote 
          Kermit. This time out is used to handle  transmission errors
          which  totally  lose  a  message.  The  default value is  15
          seconds.

@blankspace(1 line)
@begin(center)
@b[KERMIT-65>]SET RECEIVE TIMEOUT nn
@end(center)

@\@\Where nn is the number of seconds to wait for a message (in hex).
@end(description)

@begin(description)
@b[SET RS232-REGISTERS]@\This sets the 2 registers for controlling
the baud rate, parity etc. The 2 registers are treated as a 16 bit
hex integer. The first 2 digits are the SECOND register and the last
2 digits are the FIRST register. If only 2 digits are entered, the
second register is cleared. Examples:

@blankspace(1 line)
@\@b[KERMIT-65>]SET RS232-REGISTERS 0006 (or SET RS 06) sets the
registers to 06,00 for 300 baud, 8 bit, no parity (this is the default)

@\@b[KERMIT-65>]SET RS232-REGISTERS A026 sets the registers to 26,A0
for 300 baud, 7 bit, parity mark.


@\See the C64 reference manual for a complete description of all
the bits in the 2 registers. 
@end(decription)

@begin(description)
@b[SET SEND]@\@\It is possible to set various parameters associated with the
          sending  of  data  to  the  remote  Kermit.  SET  SEND  will
          enable you  to  set  the  various  SEND  parameters.   These
          parameters  should not normally be set since, as part of the
          transfer initialization process, the  two  Kermits  exchange
          their  RECEIVE  parameters.  The capability of setting these
          parameters is provided so that the  transfer  initialization
          can  be  completed  even  if  the default parameters are not
          correct.

@\@\The suboptions of this SET command are:

@end(description)

@begin(format)
@tabclear
@tabdivide(6)
@b[
@\EIGHT-BIT-QUOTE-CHAR@\END-OF-LINE@\PACKET-LENGTH
@\PAD-CHAR@\@\PADDING@\QUOTE-CHAR
@\TIMEOUT
]
@end(format)
@tabclear
@tabdivide(7)

@begin(description)
@b[SET SEND EIGHT-BIT-QUOTE-CHAR]@\    This    command    sets    the
          character  to  be  used (when necessary) to quote characters
          which have the eighth bit (parity bit) set.  This is used to
          transfer eight-bit bytes on a transmission medium which only
          supports seven data bits.  The default value  is  26  (ASCII
          "&").  Eight-bit-quoting  will only be used if both Kermit's
          can handle it, and the tranmission medium does not  transmit
          8 data bits (as indicated by the SET PARITY command).

@blankspace(1 line)
@begin(center)
@b[KERMIT-65>]SET SEND EIGHT-BIT-QUOTE-CHAR nn
@end(center)

@\@\Where  nn  is the ASCII value of the character  (in hex)  to
use for quoting characters which have the eighth bit set.
@end(description)

@begin(description)
@b[SET SEND END-OF-LINE]@\This will set the end of line  character that
          KERMIT-65  will  send  to  the  remote  Kermit.  This is the
          character which terminates a packet.  The default  value  is
          0F (ASCII CR, CTRL-M).

@blankspace(1 line)
@begin(center)
@b[KERMIT-65>]SET SEND END-OF-LINE nn
@end(center)

@\@\Where nn is the ASCII value of the character to use  for the
end of line character (in hex).
@end(description)

@begin(description)
@b[SET SEND PACKET-LENGTH]@\This will set the send  packet  length.   The
          value  for this parameter must be between 10 and 96.  Packet
          lengths outside of this  range  are  illegal.   The  default
          value is 5E (94 decimal).

@blankspace(1 line)
@begin(center)
@b[KERMIT-65>]SET SEND PACKET-LENGTH nn
@end(center)

@end(description)
@begin(description)
@b[SET SEND PAD-CHAR]@\This parameter is the padding character  that
          is  sent  to  the  remote  Kermit.  The parameter must be an
          hex  number in the range of  0  to  1F  or  7F.   All  other
          values are illegal.  The default value is 0 (an ASCII NUL).

@blankspace(1 line)
@begin(center)
@b[KERMIT-65>]SET SEND PAD-CHAR nn
@end(center)

@\@\Where nn  is the ASCII value of the character to be used  as
a pad character (in hex).
@end(description)

@begin(description)
@b[SET SEND PADDING]@\ This command will set the number  of  padding
          characters  that  will  be  sent  to  the other Kermit.  The
          default value is 0.

@blankspace(1 line)
@begin(center)
@b[KERMIT-65>]SET SEND PADDING nn
@end(center)

@\@\Where nn is the hex number of padding characters to use.
@end(description)

@begin(description)
@b[SET SEND QUOTE-CHAR]@\This will  set  the  quoting  character  that
          KERMIT-65  will  send  in  outgoing  messages.  This is  the
          character used to quote  control  characters.   The  default
          value is 23 (ASCII "#").

@blankspace(1 line)
@begin(center)
@b[KERMIT-65>]SET SEND QUOTE-CHAR nn
@end(center)

@\@\Where nn  is the ASCII value of the  quoting  character  (in hex).
@end(description)

@begin(description)
@b[SET SEND TIMEOUT]@\Since  Kermit-65  has  no  clock  to  use, it
          can not timeout. This parameter, therefore is useless.

@end(description)
@begin(description)
@b[SET VT52-EMULATION]@\This   switch   determines  whether   or   not
          Kermit-65  will  act like a VT52 when it is  CONNECTed to  a
          remote Kermit. The possible values for the switch are ON and
          OFF. The default is ON.
@blankspace(1 line)
@begin(center)
@b[KERMIT-65>]SET VT52-EMULATION OFF
@end(center)

@end(description)
@begin(description)
@b[SHOW]@\@\The  SHOW  command  will  allow  you  to  show  the  various
          parameters  that  are  set with the SET command.

@\@\The options available to SHOW are:

@end(description)

@begin(format)
@tabclear
@tabdivide(5)
@b[
@\ALL@\DEBUGGING@\EIGHT-BIT-QUOTING
@\ESCAPE@\FILE-BYTE-SIZE@\FILE-TYPE
@\FILE-WARNING@\IBM@\LOCAL-ECHO
@\PARITY@\RECEIVE@\RS232-REGISTERS
@\SEND@\VT52-EMULATION]
@end(format)
@tabclear
@tabdivide(7)

@\@\A description of the options and suboptions follows.

@begin(description)
@b[SHOW ALL]@\@\The SHOW ALL command will cause all of the parameters to  be
          listed.

@end(description)

@begin(description)
@b[SHOW DEBUGGING]@\@\Display  whether  debugging  is  off, in terse
          mode, or in verbose mode.

@end(description)
@begin(description)
@b[SHOW EIGHT-BIT-QUOTING]@\Shows   whether  or  not  Kermit-65  is  using
          eight-bit-quoting on file transfers.

@end(description)
@begin(description)
@b[SHOW ESCAPE]@\@\   This  will display  the character  being  used
          to escape from a connection to a remote Kermit.

@end(description)
@begin(description)
@b[SHOW FILE-BYTE-SIZE]@\This  command shows whether Kermit is treating
          seven  bits or all eight bits as significant when writing to
          a file.

@end(description)
@begin(description)
@b[SHOW FILE-TYPE]@\@\ Shows  what type of file  Kermit-65 is reading
          or writing.

@end(description)
@begin(description)
@b[SHOW FILE-WARNING]@\Shows whether or not Kermit-65 will check if a
          file  exists on receive, and try to modify the name used for
          the file if it does.

@end(description)

@begin(description)
@b[SHOW IBM]@\@\Shows  whether or not Kermit-65 is being  used
          to talk to an IBM mainframe.

@end(description)
@begin(description)
@b[SHOW LOCAL-ECHO]@\Shows  whether  or not Kermit-65 will  print a
          copy of characters on the screen which are typed by the user
          and sent to the mainframe during connect processing.
   
@end(description)
@begin(description)
@b[SHOW PARITY]@\@\Shows   the  type  of  parity  being  used  by
          Kermit-65 in order to talk to the other Kermit.

@end(description)
@begin(description)
@b[SHOW RECEIVE]@\@\Shows  the  setting of  a  particular  receive
          packet parameter. The suboptions available are:

@end(description)

@begin(format)
@tabclear
@tabdivide(5)
@b[
@\EIGHT-BIT-QUOTE-CHAR@\END-OF-LINE@\PACKET-LENGTH
@\PAD-CHAR@\@\PADDING@\QUOTE-CHAR
@\TIMEOUT]
@end(format)
@tabclear
@tabdivide(7)

@\@\These are analogous to the SET RECEIVE options given above.

@begin(description)
@b[SHOW RS232-REGISTERS]@\Shows the value of the 2 RS232 registers
as a single 16 bit hex value.
@end(description)

@begin(description)
@b[SHOW SEND]@\@\ Shows   the  setting  of  a  particular   send
          packet parameter. The suboptions available are:

@end(description)

@begin(format)
@tabclear
@tabdivide(5)
@b[
@\EIGHT-BIT-QUOTE-CHAR@\END-OF-LINE@\PACKET-LENGTH
@\PAD-CHAR@\@\PADDING@\QUOTE-CHAR
@\TIMEOUT]
@end(format)
@tabclear
@tabdivide(7)

@\@\These are analogous to the SET SEND options given above.

@begin(description)
@b[SHOW VT52-EMULATION]@\Shows  whether or not Kermit-65 is acting like
          a  VT52  when  talking  to  another  Kermit  during  connect
          processing.

@end(description)
@begin(description)
@b[STATUS]@\@\The current status of Kermit-65  will  be  displayed.   This
          includes  the  number  of characters that have been sent and
          received from  the  remote  Kermit.   Also  included  is the
          amount of characters which were actual data and the overhead
          for both send and receive.

@end(description)

@chapter(KERMIT-65 SYSTEM INSTALLATION GUIDE)

@section(THE FILES)

  The following files should be supplied on the distribution tape:

@begin(itemize)
C64LBT.BAS	- Initial bootstrap program to load C64DXL

C64LBT.FOR	- FORTRAN program at mainframe to talk to C64LBT.BAS

C64DXL.BAS	- Hex disk file loader in BASIC

C64DXL.HEX	- Assembled version of Disk Hex load program 

C64DXL.M65	- Source of program to load KERMIT-65 from C64 diskette

C64KER.BIN	- Assembled version of KERMIT-65 (Eight-bit Binary Object code)

C64KER.HEX	- Assembled version of KERMIT-65

C64KER.M65	- CROSS assembler source for KERMIT-65

CROSS.MAC	- CROSS Microprocessor Assembler (Source)

CROSS.EXE	- CROSS Microprocessor Assembler (Object)
@end(itemize)

@section(Building KERMIT-65)

@begin(verbatim)
.R CROSS<cr>			! Run CROSS Microprocessor Assembler

*C64K.HEX/PTP:KIM=C64K.M65/M65	! Generate .HEX file

@end(verbatim)
 This command will produce an ASCII HEX file which can be downline
loaded onto the C64 using C64LBT. If a listing is desired, one can
be produced by adding ",KERMIT.LST" after the "/PTP:KIM" in the
command line to CROSS.

@section(General Procedures and Conventions)

Before working with KERMIT on the C64 do the following:
@enumerate(
Make sure all equipment is turned off.

Remove all cartridges from you C64 computer.

Turn on your disk drive and monitor.

Turn on your C64 computer.

Turn on your printer.

Insert your working disk into the disk drive.

Follow the procedures outlined below to bring up KERMIT.
)

@section(Loading an assembled file)

  The procedure to bootstrap an assembled KERMIT object file from a 
mainframe to the C64 is as follows:

  On the C64, Load and run SUPERMON machine language monitor or
equivalent. Preferably should be in address $C800-$CFFF.

Type in the BASIC program C64LBT.BAS on the C64. This is a dumb
terminal program with a simple file receive function. It is
recommended that the user save this program as it may be needed to
bootstrap newer versions of KERMIT, C64HXL or C64DXL in the future.

Enter and save  the BASIC  program C64DXL.BAS  on the  C-64.
This is a simple and slow  program to load hex object  files
produced by CROSS. A faster, better loader written in  CROSS
assembler will be loaded with this.

 Call and login to the mainframe on which KERMIT-65 resides.

Compile and execute C64LBT.FOR. This will be used along with C64LBT.BAS
on the C64 to load the C64DXL program. Once C64LBT is executing on
the mainframe, give control back to the C64 and then run C64LBT.BAS
on the C64. The procedure is:

@begin(verbatim)
 RUN<cr>
 <hit the F7 key>
 Name of File? C64DXL.HEX

 Relocate and save C64HXL. Type the following:
  
 SYS 51181 (to enter Supermon)
 .S "C64DXL.C000",08,C000,xxxx

 Where xxxx is the last address +1 of the program. You will have to
figure out the last address yourself for now.

 Now execute C64LBT again:

 RUN<cr>
 <Hit the F7 key>
 Name of File? KERMIT.HEX <cr>

 This will take about 35 minutes


 Start executing C64DXL:

 LOAD "C64DXL.C000",8,1
 SYS 49152

 Hex Object File Loader
 Object File Name? KERMIT.HEX <cr>

 C64DXL will display what it is receiving on the screen as well as
loading it into memory.

 Whn finished, C64DXL will display the last address of the program
and return you to SUPERMON. In SUPERMON, save the Program:

 .S "KERMIT",08,0801,xxxx+1

 Where xxxx is the last address displayed by C64DXL.

@end(verbatim)
You will now have a working version of Kermit.

@section(Loading a new version of KERMIT-65)

Once KERMIT-65 is on the users system, it can be used to load new versions
of KERMIT-65.  There are two ways of doing this.  One will work in any
enviroment where the initial bootstrap procedure works, since it depends
only on the capability of transferring text files.  The other method
depends upon the capability of being able to obtain and transfer
a binary file.

@section(Loading from a .HEX file)

 Use Kermit-65 to transfer the new version of itself over.
Make the C64 file a Text file. WARNING: This file will take
LOTS of space (about 120 sectors) so make sure the disk is 
reasonably empty.

 Start executing C64DXL.

@begin(verbatim)
 LOAD "C64DXL.C000",8,1
 SYS 49152

 Hex Object File Loader
 Object File Name? KERMIT.HEX <cr>

 When done, enter SUPERMON and save the file:

 .S "KERMIT",08,0801,xxxx+1

 Where xxxx is the last address diplayed by C64DXL
@end(verbatim)

 The new version of Kermit is now on disk.
 
@section(Loading from the binary version)

 There is yet another way to Bootstrap a new version of KERMIT  onto
an C64. If the user has an older version of KERMIT-65 which supports
binary mode transfer, and has access  to a machine with a valid  copy
of C64K.BIN, they can simply  transfer C64K.BIN using their  version
of KERMIT. Be sure to set  the File-byte-size to Eight-bit, and  the
File-type-mode to Binary before transfering  the file since this  is
the actual object  code.  Also be  sure that the  sending Kermit  is
also set  for  doing  a  binary  transfer.  No  special  loading  or
conversion is needed.

@appendix(C64LBT.BAS - BOOTSTRAP PROGRAM FOR C64HXL)
@begin(verbatim)

@end(verbatim)

@appendix(C64LBT.FOR - MAINFRAME SIDE OF BOOTSTRAP)
@begin(verbatim)



@end(verbatim)

@appendix(Character and Control Code Definitions)
@appendixsection(Keyboard Layout)

@table<@verbatim[

	TO SEND		TYPE
	-------		----
	\		BRITISH-POUND
	^\		^BRITISH-POUND
	^_		^=
	^		UP-ARROW
	^^		^UP-ARROW
	^[ (ESC)	^[ or f1
	_		
	|		
	`		
	~		
	{		
	}		
	DEL (RUB)	Commodore DEL
	BREAK		f3
	^T		SHIFT/INST
	^H (BS)		^H, or ^T
	^J (NL)		SHIFT/RETURN or ^J
	^S (DC3)	^S or HOME
	^Q (DC1)	^Q or CURSOR DOWN
	^I (TAB)	^I (ie. No separate TAB key)
]>
 
 Certain other keys also preform other actions:

@table(@verbatim<

>)


@appendixSection{GLASS terminal}

The GLASS TTY terminal type prints all characters except ASCII 0-31 and 
ASCII 127.  Most control codes are ignored.  The following, however, are
recognized:


@Table{@Verbatim{
	CHARACTER	EFFECT
	---------	------
	^G (BEL)	sounds a beep
	^H (BS)		cursor backspaces
 	^I (TAB)	cursor moves right to next tab stop
	^J (NL)		cursor moves down one line with scrolling
	^M (CR)		cursor moves to start of line

}@Caption{Control Codes For Glass TTY}}

@appendixSection{VT-52 Terminal}

The VT-52 terminal prints the same characters as the GLASS TTY.  It reacts to
control characters the same as the GLASS, except when ESC (decimal 27) is
received. Kermit will treat the next character received specially; if it
isn't in the following table, KERMIT ignores the character; if it is in
the table, the action is as indicated.

@Table{@Verbatim{
	CHARACTER	EFFECT
	---------	------
	^[A		cursor moves up one line
	^[B		cursor moves down
	^[C		cursor moves right one char.
	^[D		cursor moves left one char.
	^[H		cursor homes
	^[I		cursor moves up one line with scrolling
	^[J		clears from cursor to end of screen
	^[K		clears from cursor to end of line
	^[Ylc		cursor moves to line l-$20, col c-$20
	^[Z		sends DEC VT-52 terminal id string
	^[n		turns off reverse video
	^[o		turns on reverse video
}@Caption{Escape Sequences for VT-52}}

@newpage

 VAX UNIX users (Berkeley 4.1bsd) will find that the following
"termcap" entries effectively describe this terminal program
for use with the terminal dependent UNIX programs (eg. vi,
emacs, more, rogue, etc.):

@figure<@verbatim[
  qc|c64|C64|Commodore 64:co#40:li#25:\
          :up=\EA:do=\EB:cl=\EH\EJ:am:bs:\
          :bw:ho=\EH:nd=\EC:so=\Eo:\
          :se=\En:cm=\EY%+ %+ :\
          :ce=\EK:sr=\EI:pt:
]>

 VAX VMS users can probably get away with the following (although
some VMS programs [eg. edt] require an auxilliary keypad, and do
not work especially well in 40 column mode):

@figure<@verbatim(
          set term /dev=vt52
          set term /pag=25
          set term /wid=40
)>

 TOPS-20 users can run "emacs" and the like after the following:

@figure(@verbatim<
          term vt52
          term length 25
          term width 40
          term pause com
>)

@newpage
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    
