;
;*****
;
;	ALTCLI.CMD - This command file will attempt to walk
;	 through all the command procedures required to build
;	 an alternate CLI for RSX-11MV3.2/MplusV1.0 systems.
;
;	 If you are running on a newer release of M or Mplus,
;	 you already have alternate CLI support and don't need
;	 any of this !!
;
;	 If, however, you are on one of these retired versions
;	 of RSX, you may be able to use some of the nice
;	 features alternate CLIs can provide...
;
;*****
;
;	First, we need several files...
.TESTFILE LB:[1,1]EXEMC.MLB
.IF <FILERR> NE 1 ;
.IF <FILERR> NE 1 ; Executive macro library, LB:[1,1]EXEMC.MLB, is missing
.IF <FILERR> NE 1 ;   please get a copy and re-start
.IF <FILERR> NE 1 ;
.IF <FILERR> NE 1 .EXIT
.TESTFILE LB:[1,24]MCR.OLB
.IF <FILERR> NE 1 ;
.IF <FILERR> NE 1 ; MCR object library, LB:[1,24]MCR.OLB, is missing
.IF <FILERR> NE 1 ;   please get a copy and re-start
.IF <FILERR> NE 1 ;
.IF <FILERR> NE 1 .EXIT
.TESTFILE LB:[11,10]RSXMC.MAC
.IF <FILERR> NE 1 ;
.IF <FILERR> NE 1 ; System pre-assembly file, LB:[11,10]RSXMC.MAC, is missing
.IF <FILERR> NE 1 ;   please get a copy and re-start
.IF <FILERR> NE 1 ;
.IF <FILERR> NE 1 .EXIT
;
;*****
;
;	Now, build alternate CLI macro and object libraries
;
@CLIMLBBLD
.IF <EXSTAT> NE 1 ; Problems building CLI.MLB...please try to fix
.IF <EXSTAT> NE 1 .EXIT
@CLIOLBBLD
.IF <EXSTAT> NE 1 ; Problems building CLI.OLB...please try to fix
.IF <EXSTAT> NE 1 .EXIT
;
;*****
;
;	Now, build the alternate CLI support task, CLI.TSK
;
@CLIBLD
.IF <EXSTAT> NE 1 ; Problems building CLI.TSK...please try to fix
.IF <EXSTAT> NE 1 .EXIT
INS CLI/TASK=...CLI
;
;*****
;
;	Here's the tough part !?  We need to build a CCL library
;	file the includes the following options:
;		1) Privileged CCL
;		2) No alternate CLI support
;		3) Command lookup from a user-supplied internal table
;		4) Internal table lookup should be 1st
;		5) DO NOT BUILD CCL !! (wastes time)
;	 The internal table file to use is already distributed as
;	 TABLE.MAC so you don't need to make one (TABLE.MAC is the
;	 result of passing "CLITBL.CCL" through "TABLEGEN.CMD").
;
;	 The result of this process is "CCL.OLB" which will then
;	 be built using a modified "CCLBLD.BLD" file.
;
@CCLGEN
.SETF INS
.IFNINS TKB .SETT INS
.IFT INS INS $TKB
TKB @CCLCLIBLD
.IFT INS REM ...TKB
;
;*****
;
;	Finally, we will build a simple command dispatcher from
;	 CLIDSP.MAC.
;
@CLIDSPBLD
;
;*****
;
;	Assuming all has gone well, we should now have:
;		CLI.MLB - alternate CLI support routine macro library
;		CLI.OLB - alternate CLI support routine object library
;		CLI.TSK - alternate CLI support task
;		CCLCLI.TSK - Command interpreter task for the dispatcher
;		CLIDSP.TSK - Alternate CLI command dispatcher
;
;	To setup this new CLI, @INSCLI will install and intialize
;	 the tasks, and @REMCLI will remove them.  Once installed
;	 and initialized, you may set your terminal to use the
;	 CLI by issuing a "CLI /SET=TI:CCL" command.
;
;	NOTE: DO NOT USE REMCLI.CMD UNLESS ALL TERMINALS ASSOCIATED
;	 WITH THE CLI HAVE BEEN RESET TO MCR !!!  There is a patch
;	 required to MCR under V3.2 to prevent this.  Until
;	 you install this patch, always do a "CLI /SHOW" to verify
;	 that no terminals are using the CLI.  See ALTCLI.RNO (DOC)
;	 for a complete (I hope) description of whats going on, and
;	 what patches to your system you may want to make...PRS 1/31/85
;
@INSCLI
