#include <cx.h>
#include <stdio.h>

#define	NDQLUN	8	/* lun for network data que */
#define	LINKLUN	7	/* lun for network link */

#define NT_CON	1	/* connect */
#define NT_DSC	3	/* disconnect */
#define NT_INT	2	/* interrupt */

#define IS_SUC	1	/* sucess return */
#define IE_NDA	-78	/* no data */

struct gnd_prm {
  int *mail;	/* mail buffer addr */
  int mlen;	/* length */
  } ;

struct conblk {		/* connect block */
  word n_ctl;
  word n_segz;
  byte n_dfm;
  byte n_dot;
  byte n_snd[6];
  byte n_sfm;
  byte n_sot;
  word n_cidc;
  byte n_cid[16];
  word  n_cpsc;
  byte n_cps[8];
  word n_cacc;
  byte n_cac[16];
  word n_cdev;
  byte n_cuni;
  byte n_xxx;
  word n_cuic;
  byte n_xxz[40];
  word n_cdac;
  byte n_cda[16];
  } conbuf;

int flag = 0;
char tstbuf[512];

$$nargs=1;

main()
{
  word iosb[2];	/* io status block */
  extern word cmpast();
  extern word netast();
  word status;
  word parms[6];
  int count;
  byte *bp;
  long tod(), time;

  zero(parms, (sizeof parms));
  bp = iosb;

  clef(10);	/* just in case */

  status = alunx(NDQLUN, "NS", 0);
  dirtst(status, 0, "alun 1 failed");

  status = alunx(LINKLUN, "NS", 0);
  dirtst(status, 0, "alun 2 failed");

  status = opnwnt(NDQLUN, 1, iosb, 0, parms);
  dirtst(status, iosb, "opnw failed");

  status = spawnt(NDQLUN, 1, iosb, &cmpast, &netast);
  dirtst(status, iosb, "spaw failed");

  wtse(10);

  dsar();
  printf(" connected \n");
  enar();

  parms[0] = &tstbuf;
  parms[1] = (sizeof tstbuf);
  count = 0;
  time = 0;
  while (flag == 0) {
    if (time == 0) time = tod(0);
    status = recwnt(LINKLUN, 2, iosb, 0, parms);
    if (iosb[0] != 1) 
    	printf("recv iosb:%o:%o\n",iosb[0],iosb[1]);
/*    dirtst(status, iosb, "recw failed"); */
    count++;
    }
  time = tod(0) - time;

  dsar();
  status = clswnt(NDQLUN, 1, iosb, 0, parms);
  dirtst(status, iosb, "clsw failed");

  printf("rectst done, %d buffers received in %ld sec.\n", count, time);
  exits(1);
}

word cmpast()
{
  byte *piosb;	/* pointer  to iosb */

  astset();
  piosb = gtdp(0);	/* point to iosb */
  dirtst(1, piosb, "spaw failed");
  piosb += 2;		/* move 1 word */
  if (*piosb < 0) get_msg(*piosb);
  astx(1);
}

word netast()
{
  astset();
  get_msg(1);
  astx(0);
}

get_msg(msgcnt)
int msgcnt;
{
  char *cp;
  word iosb[2];
  byte *bp;
  word status;
  word parms[6];

  cp = &conbuf;
  bp = iosb;

  parms[0] = &conbuf;
  parms[1] = sizeof(conbuf);
  parms[2] = 0;
  parms[3] = 0;
  parms[4] = 0;
  parms[5] = 0;

  while (msgcnt-- > 0) {
    status = gndwnt(NDQLUN, 1, iosb, 0, parms);
    if (status == IE_NDA) return(1);	/* no data waiting */

    dirtst(status, iosb, "gndw failed");

    switch (*(bp+1)) { 
	case NT_CON:	{
    		status = accwnt(LINKLUN, 2, iosb, 0, parms);
    		dirtst(status, iosb, "accw failed");
  		setf(10);
		break;
  		}    
	case NT_DSC:	{
    		flag = 1;
		break;
  		}    
    
	case NT_INT:	{
    		*(cp + iosb[1]) = 0;	/* make a string */
    		printf("INT:%s\n", cp);
		break;
  		}    
    
	default:	fatal("unexpected msg", status, iosb);
	}
  }

  return(1);
}


dirtst(dstat, pio, msg)
int dstat;
char *pio, *msg;
{
  if ((dstat >= 0) && ((pio == 0) || (*pio == 1))) return(0);
  fatal(msg, dstat, pio);
}

fatal(msg, dsw, fiosb)
char *msg;
word dsw, fiosb[2];
{
  printf("FATAL:%s: \ndsw:%o, fiosb:%o:%o\n", 
			msg, dsw, fiosb[0], fiosb[1]);
  exit(4);
}
