	;
	; Make a command file to generate a Batch file
	;
	.ENABLE SUBSTITUTION
	.ENABLE DECIMAL
	.ASKS TFILE Enter the name of the command file
	.ASK OF Does the program include a chainable output file
	.ASKS [1:30] LONG Long program name
	.SETN LBL 10.
	.ASKS [::"10000"] DEFSC Default scale
	.ASKS [::"SDG"] DEFEXT Default file extension
	.OPEN #1 TEMP1.TMP
	.OPEN #2 TEMP2.TMP
	.OPEN 'TFILE'.CMD
		.DATA 	.ENABLE SUBSTITUTION
		.DATA 	.ENABLE GLOBAL
		.DATA 	.ENABLE ESCAPE
		.DATA 	.ENABLE DECIMAL
		.DATA 	.SETS TFILE "'TFILE'"
		.DATA 	.SETS DEFEXT "'DEFEXT'"
		.DATA 	.SETS STIME <TIME>
		.DATA 	.SETS SDATE <DATE>
		.DATA 	;
		.DATA 	; 'LONG' - ''STIME'' ''SDATE''
		.DATA 	;
		.DATA 	.;
		.DATA 	.; The following symbols must be declard global, and if there is
		.DATA 	.; any chaining going on, must be defined.
		.DATA 	.;
		.DATA 	.; $CHAIN - Logical, <TRUE> if chained to this routine
		.DATA 	.; $BFILE - String, Batch filename being created
		.DATA 	.; $LFILE - String, Last command file chained from
		.DATA 	.; $IFILE - String, Input data filename (last output filename)
		.DATA 	.; $SCALE - String, Last scale used (defaults to 'DEFSC')
		.DATA 	.;
		.DATA 	.IFNDF $CHAIN .SETF $CHAIN
		.DATA 	.IFNDF $SCALE .SETS $SCALE "'DEFSC'"
		.DATA 	.IFNDF $IFILE .SETS $IFILE TFILE+"."+DEFEXT
		.DATA 	.IFT $CHAIN .GOTO CHAIN
		.DATA 	; To get help on any question hit the <ESC> key.
		.DATA 	;
		.DATA 	.GOTO 'LBL'
		.DATA .CHAIN:	;
		.DATA 	; Chaining from ''$LFILE''
		.DATA 	; Building batch file ''$BFILE''
		.DATA 	;
		.DATA 	.GOTO 'LBL'
		.DATA .L2STR:	.; Logical variable to a string variable - argument of logical var.
		.DATA 	.; Have IND get a logical variable (form QnL), call this routine
		.DATA 	.; to return a corresponding string into Qn of Yes or No.
		.DATA 	.;
		.DATA 	.SETS NEWSTR COMMAN[1:2]
		.DATA 	.IFT ''COMMAN'' .SETS ''NEWSTR'' "Yes"
		.DATA 	.IFF ''COMMAN'' .SETS ''NEWSTR'' "No"
		.DATA 	.RETURN
	.SETN NXT 0
.LOOP:	.SETF INP
	.SETF OUT
	.SETF SC
	.SETF FORCED
	.SETF LOG
	.ASK QUIT Done all questions
	.IFT QUIT .GOTO VER
	.INC NXT
	.ASK INP Input file question
	.IFF INP .GOTO 10
	.SETS VAR "$IFILE"
	.GOTO GETV
.10:	.ASK OUT Output file question
	.IFF OUT .GOTO 20
	.SETS VAR "OUTFIL"
	.GOTO GETV
.20:	.ASK SC Scale question
	.IFF SC .GOTO 30
	.SETS VAR "$SCALE"
	.GOTO GETV
.30:	.ASK LOG Logical question
	.IFT LOG .GOTO 40
	.ASK FORCED A forced answer
.40:	.SETS VAR "Q'NXT'"
.GETV:	;
	; Looking for a one line verification display
	; EG. Input sounding file : 
	;
	.ASKS VER Enter verification string
	.TEST VER
	.IF <STRLEN> < 40. .SETS PRE "'VER%L40' :"
	.IF <STRLEN> >= 40. .SETS PRE "'VER' :"
		.DATA #1 'PRE' '''VAR'''
		.DATA #2 '''VAR'''
		.DATA .E'LBL':	;
	.IFF FORCED .GOTO ELOP
	.ASKS [::"No"] DEF Enter the default string
		.DATA .'LBL':	.SETS 'VAR' "'DEF'"	; 'VER'
	.GOTO RES
.ELOP:	.ASKS ESC Help line
		.DATA 	; 'ESC'
	.IF ESC = "" .GOTO GETQ
	.GOTO ELOP
.GETQ:	.IFT INP	.DATA .'LBL':	.DISABLE LOWERCASE
	.IFT INP	.DATA 	.ASKS [::$IFILE] 'VAR' Enter 'VER'
	.IFT INP	.GOTO GETQ1
	.IFT LOG	.GOTO GETQ2
	.IFT OUT	.DATA .'LBL':	.DISABLE LOWERCASE
	.IFT OUT	.DATA 	.ASKS [::"'VAR'"] 'VAR' Enter 'VER'
	.IFT OUT	.GOTO GETQ1
	.IFF SC		.DATA .'LBL':	.ASKS [::"Default_string"] 'VAR' Enter 'VER'
	.IFT SC		.DATA .'LBL':	.ASKS [::'VAR'] 'VAR' Enter 'VER'
.GETQ1:	.IFT INP .OR .IFT OUT	.DATA 	.ENABLE LOWERCASE
			.DATA 	.IFT <ESCAPE> .GOTO E'LBL'
	.GOTO GETQ3
.GETQ2:	.SETS VAR VAR+"L"
	.ASK ANS Enter default answer
	.IFT ANS	.DATA .'LBL':	.ASK [<TRUE>] 'VAR' 'VER'
	.IFF ANS	.DATA .'LBL':	.ASK [<FALSE>] 'VAR' 'VER'
			.DATA 	.IFT <ESCAPE> .GOTO E'LBL'
			.DATA 	.GOSUB L2STR 'VAR'
	.GOTO RES
.GETQ3:	.IFT INP .GOTO DOF
	.IFT OUT .GOTO DOF
	.GOTO RES
.DOF:		.DATA 	.PARSE 'VAR' ".;" FILE EXT VERSON
		.DATA 	.IF EXT = "" .SETS EXT DEFEXT
		.DATA 	.IF VERSON = ""  .SETS 'VAR' FILE+"."+EXT
		.DATA 	.IF VERSON <> "" .SETS 'VAR' FILE+"."+EXT+";"+VERSON
.RES:	.SETN LBL LBL+10.
		.DATA 	.GOTO 'LBL'
	.GOTO LOOP
.VER:	.CLOSE #1
	.CLOSE #2
	.OPENR #1 TEMP1.TMP
		.DATA .'LBL':	; 'LONG'
		.DATA 	;
.NR:	.READ #1 STRING
	.IFT <EOF> .GOTO OK
		.DATA 	; 'STRING'
	.GOTO NR
.OK:	.CLOSE #1
		.DATA 	;
		.DATA 	.GOTO OK
		.DATA .EOK:	;
		.DATA 	; Answer Yes or No to the question. A <CR> defaults to a No.
		.DATA 	;
		.DATA .OK:	.ASK OK Answers OK
		.DATA 	.IFT <ESCAPE> .GOTO EOK
		.DATA 	.IFF OK .GOTO 10
		.DATA 	.IFT $CHAIN .GOTO DOJOB
		.DATA 	.GOTO BAT
		.DATA .EBAT:	;
		.DATA 	; The batch filename if name of the file you are creating now.
		.DATA 	; This file contains a complete login session. When this file
		.DATA 	; is submitted to the batch file processor, it logs itself in
		.DATA 	; to a virtual terminal, issues commands (Run $''TFILE'' here),
		.DATA 	; supplies the answers to the questions that ''TFILE'' asks and
		.DATA 	; you have provided above, and then logs itself out.
		.DATA 	;
		.DATA .BAT:	.SETS DEF TFILE+".BAT"
		.DATA 	.ASKS [::DEF] $BFILE Enter the batch filename
		.DATA 	.IFT <ESCAPE> .GOTO EBAT
		.DATA 	.PARSE $BFILE "." NAM JUNK
		.DATA 	.OPEN ''$BFILE''
		.DATA 	.DATA $JOB/TIME:300 ''NAM''
		.DATA 	.DATA $!
		.DATA 	.DATA $! Batch job build started at ''STIME''  ''SDATE''
		.DATA 	.DATA $!
		.DATA .DOJOB:	.DATA $!
		.DATA 	.DATA $! 'LONG'
		.DATA 	.DATA $!
	.OPENR #1 TEMP1.TMP
.NB:	.READ #1 STRING
	.IFT <EOF> .GOTO CO
		.DATA 	.DATA $! 'STRING'
	.GOTO NB
.CO:	.CLOSE #1
		.DATA 	.DATA $!
		.DATA 	.DISABLE LOWERCASE
		.DATA 	.DATA $RUN $''TFILE''
	.OPENR #1 TEMP2.TMP
.NA:	.READ #1 STRING
	.IFT <EOF> .GOTO NCO
		.DATA 	.DATA 'STRING'
	.GOTO NA
.NCO:	.CLOSE #1
		.DATA 	.GOTO ANTH
		.DATA .EANTH:	;
		.DATA 	; You can chain directly to another program to effectively do
		.DATA 	; a suite of programs in one pass with the output of 1 program
		.DATA 	; being used as the input of another.
		.DATA 	;
		.DATA .ANTH:	; The following programs can be chained from this program:
		.DATA 	@''<LIBUIC>''BATCHLIST
		.DATA 	.ASKS NEXT Enter the next program (<CR> for no more)
		.DATA 	.IFT <ESCAPE> .GOTO EANTH
		.DATA 	.IF NEXT = "" .GOTO CLS
		.DATA 	.TESTFILE LB:''<LIBUIC>''''NEXT''.CMD
		.DATA 	.IF <FILERR> = 1 .GOTO GOCH
		.DATA 	;
		.DATA 	; The program ''NEXT'' is not available at this time
		.DATA 	;
		.DATA 	.GOTO ANTH
	.IFT OF	.DATA .GOCH:	.SETS $IFILE OUTFIL
	.IFF OF	.DATA .GOCH:
		.DATA 	.SETT $CHAIN
		.DATA 	.SETS $LFILE TFILE
		.DATA 	.CHAIN LB:''<LIBUIC>''''NEXT''.CMD
		.DATA .CLS:	.DATA $!
		.DATA 	.DATA $! Batch job build completed ''<TIME>''  ''<DATE>''
		.DATA 	.DATA $!
		.DATA 	.DATA $EOJ
		.DATA 	.CLOSE
		.DATA 	.TESTFILE ''$BFILE''
		.DATA 	;
		.DATA 	; Batch file ''<FILSPC>'' created
		.DATA 	;
		.DATA 	.GOTO SUB
		.DATA .ESUB:	;
		.DATA 	; You can have the command file submit the batch job for you now,
		.DATA 	; or you can submit it later yourself. The format of the SUBMIT
		.DATA 	; command is as follows:
		.DATA 	;
		.DATA 	; To run as soon as possible    : SUBMIT ''$BFILE''
		.DATA 	; To run after a specified time : SUBMIT/AFTER(hh:mm) ''$BFILE''
		.DATA 	;
		.DATA 	; If you submit the batch file now, this command file will
		.DATA 	; ask for the time at which you wish the batch file to run.
		.DATA 	;
		.DATA .SUB:	.ASK SUBMIT Do you wish to edit the batch file before Submitting
		.DATA 	.IFT <ESCAPE> .GOTO ESUB
		.DATA 	.IFT SUBMIT .GOTO TIM
		.DATA 	; You will have to edit the batch file yourself. When you are satisfied
		.DATA 	; you can submit the job as follows:
		.DATA 	;
		.DATA 	; To run as soon as possible    : SUBMIT ''$BFILE''
		.DATA 	; To run after a specified time : SUBMIT/AFTER(hh:mm) ''$BFILE''
		.DATA 	;
		.DATA 	.GOTO EOC
		.DATA .ETIM:	;
		.DATA 	; You can submit the job to run after a specified time. This is usually
		.DATA 	; done if the system is currently very busy, or an overnight run
		.DATA 	; is acceptable to you. For example: a time of 16:00 can be entered
		.DATA 	; to run after quitting time. Enter just a <CR> to submit the job
		.DATA 	; immediately.
		.DATA 	;
		.DATA .TIM:	.PARSE <TIME> "::" HOUR MIN SEC
		.DATA 	.SETS DEF HOUR+":"+MIN
		.DATA 	.ASKS [4:5:DEF] BATIME Enter the time to run the batch job
		.DATA 	.IFT <ESCAPE> .GOTO ETIM
		.DATA 	SUBMIT/AFTER:(''BATIME'') ''$BFILE''
		.DATA .EOC:
	.CLOSE
	.ENABLE QUIET
	PIP TEMP1.TMP;*/DE/NM,TEMP2.TMP;*
	.DISABLE QUIET
	;
	; The file 'TFILE'.CMD has been created.
	; There will be some editing required of this file before use.
	; The type of ASK's might have to be altered, as well as the
	; grouping of answers in the batch file.
	;
	; Good luck
	;
