/*****
******
**
**
**
**	TITLE:			AUT FILE CROSS REFERENCE READER
**	SYSTEM:			RSX11-M Version 3.2
**	SUBSYSTEM:		Program development
**	ENTRY POINT:		AUTCRF
**	SOURCE FILE:		AUTCRF.C
**	PROGRAMMER:		David A. Klotzbach - AIC
**	DATE:			7-MAY-82
**
**	REVISIONS:	DATE	PROGRAMMER	DESCRIPTION
**			----	----------	-----------
**					
**
**
**
******
**
**	1.0 PURPOSE
**
**
**	2.0 RELATED DOCUMENTS
**
**
**	3.0 INTERFACE
**
**		3.1 CALL
**
**		3.2 RETURNS
**
**
**	4.0 ENVIRONMENT
**
**
**	5.0 BACKGROUND
**
**
**	6.0 OPERATION
**
**
**	7.0 SYSTEM INTERFACES
**
**
**	8.0 TASK MEMORY REQUIREMENTS
**
**
**
*******
*****/

#include <std.h>
#include <fc.h>
	
/*
	Structure definitions
*/

struct	{
	long	symnam;		/* Symbol name in RAD50		*/
	long	refnam;		/* Reference name in Rad50	*/
	char	*symadr;	/* Symbol address		*/
	unsigned	:1;	
	unsigned tlocal :1;	/* Symbol is local to ref	*/
	unsigned 	:1;	
	unsigned define	:1;	/* Symbol is defined here	*/
	unsigned dskres	:1;	/* Segment is disk resident	*/
	unsigned relabl	:1;	/* Symbol is relocatable	*/
	unsigned	:3;
	unsigned ignore	:1;
}c_entry = {0};

static struct {
	long	tskname;
	int	ident;
	int	year;		
	int	month;
	int	day;
	int	hour;
	int	minute;	
	unsigned :16;
	}cref_hdr = {0};

typedef	struct stbcrf{
	struct stbcrf *next;	/* Next one on the list	*/
	unsigned	addr;	/* Address value of this one		*/
	long	name;		/* Name of the segment in RAD50	*/
	}s_symbl;

static s_symbl *start = 0;	/* Address of the start of the table	*/
static s_symbl *end = 0 ;	/* Address of the end of the table	*/
static char fmtstr[ 132 ] = {0};	/* formated output string	*/
static int crf[ SFDBW ] = {0};	/* fdb for crf file		*/
static int riob[2] = { 0 };

long autcrf( adr )
unsigned adr;
{
	s_symbl *stable ;	/* point to the first one	*/

	stable = start;

	if( stable == NULL )
		exit();

	while( adr != stable->addr)
		if( (stable = stable->next) == NULL)
			return 0L;
	return stable->name;
}

/*****
******
**
**      Function:       ini_crf() - Initialize the crossreference table
**
**      Usage:          ini_crf( taskname )
**
**      Returns:        nothing
**
**      Calls:          none
**
**      Operation:
**
******
*****/

ini_crf( task )
long task;
	{
	char file[ 12];		/* array for file name 	*/
	char *edmsg();
	int  st;		/* status		*/

	if( end == 0)
		end = &start;

	*edmsg( file, "%2R.CRF", task ) = '\0';
	if( ( st= fcopen( crf, "","",file,4,FCSEQIO+FCROACC,NOFOB)) != ISSUC )
		{
		return(0);
		}

	if( (st = getrb( crf, &cref_hdr, sizeof( cref_hdr)
		,NORECNUM,NOIOSB)) != ISSUC )
		return( 0);

	while( (st = getrb( crf, &c_entry, sizeof( c_entry),NORECNUM,riob))
		!= ISSUC)
		{
		if( autcrf( c_entry.symnam) )
			continue;
		end = end->next = alloc( sizeof( s_symbl));
		end->addr = c_entry.symadr;
		}
	return( 1 );
	}
