[inherit('SYS$LIBRARY:STARLET','PDPSUBS')]

program PDPLogin(Output);

const

{ String Identifiers }

  LoggedOn = 1;
  OtherUser = 2;
  Disabled = 3;
  LogSyntax = 4;
  LogInvalid = 5;
  LogPassword = 6;
  AtLogin = 7;
  LoggedOff = 8;
  Prompt = 9		{ Must go after anything that starts with '>' };
  NumStr = 9		{ Must set variable NUMSTRINGS };
  
var
  Login, Password: packed array [1..15] of char;
  LoginLen, PassLen: Word;
  Response, Try: integer;
  Done, Failed: boolean;


procedure LogOn;

  begin
    try := 0;
    repeat
      try := try + 1;   PutString('  ', 0, true, false, true);
      response := WaitFor([Prompt], 3);
    until (response = Prompt) or (Try > 5);
    PutString('HELLO ', -1, false, true, false);
    PutString(Login, LoginLen, false, true, false);
    PutString('/ ', 1, false, true, false);
    write(output, '??????');
    PutString(Password, PassLen, false, false, true);
  end { LogOn };


procedure LogOff;

  var
    Response, Try: integer;

  begin
    Try := 0;
    repeat
      PutString('BYE', -1, true, true, true);   Try := Try + 1;
      Response := WaitFor([LoggedOff], 10);
    until (Try >= 3) or (Response = LoggedOff);
  end { LogOff };


begin { PDPLogin }
  ProgramName := 'PDPLogin';

  EnterString(	LoggedOn,	17,	'Logged on Terminal');
  EnterString(	OtherUser,	1,	'HEL -- Other User Logged On');
  EnterString(	Disabled,	1,	'HEL -- Logins are disabled');
  EnterString(	LogSyntax,	1,	'HEL -- Syntax error');
  EnterString(	LogInvalid,	1,	'HEL -- Invalid account');
  EnterString(	LogPassword,	1,	'Password:');
  EnterString(	AtLogin,	1,	'>@LOGIN');
  EnterString(	LoggedOff,	23,	'logged off RSX11M');
  EnterString(	Prompt,		-1,	'> ');
  NumStrings := NumStr;

  $TRNLOG('PDP_LOGIN', LoginLen, Login);
  $TRNLOG('PDP_PASSWORD', PassLen, Password);

  repeat { Flush any garbage in buffer }
    TimedRead(1, Line, Len, Term, TimeOut);
  until TimeOut;

  Try := 0;   Done := false;   Failed := false;
  repeat
    LogOn;   Try := Try + 1;
    Response := WaitFor([LoggedOn, OtherUser, Disabled, LogSyntax,
			 LogInvalid, LogPassword], 10);
    if response = LogPassword then
      begin
	PutString('  ', 0, true, true, true);
	Response := WaitFor([LoggedOn, OtherUser, Disabled, LogSyntax,
			     LogInvalid], 10);
      end;

    case Response of
      NoAnswer: { Try again };
      OtherUser: LogOff;
      LoggedOn:
	begin
	  Done := true;   Waitfor([AtLogin, Prompt], 10);
	end;
      Disabled, LogSyntax, LogInvalid:
	begin
	  Done := true;   Failed := true;
	end;
    end;
  until Done or (Try = 3);

  if Failed then $Exit(3);
end { PDPLogin }.
