@Part(CPMKERMIT,root="KER:KUSER")
@string(-cp4version="@q<4.03>")
@Chapter<CP/M-80 KERMIT>
@Begin<Description,Leftmargin +12,Indent -12,spread 0>
@i(Program:)@\Bill Catchings, Columbia University,
with contributions from Charles Carvalho (ACC),
Bernie Eiben (DEC), Nick Bush (Stevens),
John Bray (University of Tennessee), Bruce Tanner (Cerritos College),
Greg Small (University of California at Berkeley),
Kimmo Laaksonen (Helskini University of Technology), and many others.

@i(Language:)@\8080 Assembler or MAC80

@i(Version:)@\@value(-cp4version)

@i(Date:)@\December 6, 1984

@i(Documentation:)@\Charles Carvalho, ACC; Frank da Cruz, Columbia
@end<Description>
@label<-k80>

@i<KERMIT-80 Capabilities At A Glance:>
@begin<format,leftmargin +2>
@tabclear()@tabset(3.5inches,4.0inches)
Local operation:@\Yes
Remote operation:@\No
Transfers text files:@\Yes
Transfers binary files:@\Yes
Wildcard send:@\Yes
@q<^X/^Z> interruption:@\Yes
Filename collision avoidance:@\Yes
Can time out:@\Yes 
8th-bit prefixing:@\Yes
Repeat count prefixing:@\No
Alternate block checks:@\Yes
Terminal emulation:@\Yes, VT52 and others
Communication settings:@\Yes; duplex, parity
Transmit BREAK:@\Yes; some versions
IBM communication:@\Yes
Transaction logging:@\No
Session logging (raw download):@\Yes
Raw upload:@\Yes
Act as server:@\No
Talk to server:@\Yes; SEND, GET, FIN, BYE
Advanced commands for servers:@\No
Local file management:@\Yes; DIR, ERA, SET DEFAULT disk
Handle file attributes:@\No
Command/init files:@\No
Printer control:@\Yes, limited 
@end<format>

@Section<Summary of CP/M>

CP/M-80 (version 2@q<.>2)
has only five built-in commands, and they all deal with files;
other functions are done by invoking programs.

CP/M file specifications are of
the form @q(DEV:XXXXXXXX.YYY), where
@begin<description>
 @q(DEV:)@\is a @i<device name>,
normally the A:@ or B:@ floppy.  If omitted, the device name defaults
to your connected diskette.

@q(XXXXXXXX)@\is a @i<filename> of up to 8 characters.

@q(YYY)@\is the @i<file type>, up to 3 characters.
 @end<description>
 File names and file types may contain letters, digits, and some
special characters, including dash, dollar sign, and underscore, but
no imbedded spaces.  Upper and lower case letters are equivalent.

 "Wildcard" file-@|group specifications are permitted in file names
and file types (but not device names) within certain contexts; a "@q(*)"
matches a whole field, a "@q(?)"  matches a single character, including
space.  Examples: "@q(*.F??)" specifies all files whose @i<types> start
with F and are 1, 2, or 3 characters long; "@q(F?.*)" specifies all
files whose names start with F and are no more than two characters
long (before the trailing spaces).

The five CP/M commands are:
 @Begin<Description>
DIR @i<file>@\Lists the the names of the specified files.  The
default file specification is "*.*".  Example: @w<"@q(DIR B:*.FOR)">.

ERA @i<file>@\Erases (deletes) the specified file(s); wildcards allowed.

REN @i<new> @i<old>@\Changes the name of a file from @i<old> to @i<new>, e.g.@*
@w<"@q(REN NEW.FOR=OLD.FOR)">.

SAVE@\Saves the specified number of memory blocks into a file.

TYPE @i<file>@\Types the specified file on the screen, e.g.
@w<"@q(TYPE FOO.TXT)">.
 @End<Description>
The most important programs are:
 @Begin<Description>
STAT@\Gives statistics on disk usage; sets and displays IOBYTE.

PIP@\@u<P>eripheral @u<I>nterchange @u<P>rogram.  Copies files.  In
response to the "@q(*)" prompt, give a command of the form
 @example<disk:outfile=disk:infile>
 Wildcards ("@q(*)" for a whole field or "@q(?)"  for a letter) can be used.
Examples: "@q(A:=B:*.*)" to copy a whole disk, "@q(A:=B:*.FOR)" to copy all
the Fortran programs from disk B to disk A.  If the disk specification
is omitted, your "connected" disk is assumed.  Command line arguments
are also accepted, e.g. "@q(PIP A:=B:*.*)".
@End<Description>
For further information on CP/M, consult your microcomputer manual or
a CP/M handbook.

@Section<Kermit-80 Description>

Since Kermit-80 runs on a standalone micro, it is always in control of the
screen -- it is always @i<local>@index<Local>.  Thus, it always keeps the
screen updated with the file name and the packet number, whether sending or
receiving.
@index<Timeout>
Kermit-80 is capable of an imprecise or "fuzzy" timeout on an
input request, and can break deadlocks automatically.  In most cases, this is
not important, because the KERMIT on the other side is most likely able to
handle the timeouts.  The timeouts done by Kermit-80 are fuzzy because they
depend on the speed of the processor and other factors that can vary from
system to system.

If despite the timeout capability, the transmission appears to be stuck (and
you can tell that this has happened if the screen fails to change for a while)
you can type carriage return to have the micro do what it would have done on a
@Index[Timeout] timeout, namely NAK@Index[NAK] the expected packet to cause to
foreign host to send it again (or, if the micro is sending, to retransmit the
last packet).  Micro/@|micro or micro/@|IBM-@|mainframe transfers could require
this kind of manual intervention.

File transfers may be interrupted in several ways.
@begin<description>
Control-C@\This will return you to Kermit-80 command level immediately, so that
you can connect back to the remote system, or take any other desired action.

Control-X@\When sending a file, this will terminate the sending of the current
file with a signal to the KERMIT on the other side to discard what it got so
far.  If there are more files to be sent, KERMIT-80 will go on to the next one.
When receiving a file, KERMIT-80 will send a signal to the remote KERMIT to
stop sending this file.  If the remote KERMIT understands this signal (not all
implementations of KERMIT do), it will comply, otherwise the file will keep
coming.  In any case, the remote KERMIT will go on to the next file in the
group, if any.

Control-Z@\Like Control-X, except if a file group is being transmitted, this
will stop the transmission of the entire group.  If only a single file is being
transmitted, it works exactly like Control-X.

Carriage Return@\If you type a carriage return Kermit-80 will resend the
current packet.  You may do this repeatedly, up to the packet retry limit
(somewhere between 5 and 16 times) for a particular packet.
@end<description>

@heading<Kermit-80 Commands>

KERMIT-80 uses the DECSYSTEM-20 keyword style command language.  Each keyword
may be abbreviated to its minumum unique length.  "?" may be typed to request a
menu of the available options for the current field at any point in a command.
ESC may be typed at any point in a command to fill out the current keyword or
filename; if sufficient characters have not been typed to identify the current
field uniquely, KERMIT-80 will sound a beep and allow you to continue from that
point.
@begin<description,leftmargin +8,indent -8>
@Index[Virtual Terminal]@Index[Escape Character]@Index[Connect]
CONNECT@\Establish a "virtual terminal" connection to any host that may be
connected to the serial port, i.e.@ pass all typein to the serial port and
display all input from the serial port on the screen.  Also, emulate a DEC VT52
to allow cursor control, screen clearing, etc., if VT52-EMULATION is ON (see
below), in which case you should also set your terminal type on the remote host
to VT52.  (Some versions emulate other terminals.)  The escape character
differs from micro to micro; when you issue the CONNECT command, the micro will
print a message telling you how to get back.  The escape sequence is generally
an uncommonly-@|used control character, like CTRL-backslash or
CTRL-rightbracket, followed by a single letter "command".
 @begin<description,spread 0,leftmargin +4, indent -4>
C@\Close Connection, return to @q(Kermit-80>) command level.

S@\Display Status of connection, but maintain remote connection.

@q<?>@\List available single-character commands.

0@\(zero) Send a null (0) character.

B@\Send a BREAK signal.  Only some systems provide this function.

@q<^]>@\(or whatever - a second copy of the escape character) Send the
escape character itself to the remote host.
 @end<description>

@Index[SEND]SEND @i<filespec>@\Send file(s) specified by @i<filespec> to
the remote Kermit.  The @i<filespec> may contain CP/M wildcards.

@Index[RECEIVE]@Index[File-Warning]
RECEIVE@\Receive file(s) from the remote
Kermit.  Store them under the names provided in the file headers supplied by
the remote host.  If the names aren't legal, use as many legal characters from
the name as possible (see the description of SET FILE-WARNING below).  If
there's a conflict, and FILE-WARNING is ON, warn the user and try to build a
unique name for the file by adding "@q<&>" characters to the name.

@Index<GET>GET @i<filespec>@\When Kermit-80 is talking to a Kermit Server on
the host, you should use the GET command to request the server to send
files to you, for example:
@example<get hlp:k*.hlp>
Limitation: If you request an alternate block check type using the SET BLOCK
command, the GET command will not communicate it to the remote server.  If you
want to have type 2 or 3 block checks done when getting files from the server,
you have to issue the appropriate SET BLOCK command to the remote KERMIT before
putting it in server mode.

@Index[LOG]LOG @i<filespec>@\When CONNECTed to a foreign host as a terminal,
log the terminal session to the specified diskette file.  This functionality
depends to some extent on the remote host's ability to do
@Index[XON/XOFF]XON/XOFF flow control, and does not guarantee a complete
transcript (after all, that's what the KERMIT protocol is for).  The log file
is closed when the connection is closed by typing the escape character followed
by the single-@|character command "C".

@Index[TRANSMIT]TRANSMIT @i<filespec>@\Send the specified file to the system on
the other end of the connection as though it were being typed at the terminal,
one line at a time.  No KERMIT protocol is involved.  You must manually confirm
each line.  This is useful for sending files to systems that don't have a
KERMIT program.  During transmission, you may type the escape character
followed by one of these single-@|character commands:
@begin<description,spread 0,leftmargin +4, indent -4>
C@\Cease transmission

R@\Re-transmit the previous line
@end<description>

BYE@\When talking to a remote Kermit Server, this command shuts down
the server and logs it out, and also exits from Kermit-80 to CP/M command
level.@Index[BYE]

@Index[LOGOUT]LOGOUT@\Like BYE, but leaves you at Kermit-80 command level.

@Index[FINISH]FINISH@\Like LOGOUT, but shuts down the remote server without
logging it out.  Leaves you at Kermit-80 command level; subsequent CONNECT
commands will put you back at host system command level.

@Index[VERSION]VERSION@\Show the name, edit number, and edit date of several of
the modules that make up Kermit-80.

@Index[SET]SET @i<parameter> [@i<value>]@\Set the specified parameter to
the specified value.  Possible settings:
@begin<description,leftmargin +8,indent -8>
@Index[Warning]WARNING ON (or OFF)@\Warn user of filename conflicts when
receiving files from remote host, and attempt to generate a unique name by
adding "@q<&>" characters to the given name.  ON by default.

@Index[VT52]VT52-EMULATION ON (or OFF)@\When connected as a terminal
to a foreign host, controls whether the micro emulates a VT52 or
runs in "native mode".  VT52 emulation is ON by default, except on micros
that already have terminal functionality built in, such as the DEC VT180 and
DECmate (these act as @index<VT100>VT100-@|series terminals).  Some systems
emulate other terminals, like the ADM3A; see table @ref<-cp4terms>.

@Index[Local-Echo]LOCAL-ECHO ON (or OFF)@\When you CONNECT to a remote
host, you must set LOCAL-@|ECHO ON if the host is half duplex, OFF if
full duplex.  OFF by default.

@Index[Escape Character]ESCAPE@\Change the escape character for
virtual terminal connections.  Kermit-80 will prompt you for the new
escape character, which you enter literally.

@Index[Baud]BAUD-RATE@\Change the baud rate of the communications port.  This
command only works on some systems.  @i<value> is the numeric baud rate
(300, 9600, etc.) desired.  Type SET BAUD followed by a question mark
for a list of supported baud rates.
On systems that do not support this command, you must set the port
baud rate from CP/M or other setup mechanism outside of KERMIT-80.

@Index[Parity]PARITY@\Sets parity for outgoing characters to one of the
following: NONE, SPACE, MARK, EVEN, or ODD.  On input, if parity is NONE, then
the 8th bit is kept (as data), otherwise it is stripped and ignored.  The
parity setting applies to both terminal connection and file transfer.
If you set parity to anything other than none, KERMIT-80 will attempt to use
@Index<Eighth-Bit Prefix>
"8th bit prefixing" to transfer binary files.  If the other KERMIT is also
capable of 8th bit prefixing, then binary files can be transferred
successfully; if not, the 8th bit of each data byte will be lost (you will see
a warning on your screen if this happens).

@Index[TIMER]TIMER ON (or OFF)@\Enable or disable the "fuzzy timer".  The timer
is off by default, because in the normal case KERMIT-80 is communicating with a
mainframe KERMIT that has its own timer.  Mainframe KERMIT timers tend to be
more precise or adaptable to changing conditions.  You should SET TIMER ON if
you are communicating with a KERMIT that does not have a timer.  You should SET
TIMER OFF if you are communicating over a network with long delays.

@Index[IBM]IBM ON (or OFF)@\Allow the transfer of files to and from an IBM
mainframe computer.  This makes Kermit-80 wait for the IBM turnaround character
(XON), ignore parity on input, add appropriate parity to output, and use local
echoing during CONNECT.  As distributed, KERMIT-80 uses MARK parity for IBM
communication.  If you don't give this command, IBM mode is OFF.  Since IBM
VM/CMS KERMIT does not have timeout capability, SET IBM ON also turns on the
"fuzzy timer" automatically.

@Index[Block Check]BLOCK-CHECK-TYPE@\The options are:
@begin<description,spread 0,leftmargin +8,indent -8>
1-CHARACTER-CHECKSUM@\Normal, default, standard 6-bit checksum.

2-CHARACTER-CHECKSUM@\A 12-bit checksum encoded as two characters.

3-CHARACTER-CRC-CCITT@\A 16-bit CCITT-format Cyclic Redundancy Check, encoded
as 3 characters.

@end<description>
The 2 and 3 character options should only be used under conditions of extreme
line noise.  Many implementations of KERMIT only support the single character
checksum.

FILE-MODE@\Tells KERMIT-80 what kind of file it is sending, so that KERMIT can
correctly determine the end of the file.  SET FILE BINARY means to send all the
128-@|byte blocks of the file, including the last block in its entirety; SET
FILE ASCII is used for text files, and transmission stops when the first
Control-Z is encountered anywhere in the file (this is the CP/M convention for
marking the end of a text file).
SET FILE DEFAULT tells Kermit to attempt to determine the file type by
examining the file being transmitted.  If a Control-Z appears before the
last block of the file, it is assumed to be BINARY; if, when the first
Control-Z is encountered, the remainder of the file contains only control-Z's,
it is assumed to be a text file.  Unfortunately, not all programs fill the
remainder of the last record of a text file with Control-Z's, so this algorithm
is not always successful.
If binary transmission is used on a text
file, some extraneous characters (up to 127 of them) may appear at the end of
the file on the target system.  If ASCII transmission is used on a binary file,
the entire file will not be sent if it happens to contain any data bytes that
correspond to Control-Z.

DEFAULT-DISK@\This allows you to set the default disk as source and destination
of file transfers.  In addition, issuing this command causes you to switch to
the specified disk and log it in, write-@|enabled.
The colon must be included in the disk name (A:).
The selected disk appears
in your KERMIT-80 prompt, for instance @example[Kermit-80 A:>]

PORT@\Allows you to switch between different communication ports.  This command
is not available on all systems.  Type @q<SET PORT ?> for a list of valid
options for your system.

PRINTER@\ON or OFF.  Turns copying of CONNECT session to printer on and off.
No attempt is made to do buffering or flow control; Kermit assumes the printer
can keep up.

DEBUG@\ON or OFF.  Enables/disables displaying of packets on the screen during
file transfer.
@end<description>

DIRECTORY@\This provides a directory listing of the specified files.
If no files are
specified, all files on the default disk are listed.  File sizes, in K, are
included.  You may interrupt the listing at any time by typing any character.
The listing (even if interrupted) concludes with a display of the amount of
free storage left on the disk.

ERASE@\This executes the CP/M ERA command on the specified file(s).
The names of the files being erased are not displayed.
@end<description>

@section<Kermit-80 Flavors>

Many of the systems supported use an external terminal, rather than a built-in
console.  Kermit may be further customized for these systems by defining
(at assembly time) the terminal type to be used. 
If the terminal type is unknown or does not match any of the existing 
terminal options, the generic "CRT" option may be selected.  In this case,
Kermit cannot do fancy screen control during file transfer; it simply types the
file names, packet numbers, and messages in sequence across and down the
screen.  This works best if you can put your micro or terminal in "autowrap"
mode; otherwise the packet numbers will pile up in the rightmost column; the
filenames and messages will always appear on a new line, however.
If no specific terminal has been selected, Kermit cannot do VT52 emulation;
it can act
as a "dumb terminal" (sometimes called a "glass TTY"), or else its own built in
terminal firmware provides cursor control functions independent of the Kermit
program.

@subsection<Generic Kermit-80>
@index<Generic Kermit-80>@index<8080> "Generic Kermit-80" is an implementation
of Kermit that should run on any 8080-@|compatible CP/M 2.2 system with no
modification
at all, or perhaps only a minor one.  Unlike other Kermit-80 implementations,
it contains no system-@|dependent manipulation of the serial port.
All I/O is done with standard CP/M BIOS@index<BIOS> calls, and I/O redirection
is done using the CP/M IOBYTE function, which, according to the Digital
Research @i<CP/M Operating System Manual>, is an optional feature of any
particular CP/M implementation.  If your system does not provide the IOBYTE
function, Generic Kermit-80 will not work; furthermore, not all systems that
implement IOBYTE do so in the same way.
The SET PORT command may be used to select the devices to be used for input
and output.   Table @ref<-cp4ports> lists the options to the SET PORT command
and their effects.

@begin<table,use example,centered>
@bar()
@blankspace(1)
@ux(SET PORT @i<xxx>)    @ux(input from)      @ux(output to)
    CRT            CRT:            CRT:
    PTR            PTR:            PTP:
    TTY            TTY:            TTY:
    UC1            UC1:            UC1:
    UR1            UR1:            UP1:
    UR2            UR2:            UP2:
@caption<Kermit-80 SET PORT Options>
@tag<-cp4ports>
@bar()
@end<table>

The default is SET PORT PTR.
In all cases, the console (CON:) and list (LST:) devices used are those
selected when Kermit is started.

 The reason all Kermit-80 implementations aren't
generic is that a good deal of speed is sacrificed by getting all services from
the operating system.  While a specific implementation of Kermit-80 may be able
to operate at 4800, 9600, or even 19200 baud, Generic Kermit will fail to work
on some systems at speeds in excess of 1200 baud.  In addition, many features
of Kermit require more specific knowledge of the hardware involved -- Generic
Kermit cannot send a BREAK signal, or change the baud rate.

@subsection<CP/M 3 Kermit>

CP/M 3 Kermit should run on most CP/M 3 (CP/M-Plus) systems.  It uses the
auxilliary port (AUX:) to communicate to the remote Kermit.  The SET BAUD
and SET PORT commands are not supported; nor can a BREAK be sent.
Like Generic Kermit, a terminal may be selected at assembly time.

@subsection<System-Specific Versions>

There are also many versions of Kermit-80 tailored to specific systems.
Most of these operate uniformly, but some of them take advantage (or suffer
limitations) of the specific system.  Here are some of the special features
for particular systems:

@ux<Apple II> -- two variations:
@begin<description,leftmargin +8,indent -4>
APMMDM:@\Apple with Z80 Softcard and Micromodem II in slot 2
Dialout capability provided in connect command; user is prompted for
phone number if carrier is not present.  During connect mode,
@q(^]D) drops carrier.  BYE command also causes carrier to be dropped.

AP6551:@\Apple with Z80 Softcard, and one of several 6551-based
communication cards; the slot number is a compile-time parameter
(default is slot 2).  SET BAUD-RATE supported; speeds are 110-19200
baud.
@end<description>

@begin<description,leftmargin +4,indent -4>
@ux<BigBoard II>:@\Uses serial port A.  To use port B, change mnport, mnprts,
and baudrt and reassemble.  Can generate BREAK.  SET BAUD-RATE supported;
speeds are 300-38400 baud.

@ux<Digicomp Delphi 100>:@\SET BAUD-RATE supported; speeds are 50-19200 baud.

@ux<CPT-85xx word processors>:@\Can generate BREAK.  SET BAUD-RATE supported;
speeds are 50-9600 baud.

@ux<DEC DECmate II word processor (with Z80 card)>:@\Can generate BREAK.

@ux<DEC VT180 (Robin)>:@\Three output ports, referred to as COMMUNICATIONS,
GENERAL, and PRINTER.  Can generate BREAK.

@ux<Intertec SuperBrain>:  SET BAUD-RATE supported; speeds are 50-19200 baud.

@ux<Kaypro:>@\Should work on most Kaypro models, as well as some related
systems (Ferguson BigBoard I, Xerox 820).  For the newer Kaypros with multiple
ports, Kermit uses the one labeled "serial data"; it cannot use the serial
printer or internal modem ports (but it should be possible to modify the values
for mnport, mnprts, and baudrt to do this).  Can generate BREAK.  SET BAUD-RATE
supported; speeds are 50-19200 baud.

@ux<Morrow Decision I>:@\Uses the Multi-I/O board.  Port 1 is the console, port
3 is the communications line.  SET BAUD-RATE supported; speeds are 75-56000
baud.

@ux<Nokia MicroMikko>:@\
Will not echo control-O (which locks keyboard).  SET BAUD-RATE
supported; speeds are 75-9600 baud.

@ux<Ohio Scientific>:@\Doesn't have screen control.

@ux<Osborne 1>:Uses serial line, not internal modem.  Left-arrow key generates
<DEL> ("delete" or "rubout" character) during connect mode.  SET BAUD-RATE
supported; speeds are 300 and 1200 baud.

@ux<TRS-80>: Two versions, one for Lifeboat CP/M, one for Pickles & Trout CP/M.
@end<description>

@section<Installation of Kermit-80>
Kermit-80 was written originally for the Intertec SuperBrain in
lowest-@|common-@|denominator @Index[8080] 8080 code with the standard
assembler, ASM (single source module, no macros, no advanced instructions), so
that it could be assembled on any CP/M-80 system (the 8080 assembler is
distributed as a standard part of CP/M-80, whereas the fancier Z80@Index[Z80]
or macro assemblers are normally commercial products).  It has since been
modified to run on many other systems as well.  Kermit-80 should be able to run
on any 8080-, 8085- or Z80-@|based microcomputer under @Index[CP/M] CP/M with
appropriate minor changes to reflect the port i/o and screen control for the
system (see below).

The proliferation of new systems supported by Kermit-80 made the program grow
so large and complicated that it had to be broken up into system-@|independent
and system-@|dependent modules, as of version 4 (this was done by Charles
Carvalho of ACC).  Each module is composed of multiple files.  This has reduced
the time and disk space necessary for assembly; Kermit-80 may once again be
assembled on a CP/M system with roughly 150Kbytes of space.  The majority of
the code does not need to be reassembled to support a new system.
Unfortunately, it can no longer be assembled with ASM, since ASM does not
support multiple input files.  To allow it to be assembled on any CP/M system,
the public-domain assembler LASM is included in the distribution kit; Kermit-80
may also be assembled with Microsoft's M80 (not supplied), or cross-assembled
on a DEC-10 or DEC-20 with MAC80 (also supplied in the distribution kit).  In
theory, any 8080 assembler supporting the INCLUDE directive ought to work, as
well.

All versions of Kermit-80 are assembled from the same set of sources, with
system dependencies taken care of by assembly-@|time conditionals within the
system-@|dependent module (eventually, the system-@|dependent module will
itself be broken up into multiple files, one for each system).  The most
important system dependencies are terminal emulation (when CONNECTed to the
remote host) and screen handling, which are dependent on the individual micro's
escape codes (these features are table driven and easily modified for other
CP/M systems), and the lowest level i/o routines for the serial communications
port.  The port routines are best done only with BDOS calls, but some systems
do not allow this, primarily because the BDOS routines strip the parity bit
during port i/o, and the parity bit is used for data when transmitting binary
files.

Kermit-80's I/O routines must check the port status and go elsewhere if no
input is available; this allows for virtual terminal connection, keyboard
interruption of stuck transmissions, etc.  On systems that fully implement I/O
redirection via the optional CP/M IOBYTE facility, this may be done by
switching the IOBYTE definition.  On others, however, IN/OUT instructions
explicitly referencing the port device registers must be used.

@index<Timeout>
CP/M-80 KERMIT versions 3.8 and later include a "fuzzy timer" that allows a
timeout to occur after an interval ranging from 5 to 20 seconds (depending upon
the speed of the processor and the operating system routines) during which
expected input does not appear at the port.  In this case, retransmission
occurs automatically.  In any case, you may type a carriage return during
transmission to simulate a timeout when the transfer appears to be stuck.

@subsection<Organization of Kermit-80>
Kermit-80 consists of two modules, each of which is generated from multiple
source files.  The first module contains the system-@|independent code;
the second module is configured for a particular system and merged with
the system-@|independent module to produce a customized Kermit-80.

The distribution kit contains:
@begin<itemize,spread 0>
the system-@|independent module, @q<CP4KER.HEX>;

the system-@|dependent modules, @q<CP4*.HEX> (see table @ref<-cp4systems>);

the source files, @q(CP4*.ASM),

the DEC-10/DEC-20 cross-assembler and linker, @q<MAC80.*> and @q<LINK80.*>,

the public-domain CP/M assembler, @q<LASM.*>,

the public-domain CP/M load/patch utility, @q<MLOAD.*>
@end<itemize>

@begin<table,use verbatim,leftmargin +0>
@bar()
@blankspace(1)
@u(Symbol  Filename System)
@blankspace(0.25)
AP6551  CP4APL  @r<Apple II, Z80 Softcard, 6551 ACIA in serial interface>
APMMDM  CP4APM  @r<Apple II, Z80 Softcard, Micromodem II in slot 2>
BBII    CP4BB2  @r<BigBoard II (terminal required)>
BRAIN   CP4BRN  @r<Intertec SuperBrain.>
CPM3    CP4CP3  "@r<generic": CP/M 3.0 (CP/M Plus) systems (terminal req'd)>
DELPHI  CP4DEL  @r<Digicomp Delphi 100 (terminal required)>
DMII    CP4DM2  @r<DECmate II with CP/M option>
GENER   CP4GEN  @r<"Generic": CPM 2@q(.)2 systems with IOBYTE (terminal req'd)>
HEATH   CP4H89  @r<Heath/Zenith H89.>
KPII    CP4KPR  @r<Kaypro-II (and 4; probably supports all Kaypro systems)>
MDI     CP4MDI  @r<Morrow Decision I (terminal required)>
MIKKO   CP4MIK  @r<MikroMikko>
MMDI    CP4UDI  @r<Morrow Micro Decision I (terminal required)>
OSBRN1  CP4OSB  @r<Osborne 1>
OSI     CP4OSI  @r<Ohio Scientific>
ROBIN   CP4ROB  @r<DEC VT180>
TELCON  CP4TEL  @r<TELCON Zorba portable>
TRS80LB CP4TLB  @r<TRS-80 model II with Lifeboat 2@q(.)25C CP/M Display>
TRS80PT CP4TPT  @r<TRS-80 model II with Pickles + Trout CP/M Display>
VECTOR  CP4VEC  @r<Vector Graphics.>
Z100    CP4Z00  @r<Z-100 under CP/M-85>
@begin<text,facecode R,above 1>
"symbol" is the symbol used to select the target system, in @q<CP4TYP.ASM>;
"filename" is the name under which the module is supplied in the distribution.
@end<text>
@caption<Systems supported by Kermit-80>
@bar()
@tag<-cp4systems>
@end<table>

@subsection<Downloading Kermit-80>

You'll need either a pre-configured @q<.COM> file or the system-@|independent
module, @q<CP4KER>, in binary (@q<.COM>) or hex (@q<.HEX>) format and the
system-@|dependent overlay for your system (from table @ref<-cp4systems>).  If
your system is not listed in the table, get the generic CP/M 2@q(.)2 Kermit or
the generic CP/M 3 Kermit.  If you already have a version of Kermit on your
micro and you want to install a new version, simply use your present version to
get the new files.  Transfer the files to your system and skip ahead to
"merging the modules".

If you do not have a copy of Kermit on your micro, and you cannot borrow a
Kermit floppy but you do have access to a mainframe computer with a copy of the
Kermit-80 distribution, you should read this section.

@Index[Bootstrap]@index<Downloading> There are several ways to get Kermit from
a host system to your micro.
The easiest is to "download" the necessary
"hex" files into your micro's memory and then save it on the disk.
If you have a terminal emulator program on your micro which can save a copy
of the session to disk, connect to your host, and type the necessary files.
Exit from the emulator, saving the session log, and edit the session log to
extract the hex files.  Skip ahead to "merging the files".

The following is a procedure which, though far from foolproof,
should allow you to
get a version of Kermit to your CP/M based micro.  It depends upon the host
prompt, or at least the first character of the host prompt, being some
character that cannot appear in a hex file (the valid characters for hex files
are the digits 0-9, the upper case letters A-F, the colon ``@q<:>'', carriage
return, and line feed).  As soon the prompt character is encountered, the
transfer will terminate.  If your host does not issue a prompt that will
accommodate this scheme, you can achieve the same effect by adding
an atsign ``@@'' to the very end of the hex file before sending it from the
host.  The program below looks for an atsign (the normal DEC-20 prompt, hex
40).  DECSYSTEM-10 users would look for a dot, hex 2E.

@Begin <Enumerate>
On your micro, connect to a floppy disk with plenty of free space.
Run DDT and type in the following (the comments should not be typed in;
they are there just to tell you what's happening):
@Begin <Example,Free>
-a100                   ;Begin assembling code at 100.
0100 lxi h,ffe          ;Where to put HEX file.
0103 shld 300           ;Save the address.
0106 mvi e,d            ;Get a CR.
0108 mvi c,4            ;Output function.
010A call 5
010D mvi c,3            ;Input function.
010F call 5
0112 ani 7f             ;Turn off the parity.
0114 cpi 40             ;Our DEC-20 prompt atsign?
0116 jz 124             ;Yes, we have whole file.
0119 lhld 300           ;Get the pointer.
011C mov m,a            ;Else, store the char.
011D inx h              ;Increment the pointer.
011E shld 300           ;Save the pointer.
011F jmp 10d            ;Go around again.
0124 mvi a,1a           ;Get a control-Z.
0126 lhld 300           ;Get the pointer.
0129 mov m,a            ;Store the char.
012A shld 300           ;Save the pointer.
012D lxi h,1000         ;Pointer to file.
0130 shld 310           ;Save the pointer.
0133 mvi c,16           ;Make file.
0135 lxi d,5c
0138 call 5
013B lhld 310           ;Get the file pointer.
013E xchg               ;Put it in DE.
013F mvi c,1a           ;Set DMA.
0141 call 5
0144 mvi c,15           ;Write DMA to file.
0146 lxi d,5c
0149 call 5
014C lhld 310           ;Get the file pointer.
014F lxi d,80           ;Get the DMA size.
0152 dad d              ;Adjust file pointer.
0153 shld 310           ;Save it.
0156 lda 301            ;Get high order byte.
0159 cmp h              ;Have we passed the end?
015A jm 170             ;Yes.
015D jz 163             ;Maybe.
0160 jmp 13b            ;No.
0163 lda 300            ;Get low order byte.
0166 cmp l              ;Passed the end?
0167 jm 170             ;Yes.
016A jz 170             ;Yes.
016D jmp 13b            ;Not quite.
0170 mvi c,10           ;Close file.
0172 lxi d,5c
0175 call 5
0178 ret
0179
-^C                     ;(control-C):Return to CP/M
A>SAVE 1 FETCH.COM      ;Save this program;
                        ; we need to run it twice.
@End<Example>

Connect to your host using a terminal or a terminal emulation facility.  Ensure
that your host does not have your terminal in "page mode".  E.g. on the DEC-20,
give the Exec command @q<TERMINAL NO PAUSE END-OF-PAGE>.

Tell the host to display the first hex file (the system-independent module)
at your terminal.  E.g. on the DEC-20,
give the Exec command @q<TYPE CP4KER.HEX>, @i<@u(without) a terminating
carriage return>.

Return to your micro.
Make sure your IOBYTE is set so that @q<RDR:> and @q<PUN:> correspond to the
I/O port that is connected to the DEC-20 (this would normally be the case
unless you have done something special to change things).
Load the program you entered in the first step with DDT, and use it to capture
the first hex file:
@Begin<Example,Free>
DDT FETCH.COM
-icp4ker.hex            ;Setup FCB for file CP4KER.HEX.
-g100,179               ;Execute the program.
@End<Example>
 Now there should be a file @q<CP4KER.HEX> on your connected disk.

Return to the host, and tell it to display the second hex file (the
system-@|dependent module for your configuration).  Again, do not type the
terminating carraige return.

Return to your micro, and run the capture program again:
@Begin<Example,Free>
DDT FETCH.COM
-icp4ovl.hex            ;Setup FCB to create CP4OVL.HEX
-g100,179               ;Execute the program.
@End<Example>
 Now there should be a file @q<CP4OVL.HEX> on your connected disk.
@end<enumerate>
Merging the files:
@begin<enumerate>
For purposes of illustration, we will assume the system-@|dependent overlay is
called "cp4ovl@q<.>hex".  The two hex files may be combined with MLOAD or DDT.
If you already have a running Kermit, you can transfer @q<MLOAD.HEX> to your
system and create @q<MLOAD.COM> by running LOAD.  If you're bootstrapping
Kermit, you could transfer @q<MLOAD.HEX> to your system the same way you got
the other two @q<.HEX> files, but it's probably simpler to use DDT to get
Kermit running, and get MLOAD later if you need it.

Using MLOAD, the two pieces may be easily merged:
@begin<example>
A>@ux(mload kermit40=cp4ker,cp4ovl)
[some messages about program size, etc.]
A>
@end<example>

If you don't have MLOAD running, it's a bit more complex:
@begin<example>
A>@ux<ddt cp4ker.hex>
NEXT  PC
3500 0100
-@ux<icp4ovl.hex>
-@ux<r>
NEXT  PC
xxxx 0000
-@ux<^C>
A>@ux<save @i(dd) kermit40.com>
@end<example>
The page count ("dd") used in the SAVE command is calculated from the last
address ("xxxx") given by DDT in response to the R command: drop the last two
digits and add 1 if they were not zero, then convert from hexadecimal (base 16)
to decimal (base 10): 384F becomes 39 hex, which is 57 decimal (3 times 16 plus
9) -- but 3700 becomes 37 hex, or 55 decimal (consult an introductory computing
book if you don't understand number base conversion).

Note that CP/M hex files have checksums on each line.  If there were any
transmission errors during the downloading process, MLOAD or DDT will notice a
bad checksum and will report an error (something like "Illegal Format").  If
you get any errors during loading, either fix the hex file locally with an
editor, or repeat the transfer.

@End<Enumerate>

You now should have a running version of Kermit-80, called @q<KERMIT40.COM>.

Test your new Kermit by running it.  If it gives you a prompt, it might be
OK. (don't delete your old one yet...).  Instead of a prompt, you could get
one of two messages indicating that the configuration information is invalid:
@example<?Kermit has not been configured for a target system>
or
@example<?Consistency check on configuration failed>
Of course, neither of these messages should appear if you're building Kermit
from the distribution kit.  The first message indicates that the overlay was
not found where the system-@|independent module expected to find it, probably
because the overlay address is incorrect; the second indicates that the version
of CP4LNK used in the system-@|dependent module is incompatible with the
system-@|independent module.

Once you are satisfied that KERMIT40 works correctly, you should rename your
old @q<KERMIT.COM> to something else, like @q<OKERMIT.COM>, and rename
@q<KERMIT40.COM> to @q(KERMIT.COM).

@subsection<Assembling Kermit-80 from the sources>

Kermit-80 is built in two pieces from the following 12 files:
@begin<description,spread 0>
@i(The system-independent files:)

@q<@ @ CP4KER.ASM>@\header file

@q<@ @ CP4DEF.ASM>@\definitions for both KERMIT and KERSYS

@q<@ @ CP4MIT.ASM>@\initialization, main loop, miscellaneous commands
(BYE, EXIT, LOG, SET, SHOW, STATUS, and VERSION)

@q<@ @ CP4PKT.ASM>@\the KERMIT protocol handler (SEND, RECEIVE, LOGOUT,
and FINISH commands)

@q<@ @ CP4TT.ASM>@\ the transparent commands (TRANSMIT, CONNECT)

@q<@ @ CP4CPM.ASM>@\CP/M commands (DIR, ERA)

@q<@ @ CP4WLD.ASM>@\the wildcard handler

@q<@ @ CP4CMD.ASM>@\the command parser

@q<@ @ CP4UTL.ASM>@\utility routines and data

@q<@ @ CP4LNK.ASM>@\linkage area description

@blankspace(1)
@i(The system-dependent files:)

@q<@ @ CP4TYP.ASM>@\system selection

@q<@ @ CP4SYS.ASM>@\system-specific code
@end<description>

The system-@|independent module contains all of the system-@|independent files
except for @q(CP4LNK.ASM), which is assembled into the system-@|dependent
module to provide the structures needed to connect the two modules.  As
distributed, the system-@|independent module is named @q(CP4KER.HEX).  If you
have a copy of @q(CP4KER.HEX), you do not need to reassemble the
system-@|independent module to configure Kermit for your system.

The system-@|dependent module consists of @Q(CP4TYP.ASM), @Q(CP4DEF.ASM),
@Q(CP4LNK.ASM), and @Q(CP4SYS.ASM).  One copy of the system-@|dependent module
is supplied already assembled for each supported system; the filename may be
obtained from table @ref<-cp4systems>.

After assembling the two pieces separately, they are combined with DDT or
MLOAD into a system-@|specific Kermit.

If you want to rebuild the system-@|independent module, the only change you
may need to make is to select the assembler to be used, in @Q(CP4KER.ASM).
Define one of MAC80, M80, or LASM to TRUE to select it as the assembler;
the others should be defined FALSE.

Assuming you have the Microsoft Macro Assembler package (M80/L80), you'll
need to do the following:
@begin<example>
A>@ux(m80 cp4ker=cp4ker.asm)
A>@ux(l80 /p:100,cp4ker,cp4ker/n/e)
@end<example>
This will produce @Q(CP4KER.COM).

If you are using LASM instead, do this:
@example(A>@ux<lasm cp4ker>)
LASM will generate @Q(CP4KER.HEX) and @Q(CP4KER.PRN).  LASM allows options to
be specified in the same way as the standard assembler, ASM, so the command 
@example[A>@ux(lasm cp4ker.abz)]
will read the source files from drive A, send the @q(.HEX) file to drive B,
and suppress the listing file.

If you have access to a TOPS-10 or TOPS-20 system, you can cross-assemble
Kermit there with MAC80, producing CP4KER.HEX:
@begin<example>
.@ux(run mac80)
*@ux(=cp4ker.asm)
@end<example>

If you want to generate a system-@|dependent overlay for a particular system,
or want to change the terminal supported, you'll need to check three areas in
@Q(CP4TYP.ASM):

First, the overlay start ADDRESS.  The symbol "ovladr" is EQUated to the
address of "LNKFLG" in the system-@|independent module, as the starting address
of the overlay (3400H for version @value(-cp4version)).  You'll need to know
this value if you're building the overlay with M80/L80.  You won't normally
need to change this value.

Second, the assembler being used.  Again, define one of MAC80, M80, and LASM
to be TRUE to select it, and define the others to be FALSE.  The two modules
(system-@|independent and system-@|dependent) do not need to be built with the
same assembler.

Third, the system configuration.  Locate your system in table
@ref<-cp4systems>, then define the appropriate symbol TRUE, and the rest FALSE.
If the system comes with a builtin console terminal, define all the terminal
switches FALSE.  If the system uses an external terminal as the console, locate
the terminal in table @ref<-cp4terms> and define the appropriate symbol TRUE,
and the remainder FALSE.  If the terminal is not listed in table
@ref<-cp4terms>, use the CRT switch; in this case, VT52 emulation is not
supported.

In addition, there are a few general and system-@|specific symbols which may
be altered to fit your system:

@begin<description>
APSLOT@\For Apple with 6551 ACIA, defines the slot number of the serial card

CPUSPD@\Processor speed in units of 100KHz (currently used only for bbII and
        kpII for timing loops)

TAC@\For users connecting through ARPAnet TACs: set to TRUE if you wish
        the default TACTRAP status to be ON. (This may be overridden with
        the SET TACTRAP command).  If you're not connecting through a TAC,
        set tac to FALSE and ignore tacval.

TACVAL@\For ARPANET TAC users: defines the default TAC intercept character
        (may be overridden with the SET TACTRAP command)
@end<description>

If you are just assembling an existing configuration, you'll need to edit
@Q(CP4TYP.ASM) only.  If you are adding support for a new system, you should
not modify @Q(CP4DEF.ASM) or @Q(CP4LNK.ASM); if you do, you'll have to change
the system-@| independent module also.  Eventually, @Q(CP4SYS.ASM) will be
split into separate files, each of which will generate one or more related
systems.  When this happens, you'll want to pick the one closest to your system
to use as a starting point.

After editing @q<CP4TYP.ASM> as necessary, assemble and link the overlay as
follows: 
@begin<itemize>
With M80 (where "xxxx" is the hex value of ovladr from @q<CP4LNK.ASM>):
@begin<example>
A>@ux<m80 cp4typ=cp4typ.asm>
A>@ux<l80 /p:xxxx,cp4typ,cp4typ/n/x/e>
@end<example>

With LASM:
@begin<example>
A>@ux<lasm cp4typ>
@end<example>

With MAC80 on TOPS-10:
@begin<example>
.@ux<run mac80>
*@ux<=cp4typ.asm>
@end<example>

With MAC80 on TOPS-20:
@begin<example>
@@@ux<run mac80>
*@ux<=cp4typ.asm>
@end<example>
@end<itemize>

The overlay (@Q(cp4typ.hex)) may then be merged with the system-@|independent
module as described above (creating a runnable Kermit from the distribution
kit).

If you have a TOPS-10 or TOPS-20 system and already have a running
Kermit-80 v3.9 or later, you can merge the two @q<.HEX> files into a @q<.COM>
file with LINK80, and transfer the new @q<.COM> file to your micro with Kermit:
@begin<itemize>
Tops-10:
@begin<example>
.@ux<copy kernew.hex=cp4ker.hex,cp4typ.hex>
.@ux<link80 kernew>
@end<example>

Tops-20:
@begin<example>
@@@ux<append cp4ker.hex,cp4typ.hex (to) kernew.hex>
@@@ux<link80 kernew>
@end<example>
@end<itemize>
producing @Q(KERNEW.COM).  If LINK80 says "?Data overlaid", you have an old
version of LINK80, and will have to transfer the @Q(.HEX) files to the micro
and merge them there.

@begin<table,leftmargin +0,use format>
@tabclear()@tabset(1.5in)
@bar()
@blankspace(1)
@u(Symbol)@\@ux<Terminal description>
crt@\Basic CRT, no cursor positioning
adm3a@\ADM3A Display or lookalike
smrtvd@\Netronics Smartvid-80
tvi925@\TVI925, Freedom 100
vt52@\VT52 or VT52 emulator such as Heath H19, H29, etc.
vt100@\VT100 or emulator (most ANSI terminals should work)
@caption<Terminals known to Kermit-80>
@tag<-cp4terms>
@bar()
@end<table>

@section<Adding Support For A New System>
Kermit-80 is built from a common set of source files; the system-@|dependent
module makes heavy use of conditional assembly (this complication will be
removed in future releases).  The system dependencies arise from attempts to
answer some questions:
@begin<enumerate>
@i<What kind of terminal is to be supported?>
@blankspace(1)
For many micros, the console is an integral part of the system, but
others can use an external terminal.  In either case, the commands
to manipulate the screen (position the curser, erase the screen, etc)
must be defined.

@i<How is the serial line accessed?>
@blankspace(1)
For systems supporting the IOBYTE function, this is straightforward;
the symbol "IOBYT" is defined TRUE.
If the serial line is accessed with IN and OUT instructions, it
may be possible to use the simple I/O routines provided.  In this case,
the symbol "INOUT" is defined TRUE, the MNPORT and MNPRTS are defined
to be the data and control addresses, respectively, and bit masks for
testing for "input data available" and "output buffer empty" must be
defined.
If the interface is strange, leave IOBYT and INOUT set to FALSE, and
provide the I/O routines.

@i<What initialization is necessary?>
@blankspace(1)
You may wish to set the baud rate or configure the serial line at
startup.  Examples for a number of devices are present.

@i<What special features are to be supported?>
@blankspace(1)
You may want to provide the capability to select one of several
serial lines with the SET PORT command, or to change the speed of
the serial line with the SET BAUD-RATE command.  To do this, you'll
need to build a command table, using the systems already supported
as examples.
The ability to send a BREAK signal is desirable.  Again, examples
for several different interfaces (ACIA, SIO, etc) are present.
@end<enumerate>

@section<Notes on New Features in Kermit-80 Version 4>

@i(Debugging aids:)
SET DEBUG ON will add two fields to the SEND/RECEIVE display, labelled "Spack"
and "Rpack".  These display the last packet sent and received.  Of course, this
slows down the transfer, especially if the console is an external terminal.
SET DEBUG OFF removes these fields.
The VERSION command displays the name, edit number, and edit date of several
of the modules that make up Kermit.

@index<ARPAnet>@index<TAC>
@index<Attention Character>@index<Intercept Character>
@i(TAC support:) ARPAnet TACs (and many other communication devices such as
terminal concentrators, modems, port contention units, network PADs, etc)
use a printing character (normally "@@") as an
intercept character, to allow commands to be issued to the TAC.  In order to
send this character to the host, it must be typed twice.  The command "SET TAC
CHARACTER" to Kermit enables the TACtrap and asks the user to specify the TAC
intercept character.  This character will be automatically doubled when it
appears in Kermit protocol messages (sent by the SEND or RECEIVE commands) or
when it appears in a file being sent with the TRANSMIT command.  It is not
automatically doubled when typed by the user in CONNECT mode.  "SET TAC ON"
enables the TACtrap but does not change the TAC intercept character, which is
initially "@@".  "SET TAC OFF" disables the TACtrap.  (These comments apply
equally to any communication device that uses a printable attention character
which it will pass through if doubled.)

@i(File buffering:)
Previous versions of Kermit-80 buffered only one sector (128 bytes) at a time
during file transfer operations.  This version buffers 16Kbytes at a time,
reducing the number of times the floppy drive must be spun up and down, and
increasing the effective throughput of the link.  If the disk transfer rate is
too slow, howver, the remote Kermit may time out and retransmit packets.  This
will show up on the screen in the "Retries:" field; if this occurs after disk
activity, you may want to increase the timeout value on the remote Kermit, or
reassemble Kermit with a smaller value for MAXSEC (in @Q(CP4SYS.ASM)).  This
buffer is also used by the TRANSMIT command; the log file enabled by the LOG
command is still written a sector at a time.

@section<Future Work>

Work that needs to be done in future releases includes:
@begin<itemize>
Merge in support for additional CP/M-80 systems, particularly those for
which support was recently added to the monolithic v3.x source.

Break up @q<CP4SYS> into discrete source files, one for each system.
These source files should serve as simple models for adding support for
new systems to Kermit-80 -- only the very basic screen definitions, flags,
i/o primitives, initializations, and so forth should appear in each
system-@|dependent file.

Make the file-stepping mechanism faster (buffer the FCB's in chunks of
16 or 32 or 64).  Currently, to access the @i<n>@+(th) file in a directory
requires n(n+1)/2 lookups...

Addition of missing features -- compression of repeated characters during
packet transmission, transmission of file attributes (particularly size, so
that "percent done" can be displayed for both incoming and outbound files),
advanced commands for servers (REMOTE DIRECTORY, etc), command macros and
initialization files, login scripts, remote operation and server mode, etc etc.
@end<itemize>
