	.TITLE	FIXOV
	.IDENT	/03.5P/
;
;+
;*****
;
;	FIXOV patch file for added protection when implementing
;	 alternate CLI's under MV3.2/M+V1.0.  This patch checks
;	 if the task being REMoved is a CLI, and if so, checks if
;	 the task has a special pointer in the system lists;
;	 only DEC CLI's have special pointers.  Any CLI that
;	 doesn't belong to DEC will be blocked from removal until
;	 its CLI status is dropped.
;
;	NOTE: This patch is for M+ FIXOV with .IDENT /03.5/.  For
;	 other versions, extract and disassemble FIXOV.OBJ from MCR.OLB
;	 and find an entry equivalent to:
;		.RAD50	/TKTN/
;	 in approx. the first 30(8) words.  Redefine "TSKTB" symbol
;	 to point to TKTN's name.  Next, find entries equivalent to:
;		BIT	#U2.PRV,U.CW2(R4)
;		BEQ	xxx
;		BIS	#T3.REM,T.ST3(R1)
;		MOV	$DEVHD,R0
;	 and redefine STARTP to point to the "BIT..." line.
;
;*****
;
;	Paul Sorenson, 3/21/84
;	AEP/Interactive Graphics Section
;	Columbus, OH 43214
;
;*****
;-
;
	.PSECT
TSKTB=.+26		; OFFSET TO SPECIAL TASK TABLE
STARTP=.+642		; START OF PATCH AREA
.=STARTP
	CALL	REMPAT	; TRANSFER CONTROL TO PATCH
	NOP		;  Z-BIT SET TO BLOCK "REM"
;
	.PSECT	PAT1
REMPAT:
	BIT	#U2.PRV,U.CW2(R4)	; PRIV USER ??
	BEQ	10$			; NO, BLOCK "REM"
	BIT	#T3.CLI,T.ST3(R1)	; TASK A CLI ??
	BEQ	9$			; NO, ALLOW "REM"
	MOV	#TSKTB,R4		; PICKUP START OF SPECIAL TASK POINTERS
5$:
	TST	(R4)			; END-OF-LIST ??
	BEQ	10$			; YES, NON-DEC CLI...BLOCK REM
	CMP	T.NAM(R1),(R4)		; CHECK 1ST HALF OF NAME
	BNE	8$			; BRANCH ON NO MATCH
	CMP	T.NAM+2(R1),2(R4)	; MAYBE, CHECK 2ND HALF
	BEQ	9$			; MATCH, ALLOW "REM"
8$:	ADD	#6,R4			; STEP TO NEXT ENTRY
9$:
	CLZ				; DEC'S CLI, ALLOW "REM"
10$:
	RETURN				; RETURN Z-BIT SET TO BLOCK "REM"
	.END
