	SUBROUTINE QPLOT(X,Y,S,NPTS,MODE,ICHAR)
C
C	X,Y,S	= ARRAY OF X,Y,STATISTICS TO PLOT
C	NPTS	= NUMBER OF POINTS TO PLOT
C	MODE	= -1 IF NEW PLOT (RESCALE + PLOT POINTS)
C		= 0	ERASE OLD PLOT (DO NOT PLOT)
C		= 1	PLOT POINTS OVER OLD PLOT WITH SAME SCALE
C
C	ICHAR	< 0	PLOT POINTS
C		= 0	DRAW A LINE CONNECTING THE POINTS
C		> 0	PLOT CONNECTED POINTS
C	IF THE MAGNITUDE OF ICHAR > 99 PLOT THE STATISTICS AS WELL
C	IF ICHAR = +-8 NO POINTS ARE PLOTTED.
C
C
	BYTE	IA(20)
	REAL XX(10),YY(10)
	INTEGER IXC(38),IYC(38),ICH(8),ISZ(8),IXAXE(3),IYAXE(3)
	REAL X(NPTS),Y(NPTS),S(NPTS)
	DATA ICH/0,5,14,18,23,28,33,0/
	DATA IXAXE/150,150,1000/,IYAXE/700,50,50/
	DATA ISZ/5,9,4,5,5,5,5,5/
	DATA IXC/-8,8,8,-8,-8, -8,-8,-3,3,8,8,3,-3,-8,
	1 -8,0,8,-8, -8,8,0,0,0, -8,8,0,-8,8,
	2 -8,0,8,0,-8, 0,0,-8,8,0/
	DATA IYC/-8,-8,8,8,-8, -3,3,8,8,3,-3,-8,-8,-3,
	1 -4,8,-4,-4, 0,0,0,8,-8, -8,8,0,8,-8,
	2 0,8,0,-8,0, -8,8,0,0,8/
	CALL SCOPE
	ICHA	= ABS(ICHAR)
	ISTS	= ICHA/100			! NON ZERO IF STS TO PLOT
	ICHA	= ICHA - ISTS*100
	IPSCAL	= ICHA/10			! DETERMINES SIZE OF POINT PLOT
	ICHA	= ICHA - IPSCAL*10
	IF(NPTS .LE. 0)GO TO 1
	IF(MODE .NE. 0) GO TO 10
1	XSTEP	= 0.
	CALL ERASE
	RETURN
10	IF(MODE .GT. 0 .AND. XSTEP .NE. 0.)GO TO 30
C
C	HERE WE DECIDE ON THE SCALE FOR THE PLOT
C
	XMAX	= X(1)
	XMIN	= X(1)
	YMAX	= Y(1)
	YMIN	= Y(1)
	SS	= 0.
	DO 20 J	= 1,NPTS			! SEARCH FOR THE MAX MIN VALUES
	TEMP	= Y(J)
	IF(ISTS .NE. 0)SS	= ABS(S(J))
	IF(XMAX .LT. X(J))XMAX	= X(J)
	IF(XMIN .GT. X(J))XMIN	= X(J)
	IF(YMAX .LT. TEMP + SS)YMAX	= TEMP + SS
	IF(YMIN .GT. TEMP - SS)YMIN	= TEMP - SS
20	CONTINUE
	XSTEP	= (XMAX - XMIN)/800.		! X RANGE IS OVER 8"
	IF(XSTEP .LE. 0.) XSTEP	=	1.E-20
	X0	= -200*XSTEP + XMIN
	YSTEP	= (YMAX - YMIN)/600.		! Y RANGE OVER 6"
	IF(YSTEP .LE. 0.) YSTEP =	1.E-20
	Y0	= -100*YSTEP + YMIN
	CALL PSSCAL(X0,XSTEP,Y0,YSTEP)		! SET THE SCALES
	CALL ERASE
	CALL VECT(IXAXE,IYAXE,-3)		! DRAW AXES
	DO 25 IY	= 100,700,100		! DRAW Y SCALE
	CALL PTPL(170,IY)			! TICS
	CALL VECT(150,IY)
	YT	= YSTEP*IY + Y0			! VALUE AT TIC
	ENCODE(10,1001,IA) YT
	CALL PLCHAR(0,IY-14,%DESCR(IA),10)	! WRITE VALUE ON SCOPE
25	CONTINUE
	DO 26 IX	= 200,1000,200		! DO X SCALES
	CALL PTPL(IX,70)			! TIC
	CALL VECT(IX,50)
	XT	= XSTEP*IX + X0
	ENCODE(10,1001,IA)XT
	CALL PLCHAR(IX-120,28,%DESCR(IA),10)
26	CONTINUE
30	IF(ICHAR .EQ. 0) GO TO 55		! IF ICHAR=0  NOT PLOT POINTS
	PSCAL	= (4-IPSCAL)/4.			! POINT SCALE
	DO 50 I	= 1,NPTS
	XT	= X(I)
	YT	= Y(I)
	IF(ISTS .EQ. 0)GO TO 40			! NO STATISTICS
	XX(1)	= XT
	XX(2)	= XT
	SS	= S(I)
	YY(1)	= YT + SS
	YY(2)	= YT - SS
	CALL SCPLOT(XX,YY,-2)
40	IF(ICHA .GE. 8 .OR. ICHA .LE. 0)GO TO 50
	MIN	= ICH(ICHA)			! PICK OUT POINT TO PLOT
	MAX	= ISZ(ICHA)
	DO 45 J	= 1,MAX				! TRANSFER CHAR DEFINITION
	XX(J)	= XSTEP*PSCAL*IXC(MIN + J) + XT
	YY(J)	= YSTEP*PSCAL*IYC(MIN + J) + YT
45	CONTINUE
	CALL SCPLOT(XX,YY,-MAX)
50	CONTINUE
51	IF(ICHAR .LT. 0)RETURN
55	CONTINUE				! DRAW LINE THROUGH THE POINTS
	CALL SCPLOT(X,Y,-NPTS)
	RETURN
1001	FORMAT(1P,G10.3)
	END
