	SUBROUTINE QPLOT(X,Y,S,NPTS,MODE,ICHAR)
C
C	X,Y,S	= ARRAY OF X,Y,STATISTICS TO PLOT
C	NPTS	= NUMBER OF POINTS TO PLOT
C	MODE	= -1 IF NEW PLOT (RESCALE + PLOT POINTS)
C		= 0	ERASE OLD PLOT (DO NOT PLOT)
C		= 1	PLOT POINTS OVER OLD PLOT WITH SAME SCALE
C
C	ICHAR	< 0	PLOT POINTS
C		= 0	DRAW A LINE CONNECTING THE POINTS
C		> 0	PLOT CONNECTED POINTS
C	IF THE MAGNITUDE OF ICHAR > 99 PLOT THE STATISTICS AS WELL
C	IF ICHAR = +-8 NO POINTS ARE PLOTTED.
C
C
	PARAMETER IYMIN=70
	PARAMETER IYMAX=720
	PARAMETER IXMIN=150
	PARAMETER IXMAX=1020
	PARAMETER IEXTR=10
	BYTE	IA(20)
	CHARACTER IB*10
	REAL XX(10),YY(10)
	INTEGER IXC(38),IYC(38),ICH(8),ISZ(8),IXAXE(3),IYAXE(3)
	REAL X(NPTS),Y(NPTS),S(NPTS)
	DATA ICH/0,5,14,18,23,28,33,0/
	DATA IXAXE/IXMIN,IXMIN,IXMAX/,IYAXE/iymax,iymin,iymin/
	DATA ISZ/5,9,4,5,5,5,5,5/
	DATA IXC/-8,8,8,-8,-8, -8,-8,-3,3,8,8,3,-3,-8,
	1 -8,0,8,-8, -8,8,0,0,0, -8,8,0,-8,8,
	2 -8,0,8,0,-8, 0,0,-8,8,0/
	DATA IYC/-8,-8,8,8,-8, -3,3,8,8,3,-3,-8,-8,-3,
	1 -4,8,-4,-4, 0,0,0,8,-8, -8,8,0,8,-8,
	2 0,8,0,-8,0, -8,8,0,0,8/
	ICHA	= ABS(ICHAR)
	ISTS	= ICHA/100			! NON ZERO IF STS TO PLOT
	ICHA	= ICHA - ISTS*100
	IPSCAL	= ICHA/10			! DETERMINES SIZE OF POINT PLOT
	ICHA	= ICHA - IPSCAL*10
	IF(NPTS .LE. 0)GO TO 1
	IF(MODE .NE. 0) GO TO 10
1	XSCAL	= 0.
	CALL ERASE
	RETURN
10	IF(MODE .GT. 0 .AND. XSCAL .NE. 0.)GO TO 30
C
C	HERE WE DECIDE ON THE SCALE FOR THE PLOT
C
	XMAX	= X(1)
	XMIN	= X(1)
	YMAX	= Y(1)
	YMIN	= Y(1)
	SS	= 0.
	DO 20 J	= 1,NPTS			! SEARCH FOR THE MAX MIN VALUES
	TEMP	= Y(J)
	IF(ISTS .NE. 0)SS	= ABS(S(J))
	IF(XMAX .LT. X(J))XMAX	= X(J)
	IF(XMIN .GT. X(J))XMIN	= X(J)
	IF(YMAX .LT. TEMP + SS)YMAX	= TEMP + SS
	IF(YMIN .GT. TEMP - SS)YMIN	= TEMP - SS
20	CONTINUE
	CALL ERASE
	CALL	QSCAL(XMIN,XMAX,XSCAL,IXEXP,IXSMIN,IXSMAX,IXS,IXSG)	! Get X scale
	XSCAL	= XSCAL/(IXMAX-IXMIN-2*IEXTR)		! X Scale
	X0	= XMIN - (IXMIN+IEXTR)*XSCAL		! X orogin
	CALL	QSCAL(YMIN,YMAX,YSCAL,IYEXP,IYSMIN,IYSMAX,IYS,IYSG)	! Get Y scale
	YSCAL	= YSCAL/(IYMAX-IYMIN-2*IEXTR)		! Y scale
	Y0	= YMIN - (IYMIN+IEXTR)*YSCAL
	CALL PSSCAL(X0,XSCAL,Y0,YSCAL)		! SET THE SCALES
	CALL VECT(IXAXE,IYAXE,-3)		! DRAW AXES
	DO 25 I	= IXSMIN,IXSMAX			! DRAW Y SCALE
	VALUE	= I*XMAX
	IX	= NINT((VALUE-X0)/XSCAL)
	J	= I/IXS
	IF(I - J*IXS .eq. 0) THEN		! Write Value ?
	  ENCODE(14,1007,IA) VALUE		! WRITE VALUE ON SCOPE
	  IF(IXSG .le. 2)ENCODE(14,1002,IA) VALUE
	  IF(IXSG .eq. 3)ENCODE(14,1003,IA) VALUE
	  IF(IXSG .eq. 4)ENCODE(14,1004,IA) VALUE
	  IF(IXSG .eq. 5)ENCODE(14,1005,IA) VALUE
	  IF(IXSG .eq. 6)ENCODE(14,1006,IA) VALUE
	  IF(VALUE .eq. 0)ENCODE(14,1000,IA)
	  DO 23 J = 1,14
	  IF(IA(J) .ne. ' ') K = J
23	  CONTINUE
	  J	= IX - 14*K
	  IF(J .le. 0) J = 0
	  CALL PLCHAR(J,IYMIN-30,%DESCR(IA),K)! Plot value
	  YY(2)	= YY(2) + YS
	  CALL PTPL(IX,IYMIN + 15)
	ELSE
	  CALL PTPL(IX,IYMIN+5)
	ENDIF
	  CALL VECT(IX,IYMIN)
25	CONTINUE
	DO 27 I	= IYSMIN,IYSMAX			! DRAW Y SCALE
	VALUE	= I*YMAX			! Y value
	IY	= NINT((VALUE-Y0)/YSCAL)
	IF( (I/IYS)*IYS - I .eq. 0) THEN	! Write Value ?
	  ENCODE(14,1007,IA) VALUE		! WRITE VALUE ON SCOPE
	  IF(IYSG .le. 2)ENCODE(14,1002,IA) VALUE
	  IF(IYSG .eq. 3)ENCODE(14,1003,IA) VALUE
	  IF(IYSG .eq. 4)ENCODE(14,1004,IA) VALUE
	  IF(IYSG .eq. 5)ENCODE(14,1005,IA) VALUE
	  IF(IYSG .eq. 6)ENCODE(14,1006,IA) VALUE
	  IF(VALUE .eq. 0)ENCODE(14,1000,IA)
	  DO 26 J = 1,14
	  IF(IA(J) .ne. ' ') K = J
26	  CONTINUE
	  CALL PLCHAR(0,IY,%DESCR(IA),K)	! Plot value
	  CALL PTPL(IXMIN+15,IY)
	ELSE
	  CALL PTPL(IXMIN+5,IY)
	ENDIF
	CALL VECT(IXMIN,IY)
27	CONTINUE
30	IF(ICHAR .EQ. 0) GO TO 55		! IF ICHAR=0  NOT PLOT POINTS
	PSCAL	= (4-IPSCAL)/4.			! POINT SCALE
	DO 50 I	= 1,NPTS
	XT	= X(I)
	YT	= Y(I)
	IF(ISTS .EQ. 0)GO TO 40			! NO STATISTICS
	XX(1)	= XT
	XX(2)	= XT
	SS	= S(I)
	YY(1)	= YT + SS
	YY(2)	= YT - SS
	CALL SCPLOT(XX,YY,-2)
40	IF(ICHA .GE. 8 .OR. ICHA .LE. 0)GO TO 50
	MIN	= ICH(ICHA)			! PICK OUT POINT TO PLOT
	MAX	= ISZ(ICHA)
	DO 45 J	= 1,MAX				! TRANSFER CHAR DEFINITION
	XX(J)	= XSCAL*PSCAL*IXC(MIN + J) + XT
	YY(J)	= YSCAL*PSCAL*IYC(MIN + J) + YT
45	CONTINUE
	CALL SCPLOT(XX,YY,-MAX)
50	CONTINUE
51	IF(ICHAR .LT. 0)RETURN
55	CONTINUE				! DRAW LINE THROUGH THE POINTS
	CALL SCPLOT(X,Y,-NPTS)
	RETURN
1000	FORMAT(' 0.0')
1002	FORMAT(1p,G9.2)
1003	FORMAT(1p,G10.3)
1004	FORMAT(1p,G11.4)
1005	FORMAT(1p,G12.5)
1006	FORMAT(1p,G13.6)
1007	FORMAT(1p,G14.7)
	END
	SUBROUTINE	QSCAL(XMIN,XMAX,XSCAL,IXEXP,IXMIN,IXMAX,IXS,ISIG)
	REAL	ISTEPS(6)
	DATA	ISTEPS/1,2,5,10,20,50/
d	TYPE *,'XMIN',XMIN,' XMAX',XMAX
	XSCAL	= XMAX-XMIN
	IF(XSCAL .eq. 0.) XSCAL = 1.		! Make it 1 if zero
	SCAL	= ALOG10(XSCAL)			! Find range of number
	IXEXP	= SCAL				! In integer
	IF(SCAL .lt. 0) IXEXP = IXEXP - 1	! If negative round down
	IXEXP	= IXEXP-1
	SCAL	= 10.**IXEXP			! Power of 10 for 2 sig figs
	XSCAL	= XSCAL/SCAL			! Now have number and magn
	XSCAL	= NINT(XSCAL)+2			! Now is nearest integer
	XS	= 1.	
	DO 10 J = 1,6
	IXS	= ISTEPS(J)
	XS	= IXS
	IF(XSCAL/XS .le. 6.001) go to 20	! Done ?
10	CONTINUE
20	IXMIN	= XMIN/SCAL-1.			! Find integer XMIN
	XMIN	= IXMIN * SCAL			! Round off XMIN
	IXMAX	= XSCAL+.5 + IXMIN		! Maximum X
	ISIG	= 1
	IF(XMIN .ne. 0.) THEN
	  I	= ALOG10(ABS(XMIN)/SCAL)+1	! Number of sig figs.
	  IF(I .gt. ISIG) ISIG	= I		! Maximum number of sig figs.
d	  TYPE *,'I=',I
	ENDIF
	IF(XMAX .ne. 0.) THEN
	  I	= ALOG10(ABS(XMAX)/SCAL)+1
d	  TYPE *,'I=',I
	  IF(I .gt. ISIG) ISIG	= I		! Maximum number of sig figs.
	ENDIF
	IPOIN	= IXEXP				! Decimal pt. (+ to rt of sig)
d	type *,'ISIG=',ISIG,' IPOIN=',IPOIN
	IF(IXS .gt. 9) THEN
	  ISIG = ISIG -1			! Corrected for scale
	  IPOIN	= IPOIN + 1
	ENDIF
	IF(IPOIN .gt. 0 .and. IPOIN + ISIG .le. 5) ISIG = ISIG + IPOIN
d	type *,'ISIG=',ISIG,' IPOIN=',IPOIN
	XSCAL	= XSCAL*SCAL
	XMAX	= SCAL
d	TYPE *,'XMIN',XMIN,' XMAX',XMAX,' Xscal',XSCAL,
d	1 'IXEXP',IXEXP,' IXMIN',IXMIN,' IXMAX',IXMAX,' IXS',IXS
d	2 ,' ISIG=',ISIG
	RETURN
	END
