$!+
$!	ZGTAPE.COM
$!
$!	Abstract:
$!      ========
$!
$!	Command file to produce a ZG tape for new version of 
$!	RSX software stored on some facility account on the VAX.
$!	Copies a set of files (wildcards are permitted) from
$!      the facility account to a new RSX-11M ZG tape. 
$! 	Makes an entry in the facility journal file
$!      recording date, time and reason of the ZG tape update and 
$!      name of person doing the update.
$!
$!	Author:
$!	======
$!	
$!	Mark Pyatetsky (based on an idea by Victoria White)
$!	Computing Department
$!	Fermilab,Batavia, IL 60510
$!
$!	Date Created:
$!	=============
$!
$!	May 29 1984	Original version
$!
$!	Modifications:
$!	==============
$!      July 22 1984    Vicky White   - following changes
$!        
$!	1)  Restructure command file to call ZG tape specific
$!          command file three times (with different parameter) to
$!                create directories on copy disk
$!		  copy files onto disk
$!                delete accounts related to zg tape making on copy disk
$!          Handle the BRU copy to tape in this file not in each ZG tape
$!          command file - since a bit tricky (needs logicals, temporary
$!          input file, correct mount of tape and disc etc.)
$!          Above structure also permits final calling of users ZG command
$!          file if necessary to do special tidy up or whatever.
$!      2)  Made facility independent by removing all SPR.RSX, CDSOURCE etc
$!          references in body of COM file and putting definitions at start
$!          of file
$!      3)  Reset users directory on abort or error exit
$!      4)  Check on tape density input changed from .or.'s to .and.'s
$!      5)  Magtape label changed to be ZG number
$!      6)  BRU save set name input by user
$!      7)  Indirect input file for BRU - temporarily use scratch disc
$!          and leave this mounted - so need log_io privelege
$!      NOTE:  if we can either make the BRU task on the VAX accept ODS
$!             level 2 file as input file, or have a UIC rooted directory
$!             available to write the temporary input file then this
$!             can go away, and the disc can be mounted foreign, with
$!             no special privilege needed to do the BRU.
$!      8)  Only ask if want to create directories if didnt initialise disc
$!      9)  Write out more information to terminal to let user know what is
$!          happening e.g. directories being created, copy starting etc.
$!     10)  When initialising disc allow dismount of disc during command file
$!     11)  Allow set VOLPRO privilege in command file in case need to 
$!          overwrite disk not owned by this UIC (RSX and VAX UICs of people
$!          often different)
$!     12)  Add separate error exit for CTRLY during init of disc so dont 
$!          give message about mounting mt at this time and tidy up other
$!          on warning and on control_y handling.
$!     13)  Tidy up indenting and add more comments, put errors at end
$!
$!-
$!  *************************************************
$!  Facility definitions for testing only :
$!  =====================================
$!	Facility = "WHITE"
$!	Root = "USR$ROOT4:"
$!	ZGcom = "[WHITE.CD.RSX]"
$!	Journal_file = "[WHITE.CD.RSX]journal.txt"
$!  *************************************************
$!
$!  Facility definitions :
$!  =====================
$!
$	Root = "CD$ROOT:"
$	ZGcom = "[SPR.RSX]"
$ 	Facility = "CD"
$       Journal_file = "CD$SPR:journal.txt"     
$	Scratch_disc = "CDSCRATCH"
$!
$!  definitions
$!  ===========
$	Bru_task = "SYS$SYSTEM:bru.tsk"
$	Bru_temp_input = "DS:[77,1]BRU.TMP"
$	volpro = "FALSE"
$! Note: The above file name for Bru_temp_input also appears in the command
$!       file as the input to BRU.  If we change to allow BRU to take input
$!       from a file on an ODS structure 2 disc then this can be removed
$!       and replaced by either a fixed name file in a fixed UIC directory
$!       or better still just the file BRU.TMP in the users default 
$!       directory.
$!
$!  Below this point command file is facility independent
$!  =====================================================
$!  (except for above rider on BRU.TMP)
$!
$	user_name = F$GETJPI("","USERNAME")
$	user_directory = F$LOGICAL("SYS$DISK")+F$DIRECTORY()
$ 	write sys$output " Command file to ZGtape public versions of ''Facility' software"
$	write sys$output " ------------------------------------------------------"
$       write sys$output " "
$       write sys$output " - the facility SETFACIL is required
$       write sys$output " also temporarily the privilege LOG_IO"
$	write sys$output " "
$ 	write sys$output " "
$!
$!
$!  Get name and directory of module(s) on Facility  account
$!  ========================================================
$!
$ start:
$	inquire ZG_number "Enter RSX ZG tape number [ZGxxxx]"
$	if ZG_number .eqs. "" then goto start
$       inquire fac_directory -
        "Enter ''ROOT' directory for ''ZG_number'.COM [Default: ''ZGCOM']"
$       if fac_directory .eqs. "" then fac_directory = "''ZGCOM'"
$       fac_directory = fac_directory - "[" - "]"
$       fac_directory = "[" + fac_directory + "]"
$!
$!  check that 'ZG_number' file does already exist
$!  ==============================================
$!
$       on warning then goto no_facfile
$       DIR/date  'Root''fac_directory''ZG_number'
$!
$!  Get mag tape drive and aux disk drive to which 'ZG_number' is to be copied
$!  ==========================================================================
$!
$	inquire mgtape_drv -
	"Enter mag tape drive (e.g. MTA0:) or NONE [Default:NONE]"
$	if mgtape_drv .eqs. "" then mgtape_drv = "NONE"
$	mgtape_dens = ""
$	if mgtape_drv .eqs. "NONE" then goto C0
$	on warning then continue
$	DISMOUNT/NOUNLOAD 'mgtape_drv'
$ C_dens:
$	inquire mgtape_dens "Enter mag tape density (i.e. 800/1600/6250)"
$	if mgtape_dens .eqs. "" then goto C_dens
$	if mgtape_dens .nes. "800" .and. mgtape_dens .nes. "1600" -
        .and. mgtape_dens .nes. "6250" then goto C_dens
$	on warning then goto ERR_mount
$	on control_y then goto ERR_mount
$!
$!  Initialise tape to ZG number
$!  ============================
$!
$	write sys$output -
	"Warning the tape will be initialised with label ''ZG_number'"
$	inquire continue "Do you want to continue? "
$       if .not. continue then goto EXIT
$	tape_state = "Initialising"
$	INIT /DENS='mgtape_dens' 'mgtape_drv' 'ZG_number'
$	tape_state = "Mounting"
$	MOUNT/FOREIGN/DENS='mgtape_dens' 'mgtape_drv' 'Zg_number'
$ C0:
$	inquire rsxdisk_drv "Enter RSX disk drive (e.g. DLA0:)
$	if rsxdisk_drv .eqs. "" then goto C0
$	inquire rsxdisk_init "INITIALIZE ''rsxdisk_drv' ?"
$	rsxdisk_init_sure = ""
$	on warning then goto C_drv
$	ALLOCATE 'rsxdisk_drv'
$	if rsxdisk_init then inquire  rsxdisk_init_sure -
		"''rsxdisk_drv' will be INITIALIZED - are you sure?"
$ init_pnt:
$	if rsxdisk_init .and. rsxdisk_init_sure then -
	INIT/STRUCTURE=1/NOVERIF 'rsxdisk_drv' 'scratch_disc'
$	if volpro then set process/priv=novolpro
$	if rsxdisk_init .and. .not. rsxdisk_init_sure then goto C0
$	if rsxdisk_init then rsxdisk_lbl = "''scratch_disc'"
$	if rsxdisk_init then goto C1
$	on warning then goto C0_dsk_lbl
$	DISMOUNT 'rsxdisk_drv'
$ C0_dsk_lbl:
$ 	on error then goto ERR_dsk_mount
$	on control_y then goto ERR_dsk_mount
$ 	inquire rsxdisk_lbl "Enter disk label"
$ C1:
$ 	MOUNT 'rsxdisk_drv' 'rsxdisk_lbl' DS:
$	on control_y then goto exit
$ C2:
$!
$!  Check OK to proceed
$!  ===================
$!
$	magtape = ""
$	if mgtape_drv .nes. "NONE" then magtape = "mag tape"
$	ZG_device = rsxdisk_drv
$	if mgtape_drv .nes. "NONE" then ZG_device = mgtape_drv
$	write sys$output " "
$	write sys$output "RSX ''ZG_number' ''magtape'"
$	write sys$output " "
$	write sys$output "will be created on "
$       write sys$output "                       ''ZG_device'"
$	write sys$output " "
$	write sys$output "using ''rsxdisk_drv' "
$	write sys$output "                        as an auxiliary copy disk"
$	write sys$output " "
$	inquire OK "OK to proceed"
$	if .not. OK then goto start
$!
$!  Record intention to update in journal file (in case aborts in middle
$!    of copy - leaving a mess)
$!  ============================
$!
$       on error then goto journal_err
$	SETF 'Facility'    
$	open/append  journal 'Journal_file'
$       on error then goto clean_exit
$       on control_y then goto clean_exit
$	write journal "================================================================================"
$	write journal "  "
$       write journal "''ROOT'''fac_directory'RSXZGTAPE.COM"
$	write journal "------------------------------"
$	write journal "  "
$	write journal "created RSX ''ZG_number' ''magtape' on ''ZG_device' ", -
		"by username '' user_name' on ''F$EXTRACT(0,17,F$TIME())"
$	write journal "  "
$!
$!  Get Updaters name and record of type of update
$!  ==============================================
$!
$	inquire name "Enter name of person doing this update"
$	write sys$output "Please give brief description of reason for update"
$	write sys$output "    press CR  to terminate entering description"
$	write sys$output " "
$ enter:
$       read sys$command record -
             /prompt = "Reason: " -
             /end_of_file = descrip_done
$       if record .eqs. "" then goto descrip_done
$	write journal record
$	goto enter
$ descrip_done:
$	on warning then continue
$       on error then goto clean_exit
$!
$!  Create auxiliary disc copy of ZG tape files
$!  ===========================================
$!
$	SETF 'user_name'
$	set def 'user_directory'
$	create_dir = "TRUE"
$	if .not. rsxdisk_init then -
	inquire create_dir -
	"Create directories on RSX staging disc? [Default:YES]"
$	if create_dir .eqs. "" then create_dir = "TRUE"
$	if create_dir then -
 	write sys$output "Creating directories [77,*] on auxiliary disc"
$	if create_dir then - 
	@'Root''ZGCOM''ZG_number' CREATE_DIR
$!
$!  copy the files onto the RSX disk
$!  ================================
$	write sys$output -
	"Beginning copy of files to auxiliary disc ''rsxdisk_drv'"
$	@'Root''ZGCOM''ZG_number' COPY
$
$!
$!  copy the RSX disk into the mag tape
$!  ===================================
$
$	if mgtape_drv .eqs. "NONE" then goto update_pnt
$
$	write sys$output -
	"Copy to disc ''rsxdisk_drv' complete.  Beginning copy to tape"
$! Note:  following 2 lines should be put in if/when temporary input file
$!        for BRU can be put on a disc other than the auxiliary RSX copy
$!        disc.  Then if mounted foreign the BRU from disc to tape may
$!        be done without LOG_IO privilege being required
$!!!!!!!! DISMOUNT 'rsxdisk_drv'
$!!!!!!!! MOU/FOR 'rsxdisk_drv' 'rsxdisk_lbl' 
$	DEFINE DK0 'rsxdisk_drv'
$	DEFINE MM0 'mgtape_drv'
$	write sys$output -
	"The save set name on the tape should be the date of the "
$	write sys$output "version number of the software being archived normally."
$	write sys$output "In the form   e.g.  JUL84"
$	write sys$output " "
$	inquire bru_save_set "Enter save set name for RSX backup utility BRU "
$	open/write bru_input 'BRU_TEMP_INPUT'
$       write bru_input -
"/VER/REW/MOUNTED/DENS:''mgtape_dens'/BACKUP:''bru_save_set'/OUT:''ZG_number'"
$	write bru_input "DK0:"
$	write bru_input "MM0:"
$	close bru_input
$	set process/priv=log_io
$	RUN 'Bru_task' 
@DK0:[77,1]BRU.TMP
$	 Delete 'BRU_TEMP_INPUT';0
$	set process/priv=nolog_io
$ unload_pnt:
$	DISMOUNT/NOUNLOAD 'mgtape_drv'
$!
$!  Clean up auxiliary disc if required
$!  ===================================
$ update_pnt:
$ 	inquire del_zg_related -
	"Delete zg-related files and directories on RSX disc[Default:YES]"
$	if del_zg_related .eqs. "" then del_zg_related = "YES"
$       if .not. del_zg_related then goto dism_pnt
$	DISMOUNT 'rsxdisk_drv'
$	MOUNT 'rsxdisk_drv' 'rsxdisk_lbl' DS:
$	@'Root''ZGCOM''ZG_number' DELETE
$ dism_pnt:
$       DISMOUNT 'rsxdisk_drv'
$	DEALLOCATE 'rsxdisk_drv'
$	SETF 'FACILITY'
$!
$!  Update journal file for successfull completion
$!  ==============================================
$!
$	write journal " "
$	write journal -
	"-- ''ZG_number' completed by -- ''name' --''F$EXTRACT(0,17,F$TIME())'"
$       close journal
$       SETF 'user_name'
$	set def 'user_directory'
$	write sys$output " -------     RSX ''ZG_number' complete    ---- "
$       inquire more_mods "Any more RSX ZGtapes to create "
$	if more_mods then goto start
$	goto exit
$!
$!**************************************************************************
$!  Errors
$!**************************************************************************
$!
$!  Errors initialising or mounting either tape or disc
$!  ===================================================
$!
$ ERR_mount:
$	write sys$output -
	"An error occured while ''tape_state' the tape ''mgtape_drv' "
$	inquire mgtape_retry "Do you want to retry"
$	if mgtape_retry then goto C_dens
$	goto exit
$	on control_y then goto to C_drv
$ C_drv:
$	write sys$output -
	"Error initialising disc - the disc must not be a mounted volume"
$	inquire dism_rsx "Do you want to dismount the disc"
$	on warning then continue
$	if dism_rsx .eqs. "" then dism_rsx = "TRUE"
$	if .not. dism_rsx then goto retry_init
$	DISMOUNT 'rsxdisk_drv'
$ retry_init: 
$	on warning then goto exit
$	if .not. dism_rsx then write sys$output -
"If disc was previously initialised it may have owner UIC different from yours"
$	write sys$output "If you do not have same UIC as owner you need "
$	write sys$output " VOLPRO privilege to initialise the disc "
$	inquire continue "Do you want to continue - to initialise the disc"
$	if continue .eq. "" then continue = "FALSE"
$	if .not. continue then goto exit
$	inquire volpro "Do you need to set VOLPRO privilege"
$	if volpro .eqs. "" then volpro = "FALSE"
$	if .not. volpro then goto init_pnt
$	set process/priv=volpro
$	goto init_pnt
$ err_dsk_mount:
$	write sys$output -
	"An error occured while executing $MOUNT ''rsxdisk_drv' "
$	write sys$output "You probably supplied incorrect disk label, or"
$	write sys$output "you probably mounted wrong disk in the drive"
$	inquire rsxdisk_retry "Do you want to retry"
$	if rsxdisk_retry then goto C0_dsk_lbl
$	goto exit
$!----------------------------------------------------------------------------
$!
$!  Error - no ZGxxxx.COM file found
$!  ================================
$
$ no_facfile:
$       write sys$output -
	"No version of this found on ''Facility' account, on directory given "
	goto exit
$!
$!  Error - journal file not available
$!  ==================================
$ journal_err:
$	write sys$output -
	"Journal file for update either does not exist or cannot be accessed "
$	write sys$output -
	"See System manager or Maintainer of ''Facility' Facility "
	goto exit
$!
$!  Error or Warning exit after journal file first entry made
$!  =========================================================
$!
$ clean_exit:
$       SETF  'user_name'
$       set def 'user_directory'
$       close journal
$!
$!****************************************************************************
$!
$ exit:
$	if volpro then set proc/priv=novolpro
$       exit
