$ ! 	ZG0168
$ !	------
$ ! COMMAND FILE TO CREATE AN RSX DISK OR (BRU) TAPE
$ ! WITH RSX11M COMMUNICATION SOFTWARE (CD DRIVER, CDPACK, ETC.)
$ ! 
$ ! AUTHOR:   MARK PYATETSKY
$ !
$ ! DATE:     28-MAY-1984
$ !
$ ! MODIFIED: VICKY WHITE	19-JULY-1984
$ !
$ !   Following changes made:
$ !     1)  Command file structured in three separate sections called
$ !         from RSXZGMAKE three separate times where appropriate to
$ !              Create directories on temporary disc
$ !              Copy all files to temporary disc
$ !              Delete all files created on disc
$ !
$ !     2)  BRU no longer called in this command file, but in master
$ !         RSXZGMAKE command file
$ !     3)  wherever possible wild cards used in COPY to avoid
$ !         maintainence problems when software on CD$ROOT is
$ !         expanded or changed.
$ !     4)  Protection on files changed to permit owner delete
$ !
$ ! MODIFIED: DAVID BERG	3-OCT-84
$ !
$ !   Following changes made:
$ !     1)  Get CDPACK sources from [CDPACK.PDP] instead of [CDPACK.RSX]
$ !	2)  Add USRAST source to [77,5] along with RCV/XMT sources
$ !
$ ! get parameters
$ ! --- ----------
$ !
$	action_flag    = P1
$ !                      takes one of the following values
$ !			 CREATE_DIR
$ !                      COPY
$ !                      DELETE
$ !
$ ! implicit inputs
$ ! ---------------
$ ! 	DS: is logical name of RSX disc used as temporary staging device
$ !         This device is assumed already mounted.
$ !
$ ! decide what to do
$ ! -----------------
$ !
$ 	if action_flag .eqs. "CREATE_DIR" then goto CREATE_DIR_pnt
$ 	if action_flag .eqs. "COPY" then goto COPY_pnt
$ 	if action_flag .eqs. "DELETE" then goto DELETE_pnt
$ EXIT
$ !
$ !-----------------------------------------------------
$
$ !
$ ! create directories
$ ! ------ -----------
$ !
$
$ CREATE_DIR_pnt:
$ !  begin
$ CREATE/DIR/PROT=(S:RWE,O:RWED,G:RE,W:RE)	 DS:[077,001]
$ CREATE/DIR/PROT=(S:RWE,O:RWED,G:RE,W:RE)	 DS:[077,002]
$ CREATE/DIR/PROT=(S:RWE,O:RWED,G:RE,W:RE)	 DS:[077,003]
$ CREATE/DIR/PROT=(S:RWE,O:RWED,G:RE,W:RE)	 DS:[077,004]
$ CREATE/DIR/PROT=(S:RWE,O:RWED,G:RE,W:RE)	 DS:[077,005]
$ CREATE/DIR/PROT=(S:RWE,O:RWED,G:RE,W:RE)	 DS:[077,006]
$ CREATE/DIR/PROT=(S:RWE,O:RWED,G:RE,W:RE)	 DS:[077,007]
$ CREATE/DIR/PROT=(S:RWE,O:RWED,G:RE,W:RE)	 DS:[077,010]
$ CREATE/DIR/PROT=(S:RWE,O:RWED,G:RE,W:RE)	 DS:[077,011]
$ CREATE/DIR/PROT=(S:RWE,O:RWED,G:RE,W:RE)	 DS:[077,012]
$ CREATE/DIR/PROT=(S:RWE,O:RWED,G:RE,W:RE)	 DS:[077,013]
$ CREATE/DIR/PROT=(S:RWE,O:RWED,G:RE,W:RE)	 DS:[077,020]
$ CREATE/DIR/PROT=(S:RWE,O:RWED,G:RE,W:RE)	 DS:[077,100]
$ CREATE/DIR/PROT=(S:RWE,O:RWED,G:RE,W:RE)	 DS:[077,200]
$ !  end
$ EXIT
$
$ !-----------------------------------------------------
$
$ ! copy CD$ROOT into the RSX disk
$ ! ---- ------- ---- --- --- ----
$
$
$ COPY_pnt:
$ !
$ !  begin
$ !
$ !  Maintainence and Installation files
$ !  ===================================
$ COPY CD$ROOT:[SPR.RSX]*.*              DS:[077,001]*.*   /PROT=(O:RWED)
$ !                                                        
$ !  Device driver source and command files                
$ !  ======================================                
$ COPY CD$ROOT:[DRIVER.RSX]*.CMD         DS:[077,002]*.*   /PROT=(O:RWED)
$ COPY CD$ROOT:[DRIVER.RSX]*.MAC         DS:[077,002]*.*   /PROT=(O:RWED)
$ !                                                        
$ !  CDPACK sources and command files                      
$ !  ================================                      
$ COPY CD$ROOT:[CDPACK.PDP]*.MAC         DS:[077,003]*.*   /PROT=(O:RWED)
$ COPY CD$ROOT:[CDPACK.PDP.RSX]*.*       DS:[077,003]*.*   /PROT=(O:RWED)
$ !                                                        
$ !  CDPACK library                                        
$ !  ==============                                        
$ COPY CD$ROOT:[LIBRARY.RSX]CDPACK.OLB   DS:[077,004]*.*   /PROT=(O:RWED)
$ !                                                        
$ !  RCVLUP/XMTLUP and RCVTST/XMTTST sources               
$ !  =====================                                 
$ COPY CD$ROOT:[TESTS.RSX]TEST.CMD       DS:[077,005]*.*   /PROT=(O:RWED)
$ COPY CD$ROOT:[TESTS.RSX]USRAST.FTN     DS:[077,005]*.*   /PROT=(O:RWED)
$ COPY CD$ROOT:[TESTS.ALL]RCVLUP.FOR     DS:[077,005]*.FTN /PROT=(O:RWED)
$ COPY CD$ROOT:[TESTS.ALL]XMTLUP.FOR     DS:[077,005]*.FTN /PROT=(O:RWED)
$ COPY CD$ROOT:[TESTS.ALL]RCVTST.FOR     DS:[077,005]*.FTN /PROT=(O:RWED)
$ COPY CD$ROOT:[TESTS.ALL]XMTTST.FOR     DS:[077,005]*.FTN /PROT=(O:RWED)
$ !                                                        
$ ! Tests using direct QIOs                                
$ ! =======================                                
$ COPY CD$ROOT:[TESTS.RSX]QIORCV.MAC     DS:[077,006]*.*   /PROT=(O:RWED)
$ COPY CD$ROOT:[TESTS.RSX]QIORCV.CMD     DS:[077,006]*.*   /PROT=(O:RWED)
$ COPY CD$ROOT:[TESTS.RSX]QIOXMT.MAC     DS:[077,006]*.*   /PROT=(O:RWED)
$ COPY CD$ROOT:[TESTS.RSX]QIOXMT.CMD     DS:[077,006]*.*   /PROT=(O:RWED)
$ !                                                        
$ ! CDTEST test program                                    
$ ! ===================                                    
$ COPY CD$ROOT:[TESTS.RSX]CDWAKE.FTN     DS:[077,007]*.*   /PROT=(O:RWED)
$ COPY CD$ROOT:[TESTS.RSX]CDTEST.INC     DS:[077,007]*.*   /PROT=(O:RWED)
$ COPY CD$ROOT:[TESTS.RSX]CDTEST.FTN     DS:[077,007]*.*   /PROT=(O:RWED)
$ COPY CD$ROOT:[TESTS.RSX]CDTEST.CMD     DS:[077,007]*.*   /PROT=(O:RWED)
$ !                                                        
$ ! RCVXMT test program sources                            
$ ! ===========================                            
$ COPY CD$ROOT:[TESTS.ALL]RCVXMT.*       DS:[077,010]*.*   /PROT=(O:RWED)
$ COPY CD$ROOT:[TESTS.ALL]RX*.FOR        DS:[077,010]*.*   /PROT=(O:RWED)
$ COPY CD$ROOT:[TESTS.RSX]RCVXMT.CMD	 DS:[077,010]*.*   /PROT=(O:RWED)
$ RENAME DS:[077,010]*.FOR DS:[077,010]*.FTN
$ !                                                        
$ ! ECHO tests sources                                     
$ ! ==================                                     
$ COPY CD$ROOT:[TESTS.ALL]ECHO*.*        DS:[077,012]*.*   /PROT=(O:RWED)
$ COPY CD$ROOT:[TESTS.RSX]ECHO*.CMD      DS:[077,012]*.*   /PROT=(O:RWED)
$ RENAME DS:[077,012]*.FOR DS:[077,012]*.FTN               
$ !                                                        
$ ! MONITRQ test program                                   
$ ! ====================                                   
$ COPY CD$ROOT:[TESTS.ALL]MONITRQ.FOR    DS:[077,013]*.FTN /PROT=(O:RWED)
$ !                                                        
$ ! All Test tasks                                         
$ ! ==============                                         
$ COPY CD$ROOT:[TESTS.RSX]*.TSK          DS:[077,011]*.*   /PROT=(O:RWED)
$ COPY CD$ROOT:[TESTS.RSX]*.MAP          DS:[077,011]*.*   /PROT=(O:RWED)
$ !                                                        
$ ! Tests for CDPACK (to run on both RSX and VAX)  
$ ! =========================                              
$ COPY CD$ROOT:[CDPACK.TESTS]*.FOR       DS:[077,020]*.FTN /PROT=(O:RWED)
$ COPY CD$ROOT:[CDPACK.TESTS.RSX]*.FTN   DS:[077,020]*.*   /PROT=(O:RWED)
$ COPY CD$ROOT:[CDPACK.TESTS.RSX]*.MAC   DS:[077,020]*.*   /PROT=(O:RWED)
$ COPY CD$ROOT:[CDPACK.TESTS.RSX]*.BLD   DS:[077,020]*.*   /PROT=(O:RWED)
$ COPY CD$ROOT:[CDPACK.TESTS.RSX]*.COM   DS:[077,020]*.*   /PROT=(O:RWED)
$ !                                                        
$ ! Libraries                                              
$ ! =========                                              
$ COPY CD$ROOT:[LIBRARY.RSX]RSXLIB.OLB   DS:[077,100]*.*   /PROT=(O:RWED)
$ COPY CD$ROOT:[LIBRARY.RSX]CERNLIB.MLB  DS:[077,100]*.*   /PROT=(O:RWED)
$ !                                                        
$ ! Documentation                                          
$ ! =============                                          
$ COPY CD$ROOT:[DOC.ALL]*.MEM            DS:[077,200]*.*   /PROT=(O:RWED)
$ COPY CD$ROOT:[DOC.ALL]*.RNO            DS:[077,200]*.*   /PROT=(O:RWED)
$ COPY CD$ROOT:[DOC.RSX]*.MEM            DS:[077,200]*.*   /PROT=(O:RWED)
$ COPY CD$ROOT:[DOC.RSX]*.RNO            DS:[077,200]*.*   /PROT=(O:RWED)
$ !  end
$ EXIT
$
$ !-----------------------------------------------------
$ ! Delete all files on areas related to this ZG tape making
$ ! -------------------------------------------------------
$
$ DELETE_pnt:
$ !  begin
$	SET PROTECTION=(OW:RWED) DS:[077,001]*.*;*
$	SET PROTECTION=(OW:RWED) DS:[077,002]*.*;*
$	SET PROTECTION=(OW:RWED) DS:[077,003]*.*;*
$	SET PROTECTION=(OW:RWED) DS:[077,004]*.*;*
$	SET PROTECTION=(OW:RWED) DS:[077,005]*.*;*
$	SET PROTECTION=(OW:RWED) DS:[077,006]*.*;*
$	SET PROTECTION=(OW:RWED) DS:[077,007]*.*;*
$	SET PROTECTION=(OW:RWED) DS:[077,010]*.*;*
$	SET PROTECTION=(OW:RWED) DS:[077,011]*.*;*
$       SET PROTECTION=(OW:RWED) DS:[077,012]*.*;*
$       SET PROTECTION=(OW:RWED) DS:[077,013]*.*;*
$	SET PROTECTION=(OW:RWED) DS:[077,020]*.*;*
$	SET PROTECTION=(OW:RWED) DS:[077,100]*.*;*
$	SET PROTECTION=(OW:RWED) DS:[077,200]*.*;*
$ !		*****
$	DELETE	 DS:[077,001]*.*;*
$	DELETE	 DS:[077,002]*.*;*
$	DELETE	 DS:[077,003]*.*;*
$	DELETE	 DS:[077,004]*.*;*
$	DELETE	 DS:[077,005]*.*;*
$	DELETE	 DS:[077,006]*.*;*
$	DELETE	 DS:[077,007]*.*;*
$	DELETE	 DS:[077,010]*.*;*
$	DELETE	 DS:[077,011]*.*;*
$       DELETE   DS:[077,012]*.*;*
$       DELETE   DS:[077,013]*.*;*
$	DELETE	 DS:[077,020]*.*;*
$	DELETE	 DS:[077,100]*.*;*
$	DELETE	 DS:[077,200]*.*;*
$ !		*****
$	SET PROTECTION=(W:RWED)	 DS:[0,0]077001.DIR;1
$	SET PROTECTION=(W:RWED)	 DS:[0,0]077002.DIR;1
$	SET PROTECTION=(W:RWED)	 DS:[0,0]077003.DIR;1
$	SET PROTECTION=(W:RWED)	 DS:[0,0]077004.DIR;1
$	SET PROTECTION=(W:RWED)	 DS:[0,0]077005.DIR;1
$	SET PROTECTION=(W:RWED)	 DS:[0,0]077006.DIR;1
$	SET PROTECTION=(W:RWED)	 DS:[0,0]077007.DIR;1
$	SET PROTECTION=(W:RWED)	 DS:[0,0]077010.DIR;1
$	SET PROTECTION=(W:RWED)	 DS:[0,0]077011.DIR;1
$	SET PROTECTION=(W:RWED)	 DS:[0,0]077012.DIR;1
$	SET PROTECTION=(W:RWED)	 DS:[0,0]077013.DIR;1
$	SET PROTECTION=(W:RWED)	 DS:[0,0]077020.DIR;1
$	SET PROTECTION=(W:RWED)	 DS:[0,0]077100.DIR;1
$	SET PROTECTION=(W:RWED)	 DS:[0,0]077200.DIR;1
$ !		*****
$	DELETE	 DS:[0,0]077001.DIR;1
$	DELETE	 DS:[0,0]077002.DIR;1
$	DELETE	 DS:[0,0]077003.DIR;1
$	DELETE	 DS:[0,0]077004.DIR;1
$	DELETE	 DS:[0,0]077005.DIR;1
$	DELETE	 DS:[0,0]077006.DIR;1
$	DELETE	 DS:[0,0]077007.DIR;1
$	DELETE	 DS:[0,0]077010.DIR;1
$	DELETE	 DS:[0,0]077011.DIR;1
$	DELETE	 DS:[0,0]077012.DIR;1
$	DELETE	 DS:[0,0]077013.DIR;1
$	DELETE	 DS:[0,0]077020.DIR;1
$	DELETE	 DS:[0,0]077100.DIR;1
$	DELETE	 DS:[0,0]077200.DIR;1
$ !  end
$ EXIT
$
$ !-----------------------------------------------------
$
