	.MACRO	ASTVEC	VECNAM,SRVRTN,XTRPRM,PSECT=TRPVEC,DSECT,DLABEL
;
; MACRO ASTVEC
;
; VECNAM = Name of the AST vector (a global label)
; SRVRTN = Asynchronous System Trap Service Routine Name
; XTRPRM = Number of extra AST stack parameters
; PSECT  = Name of the program section for the vector (default = TRPVEC)
; DSECT  = Name of the program section for the data portion of the vector
;	   if separate I- and D-spaces are desired (leave blank otherwise).
; DLABEL = Name of the data portion of the vector (a global label)
;	   if separate I- and D-spaces are used (ignored otherwise).
;
	.MCALL	TRPVEC
	TRPVEC	VECNAM,SRVRTN,XTRPRM,PSECT,DSECT,DLABEL
	.ENDM	ASTVEC

	
	.MACRO	SSTVEC	VECNAM,SRVRTN,XTRPRM,PSECT=TRPVEC,DSECT,DLABEL
;
; MACRO SSTVEC
;
; VECNAM = Name of the SST vector (a global label)
; SRVRTN = Synchronous System Trap Service Routine Name
; XTRPRM = Number of extra SST stack parameters
; PSECT  = Name of the program section for the vector (default = TRPVEC)
; DSECT  = Name of the program section for the data portion of the vector
;	   if separate I- and D-spaces are desired (leave blank otherwise).
; DLABEL = Name of the data portion of the vector (a global label)
;	   if separate I- and D-spaces are used (ignored otherwise).
;
	.MCALL	TRPVEC
	TRPVEC	VECNAM,SRVRTN,<-<XTRPRM+2>>,PSECT,DSECT,DLABEL
	.ENDM	SSTVEC
	
	
	.MACRO	TRPVEC	VECNAM,SRVRTN,COUNT,PSECT=TRPVEC,DSECT,DLABEL
;
; MACRO TRPVEC
;
; VECNAM = Name of the AST/SST vector (a global label)
; SRVRTN = System Trap Service Routine Name
; COUNT  = System Trap Service Stack Code Word
;          (Number of extra AST stack parameters, or
;           Negative of total number of SST stack parameters)
; PSECT  = Name of the program section for the vector (default = TRPVEC)
; DSECT  = Name of the program section for the data portion of the vector
;	   if separate I- and D-spaces are desired (leave blank otherwise).
; DLABEL = Name of the data portion of the vector (a global label)
;	   if separate I- and D-spaces are used (ignored otherwise).
;
	.if b	<VECNAM>
	.error				;Vector's name is missing
	.mexit
	.endc
	.if b	<SRVRTN>
	.error				;Service Routine's name is missing
	.mexit
	.endc
	.if b	<COUNT>
	.error				;Stack code word is missing
	.mexit
	.endc
	.save				;save the current psect settings
	.if b	<DSECT>
	.psect	TRPVEC	ro,gbl,sav
	.nchr	$$$,<VECNAM>
	.if lt	$$$-6
VECNAM::	jsr	r1,@#entrap		;transfer to entrap
	.iff
VECNAM::jsr	r1,@#entrap		;transfer to entrap
	.endc
	.iff
	.psect	DSECT	d,sav
	.if b	<DLABEL>
$$$	=	.			;address of the data portion
	.iff
DLABEL::				;address of the data portion
	.endc
	.iftf
	.if ge	<COUNT>
	.word	COUNT			;AST stack code word
	.word	SRVRTN			;AST service routine address
	.iff
	.word	COUNT			;SST stack code word
	.word	SRVRTN			;SST service routine address
	.endc
	.iff
	.psect	TRPVEC,ro,gbl,sav
	.nchr	$$$,<VECNAM>
	.if lt	$$$-6
VECNAM::	mov	r1,-(sp)		;save R1's contents
	.iff
VECNAM::mov	r1,-(sp)		;save R1's contents
	.endc
	.if b	<DLABEL>
	mov	#$$$,r1			;load address of the data portion
	.iff
	mov	#DLABEL,r1		;load address of the data portion
	.endc
	jmp	@#entrap		;transfer to entrap
	.endc
	.restore			;restore psect settings
	.ENDM	TRPVEC
